/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCavernousVine
extends Block
implements IShearable,
IShiftDescription,
ISortableBlock {
    public static final PropertyEnum<EnumVineType> VINE_TYPE = PropertyEnum.func_177709_a((String)"vineType", EnumVineType.class);

    public BlockCavernousVine(String assetName) {
        super(Material.field_151582_l);
        this.func_149715_a(1.0f);
        this.func_149675_a(true);
        this.func_149672_a(field_149779_h);
        this.func_149663_c(assetName);
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.func_175698_g(pos)) {
            int y2 = pos.func_177956_o() - 1;
            while (world.func_180495_p(new BlockPos(pos.func_177958_n(), y2, pos.func_177952_p())).func_177230_c() == this) {
                world.func_175698_g(new BlockPos(pos.func_177958_n(), y2, pos.func_177952_p()));
                --y2;
            }
            return true;
        }
        return false;
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        Block blockAbove = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return blockAbove == this || blockAbove.func_149688_o().func_76220_a();
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.func_176204_a(worldIn, pos, state, neighborBlock);
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            if (entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).field_71075_bZ.field_75100_b) {
                return;
            }
            entityIn.field_70181_x = 0.06f;
            entityIn.field_70177_z += 0.4f;
            if (!((EntityLivingBase)entityIn).func_70651_bq().contains(Potion.field_76436_u)) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 5, 20, false, true));
            }
        }
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return this.getVineLight(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing facing) {
        return facing == EnumFacing.DOWN && this.func_176212_b((IBlockAccess)world, pos.func_177984_a(), facing);
    }

    public int getVineLength(IBlockAccess world, BlockPos pos) {
        int vineCount = 0;
        int y2 = pos.func_177956_o();
        while (world.func_180495_p(new BlockPos(pos.func_177958_n(), y2, pos.func_177952_p())).func_177230_c() == MarsBlocks.vine) {
            ++vineCount;
            ++y2;
        }
        return vineCount;
    }

    public int getVineLight(IBlockAccess world, BlockPos pos) {
        int vineCount = 0;
        int y2 = pos.func_177956_o();
        while (world.func_180495_p(new BlockPos(pos.func_177958_n(), y2, pos.func_177952_p())).func_177230_c() == MarsBlocks.vine) {
            vineCount += 4;
            --y2;
        }
        return Math.max(19 - vineCount, 0);
    }

    public int func_149738_a(World par1World) {
        return 50;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            for (int y2 = pos.func_177956_o() - 1; y2 >= pos.func_177956_o() - 2; --y2) {
                BlockPos pos1 = new BlockPos(pos.func_177958_n(), y2, pos.func_177952_p());
                Block blockID = worldIn.func_180495_p(pos1).func_177230_c();
                if (blockID.isAir((IBlockAccess)worldIn, pos1)) continue;
                return;
            }
            worldIn.func_180501_a(pos.func_177977_b(), this.func_176203_a(this.getVineLength((IBlockAccess)worldIn, pos) % 3), 2);
            worldIn.func_175664_x(pos);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150350_a);
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, 0));
        return ret;
    }

    public boolean isLadder(IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)(this.func_149739_a() + ".description"));
    }

    public boolean showDescription(int meta) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VINE_TYPE, (Comparable)((Object)EnumVineType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumVineType)((Object)state.func_177229_b(VINE_TYPE))).getMeta();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VINE_TYPE});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }

    public static enum EnumVineType implements IStringSerializable
    {
        VINE_0(0, "vine_0"),
        VINE_1(1, "vine_1"),
        VINE_2(2, "vine_2");

        private final int meta;
        private final String name;
        private static final EnumVineType[] values;

        private EnumVineType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumVineType byMetadata(int meta) {
            return values[meta % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumVineType.values();
        }
    }
}

