/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.items;

import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.item.IHoldableItem;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityTier3Rocket;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTier3Rocket
extends Item
implements IHoldableItem,
ISortableItem {
    public ItemTier3Rocket(String assetName) {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return GalacticraftCore.galacticraftItemsTab;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean padFound = false;
        TileEntity tile = null;
        if (worldIn.field_72995_K) {
            return false;
        }
        float centerX = -1.0f;
        float centerY = -1.0f;
        float centerZ = -1.0f;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos pos1 = pos.func_177982_a(i, 0, j);
                IBlockState state = worldIn.func_180495_p(pos1);
                Block id = state.func_177230_c();
                int meta = id.func_176201_c(state);
                if (id != GCBlocks.landingPadFull || meta != 0) continue;
                padFound = true;
                tile = worldIn.func_175625_s(pos1);
                centerX = (float)(pos.func_177958_n() + i) + 0.5f;
                centerY = (float)pos.func_177956_o() + 0.4f;
                centerZ = (float)(pos.func_177952_p() + j) + 0.5f;
                break;
            }
            if (padFound) break;
        }
        if (padFound) {
            if (!ItemTier3Rocket.placeRocketOnPad(stack, worldIn, tile, centerX, centerY, centerZ)) {
                return false;
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
                if (stack.field_77994_a <= 0) {
                    stack = null;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        for (int i = 0; i < IRocketType.EnumRocketType.values().length; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer player, List<String> tooltip, boolean b) {
        IRocketType.EnumRocketType type = par1ItemStack.func_77952_i() < 10 ? IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i()] : IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i() - 10];
        if (!type.getTooltip().isEmpty()) {
            tooltip.add(type.getTooltip());
        }
        if (type.getPreFueled()) {
            tooltip.add(EnumColor.RED + "\u00a7o" + GCCoreUtil.translate((String)"gui.creative_only.desc"));
        }
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("RocketFuel")) {
            EntityTier3Rocket rocket = new EntityTier3Rocket((World)FMLClientHandler.instance().getWorldClient(), 0.0, 0.0, 0.0, IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i()]);
            tooltip.add(GCCoreUtil.translate((String)"gui.message.fuel.name") + ": " + par1ItemStack.func_77978_p().func_74762_e("RocketFuel") + " / " + rocket.fuelTank.getCapacity());
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77667_c(par1ItemStack) + ".t3Rocket";
    }

    public boolean shouldHoldLeftHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldHoldRightHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldCrouch(EntityPlayer player) {
        return true;
    }

    public EnumSortCategoryItem getCategory(int meta) {
        return EnumSortCategoryItem.ROCKET;
    }

    public static boolean placeRocketOnPad(ItemStack stack, World worldIn, TileEntity tile, float centerX, float centerY, float centerZ) {
        if (tile instanceof TileEntityLandingPad) {
            if (((TileEntityLandingPad)tile).getDockedEntity() != null) {
                return false;
            }
        } else {
            return false;
        }
        EntityTier3Rocket rocket = new EntityTier3Rocket(worldIn, centerX, centerY, centerZ, IRocketType.EnumRocketType.values()[stack.func_77952_i()]);
        rocket.field_70177_z += 45.0f;
        rocket.func_70107_b(rocket.field_70165_t, rocket.field_70163_u + rocket.getOnPadYOffset(), rocket.field_70161_v);
        worldIn.func_72838_d((Entity)rocket);
        if (rocket.getType().getPreFueled()) {
            rocket.fuelTank.fill(new FluidStack(GCFluids.fluidFuel, rocket.getMaxFuel()), true);
        } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("RocketFuel")) {
            rocket.fuelTank.fill(new FluidStack(GCFluids.fluidFuel, stack.func_77978_p().func_74762_e("RocketFuel")), true);
        }
        return true;
    }
}

