/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.items;

import java.util.List;
import micdoodle8.mods.galacticraft.api.item.IHoldableItem;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAstroMiner
extends Item
implements IHoldableItem,
ISortableItem {
    public ItemAstroMiner(String assetName) {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77655_b(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return GalacticraftCore.galacticraftItemsTab;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = null;
        if (worldIn.field_72995_K || playerIn == null) {
            return false;
        }
        Block id = worldIn.func_180495_p(pos).func_177230_c();
        if (id == GCBlocks.fakeBlock && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityMulti) {
            tile = ((TileEntityMulti)tile).getMainBlockTile();
        }
        if (id == AsteroidBlocks.minerBaseFull) {
            tile = worldIn.func_175625_s(pos);
        }
        if (tile instanceof TileEntityMinerBase) {
            if (worldIn.field_73011_w instanceof WorldProviderSpaceStation) {
                playerIn.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate((String)"gui.message.astro_miner7.fail")));
                return false;
            }
            if (((TileEntityMinerBase)tile).getLinkedMiner() != null) {
                playerIn.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate((String)"gui.message.astro_miner.fail")));
                return false;
            }
            if ((long)((TileEntityMinerBase)tile).ticks < 15L) {
                return false;
            }
            EntityPlayerMP playerMP = (EntityPlayerMP)playerIn;
            GCPlayerStats stats = GCPlayerStats.get((Entity)playerIn);
            int astroCount = stats.getAstroMinerCount();
            if (astroCount >= ConfigManagerAsteroids.astroMinerMax && !playerIn.field_71075_bZ.field_75098_d) {
                playerIn.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate((String)"gui.message.astro_miner2.fail")));
                return false;
            }
            if (!((TileEntityMinerBase)tile).spawnMiner(playerMP)) {
                playerIn.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate((String)"gui.message.astro_miner1.fail") + " " + GCCoreUtil.translate((String)EntityAstroMiner.blockingBlock.toString())));
                return false;
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stats.setAstroMinerCount(stats.getAstroMinerCount() + 1);
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer player, List<String> tooltip, boolean b) {
    }

    public boolean shouldHoldLeftHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldHoldRightHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldCrouch(EntityPlayer player) {
        return true;
    }

    public EnumSortCategoryItem getCategory(int meta) {
        return EnumSortCategoryItem.GENERAL;
    }
}

