/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.client.render.entity;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.client.model.OBJLoaderGC;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityTier3Rocket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderTier3Rocket
extends Render<EntityTier3Rocket> {
    private OBJModel.OBJBakedModel rocketModel;
    private OBJModel.OBJBakedModel coneModel;
    private OBJModel.OBJBakedModel cubeModel;

    public RenderTier3Rocket(RenderManager manager) {
        super(manager);
        this.field_76989_e = 2.0f;
    }

    private void updateModel() {
        if (this.rocketModel == null) {
            try {
                IModel model = OBJLoaderGC.instance.loadModel(new ResourceLocation("galacticraftplanets", "tier3rocket.obj"));
                Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                this.rocketModel = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Boosters", (Object)"Rocket"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
                this.coneModel = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"NoseCone"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
                this.cubeModel = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Cube"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected ResourceLocation getEntityTexture(EntityTier3Rocket par1Entity) {
        return new ResourceLocation("missing");
    }

    public void doRender(EntityTier3Rocket entity, double par2, double par4, double par6, float par8, float par9) {
        GL11.glDisable((int)32826);
        GL11.glPushMatrix();
        float var24 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * par9 + 180.0f;
        GL11.glTranslatef((float)((float)par2), (float)((float)par4 + entity.getRenderOffsetY()), (float)((float)par6));
        GL11.glRotatef((float)(180.0f - par8), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-var24), (float)0.0f, (float)0.0f, (float)1.0f);
        float var28 = entity.rollAmplitude / 3.0f - par9;
        if (var28 > 0.0f) {
            float i = entity.getLaunched() ? (float)(5 - MathHelper.func_76128_c((double)(entity.timeUntilLaunch / 85))) / 10.0f : 0.3f;
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)var28) * var28 * i * par9), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)var28) * var28 * i * par9), (float)1.0f, (float)0.0f, (float)1.0f);
        }
        this.updateModel();
        RenderHelper.func_74518_a();
        this.func_110776_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
        ClientUtil.drawBakedModel((IFlexibleBakedModel)this.rocketModel);
        GlStateManager.func_179090_x();
        Vector3 teamColor = ClientUtil.updateTeamColor((String)FMLClientHandler.instance().getClient().field_71439_g.func_70005_c_(), (boolean)true);
        if (teamColor != null) {
            int color = ColorUtil.to32BitColor((int)255, (int)((int)(teamColor.floatZ() * 255.0f)), (int)((int)(teamColor.floatY() * 255.0f)), (int)((int)(teamColor.floatX() * 255.0f)));
            ClientUtil.drawBakedModelColored((IFlexibleBakedModel)this.coneModel, (int)color);
        } else {
            ClientUtil.drawBakedModel((IFlexibleBakedModel)this.coneModel);
        }
        GlStateManager.func_179140_f();
        boolean red = FMLClientHandler.instance().getClient().field_71439_g.field_70173_aa / 10 % 2 < 1;
        int color = ColorUtil.to32BitColor((int)255, (int)0, (int)(red ? 0 : 255), (int)(red ? 255 : 0));
        ClientUtil.drawBakedModelColored((IFlexibleBakedModel)this.cubeModel, (int)color);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        RenderHelper.func_74519_b();
    }

    public boolean shouldRender(EntityTier3Rocket rocket, ICamera camera, double camX, double camY, double camZ) {
        AxisAlignedBB axisalignedbb = rocket.func_174813_aQ().func_72314_b(0.5, 0.0, 0.5);
        return rocket.func_145770_h(camX, camY, camZ) && camera.func_78546_a(axisalignedbb);
    }
}

