/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.client.gui;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiCargoLoader;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.inventory.ContainerAstroMinerDock;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GuiAstroMinerDock
extends GuiContainerGC {
    private static final ResourceLocation dockGui = new ResourceLocation("galacticraftplanets", "textures/gui/gui_astro_miner_dock.png");
    private final TileEntityMinerBase tile;
    private GuiButton recallButton;
    private GuiElementInfoRegion electricInfoRegion;
    private boolean extraLines;

    public GuiAstroMinerDock(InventoryPlayer playerInventory, TileEntityMinerBase dock) {
        super((Container)new ContainerAstroMinerDock(playerInventory, (IInventory)dock));
        this.electricInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 233, (this.field_146295_m - this.field_147000_g) / 2 + 31, 10, 68, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.field_146999_f = 256;
        this.field_147000_g = 221;
        this.tile = dock;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.recallButton.field_146124_l = true;
        if (this.tile.linkedMinerID == null) {
            this.recallButton.field_146124_l = false;
        } else if (this.tile.linkedMinerDataAIState < 2 || this.tile.linkedMinerDataAIState == 5) {
            this.recallButton.field_146124_l = false;
        }
        this.recallButton.field_146126_j = GCCoreUtil.translate((String)"gui.button.recall.name");
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        electricityDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.energy_storage.desc.1") + (int)Math.floor(this.tile.getEnergyStoredGC()) + " / " + (int)Math.floor(this.tile.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = xPos + 233;
        this.electricInfoRegion.yPosition = yPos + 29;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion(xPos + 230, yPos + 108, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        this.recallButton = new GuiButton(0, xPos + 173, yPos + 195, 76, 20, GCCoreUtil.translate((String)"gui.button.recall.name"));
        this.field_146292_n.add(this.recallButton);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
                }
            }
        }
    }

    private String getDeltaString(int num) {
        return num > 0 ? "+" + num : "" + num;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.tile.func_70005_c_(), 7, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.getStatus(), 177, 141, 0x404040);
        if (this.extraLines) {
            this.field_146289_q.func_78276_b("\u0394x: " + this.getDeltaString(this.tile.linkedMinerDataDX), 186, 152, 2536735);
        }
        if (this.extraLines) {
            this.field_146289_q.func_78276_b("\u0394y: " + this.getDeltaString(this.tile.linkedMinerDataDY), 186, 162, 2536735);
        }
        if (this.extraLines) {
            this.field_146289_q.func_78276_b("\u0394z: " + this.getDeltaString(this.tile.linkedMinerDataDZ), 186, 172, 2536735);
        }
        if (this.extraLines) {
            this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"gui.miner.mined") + ": " + this.tile.linkedMinerDataCount, 177, 183, 2536735);
        }
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"container.inventory"), 7, this.field_147000_g - 92, 0x404040);
    }

    private String getStatus() {
        this.extraLines = false;
        switch (this.tile.linkedMinerDataAIState) {
            case -3: {
                return "";
            }
            case -2: {
                return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.miner.out_of_range");
            }
            case -1: {
                return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.miner.offline");
            }
            case 0: {
                this.extraLines = true;
                return EnumColor.RED + GCCoreUtil.translate((String)"gui.miner.stuck");
            }
            case 1: {
                return EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.miner.docked");
            }
            case 2: {
                this.extraLines = true;
                return EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.miner.travelling");
            }
            case 3: {
                this.extraLines = true;
                return EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.miner.mining");
            }
            case 4: {
                this.extraLines = true;
                return EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.miner.returning");
            }
            case 5: {
                return EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.miner.docking");
            }
        }
        return "";
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(dockGui);
        this.func_73729_b(xPos, yPos, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tile.getEnergyStoredGC(), (float)this.tile.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.field_146297_k.func_110434_K().func_110577_a(GuiCargoLoader.loaderTexture);
        if (this.tile.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(xPos + 233, yPos + 17, 176, 0, 11, 10);
        }
        int level = Math.min(this.tile.getScaledElecticalLevel(66), 66);
        this.drawColorModalRect(xPos + 234, yPos + 29 + 66 - level, 8, level, 12692004);
    }

    private void drawColorModalRect(int x, int y, int width, int height, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldRenderer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_181666_a((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_181666_a((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_181666_a((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_181666_a((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179112_b((int)770, (int)771);
    }
}

