/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.blocks;

import java.util.List;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTransmitter;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidPipe;
import micdoodle8.mods.galacticraft.core.tile.TileEntityNull;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWalkway
extends BlockTransmitter
implements ITileEntityProvider,
IShiftDescription,
ISortableBlock {
    public static final PropertyEnum<EnumWalkwayType> WALKWAY_TYPE = PropertyEnum.func_177709_a((String)"type", EnumWalkwayType.class);
    private Vector3 minVector = new Vector3(0.0, 0.32, 0.0);
    private Vector3 maxVector = new Vector3(1.0, 1.0, 1.0);

    protected BlockWalkway(String assetName) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149663_c(assetName);
        this.func_149672_a(Block.field_149777_j);
        this.field_149758_A = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(WALKWAY_TYPE, (Comparable)((Object)EnumWalkwayType.WALKWAY)));
    }

    public Vector3 getMinVector(IBlockState state) {
        return this.minVector;
    }

    public Vector3 getMaxVector(IBlockState state) {
        return this.maxVector;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean isNormalCube(Block block) {
        return block.func_149688_o().func_76230_c() && block.func_149686_d();
    }

    public TileEntity func_149915_a(World worldIn, int metadata) {
        if (metadata == EnumWalkwayType.WALKWAY_PIPE.getMeta()) {
            return new TileEntityFluidPipe();
        }
        if (metadata == EnumWalkwayType.WALKWAY_WIRE.getMeta()) {
            return new TileEntityAluminumWire(2);
        }
        return new TileEntityNull();
    }

    public NetworkType getNetworkType(IBlockState state) {
        if (state.func_177229_b(WALKWAY_TYPE) == EnumWalkwayType.WALKWAY_PIPE) {
            return NetworkType.FLUID;
        }
        if (state.func_177229_b(WALKWAY_TYPE) == EnumWalkwayType.WALKWAY_PIPE) {
            return NetworkType.POWER;
        }
        return null;
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        TileEntity[] connectable = new TileEntity[6];
        IBlockState state = worldIn.func_180495_p(pos);
        if (tileEntity != null && state.func_177230_c() instanceof BlockWalkway) {
            if (this.getNetworkType(state) != null) {
                switch (this.getNetworkType(state)) {
                    case FLUID: {
                        connectable = OxygenUtil.getAdjacentFluidConnections((TileEntity)tileEntity);
                        break;
                    }
                    case POWER: {
                        connectable = EnergyUtil.getAdjacentPowerConnections((TileEntity)tileEntity);
                        break;
                    }
                }
            }
            float minX = 0.0f;
            float minY = 0.32f;
            float minZ = 0.0f;
            float maxX = 1.0f;
            float maxY = 1.0f;
            float maxZ = 1.0f;
            if (connectable[0] != null) {
                minY = 0.0f;
            }
            this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    private void addCollisionBox(World worldIn, BlockPos pos, AxisAlignedBB aabb, List<AxisAlignedBB> list) {
        AxisAlignedBB mask1 = this.func_180640_a(worldIn, pos, worldIn.func_180495_p(pos));
        if (mask1 != null && aabb.func_72326_a(mask1)) {
            list.add(mask1);
        }
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        TileEntity[] connectable = new TileEntity[6];
        if (this.getNetworkType(state) != null) {
            switch (this.getNetworkType(state)) {
                case FLUID: {
                    connectable = OxygenUtil.getAdjacentFluidConnections((TileEntity)tileEntity);
                    break;
                }
                case POWER: {
                    connectable = EnergyUtil.getAdjacentPowerConnections((TileEntity)tileEntity);
                    break;
                }
            }
        }
        this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
        this.addCollisionBox(worldIn, pos, mask, list);
        this.func_149676_a(0.0f, 0.9f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addCollisionBox(worldIn, pos, mask, list);
        if (connectable[4] != null) {
            this.func_149676_a(0.0f, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
            this.addCollisionBox(worldIn, pos, mask, list);
        }
        if (connectable[5] != null) {
            this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, 1.0f, (float)this.maxVector.y, (float)this.maxVector.z);
            this.addCollisionBox(worldIn, pos, mask, list);
        }
        if (connectable[0] != null) {
            this.func_149676_a((float)this.minVector.x, 0.0f, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
            this.addCollisionBox(worldIn, pos, mask, list);
        }
        if (connectable[1] != null) {
            this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, 1.0f, (float)this.maxVector.z);
            this.addCollisionBox(worldIn, pos, mask, list);
        }
        if (connectable[2] != null) {
            this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, 0.0f, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
            this.addCollisionBox(worldIn, pos, mask, list);
        }
        if (connectable[3] != null) {
            this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, 1.0f);
            this.addCollisionBox(worldIn, pos, mask, list);
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public String getShiftDescription(int meta) {
        if (meta == EnumWalkwayType.WALKWAY.getMeta()) {
            return GCCoreUtil.translate((String)"tile.walkway.walkway.description");
        }
        if (meta == EnumWalkwayType.WALKWAY_WIRE.getMeta()) {
            return GCCoreUtil.translate((String)"tile.walkway.walkway_wire.description");
        }
        if (meta == EnumWalkwayType.WALKWAY_PIPE.getMeta()) {
            return GCCoreUtil.translate((String)"tile.walkway.walkway_pipe.description");
        }
        return "";
    }

    public boolean showDescription(int meta) {
        return true;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{WALKWAY_TYPE, NORTH, EAST, SOUTH, WEST, DOWN});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Object[] connectable = new Object[EnumFacing.field_82609_l.length];
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            TileEntity tileEntity;
            if (direction == EnumFacing.UP || direction == EnumFacing.DOWN && state.func_177229_b(WALKWAY_TYPE) == EnumWalkwayType.WALKWAY) continue;
            if (state.func_177229_b(WALKWAY_TYPE) == EnumWalkwayType.WALKWAY) {
                BlockPos neighbour = pos.func_177972_a(direction);
                Block block = worldIn.func_180495_p(neighbour).func_177230_c();
                if (block != this && !block.isSideSolid(worldIn, neighbour, direction.func_176734_d())) continue;
                connectable[direction.ordinal()] = block;
                continue;
            }
            if (state.func_177229_b(WALKWAY_TYPE) == EnumWalkwayType.WALKWAY_PIPE) {
                tileEntity = worldIn.func_175625_s(pos);
                connectable = OxygenUtil.getAdjacentFluidConnections((TileEntity)tileEntity);
                continue;
            }
            if (state.func_177229_b(WALKWAY_TYPE) != EnumWalkwayType.WALKWAY_WIRE) continue;
            tileEntity = worldIn.func_175625_s(pos);
            connectable = EnergyUtil.getAdjacentPowerConnections((TileEntity)tileEntity);
        }
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(connectable[EnumFacing.NORTH.ordinal()] != null)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(connectable[EnumFacing.EAST.ordinal()] != null)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(connectable[EnumFacing.SOUTH.ordinal()] != null)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(connectable[EnumFacing.WEST.ordinal()] != null)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(connectable[EnumFacing.DOWN.ordinal()] != null));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(WALKWAY_TYPE, (Comparable)((Object)EnumWalkwayType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumWalkwayType)((Object)state.func_177229_b(WALKWAY_TYPE))).getMeta();
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn, 1, 0));
        list.add(new ItemStack(itemIn, 1, 1));
        list.add(new ItemStack(itemIn, 1, 2));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }

    public static enum EnumWalkwayType implements IStringSerializable
    {
        WALKWAY(0, "walkway"),
        WALKWAY_WIRE(1, "walkway_wire"),
        WALKWAY_PIPE(2, "walkway_pipe");

        private final int meta;
        private final String name;
        private static final EnumWalkwayType[] values;

        private EnumWalkwayType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumWalkwayType byMetadata(int meta) {
            return values[meta % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumWalkwayType.values();
        }
    }
}

