/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.blocks;

import java.util.List;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReceiver;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBeamReceiver
extends BlockTileGC
implements IShiftDescription,
ISortableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockBeamReceiver(String assetName) {
        super(Material.field_151573_f);
        this.func_149663_c(assetName);
        this.func_149672_a(Block.field_149777_j);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        int oldMeta = this.func_176201_c(worldIn.func_180495_p(pos));
        int meta = this.getMetadataFromAngle(worldIn, pos, EnumFacing.func_82600_a((int)oldMeta).func_176734_d());
        if (meta == -1) {
            worldIn.func_175655_b(pos, true);
        } else if (meta != oldMeta) {
            worldIn.func_180501_a(pos, this.func_176203_a(meta), 3);
            TileEntity thisTile = worldIn.func_175625_s(pos);
            if (thisTile instanceof TileEntityBeamReceiver) {
                TileEntityBeamReceiver thisReceiver = (TileEntityBeamReceiver)thisTile;
                thisReceiver.setFacing(EnumFacing.func_82600_a((int)meta));
                thisReceiver.invalidateReflector();
                thisReceiver.initiateReflector();
            }
        }
        super.func_176204_a(worldIn, pos, state, neighborBlock);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntity thisTile = world.func_175625_s(pos);
        if (thisTile instanceof TileEntityBeamReceiver) {
            ((TileEntityBeamReceiver)thisTile).setFacing(EnumFacing.func_82600_a((int)this.func_176201_c(state)));
        }
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        int meta = this.func_176201_c(world.func_180495_p(pos));
        if (meta != -1) {
            EnumFacing dir = EnumFacing.func_82600_a((int)meta);
            switch (dir) {
                case UP: {
                    this.func_149676_a(0.3f, 0.3f, 0.3f, 0.7f, 1.0f, 0.7f);
                    break;
                }
                case DOWN: {
                    this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 0.42f, 0.8f);
                    break;
                }
                case EAST: {
                    this.func_149676_a(0.58f, 0.2f, 0.2f, 1.0f, 0.8f, 0.8f);
                    break;
                }
                case WEST: {
                    this.func_149676_a(0.0f, 0.2f, 0.2f, 0.42f, 0.8f, 0.8f);
                    break;
                }
                case NORTH: {
                    this.func_149676_a(0.2f, 0.2f, 0.0f, 0.8f, 0.8f, 0.42f);
                    break;
                }
                case SOUTH: {
                    this.func_149676_a(0.2f, 0.2f, 0.58f, 0.8f, 0.8f, 1.0f);
                    break;
                }
            }
        }
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
    }

    private int getMetadataFromAngle(World world, BlockPos pos, EnumFacing side) {
        EnumFacing direction = side.func_176734_d();
        TileEntity tileAt = world.func_175625_s(pos.func_177982_a(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e()));
        if (tileAt instanceof EnergyStorageTile) {
            if (((EnergyStorageTile)tileAt).getModeFromDirection(direction.func_176734_d()) != null) {
                return direction.ordinal();
            }
            return -1;
        }
        if (EnergyUtil.otherModCanReceive((TileEntity)tileAt, (EnumFacing)direction.func_176734_d())) {
            return direction.ordinal();
        }
        for (EnumFacing adjacentDir : EnumFacing.field_82609_l) {
            if (adjacentDir == direction || (tileAt = world.func_175625_s(pos.func_177982_a(adjacentDir.func_82601_c(), adjacentDir.func_96559_d(), adjacentDir.func_82599_e()))) instanceof IConductor) continue;
            if (tileAt instanceof EnergyStorageTile && ((EnergyStorageTile)tileAt).getModeFromDirection(adjacentDir.func_176734_d()) != null) {
                return adjacentDir.ordinal();
            }
            if (!EnergyUtil.otherModCanReceive((TileEntity)tileAt, (EnumFacing)adjacentDir.func_176734_d())) continue;
            return adjacentDir.ordinal();
        }
        return -1;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(this.getMetadataFromAngle(worldIn, pos, facing));
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (this.getMetadataFromAngle(worldIn, pos, side) != -1) {
            return true;
        }
        if (worldIn.field_72995_K) {
            this.sendIncorrectSideMessage();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void sendIncorrectSideMessage() {
        FMLClientHandler.instance().getClient().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumColor.RED + GCCoreUtil.translate((String)"gui.receiver.cannot_attach")));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public int func_180651_a(IBlockState metadata) {
        return 0;
    }

    public TileEntity createTileEntity(World world, IBlockState metadata) {
        return new TileEntityBeamReceiver();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
    }

    public boolean onMachineActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityBeamReceiver) {
            return ((TileEntityBeamReceiver)tile).onMachineActivated(worldIn, pos, state, playerIn, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)(this.func_149739_a() + ".description"));
    }

    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }
}

