/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.command.CommandGCAstroMiner;
import micdoodle8.mods.galacticraft.planets.IPlanetsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.TeleportTypeAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityEntryPod;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityGrapple;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntitySmallAsteroid;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.player.AsteroidsPlayerHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.event.AsteroidsEventHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.inventory.ContainerAstroMinerDock;
import micdoodle8.mods.galacticraft.planets.asteroids.inventory.ContainerShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.network.PacketSimpleAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.recipe.CanisterRecipes;
import micdoodle8.mods.galacticraft.planets.asteroids.recipe.RecipeManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.schematic.SchematicAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.schematic.SchematicTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.tick.AsteroidsTickHandlerServer;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReceiver;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReflector;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBaseSingle;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityTelepadFake;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.ChunkProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringTranslate;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.LanguageRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.RecipeSorter;

public class AsteroidsModule
implements IPlanetsModule {
    public static Planet planetAsteroids;
    private File GCPlanetsSource;
    public static AsteroidsPlayerHandler playerHandler;
    public static Fluid fluidMethaneGas;
    public static Fluid fluidOxygenGas;
    public static Fluid fluidNitrogenGas;
    public static Fluid fluidLiquidMethane;
    public static Fluid fluidLiquidOxygen;
    public static Fluid fluidLiquidNitrogen;
    public static Fluid fluidLiquidArgon;
    public static Fluid fluidAtmosphericGases;

    private Fluid registerFluid(String fluidName, int density, int viscosity, int temperature, boolean gaseous) {
        Fluid returnFluid = FluidRegistry.getFluid((String)fluidName);
        if (returnFluid == null) {
            ResourceLocation texture = new ResourceLocation("galacticraftplanets:blocks/fluids/" + fluidName);
            FluidRegistry.registerFluid((Fluid)new Fluid(fluidName, texture, texture).setDensity(density).setViscosity(viscosity).setTemperature(temperature).setGaseous(gaseous));
            returnFluid = FluidRegistry.getFluid((String)fluidName);
        }
        return returnFluid;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.GCPlanetsSource = event.getSourceFile();
        playerHandler = new AsteroidsPlayerHandler();
        MinecraftForge.EVENT_BUS.register((Object)playerHandler);
        AsteroidsEventHandler eventHandler = new AsteroidsEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        RecipeSorter.register((String)"galacticraftplanets:canisterRecipe", CanisterRecipes.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        this.registerFluid("methane", 1, 11, 295, true);
        this.registerFluid("atmosphericgases", 1, 13, 295, true);
        this.registerFluid("liquidmethane", 450, 120, 109, false);
        this.registerFluid("liquidoxygen", 1141, 140, 90, false);
        this.registerFluid("liquidnitrogen", 808, 130, 90, false);
        this.registerFluid("nitrogen", 1, 12, 295, true);
        this.registerFluid("carbondioxide", 2, 20, 295, true);
        this.registerFluid("argon", 1, 4, 295, true);
        this.registerFluid("liquidargon", 900, 100, 87, false);
        this.registerFluid("helium", 1, 1, 295, true);
        fluidMethaneGas = FluidRegistry.getFluid((String)"methane");
        fluidAtmosphericGases = FluidRegistry.getFluid((String)"atmosphericgases");
        fluidLiquidMethane = FluidRegistry.getFluid((String)"liquidmethane");
        fluidLiquidOxygen = FluidRegistry.getFluid((String)"liquidoxygen");
        fluidOxygenGas = FluidRegistry.getFluid((String)"oxygen");
        fluidLiquidNitrogen = FluidRegistry.getFluid((String)"liquidnitrogen");
        fluidLiquidArgon = FluidRegistry.getFluid((String)"liquidargon");
        fluidNitrogenGas = FluidRegistry.getFluid((String)"nitrogen");
        AsteroidBlocks.initBlocks();
        AsteroidBlocks.registerBlocks();
        AsteroidBlocks.setHarvestLevels();
        AsteroidBlocks.oreDictRegistration();
        AsteroidsItems.initItems();
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidMethaneGas, 1000), new ItemStack(AsteroidsItems.methaneCanister, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidLiquidOxygen, 1000), new ItemStack(AsteroidsItems.canisterLOX, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidLiquidNitrogen, 1000), new ItemStack(AsteroidsItems.canisterLN2, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        GalacticraftCore.galacticraftItemsTab.setItemForTab(AsteroidsItems.astroMiner);
        this.registerMicroBlocks();
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier3Rocket());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicAstroMiner());
        GalacticraftCore.packetPipeline.addDiscriminator(7, PacketSimpleAsteroids.class);
        AsteroidsTickHandlerServer eventHandler = new AsteroidsTickHandlerServer();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        this.registerEntities();
        RecipeManagerAsteroids.loadRecipes();
        planetAsteroids = new Planet("asteroids").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetAsteroids.setDimensionInfo(ConfigManagerAsteroids.dimensionIDAsteroids, WorldProviderAsteroids.class).setTierRequired(3);
        planetAsteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.375f, 1.375f)).setRelativeOrbitTime(45.0f).setPhaseShift((float)(Math.random() * (Math.PI * 2)));
        planetAsteroids.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/asteroid.png"));
        planetAsteroids.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, -1.5f, 0.05f, 0.0f));
        planetAsteroids.addChecklistKeys(new String[]{"equip_oxygen_suit", "craft_grapple_hook", "thermal_padding"});
        GalaxyRegistry.registerPlanet((Planet)planetAsteroids);
        GalacticraftRegistry.registerTeleportType(WorldProviderAsteroids.class, (ITeleportType)new TeleportTypeAsteroids());
        GalacticraftRegistry.registerGear((int)6, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_HELMET, (ItemStack)new ItemStack(AsteroidsItems.thermalPadding, 1, 0));
        GalacticraftRegistry.registerGear((int)7, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_CHESTPLATE, (ItemStack)new ItemStack(AsteroidsItems.thermalPadding, 1, 1));
        GalacticraftRegistry.registerGear((int)8, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_LEGGINGS, (ItemStack)new ItemStack(AsteroidsItems.thermalPadding, 1, 2));
        GalacticraftRegistry.registerGear((int)9, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_BOOTS, (ItemStack)new ItemStack(AsteroidsItems.thermalPadding, 1, 3));
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        try {
            ZipFile zf = new ZipFile(this.GCPlanetsSource);
            Pattern assetENUSLang = Pattern.compile("assets/(.*)/lang/(?:.+/|)([\\w_-]+).lang");
            for (ZipEntry zipEntry : Collections.list(zf.entries())) {
                Matcher matcher;
                if (!zipEntry.getName().contains("galacticraftasteroids/lang") || !(matcher = assetENUSLang.matcher(zipEntry.getName())).matches()) continue;
                String lang = matcher.group(2);
                LanguageRegistry.instance().injectLanguage(lang, StringTranslate.parseLangFile((InputStream)zf.getInputStream(zipEntry)));
                if (!"en_US".equals(lang) || event.getSide() != Side.SERVER) continue;
                StringTranslate.inject((InputStream)zf.getInputStream(zipEntry));
            }
            zf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandGCAstroMiner());
        ChunkProviderAsteroids.reset();
    }

    @Override
    public void serverInit(FMLServerStartedEvent event) {
        AsteroidsTickHandlerServer.restart();
    }

    @Override
    public void getGuiIDs(List<Integer> idList) {
        idList.add(3);
    }

    @Override
    public Object getGuiElement(Side side, int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (side == Side.SERVER) {
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            switch (ID) {
                case 3: {
                    if (tile instanceof TileEntityShortRangeTelepad) {
                        return new ContainerShortRangeTelepad(player.field_71071_by, (TileEntityShortRangeTelepad)tile, player);
                    }
                    if (!(tile instanceof TileEntityMinerBase)) break;
                    return new ContainerAstroMinerDock(player.field_71071_by, (IInventory)((TileEntityMinerBase)tile));
                }
            }
        }
        return null;
    }

    private void registerEntities() {
        this.registerCreatures();
        this.registerNonMobEntities();
        this.registerTileEntities();
    }

    private void registerCreatures() {
    }

    private void registerNonMobEntities() {
        MarsModule.registerGalacticraftNonMobEntity(EntitySmallAsteroid.class, "small_asteroid", 150, 3, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityGrapple.class, "grapple_hook", 150, 1, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityTier3Rocket.class, "rocket_t3", 150, 1, false);
        MarsModule.registerGalacticraftNonMobEntity(EntityEntryPod.class, "entry_pod", 150, 1, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityAstroMiner.class, "astro_miner", 80, 1, true);
    }

    private void registerMicroBlocks() {
        try {
            Class<?> clazz = Class.forName("codechicken.microblock.MicroMaterialRegistry");
            if (clazz != null) {
                Method[] methodz;
                Method registerMethod = null;
                for (Method m : methodz = clazz.getMethods()) {
                    if (!m.getName().equals("registerMaterial")) continue;
                    registerMethod = m;
                    break;
                }
                Class<?> clazzbm = Class.forName("codechicken.microblock.BlockMicroMaterial");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockBasic, 0), "tile.asteroids_block.asteroid_rock_0");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockBasic, 1), "tile.asteroids_block.asteroid_rock_1");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockBasic, 2), "tile.asteroids_block.asteroid_rock_2");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockDenseIce, 0), "tile.dense_ice");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityBeamReflector.class, (String)"GC Beam Reflector");
        GameRegistry.registerTileEntity(TileEntityBeamReceiver.class, (String)"GC Beam Receiver");
        GameRegistry.registerTileEntity(TileEntityShortRangeTelepad.class, (String)"GC Short Range Telepad");
        GameRegistry.registerTileEntity(TileEntityTelepadFake.class, (String)"GC Fake Short Range Telepad");
        GameRegistry.registerTileEntity(TileEntityMinerBaseSingle.class, (String)"GC Astro Miner Base Builder");
        GameRegistry.registerTileEntity(TileEntityMinerBase.class, (String)"GC Astro Miner Base");
    }

    @Override
    public Configuration getConfiguration() {
        return ConfigManagerAsteroids.config;
    }

    @Override
    public void syncConfig() {
        ConfigManagerAsteroids.syncConfig(false, false);
    }
}

