/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.asm.transformers.ModAccessTransformer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sun.misc.URLClassPath;
import sun.net.util.URLUtil;

public class ThaumcraftLoader
implements IFMLLoadingPlugin,
IFMLCallHook {
    private static ByteBuffer downloadBuffer = ByteBuffer.allocateDirect(0x800000);
    private static final String owner = "ThaumcraftLoader";
    private static DepLoadInst inst;
    private static final Logger logger;

    public static void load() {
        if (inst == null) {
            inst = new DepLoadInst();
            inst.load();
        }
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public Void call() {
        ThaumcraftLoader.load();
        return null;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static {
        logger = LogManager.getLogger((String)owner);
    }

    public static class DepLoadInst {
        private File modsDir;
        private File v_modsDir;
        private IDownloadDisplay downloadMonitor;
        private JDialog popupWindow;
        private Map<String, Dependency> depMap = new HashMap<String, Dependency>();
        private HashSet<String> depSet = new HashSet();
        private File scanning;
        private LaunchClassLoader loader = (LaunchClassLoader)ThaumcraftLoader.class.getClassLoader();

        public DepLoadInst() {
            String mcVer = (String)FMLInjectionData.data()[4];
            File mcDir = (File)FMLInjectionData.data()[6];
            this.modsDir = new File(mcDir, "mods");
            this.v_modsDir = new File(mcDir, "mods/" + mcVer);
            if (!this.v_modsDir.exists()) {
                this.v_modsDir.mkdirs();
            }
        }

        private void addClasspath(File file) {
            try {
                this.loader.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        private void deleteMod(File mod) {
            if (mod.delete()) {
                return;
            }
            try {
                URL url = mod.toURI().toURL();
                Field f_ucp = URLClassLoader.class.getDeclaredField("ucp");
                Field f_loaders = URLClassPath.class.getDeclaredField("loaders");
                Field f_lmap = URLClassPath.class.getDeclaredField("lmap");
                f_ucp.setAccessible(true);
                f_loaders.setAccessible(true);
                f_lmap.setAccessible(true);
                URLClassPath ucp = (URLClassPath)f_ucp.get(this.loader);
                Closeable loader = (Closeable)((Map)f_lmap.get(ucp)).remove(URLUtil.urlNoFragString(url));
                if (loader != null) {
                    loader.close();
                    ((List)f_loaders.get(ucp)).remove(loader);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!mod.delete()) {
                mod.deleteOnExit();
                String msg = "ThaumcraftLoader was unable to delete file " + mod.getPath() + " the game will now try to delete it on exit. If this dialog appears again, delete it manually.";
                logger.error(msg);
                if (!GraphicsEnvironment.isHeadless()) {
                    JOptionPane.showMessageDialog(null, msg, "An update error has occured", 0);
                }
                System.exit(1);
            }
        }

        private void install(Dependency dep) {
            this.popupWindow = (JDialog)this.downloadMonitor.makeDialog();
            if (!this.extract(dep)) {
                this.download(dep);
            }
            dep.existing = dep.file.filename;
            this.scanDepInfo(new File(this.v_modsDir, dep.existing));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean extract(Dependency dep) {
            if (dep.packed == null) {
                return false;
            }
            ZipFile zip = null;
            try {
                zip = new ZipFile(dep.source);
                ZipEntry libEntry = zip.getEntry(dep.packed + dep.file.filename);
                if (libEntry == null) {
                    boolean bl = false;
                    return bl;
                }
                this.downloadMonitor.updateProgressString("Extracting file %s\n", dep.source.getPath() + '!' + libEntry.toString());
                logger.info("Extracting file " + dep.source.getPath() + '!' + libEntry.toString());
                this.download(zip.getInputStream(libEntry), (int)libEntry.getSize(), dep);
                this.downloadMonitor.updateProgressString("Extraction complete", new Object[0]);
                logger.info("Extraction complete");
            }
            catch (Exception e) {
                this.installError(e, dep, "extraction");
            }
            finally {
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }

        private void download(Dependency dep) {
            try {
                URL libDownload = new URL(dep.repo + dep.file.filename);
                this.downloadMonitor.updateProgressString("Downloading file %s", libDownload.toString());
                logger.info("Downloading file " + libDownload.toString());
                URLConnection connection = libDownload.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.setRequestProperty("User-Agent", "ThaumcraftLoader Downloader");
                this.download(connection.getInputStream(), connection.getContentLength(), dep);
                this.downloadMonitor.updateProgressString("Download complete", new Object[0]);
                logger.info("Download complete");
            }
            catch (Exception e) {
                this.installError(e, dep, "download");
            }
        }

        private void installError(Exception e, Dependency dep, String s) {
            if (this.downloadMonitor.shouldStopIt()) {
                logger.error("You have stopped the " + s + " before it could complete");
                System.exit(1);
            }
            this.downloadMonitor.showErrorDialog(dep.file.filename, dep.repo + '/' + dep.file.filename);
            throw new RuntimeException(s + " error", e);
        }

        private void download(InputStream is, int sizeGuess, Dependency dep) throws Exception {
            File target = new File(this.v_modsDir, dep.file.filename);
            if (sizeGuess > downloadBuffer.capacity()) {
                throw new Exception(String.format("The file %s is too large to be downloaded by ThaumcraftLoader - the download is invalid", target.getName()));
            }
            downloadBuffer.clear();
            int fullLength = 0;
            this.downloadMonitor.resetProgress(sizeGuess);
            try {
                int read;
                this.downloadMonitor.setPokeThread(Thread.currentThread());
                byte[] buffer = new byte[1024];
                while ((read = is.read(buffer)) >= 0) {
                    downloadBuffer.put(buffer, 0, read);
                    fullLength += read;
                    if (this.downloadMonitor.shouldStopIt()) break;
                    this.downloadMonitor.updateProgress(fullLength);
                }
                is.close();
                this.downloadMonitor.setPokeThread(null);
                downloadBuffer.limit(fullLength);
                downloadBuffer.position(0);
            }
            catch (InterruptedIOException e) {
                Thread.interrupted();
                throw new Exception("Stop");
            }
            if (!target.exists()) {
                target.createNewFile();
            }
            downloadBuffer.position(0);
            FileOutputStream fos = new FileOutputStream(target);
            fos.getChannel().write(downloadBuffer);
            fos.close();
        }

        private String checkExisting(Dependency dep) {
            VersionedFile vfile;
            for (File f : this.modsDir.listFiles()) {
                vfile = new VersionedFile(f.getName(), dep.file.pattern);
                if (!vfile.matches() || !vfile.name.equals(dep.file.name) || f.renameTo(new File(this.v_modsDir, f.getName()))) continue;
                this.deleteMod(f);
            }
            for (File f : this.v_modsDir.listFiles()) {
                vfile = new VersionedFile(f.getName(), dep.file.pattern);
                if (!vfile.matches() || !vfile.name.equals(dep.file.name)) continue;
                int cmp = vfile.version.compareTo(dep.file.version);
                if (cmp < 0) {
                    logger.info("Deleted old version " + f.getName());
                    this.deleteMod(f);
                    return null;
                }
                if (cmp > 0) {
                    logger.info("Warning: version of " + dep.file.name + ", " + vfile.version + " is newer than request " + dep.file.version);
                    return f.getName();
                }
                return f.getName();
            }
            return null;
        }

        public void load() {
            this.scanDepInfos();
            if (this.depMap.isEmpty()) {
                return;
            }
            this.loadDeps();
            this.activateDeps();
        }

        private void activateDeps() {
            for (Dependency dep : this.depMap.values()) {
                File file = new File(this.v_modsDir, dep.existing);
                if (this.searchCoreMod(file) || !dep.coreLib) continue;
                this.addClasspath(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean searchCoreMod(File coreMod) {
            Attributes mfAttributes;
            JarFile jar = null;
            try {
                jar = new JarFile(coreMod);
                if (jar.getManifest() == null) {
                    boolean bl = false;
                    return bl;
                }
                ModAccessTransformer.addJar((JarFile)jar);
                mfAttributes = jar.getManifest().getMainAttributes();
            }
            catch (IOException ioe) {
                FMLRelaunchLog.log((Level)Level.ERROR, (Throwable)ioe, (String)"Unable to read the jar file %s - ignoring", (Object[])new Object[]{coreMod.getName()});
                boolean ignored = false;
                return ignored;
            }
            finally {
                try {
                    if (jar != null) {
                        jar.close();
                    }
                }
                catch (IOException ignored) {}
            }
            String fmlCorePlugin = mfAttributes.getValue("FMLCorePlugin");
            if (fmlCorePlugin == null) {
                return false;
            }
            this.addClasspath(coreMod);
            try {
                Class<CoreModManager> c = CoreModManager.class;
                if (!mfAttributes.containsKey(new Attributes.Name("FMLCorePluginContainsFMLMod"))) {
                    FMLRelaunchLog.finer((String)"Adding %s to the list of known coremods, it will not be examined again", (Object[])new Object[]{coreMod.getName()});
                    Field f_loadedCoremods = c.getDeclaredField("loadedCoremods");
                    f_loadedCoremods.setAccessible(true);
                    ((List)f_loadedCoremods.get(null)).add(coreMod.getName());
                } else {
                    FMLRelaunchLog.finer((String)"Found FMLCorePluginContainsFMLMod marker in %s, it will be examined later for regular @Mod instances", (Object[])new Object[]{coreMod.getName()});
                    Field f_reparsedCoremods = c.getDeclaredField("reparsedCoremods");
                    f_reparsedCoremods.setAccessible(true);
                    ((List)f_reparsedCoremods.get(null)).add(coreMod.getName());
                }
                Method m_loadCoreMod = c.getDeclaredMethod("loadCoreMod", LaunchClassLoader.class, String.class, File.class);
                m_loadCoreMod.setAccessible(true);
                m_loadCoreMod.invoke(null, this.loader, fmlCorePlugin, coreMod);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadDeps() {
            this.downloadMonitor = FMLLaunchHandler.side().isClient() ? new Downloader() : new DummyDownloader();
            try {
                while (!this.depSet.isEmpty()) {
                    Iterator<String> it = this.depSet.iterator();
                    Dependency dep = this.depMap.get(it.next());
                    it.remove();
                    this.load(dep);
                }
            }
            finally {
                if (this.popupWindow != null) {
                    this.popupWindow.setVisible(false);
                    this.popupWindow.dispose();
                }
            }
        }

        private void load(Dependency dep) {
            dep.existing = this.checkExisting(dep);
            if (dep.existing == null && ThaumcraftLoader.class.getResource("/" + dep.testClass.replace('.', '/') + ".class") == null) {
                this.install(dep);
            }
        }

        private List<File> modFiles() {
            LinkedList<File> list = new LinkedList<File>();
            list.addAll(Arrays.asList(this.modsDir.listFiles()));
            list.addAll(Arrays.asList(this.v_modsDir.listFiles()));
            return list;
        }

        private void scanDepInfos() {
            for (File file : this.modFiles()) {
                if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
                this.scanDepInfo(file);
            }
        }

        private void scanDepInfo(File file) {
            try {
                this.scanning = file;
                ZipFile zip = new ZipFile(file);
                ZipEntry e = zip.getEntry("dependencies.info");
                if (e != null) {
                    this.loadJSon(zip.getInputStream(e));
                }
                zip.close();
            }
            catch (Exception e) {
                logger.error("Failed to load dependencies.info from " + file.getName() + " as JSON", (Throwable)e);
            }
        }

        private void loadJSon(InputStream input) throws IOException {
            InputStreamReader reader = new InputStreamReader(input);
            JsonElement root = new JsonParser().parse((Reader)reader);
            if (root.isJsonArray()) {
                this.loadJSonArr(root);
            } else {
                this.loadJson(root.getAsJsonObject());
            }
            reader.close();
        }

        private void loadJSonArr(JsonElement root) throws IOException {
            for (JsonElement node : root.getAsJsonArray()) {
                this.loadJson(node.getAsJsonObject());
            }
        }

        private void loadJson(JsonObject node) throws IOException {
            VersionedFile file;
            boolean obfuscated = ((LaunchClassLoader)ThaumcraftLoader.class.getClassLoader()).getClassBytes("net.minecraft.world.World") == null;
            String repo = node.has("repo") ? node.get("repo").getAsString() : null;
            String packed = node.has("packed") ? node.get("packed").getAsString() : null;
            String testClass = node.get("class").getAsString();
            String filename = node.get("file").getAsString();
            if (!obfuscated && node.has("dev")) {
                filename = node.get("dev").getAsString();
            }
            boolean coreLib = node.has("coreLib") && node.get("coreLib").getAsBoolean();
            Pattern pattern = null;
            try {
                if (node.has("pattern")) {
                    pattern = Pattern.compile(node.get("pattern").getAsString());
                }
            }
            catch (PatternSyntaxException e) {
                logger.error("Invalid filename pattern: " + node.get("pattern"), (Throwable)e);
            }
            if (pattern == null) {
                pattern = Pattern.compile("(\\w+).*?([\\d\\.]+)[-\\w]*\\.[^\\d]+");
            }
            if (!(file = new VersionedFile(filename, pattern)).matches()) {
                throw new RuntimeException("Invalid filename format for dependency: " + filename);
            }
            this.addDep(new Dependency(this.scanning, repo, packed, file, testClass, coreLib));
        }

        private void addDep(Dependency newDep) {
            Dependency oldDep = this.depMap.get(newDep.file.name);
            if (oldDep == null) {
                this.depMap.put(newDep.file.name, newDep);
                this.depSet.add(newDep.file.name);
                return;
            }
            oldDep.coreLib |= newDep.coreLib;
            int cmp = newDep.file.version.compareTo(oldDep.file.version);
            if (cmp == 1) {
                oldDep.set(newDep);
            } else if (cmp == 0) {
                if (oldDep.repo == null) {
                    oldDep.repo = newDep.repo;
                }
                if (oldDep.packed == null) {
                    oldDep.source = newDep.source;
                    oldDep.packed = newDep.packed;
                }
            }
        }
    }

    public static class Dependency {
        public File source;
        public String repo;
        public String packed;
        public VersionedFile file;
        public String testClass;
        public boolean coreLib;
        public String existing;

        public Dependency(File source, String repo, String packed, VersionedFile file, String testClass, boolean coreLib) {
            this.source = source;
            this.repo = repo;
            this.packed = packed;
            this.file = file;
            this.coreLib = coreLib;
            this.testClass = testClass;
        }

        public void set(Dependency dep) {
            this.source = dep.source;
            this.repo = dep.repo;
            this.packed = dep.packed;
            this.file = dep.file;
        }
    }

    public static class VersionedFile {
        public final Pattern pattern;
        public final String filename;
        public final ComparableVersion version;
        public final String name;

        public VersionedFile(String filename, Pattern pattern) {
            this.pattern = pattern;
            this.filename = filename;
            Matcher m = pattern.matcher(filename);
            if (m.matches()) {
                this.name = m.group(1);
                this.version = new ComparableVersion(m.group(2));
            } else {
                this.name = null;
                this.version = null;
            }
        }

        public boolean matches() {
            return this.name != null;
        }
    }

    public static class DummyDownloader
    implements IDownloadDisplay {
        @Override
        public void resetProgress(int sizeGuess) {
        }

        @Override
        public void setPokeThread(Thread currentThread) {
        }

        @Override
        public void updateProgress(int fullLength) {
        }

        @Override
        public boolean shouldStopIt() {
            return false;
        }

        @Override
        public void updateProgressString(String string, Object ... data) {
        }

        @Override
        public Object makeDialog() {
            return null;
        }

        @Override
        public void showErrorDialog(String name, String url) {
        }
    }

    public static class Downloader
    extends JOptionPane
    implements IDownloadDisplay {
        private JDialog container;
        private JLabel currentActivity;
        private JProgressBar progress;
        boolean stopIt;
        Thread pokeThread;

        private Box makeProgressPanel() {
            Box box = Box.createVerticalBox();
            box.add(Box.createRigidArea(new Dimension(0, 10)));
            JLabel welcomeLabel = new JLabel("<html><b><font size='+1'>ThaumcraftLoader is setting up your minecraft environment</font></b></html>");
            box.add(welcomeLabel);
            welcomeLabel.setAlignmentY(0.0f);
            welcomeLabel = new JLabel("<html>Please wait, ThaumcraftLoader has some tasks to do before you can play</html>");
            welcomeLabel.setAlignmentY(0.0f);
            box.add(welcomeLabel);
            box.add(Box.createRigidArea(new Dimension(0, 10)));
            this.currentActivity = new JLabel("Currently doing ...");
            box.add(this.currentActivity);
            box.add(Box.createRigidArea(new Dimension(0, 10)));
            this.progress = new JProgressBar(0, 100);
            this.progress.setStringPainted(true);
            box.add(this.progress);
            box.add(Box.createRigidArea(new Dimension(0, 30)));
            return box;
        }

        @Override
        public JDialog makeDialog() {
            if (this.container != null) {
                return this.container;
            }
            this.setMessageType(1);
            this.setMessage(this.makeProgressPanel());
            this.setOptions(new Object[]{"Stop"});
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getSource() == Downloader.this && evt.getPropertyName() == "value") {
                        Downloader.this.requestClose("This will stop minecraft from launching\nAre you sure you want to do this?");
                    }
                }
            });
            this.container = new JDialog(null, "Hello", Dialog.ModalityType.MODELESS);
            this.container.setResizable(false);
            this.container.setLocationRelativeTo(null);
            this.container.add(this);
            this.updateUI();
            this.container.pack();
            this.container.setMinimumSize(this.container.getPreferredSize());
            this.container.setVisible(true);
            this.container.setDefaultCloseOperation(0);
            this.container.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Downloader.this.requestClose("Closing this window will stop minecraft from launching\nAre you sure you wish to do this?");
                }
            });
            return this.container;
        }

        protected void requestClose(String message) {
            int shouldClose = JOptionPane.showConfirmDialog(this.container, message, "Are you sure you want to stop?", 0, 2);
            if (shouldClose == 0) {
                this.container.dispose();
            }
            this.stopIt = true;
            if (this.pokeThread != null) {
                this.pokeThread.interrupt();
            }
        }

        @Override
        public void updateProgressString(String progressUpdate, Object ... data) {
            if (this.currentActivity != null) {
                this.currentActivity.setText(String.format(progressUpdate, data));
            }
        }

        @Override
        public void resetProgress(int sizeGuess) {
            if (this.progress != null) {
                this.progress.getModel().setRangeProperties(0, 0, 0, sizeGuess, false);
            }
        }

        @Override
        public void updateProgress(int fullLength) {
            if (this.progress != null) {
                this.progress.getModel().setValue(fullLength);
            }
        }

        @Override
        public void setPokeThread(Thread currentThread) {
            this.pokeThread = currentThread;
        }

        @Override
        public boolean shouldStopIt() {
            return this.stopIt;
        }

        @Override
        public void showErrorDialog(String name, String url) {
            JEditorPane ep = new JEditorPane("text/html", "<html>ThaumcraftLoader was unable to download required library " + name + "<br>Check your internet connection and try restarting or download it manually from" + "<br><a href=\"" + url + "\">" + url + "</a> and put it in your mods folder" + "</html>");
            ep.setEditable(false);
            ep.setOpaque(false);
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    try {
                        if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(event.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JOptionPane.showMessageDialog(null, ep, "A download error has occured", 0);
        }
    }

    public static interface IDownloadDisplay {
        public void resetProgress(int var1);

        public void setPokeThread(Thread var1);

        public void updateProgress(int var1);

        public boolean shouldStopIt();

        public void updateProgressString(String var1, Object ... var2);

        public Object makeDialog();

        public void showErrorDialog(String var1, String var2);
    }
}

