/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.essentia;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.blocks.TileThaumcraft;
import thaumcraft.api.items.ItemGenericEssentiaContainer;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.utils.InventoryUtils;

public class TileCrystallizer
extends TileThaumcraft
implements IAspectContainer,
IEssentiaTransport,
ITickable {
    public Aspect aspect = null;
    int count = 0;
    int progress = 0;
    int fuel = 0;
    final int progMax = 200;
    public float spin = 0.0f;
    public float spinInc = 0.0f;
    float tr = 1.0f;
    float tg = 1.0f;
    float tb = 1.0f;
    public float cr = 1.0f;
    public float cg = 1.0f;
    public float cb = 1.0f;
    int venting = 0;

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.aspect = Aspect.getAspect(nbttagcompound.func_74779_i("Aspect"));
        this.fuel = nbttagcompound.func_74762_e("fuel");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        if (this.aspect != null) {
            nbttagcompound.func_74778_a("Aspect", this.aspect.getTag());
        }
        nbttagcompound.func_74768_a("fuel", this.fuel);
    }

    @Override
    public AspectList getAspects() {
        AspectList al = new AspectList();
        if (this.aspect != null) {
            al.add(this.aspect, 1);
        }
        return al;
    }

    @Override
    public void setAspects(AspectList aspects) {
    }

    @Override
    public int addToContainer(Aspect tt, int am) {
        if (am == 0) {
            return am;
        }
        if (this.aspect == null) {
            --am;
            this.aspect = tt;
            this.field_145850_b.func_175689_h(this.func_174877_v());
            this.func_70296_d();
        }
        return am;
    }

    @Override
    public boolean takeFromContainer(Aspect tt, int am) {
        if (this.aspect != null && am == 1) {
            this.aspect = null;
            this.field_145850_b.func_175689_h(this.func_174877_v());
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @Override
    public boolean doesContainerContainAmount(Aspect tag, int amt) {
        return amt == 1 && this.aspect != null && tag == this.aspect;
    }

    @Override
    public boolean doesContainerContain(AspectList ot) {
        for (Aspect tt : ot.getAspects()) {
            if (this.aspect != null && this.aspect == tt && ot.getAmount(tt) == 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public int containerContains(Aspect tag) {
        return this.aspect != null && tag == this.aspect ? 1 : 0;
    }

    @Override
    public boolean doesContainerAccept(Aspect tag) {
        return true;
    }

    @Override
    public boolean isConnectable(EnumFacing face) {
        return face == this.getFacing();
    }

    @Override
    public boolean canInputFrom(EnumFacing face) {
        return face == this.getFacing();
    }

    @Override
    public boolean canOutputTo(EnumFacing face) {
        return false;
    }

    @Override
    public void setSuction(Aspect aspect, int amount) {
    }

    @Override
    public int getMinimumSuction() {
        return 0;
    }

    @Override
    public Aspect getSuctionType(EnumFacing loc) {
        return null;
    }

    @Override
    public int getSuctionAmount(EnumFacing loc) {
        return this.gettingPower() ? 0 : (loc == this.getFacing() && this.aspect == null ? 128 : 64);
    }

    @Override
    public Aspect getEssentiaType(EnumFacing loc) {
        return this.aspect;
    }

    @Override
    public int getEssentiaAmount(EnumFacing loc) {
        return this.aspect == null ? 0 : 1;
    }

    @Override
    public int takeEssentia(Aspect aspect, int amount, EnumFacing face) {
        return 0;
    }

    @Override
    public int addEssentia(Aspect aspect, int amount, EnumFacing face) {
        return this.canInputFrom(face) ? amount - this.addToContainer(aspect, amount) : 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (++this.count % 5 == 0 && !this.gettingPower()) {
                if (this.aspect == null) {
                    this.fillReservoir();
                    this.progress = 0;
                } else {
                    if (this.fuel <= 0) {
                        this.fuel += AuraHandler.drainAuraAvailable(this.func_145831_w(), this.func_174877_v(), Aspect.EARTH, 4) * 25;
                    }
                    if (this.fuel > 0) {
                        int q = Math.min(5, Math.min(Math.max(1, (200 - this.progress) / 5), this.fuel));
                        this.fuel -= q;
                        this.progress += q * 5;
                    }
                }
            }
            if (this.aspect != null && this.progress >= 200) {
                this.eject();
                this.aspect = null;
                this.progress = 0;
                this.field_145850_b.func_175689_h(this.func_174877_v());
                this.func_70296_d();
            }
        } else {
            if (this.aspect == null) {
                this.tb = 1.0f;
                this.tg = 1.0f;
                this.tr = 1.0f;
            } else {
                Color c = new Color(this.aspect.getColor());
                this.tr = (float)c.getRed() / 220.0f;
                this.tg = (float)c.getGreen() / 220.0f;
                this.tb = (float)c.getBlue() / 220.0f;
            }
            if (this.cr < this.tr) {
                this.cr += 0.05f;
            }
            if (this.cr > this.tr) {
                this.cr -= 0.05f;
            }
            if (this.cg < this.tg) {
                this.cg += 0.05f;
            }
            if (this.cg > this.tg) {
                this.cg -= 0.05f;
            }
            if (this.cb < this.tb) {
                this.cb += 0.05f;
            }
            if (this.cb > this.tb) {
                this.cb -= 0.05f;
            }
            this.spin += this.spinInc;
            if (this.spin > 360.0f) {
                this.spin -= 360.0f;
            }
            if (this.aspect != null && this.spinInc < 20.0f && !this.gettingPower()) {
                this.spinInc += 0.1f;
                if (this.spinInc > 20.0f) {
                    this.spinInc = 20.0f;
                }
            } else if ((this.aspect == null || this.gettingPower()) && this.spinInc > 0.0f) {
                this.spinInc -= 0.2f;
                if (this.spinInc < 0.0f) {
                    this.spinInc = 0.0f;
                }
            }
            if (this.venting > 0) {
                --this.venting;
                float fx = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                float fz = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                float fy = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                float fx2 = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                float fz2 = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                float fy2 = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                int color = 0xFFFFFF;
                Thaumcraft.proxy.getFX().drawVentParticles((float)this.func_174877_v().func_177958_n() + 0.5f + fx + (float)this.getFacing().func_176734_d().func_82601_c() / 2.1f, (float)this.func_174877_v().func_177956_o() + 0.5f + fy + (float)this.getFacing().func_176734_d().func_96559_d() / 2.1f, (float)this.func_174877_v().func_177952_p() + 0.5f + fz + (float)this.getFacing().func_176734_d().func_82599_e() / 2.1f, (float)this.getFacing().func_176734_d().func_82601_c() / 4.0f + fx2, (float)this.getFacing().func_176734_d().func_96559_d() / 4.0f + fy2, (float)this.getFacing().func_176734_d().func_82599_e() / 4.0f + fz2, color);
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i >= 0) {
            if (this.field_145850_b.field_72995_K) {
                this.venting = 7;
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }

    public void eject() {
        ItemStack stack = new ItemStack(ItemsTC.crystalEssence, 1, 0);
        ((ItemGenericEssentiaContainer)stack.func_77973_b()).setAspects(stack, new AspectList().add(this.aspect, 1));
        TileEntity inventory = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.getFacing().func_176734_d()));
        if (inventory != null && inventory instanceof IInventory) {
            stack = InventoryUtils.placeItemStackIntoInventory(stack, (IInventory)inventory, this.getFacing(), true);
        }
        if (stack != null) {
            this.spawnItem(stack);
        }
        this.field_145850_b.func_72908_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, "random.fizz", 0.25f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
    }

    public boolean spawnItem(ItemStack stack) {
        EntityItem ie2 = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)this.getFacing().func_176734_d().func_82601_c() * 0.65, (double)this.func_174877_v().func_177956_o() + 0.5 + (double)this.getFacing().func_176734_d().func_96559_d() * 0.65, (double)this.func_174877_v().func_177952_p() + 0.5 + (double)this.getFacing().func_176734_d().func_82599_e() * 0.65, stack);
        ie2.field_70159_w = (float)this.getFacing().func_176734_d().func_82601_c() * 0.04f;
        ie2.field_70181_x = (float)this.getFacing().func_176734_d().func_96559_d() * 0.04f;
        ie2.field_70179_y = (float)this.getFacing().func_176734_d().func_82599_e() * 0.04f;
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
        return this.field_145850_b.func_72838_d((Entity)ie2);
    }

    void fillReservoir() {
        TileEntity te = ThaumcraftApiHelper.getConnectableTile(this.field_145850_b, this.func_174877_v(), this.getFacing());
        if (te != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(this.getFacing().func_176734_d())) {
                return;
            }
            Aspect ta = null;
            if (ic.getEssentiaAmount(this.getFacing().func_176734_d()) > 0 && ic.getSuctionAmount(this.getFacing().func_176734_d()) < this.getSuctionAmount(this.getFacing()) && this.getSuctionAmount(this.getFacing()) >= ic.getMinimumSuction()) {
                ta = ic.getEssentiaType(this.getFacing().func_176734_d());
            }
            if (ta != null && ic.getSuctionAmount(this.getFacing().func_176734_d()) < this.getSuctionAmount(this.getFacing())) {
                this.addToContainer(ta, ic.takeEssentia(ta, 1, this.getFacing().func_176734_d()));
            }
        }
    }
}

