/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.client.gui.GuiResearchBrowser;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.ResearchManager;

public class PacketSyncAll
implements IMessage,
IMessageHandler<PacketSyncAll, IMessage> {
    protected String name;
    protected ArrayList<String> data = new ArrayList();
    protected HashMap<String, Byte> flags = new HashMap();
    protected int warpTemp = 0;
    protected int warpSticky = 0;
    protected int warpPerm = 0;

    public PacketSyncAll() {
    }

    public PacketSyncAll(EntityPlayer player) {
        this.name = player.func_70005_c_();
        this.data = ResearchManager.getResearchForPlayer(this.name);
        this.flags = ResearchManager.getResearchFlagsForPlayer(this.name);
        this.warpTemp = Thaumcraft.proxy.getPlayerKnowledge().getWarpTemp(this.name);
        this.warpSticky = Thaumcraft.proxy.getPlayerKnowledge().getWarpSticky(this.name);
        this.warpPerm = Thaumcraft.proxy.getPlayerKnowledge().getWarpPerm(this.name);
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        if (this.data != null && this.data.size() > 0) {
            buffer.writeShort(this.data.size());
            for (String re : this.data) {
                if (re == null) continue;
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)re);
                buffer.writeByte(this.flags.get(re) != null ? (int)this.flags.get(re).byteValue() : 0);
            }
        } else {
            buffer.writeShort(0);
        }
        buffer.writeShort(this.warpTemp);
        buffer.writeShort(this.warpSticky);
        buffer.writeShort(this.warpPerm);
    }

    public void fromBytes(ByteBuf buffer) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        int size = buffer.readShort();
        this.data = new ArrayList();
        for (int a = 0; a < size; ++a) {
            String s = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            this.data.add(s);
            this.flags.put(s, buffer.readByte());
        }
        this.warpTemp = buffer.readShort();
        this.warpSticky = buffer.readShort();
        this.warpPerm = buffer.readShort();
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketSyncAll message, MessageContext ctx) {
        boolean old = ResearchManager.loadingBlocked;
        ResearchManager.loadingBlocked = true;
        Thaumcraft.proxy.getPlayerKnowledge().wipePlayerKnowledge(message.name);
        for (String key : message.data) {
            Thaumcraft.proxy.getResearchManager();
            ResearchManager.completeResearchUnsaved(message.name, key, message.flags.get(key));
        }
        GuiResearchBrowser.completedResearch.put(message.name, message.data);
        Thaumcraft.proxy.getPlayerKnowledge().setWarpTemp(message.name, message.warpTemp);
        Thaumcraft.proxy.getPlayerKnowledge().setWarpSticky(message.name, message.warpSticky);
        Thaumcraft.proxy.getPlayerKnowledge().setWarpPerm(message.name, message.warpPerm);
        ResearchManager.loadingBlocked = old;
        return null;
    }
}

