/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.misc;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.common.tiles.crafting.TileGolemBuilder;

public class PacketStartGolemCraftToServer
implements IMessage,
IMessageHandler<PacketStartGolemCraftToServer, IMessage> {
    private int dim;
    private int playerid;
    private long pos;
    private long golem;

    public PacketStartGolemCraftToServer() {
    }

    public PacketStartGolemCraftToServer(EntityPlayer player, BlockPos pos, long golem) {
        this.dim = player.field_70170_p.field_73011_w.func_177502_q();
        this.playerid = player.func_145782_y();
        this.pos = pos.func_177986_g();
        this.golem = golem;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeInt(this.playerid);
        buffer.writeLong(this.pos);
        buffer.writeLong(this.golem);
    }

    public void fromBytes(ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.playerid = buffer.readInt();
        this.pos = buffer.readLong();
        this.golem = buffer.readLong();
    }

    public IMessage onMessage(PacketStartGolemCraftToServer message, MessageContext ctx) {
        TileEntity te;
        WorldServer world = DimensionManager.getWorld((int)message.dim);
        if (world == null || ctx.getServerHandler().field_147369_b != null && ctx.getServerHandler().field_147369_b.func_145782_y() != message.playerid) {
            return null;
        }
        Entity player = world.func_73045_a(message.playerid);
        BlockPos bp = BlockPos.func_177969_a((long)message.pos);
        if (player != null && player instanceof EntityPlayer && bp != null && (te = world.func_175625_s(bp)) != null && te instanceof TileGolemBuilder) {
            ((TileGolemBuilder)te).startCraft(message.golem, (EntityPlayer)player);
        }
        return null;
    }
}

