/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.misc;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.lib.HudHandler;

public class PacketAuraToClient
implements IMessage,
IMessageHandler<PacketAuraToClient, IMessage> {
    AspectList aura = new AspectList();

    public PacketAuraToClient() {
    }

    public PacketAuraToClient(AspectList al) {
        this.aura = al;
    }

    public void toBytes(ByteBuf dos) {
        if (this.aura != null && this.aura.size() > 0) {
            dos.writeByte(this.aura.size());
            for (Aspect a : this.aura.getAspects()) {
                if (a == null) continue;
                ByteBufUtils.writeUTF8String((ByteBuf)dos, (String)a.getTag());
                dos.writeShort(this.aura.getAmount(a));
            }
        } else {
            dos.writeShort(0);
        }
    }

    public void fromBytes(ByteBuf dat) {
        int size = dat.readByte();
        this.aura = new AspectList();
        for (int a = 0; a < size; ++a) {
            String tag = ByteBufUtils.readUTF8String((ByteBuf)dat);
            short amount = dat.readShort();
            this.aura.add(Aspect.getAspect(tag), amount);
        }
    }

    public IMessage onMessage(PacketAuraToClient message, MessageContext ctx) {
        AspectList r = message.aura;
        HudHandler.currentAura = r.copy();
        return null;
    }
}

