/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.fx;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.utils.Utils;

public class PacketFXScanSource
implements IMessage,
IMessageHandler<PacketFXScanSource, IMessage> {
    private long loc;
    private int size;

    public PacketFXScanSource() {
    }

    public PacketFXScanSource(BlockPos pos, int size) {
        this.loc = pos.func_177986_g();
        this.size = size;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeLong(this.loc);
        buffer.writeByte(this.size);
    }

    public void fromBytes(ByteBuf buffer) {
        this.loc = buffer.readLong();
        this.size = buffer.readByte();
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketFXScanSource message, MessageContext ctx) {
        this.startScan(Minecraft.func_71410_x().field_71439_g.field_70170_p, BlockPos.func_177969_a((long)message.loc), message.size);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void startScan(World world, BlockPos pos, int r) {
        int range = 4 + r * 4;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int xx = -range; xx <= range; ++xx) {
            for (int yy = -range; yy <= range; ++yy) {
                for (int zz = -range; zz <= range; ++zz) {
                    BlockPos p = pos.func_177982_a(xx, yy, zz);
                    if (!Utils.isOreBlock(world, p)) continue;
                    positions.add(p);
                }
            }
        }
        for (BlockPos p : positions) {
            int dis = MathHelper.func_76128_c((double)Math.sqrt(pos.func_177957_d((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p())));
            FXGeneric fb = new FXGeneric(world, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            fb.setMaxAge(40, dis);
            fb.func_70538_b(0.5f, 0.5f, 1.0f);
            fb.setAlphaF(0.66f, 0.0f);
            fb.setLoop(true);
            fb.setParticles(80, 16, 1);
            fb.setScale(5.0f, 1.0f);
            fb.setLayer(0);
            fb.setDepthIgnore(true);
            fb.setRotationSpeed(0.0f);
            ParticleEngine.instance.addEffect(world, fb);
        }
    }
}

