/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemGenericEssentiaContainer;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.EntityFollowingItem;
import thaumcraft.common.entities.projectile.EntityPrimalArrow;
import thaumcraft.common.items.armor.Hover;
import thaumcraft.common.items.tools.ItemBowBone;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXScanSource;
import thaumcraft.common.lib.network.fx.PacketFXSlash;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.lib.utils.Utils;

public class ToolEvents {
    HashMap<Integer, EnumFacing> lastFaceClicked = new HashMap();
    boolean blockDestructiveRecursion = false;

    @SubscribeEvent
    public void playerAttack(AttackEntityEvent event) {
        List<EnumInfusionEnchantment> list;
        ItemStack heldItem = event.entityPlayer.func_70694_bm();
        if (heldItem != null && (list = EnumInfusionEnchantment.getInfusionEnchantments(heldItem)).contains((Object)EnumInfusionEnchantment.ARCING) && event.target.func_70089_S()) {
            int rank = EnumInfusionEnchantment.getInfusionEnchantmentLevel(heldItem, EnumInfusionEnchantment.ARCING);
            List targets = event.entityPlayer.field_70170_p.func_72839_b((Entity)event.entityPlayer, event.target.func_174813_aQ().func_72314_b(1.5 + (double)rank, (double)(1.0f + (float)rank / 2.0f), 1.5 + (double)rank));
            int count = 0;
            if (targets.size() > 1) {
                for (int var9 = 0; var9 < targets.size(); ++var9) {
                    Entity var10 = (Entity)targets.get(var9);
                    if (var10.field_70128_L || var10 instanceof IEntityOwnable && ((IEntityOwnable)var10).func_70902_q() != null && ((IEntityOwnable)var10).func_70902_q().equals((Object)event.entityPlayer)) continue;
                    if (var10 instanceof EntityLiving && var10.func_145782_y() != event.target.func_145782_y() && (!(var10 instanceof EntityPlayer) || ((EntityPlayer)var10).func_70005_c_() != event.entityPlayer.func_70005_c_()) && var10.func_70089_S()) {
                        float f = (float)event.entityPlayer.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                        event.entityPlayer.func_70652_k(var10);
                        if (var10.func_70097_a(DamageSource.func_76365_a((EntityPlayer)event.entityPlayer), f * 0.5f)) {
                            try {
                                if (var10 instanceof EntityLivingBase) {
                                    EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)var10), (Entity)event.entityPlayer);
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            var10.func_70024_g((double)(-MathHelper.func_76126_a((float)(event.entityPlayer.field_70177_z * (float)Math.PI / 180.0f)) * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(event.entityPlayer.field_70177_z * (float)Math.PI / 180.0f)) * 0.5f));
                            ++count;
                            if (!event.entityPlayer.field_70170_p.field_72995_K) {
                                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXSlash(event.target.func_145782_y(), var10.func_145782_y()), new NetworkRegistry.TargetPoint(event.entityPlayer.field_70170_p.field_73011_w.func_177502_q(), event.target.field_70165_t, event.target.field_70163_u, event.target.field_70161_v, 64.0));
                            }
                        }
                    }
                    if (count >= rank) break;
                }
                if (count > 0 && !event.entityPlayer.field_70170_p.field_72995_K) {
                    event.entityPlayer.field_70170_p.func_72956_a(event.target, "thaumcraft:swing", 1.0f, 0.9f + event.entityPlayer.field_70170_p.field_73012_v.nextFloat() * 0.2f);
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXSlash(event.entityPlayer.func_145782_y(), event.target.func_145782_y()), new NetworkRegistry.TargetPoint(event.entityPlayer.field_70170_p.field_73011_w.func_177502_q(), event.entityPlayer.field_70165_t, event.entityPlayer.field_70163_u, event.entityPlayer.field_70161_v, 64.0));
                }
            }
        }
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        List<EnumInfusionEnchantment> list;
        ItemStack heldItem;
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && !event.world.field_72995_K && event.entityPlayer != null && (heldItem = event.entityPlayer.func_70694_bm()) != null && (list = EnumInfusionEnchantment.getInfusionEnchantments(heldItem)).contains((Object)EnumInfusionEnchantment.SOUNDING) && !event.entityPlayer.func_70093_af()) {
            heldItem.func_77972_a(5, (EntityLivingBase)event.entityPlayer);
            event.world.func_72908_a((double)event.pos.func_177958_n() + 0.5, (double)event.pos.func_177956_o() + 0.5, (double)event.pos.func_177952_p() + 0.5, "thaumcraft:wandfail", 0.2f, 0.2f + event.world.field_73012_v.nextFloat() * 0.2f);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketFXScanSource(event.pos, EnumInfusionEnchantment.getInfusionEnchantmentLevel(heldItem, EnumInfusionEnchantment.SOUNDING)), (EntityPlayerMP)event.entityPlayer);
        }
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && event.entityPlayer != null) {
            this.lastFaceClicked.put(event.entityPlayer.func_145782_y(), event.face);
        }
    }

    @SubscribeEvent
    public void breakBlockEvent(BlockEvent.BreakEvent event) {
        ItemStack heldItem;
        if (!event.world.field_72995_K && event.getPlayer() != null && (heldItem = event.getPlayer().func_70694_bm()) != null) {
            List<EnumInfusionEnchantment> list = EnumInfusionEnchantment.getInfusionEnchantments(heldItem);
            if (ForgeHooks.isToolEffective((IBlockAccess)event.world, (BlockPos)event.pos, (ItemStack)heldItem) && list.contains((Object)EnumInfusionEnchantment.BURROWING) && !event.getPlayer().func_70093_af() && this.isValidBurrowBlock(event.world, event.pos)) {
                event.setCanceled(true);
                BlockUtils.breakFurthestBlock(event.world, event.pos, event.state, event.getPlayer());
            }
        }
    }

    private boolean isValidBurrowBlock(World world, BlockPos pos) {
        return Utils.isWoodLog((IBlockAccess)world, pos) || Utils.isOreBlock(world, pos);
    }

    @SubscribeEvent
    public void harvestBlockEvent(BlockEvent.HarvestDropsEvent event) {
        ItemStack heldItem;
        if (!event.world.field_72995_K && event.harvester != null && (heldItem = event.harvester.func_70694_bm()) != null) {
            List<EnumInfusionEnchantment> list = EnumInfusionEnchantment.getInfusionEnchantments(heldItem);
            if (event.isSilkTouching || ForgeHooks.isToolEffective((IBlockAccess)event.world, (BlockPos)event.pos, (ItemStack)heldItem) || heldItem.func_77973_b() instanceof ItemTool && ((ItemTool)heldItem.func_77973_b()).func_150893_a(heldItem, event.state.func_177230_c()) > 1.0f) {
                if (list.contains((Object)EnumInfusionEnchantment.REFINING)) {
                    int fortune = 1 + EnumInfusionEnchantment.getInfusionEnchantmentLevel(heldItem, EnumInfusionEnchantment.REFINING);
                    float chance = (float)fortune * 0.125f;
                    boolean b = false;
                    for (int a = 0; a < event.drops.size(); ++a) {
                        ItemStack smr;
                        ItemStack is = (ItemStack)event.drops.get(a);
                        if (is.func_77969_a(smr = Utils.findSpecialMiningResult(is, chance, event.world.field_73012_v))) continue;
                        event.drops.set(a, smr);
                        b = true;
                    }
                    if (b) {
                        event.world.func_72908_a((double)((float)event.pos.func_177958_n() + 0.5f), (double)((float)event.pos.func_177956_o() + 0.5f), (double)((float)event.pos.func_177952_p() + 0.5f), "random.orb", 0.2f, 0.7f + event.world.field_73012_v.nextFloat() * 0.2f);
                    }
                }
                if (!this.blockDestructiveRecursion && list.contains((Object)EnumInfusionEnchantment.DESTRUCTIVE) && !event.harvester.func_70093_af()) {
                    this.blockDestructiveRecursion = true;
                    EnumFacing face = this.lastFaceClicked.get(event.harvester.func_145782_y());
                    if (face == null) {
                        face = BlockPistonBase.func_180695_a((World)event.world, (BlockPos)event.pos, (EntityLivingBase)event.harvester);
                    }
                    for (int aa = -1; aa <= 1; ++aa) {
                        for (int bb = -1; bb <= 1; ++bb) {
                            if (aa == 0 && bb == 0) continue;
                            int xx = 0;
                            int yy = 0;
                            int zz = 0;
                            if (face.ordinal() <= 1) {
                                xx = aa;
                                zz = bb;
                            } else if (face.ordinal() <= 3) {
                                xx = aa;
                                yy = bb;
                            } else {
                                zz = aa;
                                yy = bb;
                            }
                            Block bl = event.world.func_180495_p(event.pos.func_177982_a(xx, yy, zz)).func_177230_c();
                            if (!(bl.func_176195_g(event.world, event.pos.func_177982_a(xx, yy, zz)) >= 0.0f) || !ForgeHooks.isToolEffective((IBlockAccess)event.world, (BlockPos)event.pos.func_177982_a(xx, yy, zz), (ItemStack)heldItem) && (!(heldItem.func_77973_b() instanceof ItemTool) || !(((ItemTool)heldItem.func_77973_b()).func_150893_a(heldItem, bl) > 1.0f))) continue;
                            heldItem.func_77972_a(1, (EntityLivingBase)event.harvester);
                            BlockUtils.harvestBlock(event.world, event.harvester, event.pos.func_177982_a(xx, yy, zz));
                        }
                    }
                    this.blockDestructiveRecursion = false;
                }
                if (list.contains((Object)EnumInfusionEnchantment.COLLECTOR) && !event.harvester.func_70093_af()) {
                    InventoryUtils.dropHarvestsAtPos(event.world, event.pos, event.drops, true, 10, (Entity)event.harvester);
                    event.drops.clear();
                }
            }
        }
    }

    @SubscribeEvent
    public void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (!event.entityPlayer.field_70122_E && Hover.getHover(event.entityPlayer.func_145782_y())) {
            event.newSpeed = event.originalSpeed * 5.0f;
        }
    }

    @SubscribeEvent
    public void bowNocked(ArrowNockEvent event) {
        if (event.entityPlayer.field_71071_by.func_146028_b(ItemsTC.primalArrows)) {
            event.entityPlayer.func_71008_a(event.result, event.result.func_77973_b().func_77626_a(event.result));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void bowShot(ArrowLooseEvent event) {
        if (event.entityPlayer.field_71071_by.func_146028_b(ItemsTC.primalArrows)) {
            float f = 0.0f;
            float dam = 2.0f;
            if (event.bow.func_77973_b() instanceof ItemBowBone) {
                f = (float)event.charge / 10.0f;
                if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
                dam = 2.5f;
            } else {
                f = (float)event.charge / 20.0f;
                if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            int type = 0;
            for (int j = 0; j < event.entityPlayer.field_71071_by.field_70462_a.length; ++j) {
                if (event.entityPlayer.field_71071_by.field_70462_a[j] == null || event.entityPlayer.field_71071_by.field_70462_a[j].func_77973_b() != ItemsTC.primalArrows) continue;
                type = event.entityPlayer.field_71071_by.field_70462_a[j].func_77952_i();
                break;
            }
            EntityPrimalArrow entityarrow = new EntityPrimalArrow(event.entityPlayer.field_70170_p, (EntityLivingBase)event.entityPlayer, f * dam, type);
            if (event.bow.func_77973_b() instanceof ItemBowBone) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + 0.5);
            } else if (f == 1.0f) {
                entityarrow.func_70243_d(true);
            }
            int k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)event.bow);
            if (k > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)k * 0.5 + 0.5);
            }
            int l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)event.bow);
            if (type == 3) {
                ++l;
            }
            if (l > 0) {
                entityarrow.func_70240_a(l);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)event.bow) > 0) {
                entityarrow.func_70015_d(100);
            }
            event.bow.func_77972_a(1, (EntityLivingBase)event.entityPlayer);
            event.entityPlayer.field_70170_p.func_72956_a((Entity)event.entityPlayer, "random.bow", 1.0f, 1.0f / (event.entityPlayer.field_70170_p.field_73012_v.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            boolean flag = false;
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)event.bow) > 0 && event.entityPlayer.field_70170_p.field_73012_v.nextFloat() < 0.33f) {
                flag = true;
            }
            if (!event.entityPlayer.field_71075_bZ.field_75098_d || !flag) {
                InventoryUtils.consumeInventoryItem(event.entityPlayer, ItemsTC.primalArrows, type);
            }
            if (!event.entityPlayer.field_70170_p.field_72995_K) {
                event.entityPlayer.field_70170_p.func_72838_d((Entity)entityarrow);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void fillBucket(FillBucketEvent event) {
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            IBlockState bs = event.world.func_180495_p(event.target.func_178782_a());
            if (bs.func_177230_c() == BlocksTC.purifyingFluid && ((BlockFluidClassic)bs.func_177230_c()).isSourceBlock((IBlockAccess)event.world, event.target.func_178782_a())) {
                event.world.func_175698_g(event.target.func_178782_a());
                event.result = new ItemStack(ItemsTC.bucketPure);
                event.setResult(Event.Result.ALLOW);
                return;
            }
            if (bs.func_177230_c() == BlocksTC.liquidDeath && ((BlockFluidClassic)bs.func_177230_c()).isSourceBlock((IBlockAccess)event.world, event.target.func_178782_a())) {
                event.world.func_175698_g(event.target.func_178782_a());
                event.result = new ItemStack(ItemsTC.bucketDeath);
                event.setResult(Event.Result.ALLOW);
                return;
            }
        }
    }

    @SubscribeEvent
    public void livingDrops(LivingDropsEvent event) {
        ItemStack heldItem;
        if (event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityPlayer && (heldItem = ((EntityPlayer)event.source.func_76346_g()).func_70694_bm()) != null) {
            AspectList aspects;
            List<EnumInfusionEnchantment> list = EnumInfusionEnchantment.getInfusionEnchantments(heldItem);
            if (list.contains((Object)EnumInfusionEnchantment.COLLECTOR)) {
                boolean b = false;
                for (int a = 0; a < event.drops.size(); ++a) {
                    EntityItem ei = (EntityItem)event.drops.get(a);
                    ItemStack is = ei.func_92059_d().func_77946_l();
                    EntityFollowingItem nei = new EntityFollowingItem(event.entity.field_70170_p, ei.field_70165_t, ei.field_70163_u, ei.field_70161_v, is, event.source.func_76346_g(), 10);
                    nei.field_70159_w = ei.field_70159_w;
                    nei.field_70181_x = ei.field_70181_x;
                    nei.field_70179_y = ei.field_70179_y;
                    nei.func_174869_p();
                    ei.func_70106_y();
                    event.drops.set(a, nei);
                }
            }
            if (list.contains((Object)EnumInfusionEnchantment.ESSENCE) && (aspects = AspectHelper.getEntityAspects((Entity)event.entityLiving).copy()) != null && aspects.size() > 0) {
                int b;
                int q = EnumInfusionEnchantment.getInfusionEnchantmentLevel(heldItem, EnumInfusionEnchantment.ESSENCE);
                Aspect[] al = aspects.getAspects();
                int n = b = event.entity.field_70170_p.field_73012_v.nextInt(5) < q ? 0 : 99;
                while (b < q && al != null && al.length > 0) {
                    Aspect aspect = al[event.entity.field_70170_p.field_73012_v.nextInt(al.length)];
                    if (aspects.getAmount(aspect) > 0) {
                        aspects.remove(aspect, 1);
                        ItemStack stack = new ItemStack(ItemsTC.crystalEssence, 1, 0);
                        ((ItemGenericEssentiaContainer)stack.func_77973_b()).setAspects(stack, new AspectList().add(aspect, 1));
                        if (list.contains((Object)EnumInfusionEnchantment.COLLECTOR)) {
                            event.drops.add(new EntityFollowingItem(event.entity.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u + (double)event.entityLiving.func_70047_e(), event.entityLiving.field_70161_v, stack, event.source.func_76346_g(), 10));
                        } else {
                            event.drops.add(new EntityItem(event.entity.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u + (double)event.entityLiving.func_70047_e(), event.entityLiving.field_70161_v, stack));
                        }
                        ++b;
                    }
                    al = aspects.getAspects();
                    if (event.entity.field_70170_p.field_73012_v.nextInt(q) != 0) continue;
                    b += 1 + event.entity.field_70170_p.field_73012_v.nextInt(2);
                }
            }
        }
    }
}

