/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.internal.EnumWarpType;
import thaumcraft.api.research.ResearchHelper;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.EntityTaintSource;
import thaumcraft.common.entities.EntityTaintSourceCloud;
import thaumcraft.common.entities.EntityTaintSourceLightning;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.entities.monster.tainted.EntityTaintCrawler;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.aura.EntityAuraNode;
import thaumcraft.common.lib.aura.NodeType;
import thaumcraft.common.lib.potions.PotionInfectiousVisExhaust;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.RandomItemChooser;

public class TaintEvents {
    static ArrayList<RandomItemChooser.Item> events = new ArrayList();

    protected static boolean taintEvent(World world, BlockPos pos) {
        RandomItemChooser ric = new RandomItemChooser();
        TaintItem ei = (TaintItem)ric.chooseOnWeight(events);
        if (ei == null) {
            return false;
        }
        pos = pos.func_177982_a(world.field_73012_v.nextInt(16), 0, world.field_73012_v.nextInt(16));
        BlockPos p2 = world.func_175725_q(pos);
        if (!ei.nearTaintAllowed && TaintEvents.nearTaint(world, p2)) {
            return false;
        }
        if (!AuraHandler.drainAura(world, p2, Aspect.FLUX, ei.cost, false)) {
            return false;
        }
        boolean didit = false;
        switch (ei.event) {
            case 0: {
                if (p2.func_177956_o() + 5 >= world.func_72940_L()) break;
                EntityWisp wisp = new EntityWisp(world);
                wisp.func_70012_b(p2.func_177958_n(), p2.func_177956_o() + 5, p2.func_177952_p(), 0.0f, 0.0f);
                if (world.field_73012_v.nextInt(3) == 0) {
                    wisp.setType(Aspect.FLUX.getTag());
                }
                if (!world.func_72838_d((Entity)wisp)) break;
                didit = true;
                break;
            }
            case 1: {
                BlockPos blockpos = TaintEvents.findSpotToStrike(world, pos);
                if (!world.func_175678_i(blockpos) || !world.func_72838_d((Entity)new EntityTaintSourceLightning(world, blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p()))) break;
                didit = true;
                break;
            }
            case 2: {
                EntityTaintSourceCloud e;
                pos = p2.func_177981_b(20);
                if (pos.func_177956_o() >= world.func_72940_L() || !world.func_72838_d((Entity)(e = new EntityTaintSourceCloud(world, pos, (30 + world.field_73012_v.nextInt(10)) * 20)))) break;
                didit = true;
                break;
            }
            case 3: {
                if (p2.func_177956_o() + 1 >= world.func_72940_L()) break;
                EntityTaintCrawler crawler = new EntityTaintCrawler(world);
                crawler.func_70012_b(p2.func_177958_n(), p2.func_177956_o() + 1, p2.func_177952_p(), 0.0f, 0.0f);
                if (!world.func_72838_d((Entity)crawler)) break;
                didit = true;
                break;
            }
            case 4: {
                List targets = world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_178781_a((double)p2.func_177958_n(), (double)p2.func_177956_o(), (double)p2.func_177952_p(), (double)(p2.func_177958_n() + 1), (double)(p2.func_177956_o() + 1), (double)(p2.func_177952_p() + 1)).func_72314_b(16.0, 16.0, 16.0));
                if (targets == null || targets.size() <= 0) break;
                for (EntityPlayer target : targets) {
                    target.func_145747_a((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.func_74838_a((String)"tc.fluxevent.1")));
                    if (world.field_73012_v.nextFloat() < 0.25f) {
                        ResearchHelper.addWarpToPlayer(target, 1, EnumWarpType.NORMAL);
                    } else {
                        ResearchHelper.addWarpToPlayer(target, 2 + world.field_73012_v.nextInt(4), EnumWarpType.TEMPORARY);
                    }
                    didit = true;
                }
                break;
            }
            case 5: {
                List targets2 = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_178781_a((double)p2.func_177958_n(), (double)p2.func_177956_o(), (double)p2.func_177952_p(), (double)(p2.func_177958_n() + 1), (double)(p2.func_177956_o() + 1), (double)(p2.func_177952_p() + 1)).func_72314_b(16.0, 16.0, 16.0));
                if (targets2 == null || targets2.size() <= 0) break;
                for (EntityLivingBase target : targets2) {
                    didit = true;
                    if (target instanceof EntityPlayer) {
                        target.func_145747_a((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.func_74838_a((String)"tc.fluxevent.2")));
                    }
                    PotionEffect pe = new PotionEffect(PotionInfectiousVisExhaust.instance.func_76396_c(), 3000, 2);
                    pe.getCurativeItems().clear();
                    try {
                        target.func_70690_d(pe);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            case 6: {
                EntityAuraNode node;
                List targets3 = world.func_72872_a(EntityAuraNode.class, AxisAlignedBB.func_178781_a((double)p2.func_177958_n(), (double)p2.func_177956_o(), (double)p2.func_177952_p(), (double)(p2.func_177958_n() + 1), (double)(p2.func_177956_o() + 1), (double)(p2.func_177952_p() + 1)).func_72314_b(16.0, 16.0, 16.0));
                if (targets3 == null || targets3.size() <= 0 || (node = (EntityAuraNode)((Object)targets3.get(world.field_73012_v.nextInt(targets3.size())))) == null) break;
                didit = true;
                node.setNodeType(world.field_73012_v.nextBoolean() ? 5 : world.field_73012_v.nextInt(NodeType.nodeTypes.length));
            }
        }
        if (didit) {
            AuraHandler.drainAura(world, p2, Aspect.FLUX, ei.cost);
        }
        return true;
    }

    private static BlockPos findSpotToStrike(final World world, BlockPos pos) {
        BlockPos blockpos1 = world.func_175725_q(pos);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockpos1, new BlockPos(blockpos1.func_177958_n(), world.func_72800_K(), blockpos1.func_177952_p())).func_72314_b(4.0, 4.0, 4.0);
        List list = world.func_175647_a(EntityLivingBase.class, axisalignedbb, new Predicate(){

            public boolean applyLiving(EntityLivingBase living) {
                return living != null && living.func_70089_S() && world.func_175678_i(living.func_180425_c());
            }

            public boolean apply(Object p_apply_1_) {
                return this.applyLiving((EntityLivingBase)p_apply_1_);
            }
        });
        return !list.isEmpty() ? ((EntityLivingBase)list.get(world.field_73012_v.nextInt(list.size()))).func_180425_c() : blockpos1;
    }

    private static boolean nearTaint(World world, BlockPos pos) {
        for (EnumFacing d : EnumFacing.field_176754_o) {
            BiomeGenBase biome = world.func_180494_b(pos.func_177967_a(d, 16));
            if (biome.field_76756_M != Config.biomeTaintID) continue;
            return true;
        }
        return EntityUtils.getEntitiesInRange(world, pos, null, EntityTaintSource.class, 32.0).size() > 0;
    }

    static {
        events.add(new TaintItem(0, 25, 5, true));
        events.add(new TaintItem(1, 5, 25, false));
        events.add(new TaintItem(2, 1, 40, false));
        events.add(new TaintItem(3, 2, 10, true));
        events.add(new TaintItem(4, 5, 20, true));
        events.add(new TaintItem(5, 5, 15, true));
        events.add(new TaintItem(6, 3, 20, true));
    }

    static class TaintItem
    implements RandomItemChooser.Item {
        int weight;
        int event;
        int cost;
        boolean nearTaintAllowed;

        protected TaintItem(int event, int weight, int cost, boolean nearTaintAllowed) {
            this.weight = weight;
            this.event = event;
            this.cost = cost;
            this.nearTaintAllowed = nearTaintAllowed;
        }

        @Override
        public double getWeight() {
            return this.weight;
        }
    }
}

