/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.crafting;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.items.IRunicArmor;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchHelper;
import thaumcraft.common.lib.events.PlayerEvents;

public class InfusionRunicAugmentRecipe
extends InfusionRecipe {
    private ItemStack[] components;

    public InfusionRunicAugmentRecipe() {
        super("RUNICAUGMENTATION", null, 0, null, null, (Object[])new ItemStack[]{new ItemStack(Items.field_151045_i), new ItemStack(ItemsTC.salisMundus)});
    }

    public InfusionRunicAugmentRecipe(ItemStack in) {
        super("RUNICAUGMENTATION", null, 0, null, (Object)in, (Object[])new ItemStack[]{new ItemStack(Items.field_151045_i), new ItemStack(ItemsTC.salisMundus)});
        this.components = new ItemStack[]{new ItemStack(Items.field_151045_i), new ItemStack(ItemsTC.salisMundus)};
        int fc = PlayerEvents.getFinalCharge(in);
        if (fc > 0) {
            ArrayList<ItemStack> com = new ArrayList<ItemStack>();
            com.add(new ItemStack(Items.field_151045_i));
            com.add(new ItemStack(ItemsTC.salisMundus));
            for (int c = 0; c < fc; ++c) {
                com.add(new ItemStack(ItemsTC.salisMundus));
            }
            this.components = com.toArray(this.components);
        }
    }

    @Override
    public boolean matches(ArrayList<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
        if (this.research != null && this.research[0].length() > 0 && !ResearchHelper.isResearchComplete(player.func_70005_c_(), this.research)) {
            return false;
        }
        if (!(central.func_77973_b() instanceof IRunicArmor)) {
            return false;
        }
        ItemStack i2 = null;
        ArrayList<ItemStack> ii = new ArrayList<ItemStack>();
        for (ItemStack is : input) {
            ii.add(is.func_77946_l());
        }
        for (ItemStack comp : this.getComponents(central)) {
            boolean b = false;
            for (int a = 0; a < ii.size(); ++a) {
                i2 = ((ItemStack)ii.get(a)).func_77946_l();
                if (!ThaumcraftApiHelper.areItemStacksEqualForCrafting(i2, comp)) continue;
                ii.remove(a);
                b = true;
                break;
            }
            if (b) continue;
            return false;
        }
        return ii.size() == 0;
    }

    @Override
    public Object getRecipeOutput(EntityPlayer player, ItemStack input, ArrayList<ItemStack> comps) {
        if (input == null) {
            return null;
        }
        ItemStack out = input.func_77946_l();
        int base = PlayerEvents.getHardening(input) + 1;
        out.func_77983_a("RS.HARDEN", (NBTBase)new NBTTagByte((byte)base));
        return out;
    }

    @Override
    public AspectList getAspects(EntityPlayer player, ItemStack input, ArrayList<ItemStack> comps) {
        AspectList out = new AspectList();
        int vis = (int)(32.0 * Math.pow(2.0, PlayerEvents.getFinalCharge(input)));
        if (vis > 0) {
            out.add(Aspect.PROTECT, vis / 2);
            out.add(Aspect.CRYSTAL, vis / 2);
            out.add(Aspect.ENERGY, vis);
        }
        return out;
    }

    @Override
    public int getInstability(EntityPlayer player, ItemStack input, ArrayList<ItemStack> comps) {
        int i = 5 + PlayerEvents.getFinalCharge(input) / 2;
        return i;
    }

    public ItemStack[] getComponents(ItemStack input) {
        ArrayList<ItemStack> com = new ArrayList<ItemStack>();
        com.add(new ItemStack(Items.field_151045_i));
        com.add(new ItemStack(ItemsTC.salisMundus));
        int fc = PlayerEvents.getFinalCharge(input);
        if (fc > 0) {
            for (int c = 0; c < fc; ++c) {
                com.add(new ItemStack(ItemsTC.salisMundus));
            }
        }
        return com.toArray(new ItemStack[0]);
    }

    public ItemStack[] getComponents() {
        return this.components;
    }
}

