/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.aura;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.aura.NodeType;
import thaumcraft.common.lib.utils.EntityUtils;

public class EntityAuraNode
extends Entity {
    private int tickCounter = -1;
    int checkDelay = -1;
    ArrayList<Entity> neighbours = null;
    public boolean stablized = false;

    public EntityAuraNode(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70178_ae = true;
        this.field_70155_l = 4.0;
        this.field_70145_X = true;
    }

    public void func_70071_h_() {
        if (this.getNodeSize() == 0) {
            this.randomizeNode();
        }
        if (this.tickCounter < 0) {
            this.tickCounter = this.field_70146_Z.nextInt(200);
        }
        this.field_70170_p.field_72984_F.func_76320_a("entityBaseTick");
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        NodeType.nodeTypes[this.getNodeType()].performTickEvent(this);
        if (this.tickCounter++ > 200) {
            this.tickCounter = 0;
            NodeType.nodeTypes[this.getNodeType()].performPeriodicEvent(this);
        }
        this.checkAdjacentNodes();
        if (this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0) {
            this.field_70159_w *= 0.8;
            this.field_70181_x *= 0.8;
            this.field_70179_y *= 0.8;
            super.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    private void checkAdjacentNodes() {
        if (this.neighbours == null || this.checkDelay < this.field_70173_aa) {
            this.neighbours = EntityUtils.getEntitiesInRange(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this, EntityAuraNode.class, 32.0);
            this.checkDelay = this.field_70173_aa + 750;
        }
        if (!this.stablized) {
            try {
                Iterator<Entity> i = this.neighbours.iterator();
                while (i.hasNext()) {
                    Aspect a;
                    Entity e = i.next();
                    if (e == null || e.field_70128_L || !(e instanceof EntityAuraNode)) {
                        i.remove();
                        continue;
                    }
                    EntityAuraNode an = (EntityAuraNode)e;
                    if (an.stablized) continue;
                    double xd = this.field_70165_t - an.field_70165_t;
                    double yd = this.field_70163_u - an.field_70163_u;
                    double zd = this.field_70161_v - an.field_70161_v;
                    double d = xd * xd + yd * yd + zd * zd;
                    if (d < (double)(this.getNodeSize() + an.getNodeSize()) * 1.5 && d > 0.1) {
                        float tq = (float)(this.getNodeSize() + an.getNodeSize()) * 1.5f;
                        float xm = (float)(-xd / d / (double)tq * ((double)an.getNodeSize() / 50.0));
                        float ym = (float)(-yd / d / (double)tq * ((double)an.getNodeSize() / 50.0));
                        float zm = (float)(-zd / d / (double)tq * ((double)an.getNodeSize() / 50.0));
                        this.field_70159_w += (double)xm;
                        this.field_70181_x += (double)ym;
                        this.field_70179_y += (double)zm;
                        continue;
                    }
                    if (!(d <= 0.1) || this.getNodeSize() < an.getNodeSize() || this.field_70170_p.field_72995_K) continue;
                    int bonus = (int)Math.sqrt(an.getNodeSize());
                    int n = this.getNodeSize() + bonus;
                    this.setNodeSize(n);
                    if ((double)this.field_70146_Z.nextInt(100) < Math.sqrt(an.getNodeSize()) && (a = AspectHelper.getCombinationResult(this.getAspect(), an.getAspect())) != null) {
                        this.setAspectTag(a.getTag());
                    }
                    if (this.getNodeType() == 0 && an.getNodeType() != 0 && this.field_70146_Z.nextInt(3) == 0 || this.getNodeType() != 0 && an.getNodeType() != 0 && (double)this.field_70146_Z.nextInt(100) < Math.sqrt(an.getNodeSize() / 2)) {
                        this.setNodeType(an.getNodeType());
                    }
                    an.func_70106_y();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.field_70173_aa % 50 == 0) {
            this.stablized = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() == BlocksTC.nodeStabilizer && !this.field_70170_p.func_175640_z(this.func_180425_c().func_177977_b());
        }
    }

    public int getNodeSize() {
        return this.field_70180_af.func_75679_c(8);
    }

    public void setNodeSize(int p) {
        this.field_70180_af.func_75692_b(8, (Object)p);
    }

    public String getAspectTag() {
        return this.field_70180_af.func_75681_e(9);
    }

    public Aspect getAspect() {
        return Aspect.getAspect(this.getAspectTag());
    }

    public void setAspectTag(String t) {
        this.field_70180_af.func_75692_b(9, (Object)String.valueOf(t));
    }

    public int getNodeType() {
        return this.field_70180_af.func_75683_a(10);
    }

    public void setNodeType(int p) {
        this.field_70180_af.func_75692_b(10, (Object)((byte)MathHelper.func_76125_a((int)p, (int)0, (int)(NodeType.nodeTypes.length - 1))));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(8, (Object)0);
        this.field_70180_af.func_75682_a(9, (Object)String.valueOf(""));
        this.field_70180_af.func_75682_a(10, (Object)0);
    }

    public void randomizeNode() {
        this.setNodeSize(2 + Config.AURABASE / 3 + this.field_70146_Z.nextInt(2 + Config.AURABASE / 3));
        if (this.field_70146_Z.nextInt(Config.specialNodeRarity) == 0 && NodeType.nodeTypes.length > 1) {
            this.setNodeType(1 + this.field_70146_Z.nextInt(NodeType.nodeTypes.length - 1));
            if (this.getNodeType() == 4 && (double)this.field_70146_Z.nextFloat() < 0.33) {
                this.setNodeType(0);
            }
            if (!Config.genTaint && this.getNodeType() == 4) {
                this.setNodeType(0);
            }
        } else {
            this.setNodeType(0);
        }
        ArrayList<Aspect> al = Aspect.getPrimalAspects();
        if (this.field_70146_Z.nextInt(20) == 0) {
            al = Aspect.getCompoundAspects();
        }
        this.setAspectTag(al.get(this.field_70146_Z.nextInt(al.size())).getTag());
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_85031_j(Entity entityIn) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public void func_70091_d(double x, double y, double z) {
    }

    protected boolean func_142008_O() {
        return false;
    }

    private void onBroken(Entity entity) {
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
        this.setNodeSize(tagCompound.func_74762_e("size"));
        this.setNodeType(tagCompound.func_74771_c("type"));
        this.setAspectTag(tagCompound.func_74779_i("aspect"));
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("size", this.getNodeSize());
        tagCompound.func_74774_a("type", (byte)this.getNodeType());
        tagCompound.func_74778_a("aspect", this.getAspectTag());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double p_180426_1_, double p_180426_3_, double p_180426_5_, float p_180426_7_, float p_180426_8_, int p_180426_9_, boolean p_180426_10_) {
        this.func_70107_b(p_180426_1_, p_180426_3_, p_180426_5_);
        this.func_70101_b(p_180426_7_, p_180426_8_);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }
}

