/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.golems.seals.ISeal;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.seals.SealPos;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.api.internal.EnumWarpType;
import thaumcraft.api.internal.IInternalMethodHandler;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.api.wands.IWand;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.construct.golem.seals.ItemSealPlacer;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.items.wands.WandManager;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.events.PlayerEvents;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXPollute;
import thaumcraft.common.lib.network.playerdata.PacketResearchComplete;
import thaumcraft.common.lib.network.playerdata.PacketSyncResearchFlags;
import thaumcraft.common.lib.network.playerdata.PacketSyncWarp;
import thaumcraft.common.lib.network.playerdata.PacketWarpMessage;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.utils.Utils;

public class InternalMethodHandler
implements IInternalMethodHandler {
    @Override
    public boolean isResearchComplete(String username, String researchkey) {
        return ResearchManager.isResearchComplete(username, researchkey);
    }

    @Override
    public AspectList getObjectAspects(ItemStack is) {
        return ThaumcraftCraftingManager.getObjectTags(is);
    }

    @Override
    public AspectList generateTags(Item item, int meta) {
        return ThaumcraftCraftingManager.generateTags(item, meta);
    }

    @Override
    public boolean consumeVisFromWand(ItemStack wand, EntityPlayer player, AspectList cost, boolean doit, boolean crafting) {
        if (wand.func_77973_b() instanceof IWand) {
            return ((IWand)wand.func_77973_b()).consumeAllVis(wand, player, cost, doit, crafting);
        }
        return false;
    }

    @Override
    public boolean consumeVisFromInventory(EntityPlayer player, AspectList cost) {
        return WandManager.consumeVisFromInventory(player, cost);
    }

    @Override
    public void addWarpToPlayer(EntityPlayer player, int amount, EnumWarpType type) {
        if (amount == 0 || player.field_70170_p.field_72995_K || Thaumcraft.proxy.getPlayerKnowledge() == null) {
            return;
        }
        if (amount < 0 && this.getPlayerWarp(player, type) + amount < 0) {
            amount = this.getPlayerWarp(player, type);
        }
        if (type == EnumWarpType.TEMPORARY) {
            Thaumcraft.proxy.getPlayerKnowledge().addWarpTemp(player.func_70005_c_(), amount);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncWarp(player, 2), (EntityPlayerMP)player);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketWarpMessage(player, 2, amount), (EntityPlayerMP)player);
        }
        if (type == EnumWarpType.PERMANENT) {
            Thaumcraft.proxy.getPlayerKnowledge().addWarpPerm(player.func_70005_c_(), amount);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncWarp(player, 0), (EntityPlayerMP)player);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketWarpMessage(player, 0, amount), (EntityPlayerMP)player);
        }
        if (type == EnumWarpType.NORMAL) {
            Thaumcraft.proxy.getPlayerKnowledge().addWarpSticky(player.func_70005_c_(), amount);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncWarp(player, 1), (EntityPlayerMP)player);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketWarpMessage(player, 1, amount), (EntityPlayerMP)player);
        }
        Thaumcraft.proxy.getPlayerKnowledge().setWarpCounter(player.func_70005_c_(), Thaumcraft.proxy.getPlayerKnowledge().getWarpTotal(player.func_70005_c_()));
    }

    @Override
    public int getPlayerWarp(EntityPlayer player, EnumWarpType type) {
        if (type == EnumWarpType.TEMPORARY) {
            return Thaumcraft.proxy.getPlayerKnowledge().getWarpTemp(player.func_70005_c_());
        }
        if (type == EnumWarpType.PERMANENT) {
            return Thaumcraft.proxy.getPlayerKnowledge().getWarpPerm(player.func_70005_c_());
        }
        if (type == EnumWarpType.NORMAL) {
            return Thaumcraft.proxy.getPlayerKnowledge().getWarpSticky(player.func_70005_c_());
        }
        return 0;
    }

    @Override
    public void markRunicDirty(Entity entity) {
        PlayerEvents.markRunicDirty(entity);
    }

    @Override
    public boolean completeResearch(EntityPlayer player, String researchkey) {
        if (!ResearchManager.isResearchComplete(player.func_70005_c_(), researchkey) && ResearchManager.doesPlayerHaveRequisites(player.func_70005_c_(), researchkey)) {
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketResearchComplete(researchkey, (byte)Utils.setBit(0, 1)), (EntityPlayerMP)player);
            Thaumcraft.proxy.getResearchManager().completeResearch(player, researchkey, (byte)Utils.setBit(0, 1));
            if (ResearchCategories.getResearch(researchkey) != null && ResearchCategories.getResearch((String)researchkey).siblings != null) {
                for (String sibling : ResearchCategories.getResearch((String)researchkey).siblings) {
                    if (ResearchManager.isResearchComplete(player.func_70005_c_(), sibling) || !ResearchManager.doesPlayerHaveRequisites(player.func_70005_c_(), sibling)) continue;
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketResearchComplete(sibling, (byte)Utils.setBit(0, 1)), (EntityPlayerMP)player);
                    Thaumcraft.proxy.getResearchManager().completeResearch(player, sibling, (byte)Utils.setBit(0, 1));
                }
            }
            for (String rc : ResearchCategories.researchCategories.keySet()) {
                block2: for (ResearchItem ri : ResearchCategories.getResearchList((String)rc).research.values()) {
                    if (ri == null || ri.getPages() == null) continue;
                    for (ResearchPage page : ri.getPages()) {
                        if (page.research == null || !page.research.equals(researchkey)) continue;
                        ChatComponentTranslation text = new ChatComponentTranslation("tc.addpage", new Object[]{ri.getName()});
                        player.func_145747_a((IChatComponent)text);
                        ResearchManager.setNewPageFlag(player.func_70005_c_(), ri.key);
                        PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncResearchFlags(player, ri.key), (EntityPlayerMP)player);
                        continue block2;
                    }
                }
            }
            player.func_71023_q(5);
            return true;
        }
        return false;
    }

    @Override
    public boolean drainAura(World world, BlockPos pos, Aspect aspect, int amount) {
        return AuraHandler.drainAura(world, pos, aspect, amount);
    }

    @Override
    public int drainAuraAvailable(World world, BlockPos pos, Aspect aspect, int amount) {
        return AuraHandler.drainAuraAvailable(world, pos, aspect, amount);
    }

    @Override
    public void addAura(World world, BlockPos pos, Aspect aspect, int amount) {
        AuraHandler.addRechargeTicket(world, pos, aspect, amount);
    }

    @Override
    public int getAura(World world, BlockPos pos, Aspect aspect) {
        return AuraHandler.getAuraCurrent(world, pos, aspect);
    }

    @Override
    public int getAuraBase(World world, BlockPos pos) {
        return AuraHandler.getAuraBase(world, pos);
    }

    @Override
    public void pollute(World world, BlockPos pos, int amount, boolean showEffect) {
        if (world.field_72995_K) {
            return;
        }
        AuraHandler.addRechargeTicket(world, pos, Aspect.FLUX, amount);
        if (showEffect) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXPollute(pos, amount), new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0));
        }
    }

    @Override
    public void registerSeal(ISeal seal) {
        SealHandler.registerSeal(seal);
    }

    @Override
    public ISeal getSeal(String key) {
        return SealHandler.getSeal(key);
    }

    @Override
    public ISealEntity getSealEntity(int dim, SealPos pos) {
        return SealHandler.getSealEntity(dim, pos);
    }

    @Override
    public void addGolemTask(int dim, Task task) {
        TaskHandler.addTask(dim, task);
    }

    @Override
    public boolean shouldPreserveAura(World world, EntityPlayer player, BlockPos pos, Aspect aspect) {
        return AuraHandler.shouldPreserveAura(world, player, pos, aspect);
    }

    @Override
    public ItemStack getSealStack(String key) {
        return ItemSealPlacer.getSealStack(key);
    }
}

