/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.entities.projectile.EntityPrimalOrb;

public class ItemFocusPrimal
extends ItemFocusBasic {
    public static FocusUpgradeType seeker = new FocusUpgradeType(new ResourceLocation("thaumcraft", "textures/foci/seeker.png"), "focus.upgrade.seeker.name", "focus.upgrade.seeker.text", new AspectList().add(Aspect.SENSES, 1).add(Aspect.MIND, 1));

    public ItemFocusPrimal() {
        super("primal", 10854849);
    }

    @Override
    public boolean canBePlacedInTurret() {
        return true;
    }

    @Override
    public int getActivationCooldown(ItemStack focusstack) {
        return 500;
    }

    @Override
    public boolean onFocusActivation(ItemStack itemstack, World world, EntityLivingBase p, MovingObjectPosition mop, int count) {
        IWand wand = (IWand)itemstack.func_77973_b();
        EntityPrimalOrb shard = new EntityPrimalOrb(world, p, this.isUpgradedWith(wand.getFocusStack(itemstack), seeker));
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)shard);
            world.func_72956_a((Entity)shard, "thaumcraft:ice", 0.3f, 0.8f + world.field_73012_v.nextFloat() * 0.1f);
        }
        p.func_71038_i();
        return true;
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        Random rand = new Random(System.currentTimeMillis() / 200L);
        AspectList cost = new AspectList().add(Aspect.WATER, 10 + rand.nextInt(5) * 2).add(Aspect.AIR, 10 + rand.nextInt(5) * 2).add(Aspect.EARTH, 10 + rand.nextInt(5) * 2).add(Aspect.FIRE, 10 + rand.nextInt(5) * 2).add(Aspect.ORDER, 10 + rand.nextInt(5) * 2).add(Aspect.ENTROPY, 10 + rand.nextInt(5) * 2);
        return cost;
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, seeker};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
        }
        return null;
    }
}

