/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.entities.projectile.EntityPechBlast;

public class ItemFocusPech
extends ItemFocusBasic {
    private static final AspectList cost = new AspectList().add(Aspect.EARTH, 2).add(Aspect.ENTROPY, 2).add(Aspect.WATER, 2);
    private static final AspectList costAll = new AspectList().add(Aspect.AIR, 1).add(Aspect.FIRE, 1).add(Aspect.EARTH, 1).add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1).add(Aspect.WATER, 1);
    public static FocusUpgradeType nightshade = new FocusUpgradeType(new ResourceLocation("thaumcraft", "textures/foci/nightshade.png"), "focus.upgrade.nightshade.name", "focus.upgrade.nightshade.text", new AspectList().add(Aspect.LIFE, 1).add(Aspect.FLUX, 1).add(Aspect.ENERGY, 1));

    public ItemFocusPech() {
        super("pech", 0x229944);
    }

    @Override
    public boolean canBePlacedInTurret() {
        return true;
    }

    @Override
    public float getTurretCorrection(ItemStack focusstack) {
        return 12.0f;
    }

    @Override
    public int getActivationCooldown(ItemStack focusstack) {
        return 250;
    }

    @Override
    public boolean onFocusActivation(ItemStack itemstack, World world, EntityLivingBase p, MovingObjectPosition movingobjectposition, int count) {
        IWand wand = (IWand)itemstack.func_77973_b();
        EntityPechBlast blast = new EntityPechBlast(world, p, wand.getFocusPotency(itemstack), wand.getFocusExtend(itemstack), this.isUpgradedWith(wand.getFocusStack(itemstack), nightshade));
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)blast);
            world.func_72956_a((Entity)blast, "thaumcraft:ice", 0.4f, 1.0f + world.field_73012_v.nextFloat() * 0.1f);
        }
        p.func_71038_i();
        return true;
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        return this.isUpgradedWith(itemstack, nightshade) ? costAll : cost;
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.extend};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.extend};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, nightshade};
            }
        }
        return null;
    }
}

