/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.entities.projectile.EntityFrostShard;

public class ItemFocusFrost
extends ItemFocusBasic {
    private static final AspectList costBase = new AspectList().add(Aspect.WATER, 2).add(Aspect.FIRE, 1).add(Aspect.ENTROPY, 2);
    private static final AspectList costScatter = new AspectList().add(Aspect.WATER, 2).add(Aspect.FIRE, 1).add(Aspect.ENTROPY, 1).add(Aspect.AIR, 2);
    private static final AspectList costBoulder = new AspectList().add(Aspect.WATER, 2).add(Aspect.FIRE, 1).add(Aspect.ENTROPY, 1).add(Aspect.EARTH, 2);
    public static FocusUpgradeType scattershot = new FocusUpgradeType(new ResourceLocation("thaumcraft", "textures/foci/scattershot.png"), "focus.upgrade.scattershot.name", "focus.upgrade.scattershot.text", new AspectList().add(Aspect.COLD, 1).add(Aspect.AVERSION, 1));
    public static FocusUpgradeType iceboulder = new FocusUpgradeType(new ResourceLocation("thaumcraft", "textures/foci/iceboulder.png"), "focus.upgrade.iceboulder.name", "focus.upgrade.iceboulder.text", new AspectList().add(Aspect.COLD, 1).add(Aspect.CRYSTAL, 1));

    public ItemFocusFrost() {
        super("frost", 5204428);
    }

    @Override
    public boolean canBePlacedInTurret() {
        return true;
    }

    @Override
    public float getTurretCorrection(ItemStack focusstack) {
        return this.isUpgradedWith(focusstack, scattershot) ? 1.0f : 15.0f;
    }

    @Override
    public float getTurretRange(ItemStack focusstack) {
        return this.isUpgradedWith(focusstack, scattershot) ? 20.0f : super.getTurretRange(focusstack);
    }

    @Override
    public boolean onFocusActivation(ItemStack wandstack, World world, EntityLivingBase p, MovingObjectPosition movingobjectposition, int count) {
        IWand wand = (IWand)wandstack.func_77973_b();
        if (!world.field_72995_K) {
            int frosty = this.getUpgradeLevel(wand.getFocusStack(wandstack), FocusUpgradeType.alchemistsfrost);
            EntityFrostShard shard = null;
            if (this.isUpgradedWith(wand.getFocusStack(wandstack), scattershot)) {
                for (int a = 0; a < 5 + wand.getFocusPotency(wandstack) * 2; ++a) {
                    shard = new EntityFrostShard(world, p, 8.0f);
                    shard.setDamage(1.0f);
                    shard.fragile = true;
                    shard.setFrosty(frosty);
                    world.func_72838_d((Entity)shard);
                }
            } else if (this.isUpgradedWith(wand.getFocusStack(wandstack), iceboulder)) {
                shard = new EntityFrostShard(world, p, 1.0f);
                shard.setDamage(4 + wand.getFocusPotency(wandstack) * 2);
                shard.bounce = 0.8;
                shard.bounceLimit = 6;
                shard.setFrosty(frosty);
                world.func_72838_d((Entity)shard);
            } else {
                shard = new EntityFrostShard(world, p, 1.0f);
                shard.setDamage((float)(3.0 + (double)wand.getFocusPotency(wandstack) * 1.5));
                shard.setFrosty(frosty);
                world.func_72838_d((Entity)shard);
            }
            world.func_72956_a((Entity)shard, "thaumcraft:ice", 0.4f, 1.0f + world.field_73012_v.nextFloat() * 0.1f);
        }
        p.func_71038_i();
        return true;
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        return this.isUpgradedWith(itemstack, scattershot) ? costScatter : (this.isUpgradedWith(itemstack, iceboulder) ? costBoulder : costBase);
    }

    @Override
    public int getActivationCooldown(ItemStack focusstack) {
        return this.getUpgradeLevel(focusstack, scattershot) > 0 || this.getUpgradeLevel(focusstack, iceboulder) > 0 ? 500 : 200;
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.alchemistsfrost};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, scattershot, iceboulder, FocusUpgradeType.alchemistsfrost};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.alchemistsfrost};
            }
        }
        return null;
    }
}

