/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.items.IArchitect;
import thaumcraft.api.items.IArchitectExtended;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.IWandable;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.api.wands.WandTriggerRegistry;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.wands.WandManager;
import thaumcraft.common.lib.aura.AuraHandler;

public class ItemWand
extends Item
implements IArchitectExtended,
IRechargable,
IWand {
    DecimalFormat myFormatter = new DecimalFormat("#######.#");

    public ItemWand() {
        this.field_77777_bU = 1;
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean func_77645_m() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @Override
    public int getMaxVis(ItemStack stack) {
        return (int)((double)this.getRod(stack).getCapacity() * (this.isSceptre(stack) ? 1.5 : 1.0));
    }

    private int getMaxVisInternal(ItemStack stack) {
        return this.getMaxVis(stack) * 100;
    }

    @Override
    public int getVis(ItemStack is, Aspect aspect) {
        return this.getVisInternal(is, aspect) / 100;
    }

    private int getVisInternal(ItemStack is, Aspect aspect) {
        int out = 0;
        if (is != null && aspect != null && is.func_77942_o() && is.func_77978_p().func_74764_b(aspect.getTag())) {
            out = is.func_77978_p().func_74762_e(aspect.getTag());
        }
        return out;
    }

    @Override
    public AspectList getAllVis(ItemStack is) {
        AspectList out = new AspectList();
        for (Aspect aspect : Aspect.getPrimalAspects()) {
            if (is.func_77942_o() && is.func_77978_p().func_74764_b(aspect.getTag())) {
                out.merge(aspect, is.func_77978_p().func_74762_e(aspect.getTag()) / 100);
                continue;
            }
            out.merge(aspect, 0);
        }
        return out;
    }

    private AspectList getAllVisInternal(ItemStack is) {
        AspectList out = new AspectList();
        for (Aspect aspect : Aspect.getPrimalAspects()) {
            if (is.func_77942_o() && is.func_77978_p().func_74764_b(aspect.getTag())) {
                out.merge(aspect, is.func_77978_p().func_74762_e(aspect.getTag()));
                continue;
            }
            out.merge(aspect, 0);
        }
        return out;
    }

    @Override
    public AspectList getAspectsWithRoom(ItemStack wandstack) {
        AspectList out = new AspectList();
        AspectList cur = this.getAllVisInternal(wandstack);
        for (Aspect aspect : cur.getAspects()) {
            if (cur.getAmount(aspect) >= this.getMaxVisInternal(wandstack)) continue;
            int a = Math.max(1, (this.getMaxVisInternal(wandstack) - cur.getAmount(aspect)) / 100);
            out.add(aspect, a);
        }
        return out;
    }

    private void storeVisInternal(ItemStack is, Aspect aspect, int amount) {
        is.func_77983_a(aspect.getTag(), (NBTBase)new NBTTagInt(amount));
    }

    private void storeVisInternal(ItemStack is, AspectList in) {
        for (Aspect aspect : in.getAspects()) {
            this.storeVisInternal(is, aspect, in.getAmount(aspect));
        }
    }

    @Override
    public boolean consumeVis(ItemStack is, EntityPlayer player, Aspect aspect, int amount, boolean crafting) {
        amount *= 100;
        amount = (int)((float)amount * this.getConsumptionModifier(is, player, aspect, crafting));
        if (this.getVisInternal(is, aspect) >= amount) {
            this.storeVisInternal(is, aspect, this.getVisInternal(is, aspect) - amount);
            return true;
        }
        return false;
    }

    @Override
    public boolean consumeAllVis(ItemStack is, EntityPlayer player, AspectList aspects, boolean doit, boolean crafting) {
        if (aspects == null || aspects.size() == 0) {
            return false;
        }
        AspectList nl = new AspectList();
        for (Aspect aspect : aspects.getAspects()) {
            int cost;
            int c = cost = aspects.getAmount(aspect) * 100;
            cost = (int)((float)cost * this.getConsumptionModifier(is, player, aspect, crafting));
            if (this.getVisInternal(is, aspect) < cost) {
                return false;
            }
            nl.add(aspect, cost);
        }
        if (doit && !player.field_70170_p.field_72995_K) {
            for (Aspect aspect : nl.getAspects()) {
                this.storeVisInternal(is, aspect, this.getVisInternal(is, aspect) - nl.getAmount(aspect));
            }
        }
        return true;
    }

    @Override
    public int addVis(ItemStack is, Aspect aspect, int amount, boolean doit) {
        if (!aspect.isPrimal()) {
            return 0;
        }
        int storeAmount = this.getVisInternal(is, aspect) + amount * 100;
        int leftover = Math.max(storeAmount - this.getMaxVisInternal(is), 0);
        if (doit) {
            this.storeVisInternal(is, aspect, Math.min(storeAmount, this.getMaxVisInternal(is)));
        }
        return (int)Math.floor((double)leftover / 100.0);
    }

    @Override
    public float getConsumptionModifier(ItemStack is, EntityPlayer player, Aspect aspect, boolean crafting) {
        float consumptionModifier = 1.0f;
        consumptionModifier = this.getCap(is).getSpecialCostModifierAspects() != null && this.getCap(is).getSpecialCostModifierAspects().contains(aspect) ? this.getCap(is).getSpecialCostModifier() : this.getCap(is).getBaseCostModifier();
        if (player != null) {
            consumptionModifier -= WandManager.getTotalVisDiscount(player, aspect);
        }
        if (this.getFocus(is) != null && !crafting) {
            consumptionModifier -= (float)this.getFocusFrugal(is) / 10.0f;
            if (this.isStaff(is)) {
                consumptionModifier -= 0.1f;
            }
        }
        if (this.isSceptre(is)) {
            consumptionModifier -= 0.1f;
        }
        return Math.max(consumptionModifier, 0.1f);
    }

    @Override
    public AspectList getAspectsInChargable(ItemStack is) {
        return this.getAllVis(is);
    }

    @Override
    public Aspect handleRecharge(World world, ItemStack is, BlockPos pos, EntityPlayer player, int amount) {
        amount += this.getCap(is).getChargeBonus();
        AspectList al = this.getAspectsWithRoom(is);
        for (Aspect aspect : al.getAspectsSortedByAmount()) {
            int amt;
            int drained;
            if (aspect == null || player != null && AuraHandler.shouldPreserveAura(world, player, pos, aspect) || (drained = AuraHandler.drainAuraAvailable(world, pos, aspect, amt = Math.min(amount, al.getAmount(aspect)))) <= 0) continue;
            this.addVis(is, aspect, drained, true);
            if ((amount -= drained) > 0) continue;
            return aspect;
        }
        return null;
    }

    @Override
    public ItemFocusBasic getFocus(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("focus")) {
            NBTTagCompound nbt = stack.func_77978_p().func_74775_l("focus");
            return (ItemFocusBasic)ItemStack.func_77949_a((NBTTagCompound)nbt).func_77973_b();
        }
        return null;
    }

    @Override
    public ItemStack getFocusStack(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("focus")) {
            NBTTagCompound nbt = stack.func_77978_p().func_74775_l("focus");
            return ItemStack.func_77949_a((NBTTagCompound)nbt);
        }
        return null;
    }

    @Override
    public void setFocus(ItemStack stack, ItemStack focus) {
        if (focus == null) {
            stack.func_77978_p().func_82580_o("focus");
        } else {
            stack.func_77983_a("focus", (NBTBase)focus.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public WandRod getRod(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("rod")) {
            return WandRod.rods.get(stack.func_77978_p().func_74779_i("rod"));
        }
        return ConfigItems.WAND_ROD_WOOD;
    }

    @Override
    public boolean isStaff(ItemStack stack) {
        return this.getRod(stack).isStaff();
    }

    @Override
    public boolean isSceptre(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("sceptre");
    }

    @Override
    public void setRod(ItemStack stack, WandRod rod) {
        stack.func_77983_a("rod", (NBTBase)new NBTTagString(rod.getTag()));
        if (rod.isStaff()) {
            NBTTagList tags = new NBTTagList();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("AttributeName", SharedMonsterAttributes.field_111264_e.func_111108_a());
            AttributeModifier am = new AttributeModifier(field_111210_e, "Weapon modifier", 6.0, 0);
            tag.func_74778_a("Name", am.func_111166_b());
            tag.func_74780_a("Amount", am.func_111164_d());
            tag.func_74768_a("Operation", am.func_111169_c());
            tag.func_74772_a("UUIDMost", am.func_111167_a().getMostSignificantBits());
            tag.func_74772_a("UUIDLeast", am.func_111167_a().getLeastSignificantBits());
            tags.func_74742_a((NBTBase)tag);
            stack.func_77978_p().func_74782_a("AttributeModifiers", (NBTBase)tags);
        }
    }

    @Override
    public WandCap getCap(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("cap")) {
            return WandCap.caps.get(stack.func_77978_p().func_74779_i("cap"));
        }
        return ConfigItems.WAND_CAP_IRON;
    }

    @Override
    public void setCap(ItemStack stack, WandCap cap) {
        stack.func_77983_a("cap", (NBTBase)new NBTTagString(cap.getTag()));
    }

    @Override
    public int getFocusPotency(ItemStack itemstack) {
        if (this.getFocus(itemstack) == null) {
            return 0;
        }
        return this.getFocus(itemstack).getUpgradeLevel(this.getFocusStack(itemstack), FocusUpgradeType.potency) + (this.getRod(itemstack).hasPotencyBonus() ? 1 : 0);
    }

    @Override
    public int getFocusTreasure(ItemStack itemstack) {
        if (this.getFocus(itemstack) == null) {
            return 0;
        }
        return this.getFocus(itemstack).getUpgradeLevel(this.getFocusStack(itemstack), FocusUpgradeType.treasure);
    }

    @Override
    public int getFocusFrugal(ItemStack itemstack) {
        if (this.getFocus(itemstack) == null) {
            return 0;
        }
        return this.getFocus(itemstack).getUpgradeLevel(this.getFocusStack(itemstack), FocusUpgradeType.frugal);
    }

    @Override
    public int getFocusEnlarge(ItemStack itemstack) {
        if (this.getFocus(itemstack) == null) {
            return 0;
        }
        return this.getFocus(itemstack).getUpgradeLevel(this.getFocusStack(itemstack), FocusUpgradeType.enlarge);
    }

    @Override
    public int getFocusExtend(ItemStack itemstack) {
        if (this.getFocus(itemstack) == null) {
            return 0;
        }
        return this.getFocus(itemstack).getUpgradeLevel(this.getFocusStack(itemstack), FocusUpgradeType.extend);
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.UNCOMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack w1 = new ItemStack((Item)this);
        ItemStack w2 = new ItemStack((Item)this);
        ItemStack w3 = new ItemStack((Item)this);
        ((IWand)w2.func_77973_b()).setCap(w2, ConfigItems.WAND_CAP_GOLD);
        ((IWand)w3.func_77973_b()).setCap(w3, ConfigItems.WAND_CAP_THAUMIUM);
        ((IWand)w2.func_77973_b()).setRod(w2, ConfigItems.WAND_ROD_GREATWOOD);
        ((IWand)w3.func_77973_b()).setRod(w3, ConfigItems.WAND_ROD_SILVERWOOD);
        ItemStack sceptre = new ItemStack((Item)this);
        ((IWand)sceptre.func_77973_b()).setCap(sceptre, ConfigItems.WAND_CAP_THAUMIUM);
        ((IWand)sceptre.func_77973_b()).setRod(sceptre, ConfigItems.WAND_ROD_SILVERWOOD);
        sceptre.func_77983_a("sceptre", (NBTBase)new NBTTagByte(1));
        ItemStack staff = new ItemStack((Item)this);
        ((IWand)staff.func_77973_b()).setCap(staff, ConfigItems.WAND_CAP_VOID);
        ((IWand)staff.func_77973_b()).setRod(staff, ConfigItems.STAFF_ROD_PRIMAL);
        for (Aspect aspect : Aspect.getPrimalAspects()) {
            ((IWand)w1.func_77973_b()).addVis(w1, aspect, ((IWand)w1.func_77973_b()).getMaxVis(w1), true);
            ((IWand)w2.func_77973_b()).addVis(w2, aspect, ((IWand)w2.func_77973_b()).getMaxVis(w2), true);
            ((IWand)w3.func_77973_b()).addVis(w3, aspect, ((IWand)w3.func_77973_b()).getMaxVis(w3), true);
            ((IWand)sceptre.func_77973_b()).addVis(sceptre, aspect, ((IWand)sceptre.func_77973_b()).getMaxVis(sceptre), true);
            ((IWand)staff.func_77973_b()).addVis(staff, aspect, ((IWand)staff.func_77973_b()).getMaxVis(staff), true);
        }
        par3List.add(w1);
        par3List.add(w2);
        par3List.add(w3);
        par3List.add(sceptre);
        par3List.add(staff);
    }

    public String func_77653_i(ItemStack is) {
        String name = StatCollector.func_74838_a((String)"item.Wand.name");
        name = name.replace("%CAP", StatCollector.func_74838_a((String)("item.Wand." + this.getCap(is).getTag() + ".cap")));
        String rod = this.getRod(is).getTag();
        if (rod.indexOf("_staff") >= 0) {
            rod = rod.substring(0, this.getRod(is).getTag().indexOf("_staff"));
        }
        name = name.replace("%ROD", StatCollector.func_74838_a((String)("item.Wand." + rod + ".rod")));
        name = name.replace("%OBJ", this.isStaff(is) ? StatCollector.func_74838_a((String)"item.Wand.staff.obj") : (this.isSceptre(is) ? StatCollector.func_74838_a((String)"item.Wand.sceptre.obj") : StatCollector.func_74838_a((String)"item.Wand.wand.obj")));
        return name;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        int pos = list.size();
        String tt2 = "";
        if (stack.func_77942_o()) {
            String tt = "";
            int tot = 0;
            int num = 0;
            for (Aspect aspect : Aspect.getPrimalAspects()) {
                float amt;
                if (!stack.func_77978_p().func_74764_b(aspect.getTag())) continue;
                String amount = "" + this.getVis(stack, aspect);
                float mod = this.getConsumptionModifier(stack, player, aspect, false);
                String consumption = this.myFormatter.format(mod * 100.0f);
                ++num;
                tot = (int)((float)tot + mod * 100.0f);
                String text = "";
                ItemStack focus = this.getFocusStack(stack);
                if (focus != null && (amt = (float)((ItemFocusBasic)focus.func_77973_b()).getVisCost(focus).getAmount(aspect) * mod) > 0.0f) {
                    text = "\u00a7r, " + this.myFormatter.format(amt) + " " + StatCollector.func_74838_a((String)(((ItemFocusBasic)focus.func_77973_b()).isVisCostPerTick(focus) ? "item.Focus.cost2" : "item.Focus.cost1"));
                }
                if (Thaumcraft.proxy.isShiftKeyDown()) {
                    list.add(" \u00a7" + aspect.getChatcolor() + aspect.getName() + "\u00a7r x " + amount + ", \u00a7o(" + consumption + "% " + StatCollector.func_74838_a((String)"tc.vis.cost") + ")" + text);
                    continue;
                }
                if (tt.length() > 0) {
                    tt = tt + " | ";
                }
                tt = tt + "\u00a7" + aspect.getChatcolor() + amount + "\u00a7r";
            }
            if (!Thaumcraft.proxy.isShiftKeyDown() && num > 0) {
                list.add(tt);
                tt2 = " (" + (tot /= num) + "% " + StatCollector.func_74838_a((String)"tc.vis.costavg") + ")";
            }
        }
        list.add(pos, EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"item.capacity.text") + " " + this.getMaxVis(stack) + "\u00a7r" + tt2);
        if (this.getCap(stack).getChargeBonus() > 0) {
            list.add(pos + 1, EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"item.chargebonus.text") + " +" + this.getCap(stack).getChargeBonus() + "\u00a7r");
        }
        if (this.getFocus(stack) != null) {
            list.add(EnumChatFormatting.BOLD + "" + EnumChatFormatting.ITALIC + "" + EnumChatFormatting.GREEN + this.getFocus(stack).func_77653_i(this.getFocusStack(stack)));
            if (Thaumcraft.proxy.isShiftKeyDown()) {
                this.getFocus(stack).addFocusInformation(this.getFocusStack(stack), player, list, par4);
            }
        }
    }

    public void func_77663_a(ItemStack is, World w, Entity e, int slot, boolean currentItem) {
        if (!w.field_72995_K && e instanceof EntityPlayer) {
            int cr;
            EntityPlayer player = (EntityPlayer)e;
            if (this.getRod(is).getOnUpdate() != null) {
                this.getRod(is).getOnUpdate().onUpdate(is, player);
            }
            if (player.field_70173_aa % 5 == 0 && (cr = WandManager.getBaseChargeRate(player, currentItem, slot)) > 0) {
                this.handleRecharge(player.field_70170_p, is, new BlockPos((Entity)player), player, cr);
            }
        }
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState bs = world.func_180495_p(pos);
        boolean result = false;
        if (bs.func_177230_c() instanceof IWandable && ((IWandable)bs.func_177230_c()).onWandRightClick(world, itemstack, player, pos, side)) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof IWandable && ((IWandable)tile).onWandRightClick(world, itemstack, player, pos, side)) {
            return true;
        }
        if (WandTriggerRegistry.hasTrigger(bs)) {
            return WandTriggerRegistry.performTrigger(world, itemstack, player, pos, side, bs);
        }
        return result;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
        ItemFocusBasic focus = this.getFocus(itemstack);
        if (focus != null && !focus.isVisCostPerTick(this.getFocusStack(itemstack)) && !WandManager.isOnCooldown((EntityLivingBase)player) && this.consumeAllVis(itemstack, player, focus.getVisCost(itemstack), false, false)) {
            WandManager.setCooldown((EntityLivingBase)player, focus.getActivationCooldown(this.getFocusStack(itemstack)));
            if (focus.onFocusActivation(itemstack, world, (EntityLivingBase)player, movingobjectposition, 0)) {
                this.consumeAllVis(itemstack, player, focus.getVisCost(itemstack), !player.field_70170_p.field_72995_K, false);
            }
            return itemstack;
        }
        if (focus != null && focus.isVisCostPerTick(this.getFocusStack(itemstack)) && !WandManager.isOnCooldown((EntityLivingBase)player)) {
            player.func_71008_a(itemstack, Integer.MAX_VALUE);
            WandManager.setCooldown((EntityLivingBase)player, -1);
            return itemstack;
        }
        return super.func_77659_a(itemstack, world, player);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        IWandable tv = this.getObjectInUse(stack, player.field_70170_p);
        if (tv != null) {
            tv.onUsingWandTick(stack, player, count);
        } else {
            ItemFocusBasic focus = this.getFocus(stack);
            if (focus != null && !WandManager.isOnCooldown((EntityLivingBase)player)) {
                if (this.consumeAllVis(stack, player, focus.getVisCost(stack), false, false)) {
                    MovingObjectPosition movingobjectposition = this.func_77621_a(player.field_70170_p, player, true);
                    WandManager.setCooldown((EntityLivingBase)player, focus.getActivationCooldown(this.getFocusStack(stack)));
                    if (focus.onFocusActivation(stack, player.field_70170_p, (EntityLivingBase)player, movingobjectposition, count)) {
                        this.consumeAllVis(stack, player, focus.getVisCost(stack), !player.field_70170_p.field_72995_K, false);
                    }
                } else {
                    player.func_71034_by();
                }
            }
        }
    }

    public void setObjectInUse(ItemStack stack, int x, int y, int z) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("IIUX", x);
        stack.func_77978_p().func_74768_a("IIUY", y);
        stack.func_77978_p().func_74768_a("IIUZ", z);
    }

    public void clearObjectInUse(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_82580_o("IIUX");
        stack.func_77978_p().func_82580_o("IIUY");
        stack.func_77978_p().func_82580_o("IIUZ");
    }

    public IWandable getObjectInUse(ItemStack stack, World world) {
        TileEntity te;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("IIUX") && (te = world.func_175625_s(new BlockPos(stack.func_77978_p().func_74762_e("IIUX"), stack.func_77978_p().func_74762_e("IIUY"), stack.func_77978_p().func_74762_e("IIUZ")))) != null && te instanceof IWandable) {
            return (IWandable)te;
        }
        return null;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int count) {
        IWandable tv = this.getObjectInUse(stack, player.field_70170_p);
        if (tv != null) {
            tv.onWandStoppedUsing(stack, world, player, count);
        }
        this.clearObjectInUse(stack);
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack itemstack) {
        return Integer.MAX_VALUE;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        ItemStack focus = this.getFocusStack(stack);
        if (focus != null && !WandManager.isOnCooldown(entityLiving)) {
            WandManager.setCooldown(entityLiving, this.getFocus(stack).getActivationCooldown(focus));
            return focus.func_77973_b().onEntitySwing(entityLiving, stack);
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        ItemFocusBasic focus = this.getFocus(itemstack);
        if (focus != null && !WandManager.isOnCooldown((EntityLivingBase)player)) {
            WandManager.setCooldown((EntityLivingBase)player, focus.getActivationCooldown(this.getFocusStack(itemstack)));
            return focus.onFocusBlockStartBreak(itemstack, pos, player);
        }
        return false;
    }

    public boolean canHarvestBlock(Block par1Block, ItemStack itemstack) {
        ItemFocusBasic focus = this.getFocus(itemstack);
        if (focus != null) {
            return this.getFocusStack(itemstack).func_77973_b().canHarvestBlock(par1Block, itemstack);
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, Block block) {
        ItemFocusBasic focus = this.getFocus(stack);
        if (focus != null) {
            return this.getFocusStack(stack).func_77973_b().func_150893_a(stack, null);
        }
        return super.func_150893_a(stack, block);
    }

    @Override
    public ArrayList<BlockPos> getArchitectBlocks(ItemStack stack, World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        ItemFocusBasic focus = this.getFocus(stack);
        if (focus != null && focus instanceof IArchitect) {
            return ((IArchitect)((Object)focus)).getArchitectBlocks(stack, world, pos, side, player);
        }
        return null;
    }

    @Override
    public MovingObjectPosition getArchitectMOP(ItemStack stack, World world, EntityLivingBase player) {
        ItemFocusBasic focus = this.getFocus(stack);
        if (focus != null && focus instanceof IArchitectExtended) {
            return ((IArchitectExtended)((Object)focus)).getArchitectMOP(stack, world, player);
        }
        return null;
    }

    @Override
    public boolean useBlockHighlight(ItemStack stack) {
        ItemFocusBasic focus = this.getFocus(stack);
        if (focus != null && focus instanceof IArchitectExtended) {
            return ((IArchitectExtended)((Object)focus)).useBlockHighlight(stack);
        }
        return true;
    }

    @Override
    public boolean showAxis(ItemStack stack, World world, EntityPlayer player, EnumFacing side, IArchitect.EnumAxis axis) {
        ItemFocusBasic focus = this.getFocus(stack);
        if (focus != null && focus instanceof IArchitect && focus.isUpgradedWith(this.getFocusStack(stack), FocusUpgradeType.architect)) {
            return ((IArchitect)((Object)focus)).showAxis(stack, world, player, side, axis);
        }
        return false;
    }

    public int func_82790_a(ItemStack stack, int renderPass) {
        if (renderPass == 1 && this.getFocus(stack) != null) {
            return this.getFocus(stack).getFocusColor(stack);
        }
        return super.func_82790_a(stack, renderPass);
    }

    @Override
    public float getChargeLevel(ItemStack is) {
        return -1.0f;
    }
}

