/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.baubles;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.items.IRunicArmor;
import thaumcraft.api.items.IVisDiscountGear;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.IVariantItems;
import thaumcraft.common.lib.events.PlayerEvents;

public class ItemBaubles
extends Item
implements IBauble,
IVisDiscountGear,
IRunicArmor,
IVariantItems {
    public ItemBaubles() {
        this.field_77777_bU = 1;
        this.canRepair = false;
        this.func_77656_e(0);
        this.func_77637_a(Thaumcraft.tabTC);
        this.func_77627_a(true);
    }

    @Override
    public String[] getVariantNames() {
        return new String[]{"amulet_mundane", "ring_mundane", "girdle_mundane", "ring_apprentice", "ring_apprentice", "ring_apprentice", "ring_apprentice", "ring_apprentice", "ring_apprentice", "amulet_fancy", "ring_fancy", "girdle_fancy"};
    }

    @Override
    public int[] getVariantMeta() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77658_a() + "." + par1ItemStack.func_77952_i();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int a = 0; a < this.getVariantNames().length; ++a) {
            par3List.add(new ItemStack((Item)this, 1, a));
        }
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        switch (itemstack.func_77952_i()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                return BaubleType.RING;
            }
            case 2: 
            case 11: {
                return BaubleType.BELT;
            }
        }
        return BaubleType.AMULET;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        PlayerEvents.markRunicDirty((Entity)player);
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        PlayerEvents.markRunicDirty((Entity)player);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_77952_i() >= 3 && stack.func_77952_i() <= 8) {
            return EnumRarity.UNCOMMON;
        }
        return super.func_77613_e(stack);
    }

    @Override
    public int getVisDiscount(ItemStack stack, EntityPlayer player, Aspect aspect) {
        if (stack.func_77952_i() >= 3 && stack.func_77952_i() <= 8 && Aspect.getPrimalAspects().get(stack.func_77952_i() - 3) == aspect) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(aspect.getTag())) {
                return stack.func_77978_p().func_74762_e(aspect.getTag());
            }
            return 5;
        }
        return 0;
    }

    public int func_82790_a(ItemStack stack, int par2) {
        if (stack.func_77952_i() >= 3 && stack.func_77952_i() <= 8) {
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("color")) {
                this.calcColor(stack);
            }
            return stack.func_77978_p().func_74762_e("color");
        }
        return super.func_82790_a(stack, par2);
    }

    public void calcColor(ItemStack stack) {
        int l = Aspect.getPrimalAspects().get(stack.func_77952_i() - 3).getColor();
        int c = 1;
        int r = l >> 16 & 0xFF;
        int g = l >> 8 & 0xFF;
        int b = l & 0xFF;
        if (stack.func_77942_o()) {
            for (Aspect aspect : Aspect.getPrimalAspects()) {
                if (aspect == Aspect.getPrimalAspects().get(stack.func_77952_i() - 3) || !stack.func_77978_p().func_74764_b(aspect.getTag())) continue;
                l = aspect.getColor();
                r += l >> 16 & 0xFF;
                g += l >> 8 & 0xFF;
                b += l & 0xFF;
                ++c;
            }
        }
        int oc = (r /= c) << 16 | (g /= c) << 8 | (b /= c);
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("color", oc);
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77952_i() >= 3 && stack.func_77952_i() <= 8) {
            Aspect aspect = Aspect.getPrimalAspects().get(stack.func_77952_i() - 3);
            return StatCollector.func_74838_a((String)"item.baubles.3.name").replace("%TYPE", aspect.getName());
        }
        return super.func_77653_i(stack);
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public int getRunicCharge(ItemStack itemstack) {
        return 0;
    }
}

