/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.projectile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.monster.EntityPech;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockBamf;

public class EntityPechBlast
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    int strength = 0;
    int duration = 0;
    boolean nightshade = false;

    public EntityPechBlast(World par1World) {
        super(par1World);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeBoolean(this.nightshade);
    }

    public void readSpawnData(ByteBuf data) {
        this.nightshade = data.readBoolean();
    }

    public EntityPechBlast(World par1World, EntityLivingBase p, int strength, int duration, boolean nightshade) {
        super(par1World, p);
        Vec3 v = p.func_70040_Z();
        this.func_70012_b(p.field_70165_t + v.field_72450_a / 2.0, p.field_70163_u + (double)p.func_70047_e() + v.field_72448_b / 2.0, p.field_70161_v + v.field_72449_c / 2.0, p.field_70177_z, p.field_70125_A);
        this.strength = strength;
        this.nightshade = nightshade;
        this.duration = duration;
    }

    public EntityPechBlast(World par1World, double par2, double par4, double par6, int strength, int duration, boolean nightshade) {
        super(par1World, par2, par4, par6);
        this.strength = strength;
        this.nightshade = nightshade;
        this.duration = duration;
    }

    protected float func_70185_h() {
        return 0.025f;
    }

    protected float func_70182_d() {
        return 1.5f;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            Thaumcraft.proxy.getFX().pechsCurseTick(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        super.func_70071_h_();
        if (this.field_70173_aa > 500) {
            this.func_70106_y();
        }
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
        super.func_70106_y();
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.nightshade) {
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockBamf(mop.field_72307_f.field_72450_a, Math.max(mop.field_72307_f.field_72448_b, this.field_70163_u), mop.field_72307_f.field_72449_c, 5770890, true, true, false), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_177502_q(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
            } else {
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockBamf(mop.field_72307_f.field_72450_a, Math.max(mop.field_72307_f.field_72448_b, this.field_70163_u), mop.field_72307_f.field_72449_c, 2815273, true, true, false), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_177502_q(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
            }
            List list = this.field_70170_p.func_72839_b((Entity)this.func_85052_h(), this.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntityPech || !(entity1 instanceof EntityLivingBase)) continue;
                ((EntityLivingBase)entity1).func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), (float)(this.strength + 2));
                try {
                    if (this.nightshade) {
                        ((EntityLivingBase)entity1).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 100 + this.duration * 40, this.strength));
                        ((EntityLivingBase)entity1).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100 + this.duration * 40, this.strength + 1));
                        ((EntityLivingBase)entity1).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 100 + this.duration * 40, this.strength));
                        continue;
                    }
                    switch (this.field_70146_Z.nextInt(3)) {
                        case 0: {
                            ((EntityLivingBase)entity1).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 100 + this.duration * 40, this.strength));
                            break;
                        }
                        case 1: {
                            ((EntityLivingBase)entity1).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100 + this.duration * 40, this.strength + 1));
                            break;
                        }
                        case 2: {
                            ((EntityLivingBase)entity1).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 100 + this.duration * 40, this.strength));
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.func_70106_y();
        }
    }
}

