/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster.tainted;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.ai.combat.AIAttackOnCollide;
import thaumcraft.common.entities.ai.misc.AIConvertGrass;

public class EntityTaintSheep
extends EntityMob
implements IShearable,
ITaintedMob {
    private int sheepTimer;
    private AIConvertGrass field_48137_c = new AIConvertGrass((EntityLiving)this);

    public EntityTaintSheep(World par1World) {
        super(par1World);
        this.func_70105_a(0.9f, 1.3f);
        ((PathNavigateGround)this.func_70661_as()).func_179690_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_48137_c);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityVillager.class, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
    }

    public boolean func_70686_a(Class clazz) {
        return !ITaintedMob.class.isAssignableFrom(clazz);
    }

    public boolean func_142014_c(EntityLivingBase otherEntity) {
        return otherEntity instanceof ITaintedMob || this.func_142012_a(otherEntity.func_96124_cp());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public int func_70658_aO() {
        return 1;
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.field_48137_c.func_48396_h();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa < 5) {
            for (int a = 0; a < Thaumcraft.proxy.getFX().particleCount(10); ++a) {
                Thaumcraft.proxy.getFX().splooshFX((Entity)this);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
    }

    protected Item func_146068_u() {
        return ItemsTC.tainted;
    }

    protected void func_70628_a(boolean flag, int i) {
        if (this.field_70170_p.field_73012_v.nextInt(3) == 0) {
            if (this.field_70170_p.field_73012_v.nextBoolean()) {
                this.func_70099_a(new ItemStack(ItemsTC.tainted, 1, 0), this.field_70131_O / 2.0f);
            } else {
                this.func_70099_a(new ItemStack(ItemsTC.tainted, 1, 1), this.field_70131_O / 2.0f);
            }
        }
    }

    public void func_70103_a(byte par1) {
        if (par1 == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(par1);
        }
    }

    public float func_44003_c(float par1) {
        return this.sheepTimer <= 0 ? 0.0f : (this.sheepTimer >= 4 && this.sheepTimer <= 36 ? 1.0f : (this.sheepTimer < 4 ? ((float)this.sheepTimer - par1) / 4.0f : -((float)(this.sheepTimer - 40) - par1) / 4.0f));
    }

    public float func_44002_d(float par1) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float var2 = ((float)(this.sheepTimer - 4) - par1) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(var2 * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A / 57.295776f;
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("Sheared", this.getSheared());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setSheared(par1NBTTagCompound.func_74767_n("Sheared"));
    }

    protected String func_70639_aQ() {
        return "mob.sheep.say";
    }

    protected String func_70621_aR() {
        return "mob.sheep.say";
    }

    protected String func_70673_aS() {
        return "mob.sheep.say";
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        this.func_85030_a("mob.sheep.step", 0.15f, 1.0f);
    }

    protected float func_70647_i() {
        return 0.7f;
    }

    public boolean getSheared() {
        return (this.field_70180_af.func_75683_a(16) & 0x10) != 0;
    }

    public void setSheared(boolean par1) {
        byte var2 = this.field_70180_af.func_75683_a(16);
        if (par1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 | 0x10)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 & 0xFFFFFFEF)));
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.getSheared();
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        this.setSheared(true);
        int i = 1 + this.field_70146_Z.nextInt(3);
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Blocks.field_150325_L, 1, 10));
        }
        return ret;
    }

    public boolean func_70652_k(Entity victim) {
        if (super.func_70652_k(victim)) {
            if (victim instanceof EntityLivingBase) {
                int b0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    b0 = 3;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    b0 = 6;
                }
                if (b0 > 0 && this.field_70146_Z.nextInt(b0 + 1) > 2) {
                    ((EntityLivingBase)victim).func_70690_d(new PotionEffect(PotionFluxTaint.instance.func_76396_c(), b0 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }
}

