/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster.tainted;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.ai.combat.AIAttackOnCollide;
import thaumcraft.common.entities.ai.combat.AICreeperSwell;

public class EntityTaintCreeper
extends EntityMob
implements ITaintedMob {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;

    public EntityTaintCreeper(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AICreeperSwell(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public boolean func_70686_a(Class clazz) {
        return !ITaintedMob.class.isAssignableFrom(clazz);
    }

    public boolean func_142014_c(EntityLivingBase otherEntity) {
        return otherEntity instanceof ITaintedMob || this.func_142012_a(otherEntity.func_96124_cp());
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        if (this.field_70180_af.func_75683_a(17) == 1) {
            par1NBTTagCompound.func_74757_a("powered", true);
        }
        par1NBTTagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        par1NBTTagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.field_70180_af.func_75692_b(17, (Object)((byte)(par1NBTTagCompound.func_74767_n("powered") ? 1 : 0)));
        if (par1NBTTagCompound.func_74764_b("Fuse")) {
            this.fuseTime = par1NBTTagCompound.func_74765_d("Fuse");
        }
        if (par1NBTTagCompound.func_74764_b("ExplosionRadius")) {
            this.explosionRadius = par1NBTTagCompound.func_74771_c("ExplosionRadius");
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    protected Item func_146068_u() {
        return ItemsTC.tainted;
    }

    protected void func_70628_a(boolean flag, int i) {
        if (this.field_70170_p.field_73012_v.nextBoolean()) {
            this.func_70099_a(new ItemStack(ItemsTC.tainted, 1, 0), this.field_70131_O / 2.0f);
        } else {
            this.func_70099_a(new ItemStack(ItemsTC.tainted, 1, 1), this.field_70131_O / 2.0f);
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            this.lastActiveTime = this.timeSinceIgnited;
            int var1 = this.getCreeperState();
            if (var1 > 0 && this.timeSinceIgnited == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "random.fuse", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += var1;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= 30) {
                this.timeSinceIgnited = 30;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 1.5f, false);
                    List ents = this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_178781_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72314_b(6.0, 6.0, 6.0));
                    if (ents.size() > 0) {
                        for (Object ent : ents) {
                            EntityLivingBase el = (EntityLivingBase)ent;
                            if (el instanceof ITaintedMob || el.func_70662_br()) continue;
                            el.func_70690_d(new PotionEffect(PotionFluxTaint.instance.func_76396_c(), 100, 0, false, true));
                        }
                    }
                    int x = (int)this.field_70165_t;
                    int y = (int)this.field_70163_u;
                    int z = (int)this.field_70161_v;
                    for (int a = 0; a < 10; ++a) {
                        int xx = x + (int)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 5.0f);
                        int zz = z + (int)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 5.0f);
                        if (!this.field_70170_p.field_73012_v.nextBoolean()) continue;
                        BlockPos bp = new BlockPos(xx, y, zz);
                        IBlockState bs = this.field_70170_p.func_180495_p(bp);
                        if (!this.field_70170_p.func_175677_d(bp.func_177977_b(), false) || !bs.func_177230_c().func_176200_f(this.field_70170_p, bp)) continue;
                        this.field_70170_p.func_175656_a(bp, BlocksTC.taintFibre.func_176223_P());
                    }
                    this.func_70106_y();
                } else {
                    for (int a = 0; a < Thaumcraft.proxy.getFX().particleCount(100); ++a) {
                        Thaumcraft.proxy.getFX().taintsplosionFX((Entity)this);
                    }
                }
            }
        }
        super.func_70071_h_();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa < 5) {
            for (int a = 0; a < Thaumcraft.proxy.getFX().particleCount(10); ++a) {
                Thaumcraft.proxy.getFX().splooshFX((Entity)this);
            }
        }
    }

    public float getCreeperFlashIntensity(float par1) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * par1) / 28.0f;
    }

    protected String func_70621_aR() {
        return "mob.creeper.say";
    }

    protected String func_70673_aS() {
        return "mob.creeper.death";
    }

    protected float func_70647_i() {
        return 0.7f;
    }

    public boolean func_70652_k(Entity par1Entity) {
        return true;
    }

    public int getCreeperState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setCreeperState(int par1) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)par1));
    }
}

