/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.golems.seals.ISeal;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.seals.SealPos;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketSealToClient;
import thaumcraft.common.lib.utils.PosXY;

public class SealHandler {
    public static LinkedHashMap<String, ISeal> types = new LinkedHashMap();
    private static int lastID = 0;
    public static ConcurrentHashMap<Integer, ConcurrentHashMap<SealPos, SealEntity>> sealEntities = new ConcurrentHashMap();
    static int count = 0;

    public static void registerSeal(ISeal seal) {
        if (types.containsKey(seal.getKey())) {
            Thaumcraft.log.error("Attempting to register Seal [" + seal.getKey() + "] twice. Ignoring.");
        } else {
            types.put(seal.getKey(), seal);
        }
    }

    public static String[] getRegisteredSeals() {
        return types.keySet().toArray(new String[0]);
    }

    public static ISeal getSeal(String key) {
        return types.get(key);
    }

    public static CopyOnWriteArrayList<SealEntity> getSealsInChunk(World world, ChunkCoordIntPair chunk) {
        CopyOnWriteArrayList<SealEntity> out = new CopyOnWriteArrayList<SealEntity>();
        ConcurrentHashMap<SealPos, SealEntity> list = sealEntities.get(world.field_73011_w.func_177502_q());
        if (list != null && list.size() > 0) {
            for (SealEntity se : list.values()) {
                ChunkCoordIntPair cc;
                if (se.getSeal() == null || se.getSealPos() == null || !(cc = new ChunkCoordIntPair(se.sealPos.pos.func_177958_n() >> 4, se.sealPos.pos.func_177952_p() >> 4)).equals((Object)chunk)) continue;
                out.add(se);
            }
        }
        return out;
    }

    public static void removeSealEntity(World world, SealPos pos, boolean quiet) {
        ConcurrentHashMap<SealPos, SealEntity> se;
        if (!sealEntities.containsKey(world.field_73011_w.func_177502_q())) {
            sealEntities.put(world.field_73011_w.func_177502_q(), new ConcurrentHashMap());
        }
        if ((se = sealEntities.get(world.field_73011_w.func_177502_q())) != null) {
            block10: {
                SealEntity seal = se.remove(pos);
                try {
                    if (!world.field_72995_K && seal != null && seal.seal != null) {
                        seal.seal.onRemoval(world, pos.pos, pos.face);
                    }
                    if (quiet || seal == null || world.field_72995_K) break block10;
                    String[] rs = SealHandler.getRegisteredSeals();
                    int indx = 1;
                    for (String s : rs) {
                        if (s.equals(seal.getSeal().getKey())) {
                            world.func_72838_d((Entity)new EntityItem(world, (double)pos.pos.func_177958_n() + 0.5 + (double)((float)pos.face.func_82601_c() / 1.7f), (double)pos.pos.func_177956_o() + 0.5 + (double)((float)pos.face.func_96559_d() / 1.7f), (double)pos.pos.func_177952_p() + 0.5 + (double)((float)pos.face.func_82599_e() / 1.7f), new ItemStack(ItemsTC.seals, 1, indx)));
                            break;
                        }
                        ++indx;
                    }
                }
                catch (Exception e) {
                    Thaumcraft.log.warn("Removing invalid seal at " + pos.pos);
                }
            }
            ConcurrentHashMap<Integer, Task> ts = TaskHandler.getTasks(world.field_73011_w.func_177502_q());
            for (Task task : ts.values()) {
                if (task.getSealPos() == null || !task.getSealPos().equals(pos)) continue;
                task.setSuspended(true);
            }
            if (!world.field_72995_K) {
                PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketSealToClient(new SealEntity(world, pos, null)), world.field_73011_w.func_177502_q());
            }
            if (!quiet) {
                SealHandler.markChunkAsDirty(world.field_73011_w.func_177502_q(), pos.pos);
            }
        }
    }

    public static ISealEntity getSealEntity(int dim, SealPos pos) {
        if (!sealEntities.containsKey(dim)) {
            sealEntities.put(dim, new ConcurrentHashMap());
        }
        if (pos == null) {
            return null;
        }
        ConcurrentHashMap<SealPos, SealEntity> se = sealEntities.get(dim);
        if (se != null) {
            return se.get(pos);
        }
        return null;
    }

    public static boolean addSealEntity(World world, BlockPos pos, EnumFacing face, ISeal seal, EntityPlayer player) {
        SealPos sp;
        ConcurrentHashMap<SealPos, SealEntity> se;
        if (!sealEntities.containsKey(world.field_73011_w.func_177502_q())) {
            sealEntities.put(world.field_73011_w.func_177502_q(), new ConcurrentHashMap());
        }
        if ((se = sealEntities.get(world.field_73011_w.func_177502_q())).containsKey(sp = new SealPos(pos, face))) {
            return false;
        }
        SealEntity sealent = new SealEntity(world, sp, seal);
        sealent.setOwner(player.func_110124_au().toString());
        se.put(sp, sealent);
        if (!world.field_72995_K) {
            sealent.syncToClient(world);
            SealHandler.markChunkAsDirty(world.field_73011_w.func_177502_q(), pos);
        }
        return true;
    }

    public static boolean addSealEntity(World world, SealEntity seal) {
        ConcurrentHashMap<SealPos, SealEntity> se;
        if (world == null || sealEntities == null) {
            return false;
        }
        if (!sealEntities.containsKey(world.field_73011_w.func_177502_q())) {
            sealEntities.put(world.field_73011_w.func_177502_q(), new ConcurrentHashMap());
        }
        if ((se = sealEntities.get(world.field_73011_w.func_177502_q())).containsKey(seal.getSealPos())) {
            return false;
        }
        se.put(seal.getSealPos(), seal);
        if (!world.field_72995_K) {
            seal.syncToClient(world);
            SealHandler.markChunkAsDirty(world.field_73011_w.func_177502_q(), seal.getSealPos().pos);
        }
        return true;
    }

    public static void tickSealEntities(World world) {
        if (!sealEntities.containsKey(world.field_73011_w.func_177502_q())) {
            sealEntities.put(world.field_73011_w.func_177502_q(), new ConcurrentHashMap());
        }
        ConcurrentHashMap<SealPos, SealEntity> se = sealEntities.get(world.field_73011_w.func_177502_q());
        ++count;
        for (SealEntity sealEntity : se.values()) {
            if (!world.func_175667_e(sealEntity.sealPos.pos)) continue;
            try {
                boolean tick = true;
                if (count % 20 == 0 && !sealEntity.seal.canPlaceAt(world, sealEntity.sealPos.pos, sealEntity.sealPos.face)) {
                    SealHandler.removeSealEntity(world, sealEntity.sealPos, false);
                    tick = false;
                }
                if (!tick) continue;
                sealEntity.tickSealEntity(world);
            }
            catch (Exception e) {
                SealHandler.removeSealEntity(world, sealEntity.sealPos, false);
            }
        }
    }

    public static void markChunkAsDirty(int dim, BlockPos bp) {
        CopyOnWriteArrayList<PosXY> dc;
        PosXY pos = new PosXY(bp.func_177958_n() >> 4, bp.func_177952_p() >> 4);
        if (!AuraHandler.dirtyChunks.containsKey(dim)) {
            AuraHandler.dirtyChunks.put(dim, new CopyOnWriteArrayList());
        }
        if (!(dc = AuraHandler.dirtyChunks.get(dim)).contains(pos)) {
            dc.add(pos);
        }
    }
}

