/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.golems.seals.ISeal;
import thaumcraft.api.golems.seals.ISealConfigFilter;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.seals.ISealGui;
import thaumcraft.common.entities.construct.golem.gui.SealBaseContainer;
import thaumcraft.common.entities.construct.golem.gui.SealBaseGUI;

public abstract class SealFiltered
implements ISeal,
ISealGui,
ISealConfigFilter {
    ItemStack[] filter = new ItemStack[this.getFilterSize()];
    boolean blacklist = true;

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.filter = new ItemStack[this.getFilterSize()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.filter.length) continue;
            this.filter[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.blacklist = nbt.func_74767_n("bl");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.filter.length; ++i) {
            if (this.filter[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.filter[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        nbt.func_74757_a("bl", this.blacklist);
    }

    @Override
    public Object returnContainer(World world, EntityPlayer player, BlockPos pos, EnumFacing side, ISealEntity seal) {
        return new SealBaseContainer(player.field_71071_by, world, seal);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object returnGui(World world, EntityPlayer player, BlockPos pos, EnumFacing side, ISealEntity seal) {
        return new SealBaseGUI(player.field_71071_by, world, seal);
    }

    @Override
    public int[] getGuiCategories() {
        return new int[]{0};
    }

    @Override
    public int getFilterSize() {
        return 1;
    }

    @Override
    public ItemStack[] getInv() {
        return this.filter;
    }

    @Override
    public ItemStack getFilterSlot(int i) {
        return this.filter[i];
    }

    @Override
    public void setFilterSlot(int i, ItemStack stack) {
        this.filter[i] = stack == null ? null : stack.func_77946_l();
    }

    @Override
    public boolean isBlacklist() {
        return this.blacklist;
    }

    @Override
    public void setBlacklist(boolean black) {
        this.blacklist = black;
    }

    @Override
    public boolean hasStacksizeLimiters() {
        return false;
    }
}

