/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.golems.GolemHelper;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.api.wands.WandTriggerRegistry;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigAspects;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.config.ConfigResearch;
import thaumcraft.common.lib.crafting.ArcaneSceptreRecipe;
import thaumcraft.common.lib.crafting.ArcaneWandRecipe;
import thaumcraft.common.lib.crafting.InfusionEnchantmentRecipe;
import thaumcraft.common.lib.crafting.InfusionRunicAugmentRecipe;
import thaumcraft.common.lib.crafting.RecipeTripleMeatTreat;
import thaumcraft.common.lib.crafting.RecipesRobeArmorDyes;
import thaumcraft.common.lib.crafting.RecipesVoidRobeArmorDyes;
import thaumcraft.common.lib.crafting.ShapelessNBTOreRecipe;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;
import thaumcraft.common.lib.utils.Utils;

public class ConfigRecipes {
    static ItemStack basicWand = new ItemStack(ItemsTC.wand);

    public static void init() {
        ((IWand)basicWand.func_77973_b()).setCap(basicWand, ConfigItems.WAND_CAP_IRON);
        ((IWand)basicWand.func_77973_b()).setRod(basicWand, ConfigItems.WAND_ROD_WOOD);
        ConfigRecipes.initializeSmelting();
        ConfigRecipes.initializeNormalRecipes();
        ConfigRecipes.initializeArcaneRecipes();
        ConfigRecipes.initializeInfusionRecipes();
        ConfigRecipes.initializeAlchemyRecipes();
        ConfigRecipes.initializeCompoundRecipes();
        RecipeSorter.register((String)"forge:shapelessorenbt", ShapelessNBTOreRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipeSorter.register((String)"forge:robearmordye", RecipesRobeArmorDyes.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessorenbt");
        RecipeSorter.register((String)"forge:shapelessarcanerecipe", ShapelessArcaneRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessorenbt");
        RecipeSorter.register((String)"forge:voidrobearmordye", RecipesVoidRobeArmorDyes.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:robearmordye");
        RecipeSorter.register((String)"forge:triplemeattreat", RecipeTripleMeatTreat.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:voidrobearmordye");
        RecipeSorter.register((String)"forge:arcanerecipe", ShapedArcaneRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"forge:arcanewand", ArcaneWandRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"forge:arcanesceptre", ArcaneSceptreRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
    }

    private static void initializeCompoundRecipes() {
        ItemStack empty = new ItemStack(BlocksTC.translucent, 1, 2);
        ConfigResearch.recipes.put("InfernalFurnace", Arrays.asList(new AspectList().add(Aspect.FIRE, 50).add(Aspect.EARTH, 50), 3, 3, 3, Arrays.asList(new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), empty, new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Items.field_151129_at), new ItemStack(Blocks.field_150411_aY), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 2, Blocks.field_150343_Z.func_176223_P(), "Thaumcraft");
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 2, Blocks.field_150385_bj.func_176223_P(), "Thaumcraft");
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 2, Blocks.field_150411_aY.func_176223_P(), "Thaumcraft");
        ConfigResearch.recipes.put("InfusionAltar", Arrays.asList(new AspectList().add(Aspect.FIRE, 75).add(Aspect.EARTH, 75).add(Aspect.ORDER, 75).add(Aspect.AIR, 75).add(Aspect.ENTROPY, 75).add(Aspect.WATER, 75), 3, 3, 3, Arrays.asList(empty, null, empty, null, new ItemStack(BlocksTC.infusionMatrix), null, empty, null, empty, new ItemStack(BlocksTC.stone, 1, 0), null, new ItemStack(BlocksTC.stone, 1, 0), null, null, null, new ItemStack(BlocksTC.stone, 1, 0), null, new ItemStack(BlocksTC.stone, 1, 0), new ItemStack(BlocksTC.stone, 1, 0), null, new ItemStack(BlocksTC.stone, 1, 0), null, new ItemStack(BlocksTC.pedestal, 1, 0), null, new ItemStack(BlocksTC.stone, 1, 0), null, new ItemStack(BlocksTC.stone, 1, 0))));
        ConfigResearch.recipes.put("InfusionAltarAncient", Arrays.asList(new AspectList().add(Aspect.FIRE, 75).add(Aspect.EARTH, 75).add(Aspect.ORDER, 75).add(Aspect.AIR, 75).add(Aspect.ENTROPY, 75).add(Aspect.WATER, 75), 3, 3, 3, Arrays.asList(empty, null, empty, null, new ItemStack(BlocksTC.infusionMatrix), null, empty, null, empty, new ItemStack(BlocksTC.stone, 1, 2), null, new ItemStack(BlocksTC.stone, 1, 2), null, null, null, new ItemStack(BlocksTC.stone, 1, 2), null, new ItemStack(BlocksTC.stone, 1, 2), new ItemStack(BlocksTC.stone, 1, 2), null, new ItemStack(BlocksTC.stone, 1, 2), null, new ItemStack(BlocksTC.pedestal, 1, 2), null, new ItemStack(BlocksTC.stone, 1, 2), null, new ItemStack(BlocksTC.stone, 1, 2))));
        ConfigResearch.recipes.put("InfusionAltarEldritch", Arrays.asList(new AspectList().add(Aspect.FIRE, 75).add(Aspect.EARTH, 75).add(Aspect.ORDER, 125).add(Aspect.AIR, 75).add(Aspect.ENTROPY, 75).add(Aspect.WATER, 75), 3, 3, 3, Arrays.asList(empty, null, empty, null, new ItemStack(BlocksTC.infusionMatrix), null, empty, null, empty, new ItemStack(BlocksTC.stone, 1, 4), null, new ItemStack(BlocksTC.stone, 1, 4), null, null, null, new ItemStack(BlocksTC.stone, 1, 4), null, new ItemStack(BlocksTC.stone, 1, 4), new ItemStack(BlocksTC.stone, 1, 4), null, new ItemStack(BlocksTC.stone, 1, 4), null, new ItemStack(BlocksTC.pedestal, 1, 1), null, new ItemStack(BlocksTC.stone, 1, 4), null, new ItemStack(BlocksTC.stone, 1, 4))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 3, BlocksTC.infusionMatrix.func_176223_P(), "Thaumcraft");
        ConfigResearch.recipes.put("Thaumatorium", Arrays.asList(new AspectList().add(Aspect.FIRE, 50).add(Aspect.ORDER, 100).add(Aspect.WATER, 100), 1, 3, 1, Arrays.asList(new ItemStack(BlocksTC.metal, 1, 2), new ItemStack(BlocksTC.metal, 1, 2), new ItemStack(BlocksTC.crucible))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 4, BlocksTC.metal.func_176203_a(2), "Thaumcraft");
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 5, BlocksTC.crucible.func_176223_P(), "Thaumcraft");
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 6, BlocksTC.eldritch.func_176203_a(0), "Thaumcraft");
        ConfigResearch.recipes.put("GolemPress", Arrays.asList(new AspectList().add(Aspect.FIRE, 50).add(Aspect.ORDER, 50).add(Aspect.AIR, 50), 2, 2, 2, Arrays.asList(empty, new ItemStack(Blocks.field_150411_aY), empty, empty, new ItemStack(Items.field_151066_bu), new ItemStack((Block)Blocks.field_150331_J), new ItemStack(Blocks.field_150467_bQ), new ItemStack(BlocksTC.tableStone))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 7, Blocks.field_150331_J.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176321_a, (Comparable)EnumFacing.UP), "Thaumcraft");
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 8, Blocks.field_150383_bp.func_176223_P(), "Thaumcraft");
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 9, BlocksTC.tableStone.func_176223_P(), "Thaumcraft");
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 10, Blocks.field_150411_aY.func_176223_P(), "Thaumcraft");
        ConfigResearch.recipes.put("Thaumonomicon", Arrays.asList(new AspectList(), 1, 2, 1, Arrays.asList(basicWand, new ItemStack(Blocks.field_150342_X))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 0, Blocks.field_150342_X.func_176223_P(), "Thaumcraft");
        ConfigResearch.recipes.put("ArcTable", Arrays.asList(new AspectList(), 1, 2, 1, Arrays.asList(basicWand, new ItemStack(BlocksTC.tableWood))));
        ConfigResearch.recipes.put("ResTable", Arrays.asList(new AspectList(), 1, 2, 1, Arrays.asList(new ItemStack(ItemsTC.scribingTools), new ItemStack(BlocksTC.tableWood))));
        ConfigResearch.recipes.put("Crucible", Arrays.asList(new AspectList(), 1, 2, 1, Arrays.asList(basicWand, new ItemStack(Items.field_151066_bu))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager.triggers, 1, Blocks.field_150383_bp.func_176223_P(), "Thaumcraft");
    }

    private static void initializeAlchemyRecipes() {
        Aspect[] aspect = new Aspect[]{Aspect.AIR, Aspect.FIRE, Aspect.WATER, Aspect.EARTH, Aspect.ORDER, Aspect.ENTROPY};
        for (int a = 0; a < 6; ++a) {
            AspectList al = new AspectList();
            for (int b = 0; b < 6; ++b) {
                if (b == a) continue;
                al.add(aspect[b], 2);
            }
            ConfigResearch.recipes.put("BalancedShard_" + a, ThaumcraftApi.addCrucibleRecipe("CRUCIBLE", new ItemStack(ItemsTC.shard, 1, 7), (Object)new ItemStack(ItemsTC.shard, 1, a), al));
        }
        ConfigResearch.recipes.put("Alumentum", ThaumcraftApi.addCrucibleRecipe("ALUMENTUM", new ItemStack(ItemsTC.alumentum), (Object)new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.ENERGY, 3).merge(Aspect.FIRE, 3).merge(Aspect.ENTROPY, 3)));
        ConfigResearch.recipes.put("Nitor", ThaumcraftApi.addCrucibleRecipe("NITOR", new ItemStack(BlocksTC.nitor, 1, 4), (Object)"dustGlowstone", new AspectList().merge(Aspect.ENERGY, 3).merge(Aspect.FIRE, 3).merge(Aspect.LIGHT, 3)));
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int a = 0; a < 16; ++a) {
            ConfigRecipes.shapelessOreDictRecipe(new ItemStack(BlocksTC.nitor, 1, a), new Object[]{"dye" + dyes[15 - a], "nitor"});
        }
        ConfigResearch.recipes.put("Thaumium", ThaumcraftApi.addCrucibleRecipe("METALLURGY", new ItemStack(ItemsTC.ingots, 1, 0), (Object)"ingotIron", new AspectList().merge(Aspect.EARTH, 2).merge(Aspect.ORDER, 2)));
        ConfigResearch.recipes.put("AlchemicalBrass", ThaumcraftApi.addCrucibleRecipe("METALLURGY", new ItemStack(ItemsTC.ingots, 1, 2), (Object)"ingotIron", new AspectList().merge(Aspect.ENERGY, 1).merge(Aspect.WATER, 1)));
        ConfigResearch.recipes.put("VoidMetal", ThaumcraftApi.addCrucibleRecipe("VOIDMETAL", new ItemStack(ItemsTC.ingots, 1, 1), (Object)new ItemStack(ItemsTC.voidSeed), new AspectList().merge(Aspect.METAL, 7).merge(Aspect.FLUX, 1)));
        ConfigResearch.recipes.put("VoidSeed", ThaumcraftApi.addCrucibleRecipe("ELDRITCHMINOR", new ItemStack(ItemsTC.voidSeed), (Object)new ItemStack(Items.field_151014_N), new AspectList().merge(Aspect.DARKNESS, 8).merge(Aspect.VOID, 8).merge(Aspect.ELDRITCH, 2)));
        ConfigResearch.recipes.put("Tallow", ThaumcraftApi.addCrucibleRecipe("TALLOW", new ItemStack(ItemsTC.tallow), (Object)new ItemStack(Items.field_151078_bh), new AspectList().merge(Aspect.FIRE, 1)));
        ConfigResearch.recipes.put("AltGunpowder", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.field_151016_H, 2, 0), (Object)new ItemStack(Items.field_151016_H), new AspectList().merge(Aspect.FIRE, 4).merge(Aspect.ENTROPY, 4)));
        ConfigResearch.recipes.put("AltSlime", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.field_151123_aH, 2, 0), (Object)new ItemStack(Items.field_151123_aH), new AspectList().merge(Aspect.WATER, 2).merge(Aspect.LIFE, 1)));
        ConfigResearch.recipes.put("AltGlowstone", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.field_151114_aO, 2, 0), (Object)"dustGlowstone", new AspectList().merge(Aspect.LIGHT, 3).merge(Aspect.SENSES, 1)));
        ConfigResearch.recipes.put("AltInk", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.field_151100_aR, 2, 0), (Object)new ItemStack(Items.field_151100_aR, 1, 0), new AspectList().merge(Aspect.WATER, 2).merge(Aspect.SENSES, 2)));
        ConfigResearch.recipes.put("AltPrisCrys", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.field_179563_cD, 2, 0), (Object)new ItemStack(Items.field_179563_cD), new AspectList().merge(Aspect.WATER, 1).merge(Aspect.CRYSTAL, 2).merge(Aspect.LIGHT, 1)));
        ConfigResearch.recipes.put("AltPrisShard", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.field_179562_cC, 2, 0), (Object)new ItemStack(Items.field_179562_cC), new AspectList().merge(Aspect.WATER, 2).merge(Aspect.EARTH, 1)));
        ConfigResearch.recipes.put("AltClay", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALMANUFACTURE", new ItemStack(Items.field_151119_aD, 1, 0), (Object)new ItemStack(Blocks.field_150346_d), new AspectList().merge(Aspect.WATER, 1).merge(Aspect.EARTH, 1)));
        ConfigResearch.recipes.put("AltWeb", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALMANUFACTURE", new ItemStack(Blocks.field_150321_G), (Object)new ItemStack(Items.field_151007_F), new AspectList().merge(Aspect.TRAP, 2)));
        ConfigResearch.recipes.put("AltMossyCobble", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALMANUFACTURE", new ItemStack(Blocks.field_150341_Y), (Object)new ItemStack(Blocks.field_150347_e), new AspectList().merge(Aspect.PLANT, 2)));
        ConfigResearch.recipes.put("AltIce", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALMANUFACTURE", new ItemStack(Blocks.field_150432_aD), (Object)new ItemStack(Blocks.field_150433_aE), new AspectList().merge(Aspect.ORDER, 1).merge(Aspect.COLD, 1)));
        ConfigResearch.recipes.put("AltLava", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALMANUFACTURE", new ItemStack(Items.field_151129_at), (Object)new ItemStack(Items.field_151133_ar), new AspectList().merge(Aspect.EARTH, 2).merge(Aspect.FIRE, 4)));
        ConfigResearch.recipes.put("AltGrass", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALMANUFACTURE", new ItemStack((Block)Blocks.field_150349_c), (Object)new ItemStack(Blocks.field_150346_d), new AspectList().merge(Aspect.PLANT, 1)));
        ConfigResearch.recipes.put("AltBonemeal", ThaumcraftApi.addCrucibleRecipe("ENTROPICPROCESSING", new ItemStack(Items.field_151100_aR, 4, 15), (Object)new ItemStack(Items.field_151103_aS), new AspectList().merge(Aspect.ENTROPY, 1)));
        ConfigResearch.recipes.put("AltBlaze", ThaumcraftApi.addCrucibleRecipe("ENTROPICPROCESSING", new ItemStack(Items.field_151065_br, 3, 0), (Object)new ItemStack(Items.field_151072_bj), new AspectList().merge(Aspect.ENTROPY, 1)));
        ConfigResearch.recipes.put("AltLeather", ThaumcraftApi.addCrucibleRecipe("ENTROPICPROCESSING", new ItemStack(Items.field_151116_aA), (Object)new ItemStack(Items.field_151078_bh), new AspectList().merge(Aspect.ENTROPY, 1).merge(Aspect.FIRE, 1)));
        ConfigResearch.recipes.put("AltString", ThaumcraftApi.addCrucibleRecipe("ENTROPICPROCESSING", new ItemStack(Items.field_151007_F, 4, 0), (Object)new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.ENTROPY, 1)));
        ConfigResearch.recipes.put("AltMyc", ThaumcraftApi.addCrucibleRecipe("ENTROPICPROCESSING", new ItemStack((Block)Blocks.field_150391_bh), (Object)new ItemStack(Blocks.field_150346_d), new AspectList().merge(Aspect.ENTROPY, 1).merge(Aspect.PLANT, 1)));
        ConfigResearch.recipes.put("PureIron", ThaumcraftApi.addCrucibleRecipe("PUREMETAL", new ItemStack(ItemsTC.clusters, 1, 0), (Object)"oreIron", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        ConfigResearch.recipes.put("PureGold", ThaumcraftApi.addCrucibleRecipe("PUREMETAL", new ItemStack(ItemsTC.clusters, 1, 1), (Object)"oreGold", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        ConfigResearch.recipes.put("PureCinnabar", ThaumcraftApi.addCrucibleRecipe("PUREMETAL", new ItemStack(ItemsTC.clusters, 1, 6), (Object)"oreCinnabar", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        if (Config.foundCopperIngot) {
            ConfigResearch.recipes.put("PureCopper", ThaumcraftApi.addCrucibleRecipe("PUREMETAL", new ItemStack(ItemsTC.clusters, 1, 2), (Object)"oreCopper", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        }
        if (Config.foundTinIngot) {
            ConfigResearch.recipes.put("PureTin", ThaumcraftApi.addCrucibleRecipe("PUREMETAL", new ItemStack(ItemsTC.clusters, 1, 3), (Object)"oreTin", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        }
        if (Config.foundSilverIngot) {
            ConfigResearch.recipes.put("PureSilver", ThaumcraftApi.addCrucibleRecipe("PUREMETAL", new ItemStack(ItemsTC.clusters, 1, 4), (Object)"oreSilver", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        }
        if (Config.foundLeadIngot) {
            ConfigResearch.recipes.put("PureLead", ThaumcraftApi.addCrucibleRecipe("PUREMETAL", new ItemStack(ItemsTC.clusters, 1, 5), (Object)"oreLead", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        }
        ConfigResearch.recipes.put("TransIron", ThaumcraftApi.addCrucibleRecipe("TRANSMETAL", new ItemStack(ItemsTC.nuggets, 3, 0), (Object)"nuggetIron", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.FLUX, 1)));
        ConfigResearch.recipes.put("TransGold", ThaumcraftApi.addCrucibleRecipe("TRANSMETAL", new ItemStack(Items.field_151074_bl, 3, 0), (Object)new ItemStack(Items.field_151074_bl), new AspectList().merge(Aspect.METAL, 2).merge(Aspect.DESIRE, 1).merge(Aspect.FLUX, 1)));
        if (Config.foundCopperIngot) {
            ConfigResearch.recipes.put("TransCopper", ThaumcraftApi.addCrucibleRecipe("TRANSMETAL", new ItemStack(ItemsTC.nuggets, 3, 1), (Object)"nuggetCopper", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.EXCHANGE, 1).merge(Aspect.FLUX, 1)));
        }
        if (Config.foundTinIngot) {
            ConfigResearch.recipes.put("TransTin", ThaumcraftApi.addCrucibleRecipe("TRANSMETAL", new ItemStack(ItemsTC.nuggets, 3, 2), (Object)"nuggetTin", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.CRYSTAL, 1).merge(Aspect.FLUX, 1)));
        }
        if (Config.foundSilverIngot) {
            ConfigResearch.recipes.put("TransSilver", ThaumcraftApi.addCrucibleRecipe("TRANSMETAL", new ItemStack(ItemsTC.nuggets, 3, 3), (Object)"nuggetSilver", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.DESIRE, 1).merge(Aspect.FLUX, 1)));
        }
        if (Config.foundLeadIngot) {
            ConfigResearch.recipes.put("TransLead", ThaumcraftApi.addCrucibleRecipe("TRANSMETAL", new ItemStack(ItemsTC.nuggets, 3, 4), (Object)"nuggetLead", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.ORDER, 1).merge(Aspect.FLUX, 1)));
        }
        ConfigResearch.recipes.put("EtherealBloom", ThaumcraftApi.addCrucibleRecipe("ETHEREALBLOOM", new ItemStack(BlocksTC.bloom), (Object)new ItemStack(BlocksTC.shimmerleaf), new AspectList().add(Aspect.LIGHT, 8).add(Aspect.PLANT, 16).add(Aspect.LIFE, 16).add(Aspect.FLUX, 16)));
        ConfigResearch.recipes.put("LiquidDeath", ThaumcraftApi.addCrucibleRecipe("LIQUIDDEATH", new ItemStack(ItemsTC.bucketDeath), (Object)new ItemStack(Items.field_151133_ar), new AspectList().add(Aspect.DEATH, 32).add(Aspect.CRYSTAL, 32).add(Aspect.ENTROPY, 32)));
        ItemStack bt = new ItemStack(ItemsTC.phial, 1, 1);
        ((IEssentiaContainerItem)bt.func_77973_b()).setAspects(bt, new AspectList().add(Aspect.FLUX, 8));
        ConfigResearch.recipes.put("BottleTaint", ThaumcraftApi.addCrucibleRecipe("BOTTLETAINT", new ItemStack(ItemsTC.bottleTaint), (Object)bt, new AspectList().add(Aspect.FLUX, 8).add(Aspect.WATER, 8)));
        ConfigResearch.recipes.put("TaintShard", ThaumcraftApi.addCrucibleRecipe("TAINTSHARD", new ItemStack(ItemsTC.shard, 1, 6), (Object)new ItemStack(ItemsTC.shard, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FLUX, 4).add(Aspect.ENTROPY, 4)));
        ConfigResearch.recipes.put("BathSalts", ThaumcraftApi.addCrucibleRecipe("BATHSALTS", new ItemStack(ItemsTC.bathSalts), (Object)new ItemStack(ItemsTC.salisMundus), new AspectList().add(Aspect.MIND, 6).add(Aspect.AIR, 6).add(Aspect.ORDER, 6).add(Aspect.LIFE, 6)));
        ConfigResearch.recipes.put("SaneSoap", ThaumcraftApi.addCrucibleRecipe("SANESOAP", new ItemStack(ItemsTC.sanitySoap), (Object)new ItemStack(BlocksTC.fleshBlock), new AspectList().add(Aspect.MIND, 16).add(Aspect.ELDRITCH, 16).add(Aspect.ORDER, 16).add(Aspect.LIFE, 16)));
        ConfigResearch.recipes.put("SealCollect", ThaumcraftApi.addCrucibleRecipe("SEALCOLLECT", GolemHelper.getSealStack("Thaumcraft:pickup"), (Object)new ItemStack(ItemsTC.seals), new AspectList().add(Aspect.DESIRE, 4)));
        ConfigResearch.recipes.put("SealCollectAdv", ThaumcraftApi.addCrucibleRecipe(new String[]{"SEALCOLLECT", "MINDBIOTHAUMIC"}, GolemHelper.getSealStack("Thaumcraft:pickup_advanced"), (Object)GolemHelper.getSealStack("Thaumcraft:pickup"), new AspectList().add(Aspect.SENSES, 4).add(Aspect.MIND, 4)));
        ConfigResearch.recipes.put("SealStore", ThaumcraftApi.addCrucibleRecipe("SEALSTORE", GolemHelper.getSealStack("Thaumcraft:fill"), (Object)new ItemStack(ItemsTC.seals), new AspectList().add(Aspect.AVERSION, 4)));
        ConfigResearch.recipes.put("SealStoreAdv", ThaumcraftApi.addCrucibleRecipe(new String[]{"SEALSTORE", "MINDBIOTHAUMIC"}, GolemHelper.getSealStack("Thaumcraft:fill_advanced"), (Object)GolemHelper.getSealStack("Thaumcraft:fill"), new AspectList().add(Aspect.SENSES, 4).add(Aspect.MIND, 4)));
        ConfigResearch.recipes.put("SealEmpty", ThaumcraftApi.addCrucibleRecipe("SEALEMPTY", GolemHelper.getSealStack("Thaumcraft:empty"), (Object)new ItemStack(ItemsTC.seals), new AspectList().add(Aspect.VOID, 4)));
        ConfigResearch.recipes.put("SealEmptyAdv", ThaumcraftApi.addCrucibleRecipe(new String[]{"SEALEMPTY", "MINDBIOTHAUMIC"}, GolemHelper.getSealStack("Thaumcraft:empty_advanced"), (Object)GolemHelper.getSealStack("Thaumcraft:empty"), new AspectList().add(Aspect.SENSES, 4).add(Aspect.MIND, 4)));
        ConfigResearch.recipes.put("SealProvide", ThaumcraftApi.addCrucibleRecipe("SEALPROVIDE", GolemHelper.getSealStack("Thaumcraft:provider"), (Object)GolemHelper.getSealStack("Thaumcraft:empty_advanced"), new AspectList().add(Aspect.EXCHANGE, 4).add(Aspect.DESIRE, 4)));
        ConfigResearch.recipes.put("SealGuard", ThaumcraftApi.addCrucibleRecipe("SEALGUARD", GolemHelper.getSealStack("Thaumcraft:guard"), (Object)new ItemStack(ItemsTC.seals), new AspectList().add(Aspect.AVERSION, 8).add(Aspect.PROTECT, 8)));
        ConfigResearch.recipes.put("SealGuardAdv", ThaumcraftApi.addCrucibleRecipe(new String[]{"SEALGUARD", "MINDBIOTHAUMIC"}, GolemHelper.getSealStack("Thaumcraft:guard_advanced"), (Object)GolemHelper.getSealStack("Thaumcraft:guard"), new AspectList().add(Aspect.SENSES, 8).add(Aspect.MIND, 8)));
        ConfigResearch.recipes.put("SealLumber", ThaumcraftApi.addCrucibleRecipe(new String[]{"SEALLUMBER"}, GolemHelper.getSealStack("Thaumcraft:lumber"), (Object)GolemHelper.getSealStack("Thaumcraft:breaker"), new AspectList().add(Aspect.PLANT, 16).add(Aspect.SENSES, 8)));
        ConfigResearch.recipes.put("SealUse", ThaumcraftApi.addCrucibleRecipe(new String[]{"SEALUSE"}, GolemHelper.getSealStack("Thaumcraft:use"), (Object)new ItemStack(ItemsTC.seals), new AspectList().add(Aspect.CRAFT, 8).add(Aspect.SENSES, 4).add(Aspect.MIND, 4)));
    }

    private static void initializeArcaneRecipes() {
        ArcaneWandRecipe wr = new ArcaneWandRecipe();
        ThaumcraftApi.getCraftingRecipes().add(wr);
        CraftingManager.func_77594_a().func_180302_a((IRecipe)wr);
        ArcaneSceptreRecipe sr = new ArcaneSceptreRecipe();
        ThaumcraftApi.getCraftingRecipes().add(sr);
        CraftingManager.func_77594_a().func_180302_a((IRecipe)sr);
        ConfigResearch.recipes.put("SealBlank", ThaumcraftApi.addShapelessArcaneCraftingRecipe("CONTROLSEALS", new ItemStack(ItemsTC.seals, 3), new AspectList().add(Aspect.FIRE, 10).add(Aspect.ORDER, 10), new ItemStack(Items.field_151119_aD), new ItemStack(ItemsTC.tallow), "dyeRed", "nitor"));
        ConfigResearch.recipes.put("GolemBell", ThaumcraftApi.addArcaneCraftingRecipe("CONTROLSEALS", new ItemStack(ItemsTC.golemBell), new AspectList().add(Aspect.ORDER, 10).add(Aspect.AIR, 10), " QQ", " QQ", "S  ", Character.valueOf('S'), "stickWood", Character.valueOf('Q'), "gemQuartz"));
        ConfigResearch.recipes.put("ModuleVision", ThaumcraftApi.addArcaneCraftingRecipe("GOLEMVISION", new ItemStack(ItemsTC.modules, 1, 0), new AspectList().add(Aspect.WATER, 25).add(Aspect.AIR, 25), "B B", "E E", "PGP", Character.valueOf('B'), new ItemStack(Items.field_151069_bo), Character.valueOf('E'), new ItemStack(Items.field_151071_bq), Character.valueOf('P'), "plateBrass", Character.valueOf('G'), "gearBrass"));
        ConfigResearch.recipes.put("ModuleAggression", ThaumcraftApi.addArcaneCraftingRecipe("SEALGUARD", new ItemStack(ItemsTC.modules, 1, 1), new AspectList().add(Aspect.FIRE, 25).add(Aspect.ENTROPY, 25), " R ", "RTR", "PGP", Character.valueOf('R'), "paneGlass", Character.valueOf('T'), new ItemStack(Items.field_151065_br), Character.valueOf('P'), "plateBrass", Character.valueOf('G'), "gearBrass"));
        ConfigResearch.recipes.put("MirrorGlass", ThaumcraftApi.addShapelessArcaneCraftingRecipe("BASICARTIFACE", new ItemStack(ItemsTC.mirroredGlass), new AspectList().add(Aspect.FIRE, 25).add(Aspect.EARTH, 25), new ItemStack(ItemsTC.quicksilver), "paneGlass"));
        ConfigResearch.recipes.put("PrimalCharm", ThaumcraftApi.addShapelessArcaneCraftingRecipe("BASICARTIFACE", new ItemStack(ItemsTC.primalCharm), new AspectList().add(Aspect.EARTH, 25).add(Aspect.FIRE, 25).add(Aspect.AIR, 25).add(Aspect.WATER, 25).add(Aspect.ORDER, 25).add(Aspect.ENTROPY, 25), Items.field_151043_k, "shardBalanced", "shardAir", "shardFire", "shardWater", "shardEarth", "shardOrder", "shardEntropy"));
        for (int a = 0; a < 16; ++a) {
            ItemStack banner = new ItemStack(BlocksTC.banner, 1, 0);
            banner.func_77982_d(new NBTTagCompound());
            banner.func_77978_p().func_74774_a("color", (byte)a);
            ConfigResearch.recipes.put("Banner_" + a, ThaumcraftApi.addArcaneCraftingRecipe("BANNERS", banner, new AspectList().add(Aspect.WATER, 5).add(Aspect.EARTH, 5), "WS", "WS", "WB", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, 15 - a), Character.valueOf('S'), "stickWood", Character.valueOf('B'), "slabWood"));
        }
        ConfigResearch.recipes.put("WorkbenchCharger", ThaumcraftApi.addArcaneCraftingRecipe("WORKBENCHCHARGER", new ItemStack(BlocksTC.arcaneWorkbenchCharger), new AspectList().add(Aspect.FIRE, 100).add(Aspect.ORDER, 100).add(Aspect.AIR, 100), " R ", "W W", "I I", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), new ItemStack(ItemsTC.shard, 1, 7), Character.valueOf('W'), new ItemStack(ItemsTC.wandRods, 1, 0)));
        ConfigResearch.recipes.put("FocalManipulator", ThaumcraftApi.addArcaneCraftingRecipe("FOCALMANIPULATION", new ItemStack(BlocksTC.wandWorkbench), new AspectList().add(Aspect.FIRE, 150).add(Aspect.AIR, 150).add(Aspect.ENTROPY, 150).add(Aspect.EARTH, 150).add(Aspect.WATER, 150).add(Aspect.ORDER, 150), "IQI", "SPS", "GTG", Character.valueOf('Q'), new ItemStack(BlocksTC.slabStone), Character.valueOf('S'), new ItemStack(BlocksTC.stone), Character.valueOf('T'), new ItemStack(BlocksTC.tableStone), Character.valueOf('I'), "ingotIron", Character.valueOf('G'), new ItemStack(Items.field_151043_k), Character.valueOf('P'), new ItemStack(ItemsTC.primalCharm)));
        ConfigResearch.recipes.put("ArcaneStone1", ThaumcraftApi.addArcaneCraftingRecipe("ARCANESTONE", new ItemStack(BlocksTC.stone, 9, 0), new AspectList().add(Aspect.EARTH, 5).add(Aspect.FIRE, 5), "SSS", "SCS", "SSS", Character.valueOf('S'), "stone", Character.valueOf('C'), new ItemStack(ItemsTC.shard, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("ArcaneStone2", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stone, 4, 1), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack(BlocksTC.stone, 1, 0)}));
        ConfigResearch.recipes.put("ArcaneStone3", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stairsArcane, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stone, 1, 0)}));
        ConfigResearch.recipes.put("ArcaneStone4", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stairsArcaneBrick, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stone, 1, 1)}));
        ConfigResearch.recipes.put("ArcaneStone5", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabStone, 6, 0), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stone, 1, 0)}));
        ConfigResearch.recipes.put("ArcaneStone6", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabStone, 6, 1), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stone, 1, 1)}));
        ConfigResearch.recipes.put("PaveBarrier", ThaumcraftApi.addArcaneCraftingRecipe("PAVEBARRIER", new ItemStack(BlocksTC.pavingStone, 4, 0), new AspectList().add(Aspect.FIRE, 50).add(Aspect.ORDER, 50), "SAS", "SBS", Character.valueOf('S'), new ItemStack(BlocksTC.stone, 1, 1), Character.valueOf('A'), "shardFire", Character.valueOf('B'), "shardOrder"));
        ConfigResearch.recipes.put("PaveTravel", ThaumcraftApi.addArcaneCraftingRecipe("PAVETRAVEL", new ItemStack(BlocksTC.pavingStone, 4, 1), new AspectList().add(Aspect.EARTH, 50).add(Aspect.AIR, 50), "SAS", "SBS", Character.valueOf('S'), new ItemStack(BlocksTC.stone, 1, 1), Character.valueOf('A'), "shardAir", Character.valueOf('B'), "shardEarth"));
        ConfigResearch.recipes.put("ArcaneLamp", ThaumcraftApi.addArcaneCraftingRecipe("ARCANELAMP", new ItemStack(BlocksTC.lampArcane), new AspectList().add(Aspect.FIRE, 25).add(Aspect.AIR, 25), " S ", "IAI", " N ", Character.valueOf('A'), new ItemStack(BlocksTC.translucent), Character.valueOf('S'), new ItemStack((Block)Blocks.field_150453_bW), Character.valueOf('N'), "nitor", Character.valueOf('I'), "ingotIron"));
        ConfigResearch.recipes.put("ArcaneSpa", ThaumcraftApi.addArcaneCraftingRecipe("ARCANESPA", new ItemStack(BlocksTC.spa), new AspectList().add(Aspect.WATER, 25).add(Aspect.ORDER, 15).add(Aspect.EARTH, 15), "QIQ", "SJS", "SPS", Character.valueOf('P'), "gearBrass", Character.valueOf('J'), new ItemStack(BlocksTC.jar), Character.valueOf('S'), new ItemStack(BlocksTC.stone, 1, 0), Character.valueOf('Q'), new ItemStack(Blocks.field_150371_ca), Character.valueOf('I'), new ItemStack(Blocks.field_150411_aY)));
        ConfigResearch.recipes.put("Levitator", ThaumcraftApi.addArcaneCraftingRecipe("LEVITATOR", new ItemStack(BlocksTC.levitator), new AspectList().add(Aspect.AIR, 20).add(Aspect.EARTH, 15), "WEW", "BNB", "WGW", Character.valueOf('W'), "plankWood", Character.valueOf('E'), "shardAir", Character.valueOf('N'), "nitor", Character.valueOf('B'), "ingotIron", Character.valueOf('G'), "gearBrass"));
        ConfigResearch.recipes.put("RedstoneRelay", ThaumcraftApi.addArcaneCraftingRecipe("REDSTONERELAY", new ItemStack(BlocksTC.redstoneRelay), new AspectList().add(Aspect.FIRE, 5).add(Aspect.ORDER, 5), "   ", "TGC", "SSS", Character.valueOf('T'), new ItemStack(Blocks.field_150429_aA), Character.valueOf('G'), "gearBrass", Character.valueOf('C'), "shardOrder", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U)));
        ConfigResearch.recipes.put("ArcaneEar", ThaumcraftApi.addArcaneCraftingRecipe("ARCANEEAR", new ItemStack(BlocksTC.arcaneEar), new AspectList().add(Aspect.AIR, 10).add(Aspect.ORDER, 5), "PBP", " P ", "WRW", Character.valueOf('W'), "slabWood", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('P'), ItemsTC.plate, Character.valueOf('B'), new ItemStack(ItemsTC.brain)));
        ConfigResearch.recipes.put("PoleInner", ThaumcraftApi.addArcaneCraftingRecipe("AURAMANIP1", new ItemStack(BlocksTC.auraTotem, 1, 3), new AspectList().add(Aspect.AIR, 50).add(Aspect.EARTH, 125).add(Aspect.ORDER, 75), "WGW", "WNW", "WGW", Character.valueOf('N'), "shardEarth", Character.valueOf('W'), new ItemStack(BlocksTC.plank, 1, 1), Character.valueOf('G'), new ItemStack(BlocksTC.plank, 1, 0)));
        ConfigResearch.recipes.put("PoleOuter", ThaumcraftApi.addArcaneCraftingRecipe("AURAMANIP1", new ItemStack(BlocksTC.auraTotem, 1, 2), new AspectList().add(Aspect.AIR, 125).add(Aspect.EARTH, 50).add(Aspect.ORDER, 125), "WGW", "WNW", "WGW", Character.valueOf('N'), "shardAir", Character.valueOf('W'), new ItemStack(BlocksTC.plank, 1, 1), Character.valueOf('G'), new ItemStack(BlocksTC.plank, 1, 0)));
        ConfigResearch.recipes.put("PoleStable", ThaumcraftApi.addArcaneCraftingRecipe("AURAPOLESTABLE", new ItemStack(BlocksTC.auraTotem, 1, 4), new AspectList().add(Aspect.AIR, 125).add(Aspect.EARTH, 125).add(Aspect.ORDER, 250), "WGW", "WNW", "WGW", Character.valueOf('N'), "shardBalanced", Character.valueOf('W'), new ItemStack(BlocksTC.plank, 1, 1), Character.valueOf('G'), new ItemStack(BlocksTC.plank, 1, 0)));
        ConfigResearch.recipes.put("BoneBow", ThaumcraftApi.addArcaneCraftingRecipe("BONEBOW", new ItemStack(ItemsTC.boneBow), new AspectList().add(Aspect.AIR, 50).add(Aspect.ENTROPY, 100), "SB ", "SEB", "SB ", Character.valueOf('E'), "shardEntropy", Character.valueOf('B'), Items.field_151103_aS, Character.valueOf('S'), Items.field_151007_F));
        Aspect[] pa = new Aspect[]{Aspect.AIR, Aspect.FIRE, Aspect.WATER, Aspect.EARTH, Aspect.ORDER, Aspect.ENTROPY};
        for (int a = 0; a < 6; ++a) {
            ConfigResearch.recipes.put("PrimalArrow_" + a, ThaumcraftApi.addArcaneCraftingRecipe("PRIMALARROW", new ItemStack(ItemsTC.primalArrows, 8, a), new AspectList().add(pa[a], 25), "AAA", "ASA", "AAA", Character.valueOf('A'), Items.field_151032_g, Character.valueOf('S'), new ItemStack(ItemsTC.shard, 1, a)));
        }
        ConfigResearch.recipes.put("InfusionMatrix", ThaumcraftApi.addArcaneCraftingRecipe("INFUSION", new ItemStack(BlocksTC.infusionMatrix), new AspectList().add(Aspect.ORDER, 100), "SBS", "BNB", "SBS", Character.valueOf('S'), new ItemStack(BlocksTC.stone, 1, 1), Character.valueOf('N'), "nitor", Character.valueOf('B'), new ItemStack(ItemsTC.shard, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("MatrixSpeed", ThaumcraftApi.addArcaneCraftingRecipe("INFUSIONBOOST", new ItemStack(BlocksTC.stone, 1, 8), new AspectList().add(Aspect.AIR, 250).add(Aspect.ORDER, 250).add(Aspect.ENTROPY, 250), "SNS", "NGN", "SNS", Character.valueOf('S'), new ItemStack(BlocksTC.stone), Character.valueOf('N'), "nitor", Character.valueOf('G'), new ItemStack(Blocks.field_150484_ah)));
        ConfigResearch.recipes.put("MatrixCost", ThaumcraftApi.addArcaneCraftingRecipe("INFUSIONBOOST", new ItemStack(BlocksTC.stone, 1, 9), new AspectList().add(Aspect.WATER, 250).add(Aspect.ORDER, 250).add(Aspect.ENTROPY, 250), "SAS", "AGA", "SAS", Character.valueOf('S'), new ItemStack(BlocksTC.stone), Character.valueOf('A'), new ItemStack(ItemsTC.alumentum), Character.valueOf('G'), new ItemStack(Blocks.field_150484_ah)));
        ConfigResearch.recipes.put("ArcanePedestal", ThaumcraftApi.addArcaneCraftingRecipe("INFUSION", new ItemStack(BlocksTC.pedestal), new AspectList().add(Aspect.AIR, 5), "SSS", " B ", "SSS", Character.valueOf('S'), new ItemStack(BlocksTC.slabStone), Character.valueOf('B'), new ItemStack(BlocksTC.stone)));
        ConfigResearch.recipes.put("AncientPedestal", ThaumcraftApi.addArcaneCraftingRecipe(new String[]{"INFUSION", "!ORBLOCK1"}, new ItemStack(BlocksTC.pedestal, 1, 2), new AspectList().add(Aspect.AIR, 25).add(Aspect.ENTROPY, 25).add(Aspect.ORDER, 150), "SSS", " B ", "SSS", Character.valueOf('S'), new ItemStack(BlocksTC.slabStone, 1, 2), Character.valueOf('B'), new ItemStack(BlocksTC.stone, 1, 2)));
        ConfigResearch.recipes.put("EldritchPedestal", ThaumcraftApi.addArcaneCraftingRecipe(new String[]{"INFUSION", "!ORBLOCK2"}, new ItemStack(BlocksTC.pedestal, 1, 1), new AspectList().add(Aspect.AIR, 25).add(Aspect.ENTROPY, 150).add(Aspect.ORDER, 25), "SSS", " B ", "SSS", Character.valueOf('S'), new ItemStack(BlocksTC.slabStone, 1, 3), Character.valueOf('B'), new ItemStack(BlocksTC.stone, 1, 4)));
        ConfigResearch.recipes.put("WardedJar", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(BlocksTC.jar), new AspectList().add(Aspect.WATER, 5), "GWG", "G G", "GGG", Character.valueOf('W'), "slabWood", Character.valueOf('G'), "paneGlass"));
        ConfigResearch.recipes.put("JarVoid", ThaumcraftApi.addArcaneCraftingRecipe("JARVOID", new ItemStack(BlocksTC.jar, 1, 1), new AspectList().add(Aspect.WATER, 25).add(Aspect.ENTROPY, 25), "O", "J", "P", Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z), Character.valueOf('P'), Items.field_151065_br, Character.valueOf('J'), new ItemStack(BlocksTC.jar)));
        ConfigResearch.recipes.put("WandCapGold", ThaumcraftApi.addArcaneCraftingRecipe("CAP_gold", new ItemStack(ItemsTC.wandCaps, 1, 1), new AspectList().add(Aspect.ORDER, WandCap.caps.get("gold").getCraftCost() * 8).add(Aspect.FIRE, WandCap.caps.get("gold").getCraftCost() * 8).add(Aspect.AIR, WandCap.caps.get("gold").getCraftCost() * 8), "NNN", "N N", Character.valueOf('N'), Items.field_151074_bl));
        ConfigResearch.recipes.put("WandCapBrass", ThaumcraftApi.addArcaneCraftingRecipe("CAP_brass", new ItemStack(ItemsTC.wandCaps, 1, 2), new AspectList().add(Aspect.ORDER, WandCap.caps.get("brass").getCraftCost() * 8).add(Aspect.FIRE, WandCap.caps.get("brass").getCraftCost() * 8).add(Aspect.AIR, WandCap.caps.get("brass").getCraftCost() * 8), "NNN", "N N", Character.valueOf('N'), "nuggetBrass"));
        ConfigResearch.recipes.put("WandCapThaumiumInert", ThaumcraftApi.addArcaneCraftingRecipe("CAP_thaumium", new ItemStack(ItemsTC.wandCaps, 1, 3), new AspectList().add(Aspect.ORDER, WandCap.caps.get("thaumium").getCraftCost() * 8).add(Aspect.FIRE, WandCap.caps.get("thaumium").getCraftCost() * 8).add(Aspect.AIR, WandCap.caps.get("thaumium").getCraftCost() * 8), "NNN", "N N", Character.valueOf('N'), "nuggetThaumium"));
        ConfigResearch.recipes.put("WandCapVoidInert", ThaumcraftApi.addArcaneCraftingRecipe("CAP_void", new ItemStack(ItemsTC.wandCaps, 1, 5), new AspectList().add(Aspect.ENTROPY, WandCap.caps.get("void").getCraftCost() * 8).add(Aspect.ORDER, WandCap.caps.get("void").getCraftCost() * 8).add(Aspect.FIRE, WandCap.caps.get("void").getCraftCost() * 8).add(Aspect.AIR, WandCap.caps.get("void").getCraftCost() * 8), "NNN", "N N", Character.valueOf('N'), "nuggetVoid"));
        ConfigResearch.recipes.put("WandRodGreatwood", ThaumcraftApi.addArcaneCraftingRecipe("ROD_greatwood", new ItemStack(ItemsTC.wandRods, 1, 0), new AspectList().add(Aspect.ENTROPY, WandRod.rods.get("greatwood").getCraftCost() * 8), " G", "G ", Character.valueOf('G'), new ItemStack(BlocksTC.log, 1, 0)));
        ConfigResearch.recipes.put("WandRodGreatwoodStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_greatwood_staff", new ItemStack(ItemsTC.wandRods, 1, 8), new AspectList().add(Aspect.ORDER, WandRod.rods.get("greatwood_staff").getCraftCost() * 8), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ItemsTC.primalCharm), Character.valueOf('G'), new ItemStack(ItemsTC.wandRods, 1, 0)));
        ConfigResearch.recipes.put("WandRodSilverwoodStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_silverwood_staff", new ItemStack(ItemsTC.wandRods, 1, 9), new AspectList().add(Aspect.ORDER, WandRod.rods.get("silverwood_staff").getCraftCost() * 8), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ItemsTC.primalCharm), Character.valueOf('G'), new ItemStack(ItemsTC.wandRods, 1, 1)));
        ConfigResearch.recipes.put("WandRodObsidianStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_obsidian_staff", new ItemStack(ItemsTC.wandRods, 1, 10), new AspectList().add(Aspect.ORDER, WandRod.rods.get("obsidian_staff").getCraftCost() * 4).add(Aspect.EARTH, WandRod.rods.get("obsidian_staff").getCraftCost() * 4), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ItemsTC.primalCharm), Character.valueOf('G'), new ItemStack(ItemsTC.wandRods, 1, 2)));
        ConfigResearch.recipes.put("WandRodBlazeStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_blaze_staff", new ItemStack(ItemsTC.wandRods, 1, 11), new AspectList().add(Aspect.ORDER, WandRod.rods.get("blaze_staff").getCraftCost() * 4).add(Aspect.FIRE, WandRod.rods.get("blaze_staff").getCraftCost() * 4), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ItemsTC.primalCharm), Character.valueOf('G'), new ItemStack(ItemsTC.wandRods, 1, 3)));
        ConfigResearch.recipes.put("WandRodIceStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_ice_staff", new ItemStack(ItemsTC.wandRods, 1, 12), new AspectList().add(Aspect.ORDER, WandRod.rods.get("ice_staff").getCraftCost() * 4).add(Aspect.WATER, WandRod.rods.get("ice_staff").getCraftCost() * 4), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ItemsTC.primalCharm), Character.valueOf('G'), new ItemStack(ItemsTC.wandRods, 1, 4)));
        ConfigResearch.recipes.put("WandRodQuartzStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_quartz_staff", new ItemStack(ItemsTC.wandRods, 1, 13), new AspectList().add(Aspect.ORDER, WandRod.rods.get("quartz_staff").getCraftCost() * 4).add(Aspect.ORDER, WandRod.rods.get("quartz_staff").getCraftCost() * 4), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ItemsTC.primalCharm), Character.valueOf('G'), new ItemStack(ItemsTC.wandRods, 1, 5)));
        ConfigResearch.recipes.put("WandRodBoneStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_bone_staff", new ItemStack(ItemsTC.wandRods, 1, 14), new AspectList().add(Aspect.ORDER, WandRod.rods.get("bone_staff").getCraftCost() * 4).add(Aspect.ENTROPY, WandRod.rods.get("bone_staff").getCraftCost() * 4), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ItemsTC.primalCharm), Character.valueOf('G'), new ItemStack(ItemsTC.wandRods, 1, 6)));
        ConfigResearch.recipes.put("WandRodReedStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_reed_staff", new ItemStack(ItemsTC.wandRods, 1, 15), new AspectList().add(Aspect.ORDER, WandRod.rods.get("reed_staff").getCraftCost() * 4).add(Aspect.AIR, WandRod.rods.get("reed_staff").getCraftCost() * 4), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ItemsTC.primalCharm), Character.valueOf('G'), new ItemStack(ItemsTC.wandRods, 1, 7)));
        ConfigResearch.recipes.put("FocusShock", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSSHOCK", new ItemStack(ItemsTC.focusShock), new AspectList().add(Aspect.AIR, 75).add(Aspect.ORDER, 75).add(Aspect.ENTROPY, 50), "CQC", "Q#Q", "CQC", Character.valueOf('#'), Items.field_151174_bG, Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), "shardAir"));
        ConfigResearch.recipes.put("FocusFire", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSFIRE", new ItemStack(ItemsTC.focusFire), new AspectList().add(Aspect.FIRE, 100).add(Aspect.ENTROPY, 50), "CQC", "Q#Q", "CQC", Character.valueOf('#'), Items.field_151059_bz, Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), "shardFire"));
        ConfigResearch.recipes.put("FocusFrost", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSFROST", new ItemStack(ItemsTC.focusFrost), new AspectList().add(Aspect.WATER, 75).add(Aspect.ORDER, 75).add(Aspect.ENTROPY, 50), "CQC", "Q#Q", "CQC", Character.valueOf('#'), Items.field_151045_i, Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), "shardWater"));
        ConfigResearch.recipes.put("FocusExcavation", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSEXCAVATION", new ItemStack(ItemsTC.focusExcavation), new AspectList().add(Aspect.EARTH, 75).add(Aspect.ENTROPY, 75).add(Aspect.ORDER, 50), "CQC", "Q#Q", "CQC", Character.valueOf('#'), "gemEmerald", Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), "shardEarth"));
        ConfigResearch.recipes.put("FocusTrade", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSTRADE", new ItemStack(ItemsTC.focusEqualTrade), new AspectList().add(Aspect.ORDER, 75).add(Aspect.ENTROPY, 75).add(Aspect.EARTH, 50), "CQE", "Q#Q", "CQE", Character.valueOf('#'), new ItemStack(ItemsTC.quicksilver), Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), "shardBalanced", Character.valueOf('E'), "shardBalanced"));
        ConfigResearch.recipes.put("FocusBuilder", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSBUILDER", new ItemStack(ItemsTC.focusBuilder), new AspectList().add(Aspect.ORDER, 75).add(Aspect.AIR, 50).add(Aspect.EARTH, 75), "CQE", "Q#Q", "EQC", Character.valueOf('#'), new ItemStack(ItemsTC.amber), Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), "shardAir", Character.valueOf('E'), "shardEarth"));
        ConfigResearch.recipes.put("FocusPrimal", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSPRIMAL", new ItemStack(ItemsTC.focusPrimal), new AspectList().add(Aspect.EARTH, 150).add(Aspect.ENTROPY, 150).add(Aspect.ORDER, 150).add(Aspect.AIR, 150).add(Aspect.FIRE, 150).add(Aspect.WATER, 150), "CQC", "Q#Q", "CQC", Character.valueOf('#'), new ItemStack(ItemsTC.primalCharm), Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), Items.field_151045_i));
        ConfigResearch.recipes.put("FocusGrapple", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSGRAPPLE", new ItemStack(ItemsTC.focusGrapple), new AspectList().add(Aspect.AIR, 75).add(Aspect.WATER, 75).add(Aspect.ORDER, 50), "AQW", "Q#Q", "WQA", Character.valueOf('#'), Items.field_151123_aH, Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('A'), "shardAir", Character.valueOf('W'), "shardWater"));
        ConfigResearch.recipes.put("FocusPouch", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSPOUCH", new ItemStack(ItemsTC.focusPouch), new AspectList().add(Aspect.EARTH, 25).add(Aspect.ORDER, 25).add(Aspect.ENTROPY, 25), "LGL", "LBL", "LLL", Character.valueOf('B'), new ItemStack(ItemsTC.baubles, 1, 2), Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('G'), Items.field_151043_k));
        ConfigResearch.recipes.put("ArcaneBoreBase", ThaumcraftApi.addArcaneCraftingRecipe("ARCANEBORE", new ItemStack(BlocksTC.arcaneBoreBase), new AspectList().add(Aspect.AIR, 100).add(Aspect.ORDER, 100), "WIW", "IDI", "WGW", Character.valueOf('W'), new ItemStack(BlocksTC.plank), Character.valueOf('G'), "gearBrass", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('D'), new ItemStack(Blocks.field_150367_z, 1)));
        ConfigResearch.recipes.put("EnchantedFabric", ThaumcraftApi.addArcaneCraftingRecipe("ENCHFABRIC", new ItemStack(ItemsTC.fabric), new AspectList().add(Aspect.AIR, 5).add(Aspect.EARTH, 5).add(Aspect.FIRE, 5).add(Aspect.WATER, 5).add(Aspect.ORDER, 5).add(Aspect.ENTROPY, 5), " S ", "SCS", " S ", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('C'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("RobeChest", ThaumcraftApi.addArcaneCraftingRecipe("ENCHFABRIC", new ItemStack(ItemsTC.clothChest, 1), new AspectList().add(Aspect.AIR, 30), "I I", "III", "III", Character.valueOf('I'), new ItemStack(ItemsTC.fabric)));
        ConfigResearch.recipes.put("RobeLegs", ThaumcraftApi.addArcaneCraftingRecipe("ENCHFABRIC", new ItemStack(ItemsTC.clothLegs, 1), new AspectList().add(Aspect.WATER, 25), "III", "I I", "I I", Character.valueOf('I'), new ItemStack(ItemsTC.fabric)));
        ConfigResearch.recipes.put("RobeBoots", ThaumcraftApi.addArcaneCraftingRecipe("ENCHFABRIC", new ItemStack(ItemsTC.clothBoots, 1), new AspectList().add(Aspect.EARTH, 20), "I I", "I I", Character.valueOf('I'), new ItemStack(ItemsTC.fabric)));
        ConfigResearch.recipes.put("Goggles", ThaumcraftApi.addArcaneCraftingRecipe("GOGGLES", new ItemStack(ItemsTC.goggles), new AspectList().add(Aspect.AIR, 25).add(Aspect.FIRE, 25).add(Aspect.WATER, 25).add(Aspect.EARTH, 25).add(Aspect.ENTROPY, 25).add(Aspect.ORDER, 25), "LGL", "L L", "TGT", Character.valueOf('T'), new ItemStack(ItemsTC.thaumometer, 1, Short.MAX_VALUE), Character.valueOf('G'), "ingotBrass", Character.valueOf('L'), Items.field_151116_aA));
        ConfigResearch.recipes.put("Dioptra", ThaumcraftApi.addArcaneCraftingRecipe("DIOPTRA", new ItemStack(BlocksTC.dioptra), new AspectList().add(Aspect.AIR, 25).add(Aspect.EARTH, 25).add(Aspect.ORDER, 25), "APA", "IGI", "AAA", Character.valueOf('A'), new ItemStack(BlocksTC.stone), Character.valueOf('G'), new ItemStack(ItemsTC.goggles), Character.valueOf('P'), new ItemStack(BlocksTC.slabStone), Character.valueOf('I'), "ingotIron"));
        ConfigResearch.recipes.put("HungryChest", ThaumcraftApi.addArcaneCraftingRecipe("HUNGRYCHEST", new ItemStack(BlocksTC.hungryChest), new AspectList().add(Aspect.AIR, 15).add(Aspect.ORDER, 15).add(Aspect.ENTROPY, 15), "WTW", "W W", "WWW", Character.valueOf('W'), new ItemStack(BlocksTC.plank), Character.valueOf('T'), new ItemStack(Blocks.field_150415_aT)));
        ConfigResearch.recipes.put("Filter", ThaumcraftApi.addArcaneCraftingRecipe("CRUCIBLE", new ItemStack(ItemsTC.filter, 2, 0), new AspectList().add(Aspect.ORDER, 15).add(Aspect.WATER, 15), "GWG", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('W'), new ItemStack(BlocksTC.plank, 1, 1)));
        ConfigResearch.recipes.put("MorphicResonator", ThaumcraftApi.addArcaneCraftingRecipe("CRUCIBLE", new ItemStack(ItemsTC.morphicResonator), new AspectList().add(Aspect.ORDER, 50).add(Aspect.ENTROPY, 50), " G ", "BFB", " G ", Character.valueOf('G'), "paneGlass", Character.valueOf('B'), "plateBrass", Character.valueOf('F'), "shardTainted"));
        ConfigResearch.recipes.put("EssentiaSmelter", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(BlocksTC.smelterBasic), new AspectList().add(Aspect.FIRE, 25).add(Aspect.WATER, 25), "BCB", "SFS", "SSS", Character.valueOf('C'), new ItemStack(BlocksTC.crucible), Character.valueOf('F'), new ItemStack(Blocks.field_150460_al), Character.valueOf('S'), "cobblestone", Character.valueOf('B'), "plateBrass"));
        ConfigResearch.recipes.put("EssentiaSmelter2", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA2", new ItemStack(BlocksTC.smelterThaumium), new AspectList().add(Aspect.FIRE, 350).add(Aspect.WATER, 350), "BFB", "IGI", "III", Character.valueOf('C'), new ItemStack(BlocksTC.crucible), Character.valueOf('F'), new ItemStack(BlocksTC.smelterBasic), Character.valueOf('G'), new ItemStack(BlocksTC.metal, 1, 2), Character.valueOf('I'), "ingotThaumium", Character.valueOf('B'), "plateBrass"));
        ConfigResearch.recipes.put("EssentiaSmelter3", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA3", new ItemStack(BlocksTC.smelterVoid), new AspectList().add(Aspect.FIRE, 750).add(Aspect.WATER, 750), "BFB", "IGI", "III", Character.valueOf('C'), new ItemStack(BlocksTC.crucible), Character.valueOf('F'), new ItemStack(BlocksTC.smelterThaumium), Character.valueOf('G'), new ItemStack(BlocksTC.metal, 1, 3), Character.valueOf('I'), "ingotVoid", Character.valueOf('B'), "plateBrass"));
        ConfigResearch.recipes.put("AdvAlchemyConstruct", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA3", new ItemStack(BlocksTC.metal, 1, 3), new AspectList().add(Aspect.WATER, 200).add(Aspect.ORDER, 200).add(Aspect.EARTH, 200), "VAV", "APA", "VAV", Character.valueOf('A'), new ItemStack(BlocksTC.metal, 1, 2), Character.valueOf('V'), new ItemStack(ItemsTC.ingots, 1, 1), Character.valueOf('P'), new ItemStack(ItemsTC.primordialPearl)));
        ConfigResearch.recipes.put("Alembic", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(BlocksTC.alembic), new AspectList().add(Aspect.AIR, 15).add(Aspect.WATER, 25), "WFW", "SBS", "WFW", Character.valueOf('W'), new ItemStack(BlocksTC.plank), Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('F'), new ItemStack(ItemsTC.filter), Character.valueOf('S'), "plateBrass"));
        ConfigResearch.recipes.put("SmelterAux", ThaumcraftApi.addArcaneCraftingRecipe("IMPROVED_DISTILLATION", new ItemStack(BlocksTC.smelterAux), new AspectList().add(Aspect.AIR, 50).add(Aspect.WATER, 50).add(Aspect.EARTH, 25), "WTW", "RGR", "IBI", Character.valueOf('W'), new ItemStack(BlocksTC.plank), Character.valueOf('B'), new ItemStack(BlocksTC.bellows), Character.valueOf('R'), "plateBrass", Character.valueOf('T'), new ItemStack(BlocksTC.tube, 1, 4), Character.valueOf('F'), new ItemStack(ItemsTC.filter), Character.valueOf('I'), "ingotIron", Character.valueOf('G'), new ItemStack(BlocksTC.metal, 1, 2)));
        ConfigResearch.recipes.put("SmelterVent", ThaumcraftApi.addArcaneCraftingRecipe("IMPROVED_DISTILLATION", new ItemStack(BlocksTC.smelterVent), new AspectList().add(Aspect.AIR, 125).add(Aspect.WATER, 125).add(Aspect.ORDER, 100), "IBI", "MGF", "IBI", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "ingotBrass", Character.valueOf('F'), new ItemStack(ItemsTC.filter), Character.valueOf('M'), new ItemStack(ItemsTC.morphicResonator), Character.valueOf('G'), new ItemStack(BlocksTC.metal, 1, 2)));
        ConfigResearch.recipes.put("EssentiaTransportIn", ThaumcraftApi.addArcaneCraftingRecipe("ESSENTIATRANSPORT", new ItemStack(BlocksTC.essentiaTransportInput), new AspectList().add(Aspect.WATER, 75).add(Aspect.AIR, 50).add(Aspect.ORDER, 50), "BQB", "IGI", "IPI", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "ingotBrass", Character.valueOf('Q'), new ItemStack(Blocks.field_150367_z, 1, 0), Character.valueOf('P'), new ItemStack(BlocksTC.tube, 1, 0), Character.valueOf('G'), new ItemStack(BlocksTC.metal, 1, 2)));
        ConfigResearch.recipes.put("EssentiaTransportOut", ThaumcraftApi.addArcaneCraftingRecipe("ESSENTIATRANSPORT", new ItemStack(BlocksTC.essentiaTransportOutput), new AspectList().add(Aspect.WATER, 75).add(Aspect.AIR, 50).add(Aspect.ORDER, 50), "BQB", "IGI", "IPI", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "ingotBrass", Character.valueOf('Q'), new ItemStack((Block)Blocks.field_150438_bZ, 1, 0), Character.valueOf('P'), new ItemStack(BlocksTC.tube, 1, 0), Character.valueOf('G'), new ItemStack(BlocksTC.metal, 1, 2)));
        ConfigResearch.recipes.put("Bellows", ThaumcraftApi.addArcaneCraftingRecipe("BELLOWS", new ItemStack(BlocksTC.bellows, 1, 0), new AspectList().add(Aspect.AIR, 25).add(Aspect.ORDER, 10), "WW ", "LCI", "WW ", Character.valueOf('W'), "plankWood", Character.valueOf('C'), "shardAir", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('L'), Items.field_151116_aA));
        ConfigResearch.recipes.put("Tube", ThaumcraftApi.addArcaneCraftingRecipe("TUBES", new ItemStack(BlocksTC.tube, 8, 0), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), " Q ", "IGI", " B ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('B'), Items.field_151074_bl, Character.valueOf('G'), "blockGlass", Character.valueOf('Q'), new ItemStack(ItemsTC.nuggets, 1, 5)));
        ConfigResearch.recipes.put("Resonator", ThaumcraftApi.addArcaneCraftingRecipe("TUBES", new ItemStack(ItemsTC.resonator), new AspectList().add(Aspect.WATER, 5).add(Aspect.AIR, 5), "I I", "INI", " S ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('N'), Items.field_151128_bU, Character.valueOf('S'), "stickWood"));
        ConfigResearch.recipes.put("TubeValve", ThaumcraftApi.addShapelessArcaneCraftingRecipe("TUBES", new ItemStack(BlocksTC.tube, 1, 1), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), new ItemStack(BlocksTC.tube, 1, 0), new ItemStack(Blocks.field_150442_at)));
        ConfigResearch.recipes.put("TubeFilter", ThaumcraftApi.addShapelessArcaneCraftingRecipe("TUBEFILTER", new ItemStack(BlocksTC.tube, 1, 4), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 10), new ItemStack(BlocksTC.tube, 1, 0), new ItemStack(ItemsTC.filter)));
        ConfigResearch.recipes.put("TubeRestrict", ThaumcraftApi.addShapelessArcaneCraftingRecipe("TUBEFILTER", new ItemStack(BlocksTC.tube, 1, 2), new AspectList().add(Aspect.WATER, 5).add(Aspect.EARTH, 10), new ItemStack(BlocksTC.tube, 1, 0), "stone"));
        ConfigResearch.recipes.put("TubeOneway", ThaumcraftApi.addShapelessArcaneCraftingRecipe("TUBEFILTER", new ItemStack(BlocksTC.tube, 1, 3), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 10).add(Aspect.ENTROPY, 10), new ItemStack(BlocksTC.tube, 1, 0), "dyeBlue"));
        ConfigResearch.recipes.put("TubeBuffer", ThaumcraftApi.addArcaneCraftingRecipe("TUBEFILTER", new ItemStack(BlocksTC.tube, 1, 5), new AspectList().add(Aspect.WATER, 25).add(Aspect.ORDER, 25), "PVP", "T T", "PRP", Character.valueOf('T'), new ItemStack(BlocksTC.tube, 1, 0), Character.valueOf('V'), new ItemStack(BlocksTC.tube, 1, 1), Character.valueOf('R'), new ItemStack(BlocksTC.tube, 1, 2), Character.valueOf('P'), new ItemStack(ItemsTC.phial)));
        ConfigResearch.recipes.put("AlchemicalConstruct", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(BlocksTC.metal, 1, 2), new AspectList().add(Aspect.WATER, 50).add(Aspect.ORDER, 50), "IVI", "TWT", "IVI", Character.valueOf('W'), new ItemStack(BlocksTC.plank), Character.valueOf('V'), new ItemStack(BlocksTC.tube, 1, 1), Character.valueOf('T'), new ItemStack(BlocksTC.tube, 1, 0), Character.valueOf('I'), "ingotIron"));
        ConfigResearch.recipes.put("Centrifuge", ThaumcraftApi.addArcaneCraftingRecipe("CENTRIFUGE", new ItemStack(BlocksTC.centrifuge), new AspectList().add(Aspect.WATER, 100).add(Aspect.ORDER, 100).add(Aspect.ENTROPY, 100), " T ", "RCP", " T ", Character.valueOf('T'), new ItemStack(BlocksTC.tube, 1, 0), Character.valueOf('P'), "gearBrass", Character.valueOf('R'), new ItemStack(ItemsTC.morphicResonator), Character.valueOf('C'), new ItemStack(BlocksTC.metal, 1, 2)));
        ConfigResearch.recipes.put("EssentiaCrystalizer", ThaumcraftApi.addArcaneCraftingRecipe("ESSENTIACRYSTAL", new ItemStack(BlocksTC.crystallizer), new AspectList().add(Aspect.WATER, 100).add(Aspect.EARTH, 250).add(Aspect.ORDER, 100), "IDI", "QCQ", "WTW", Character.valueOf('T'), new ItemStack(BlocksTC.tube, 1, 0), Character.valueOf('D'), "gearBrass", Character.valueOf('Q'), "shardBalanced", Character.valueOf('I'), "ingotIron", Character.valueOf('W'), "plankWood", Character.valueOf('C'), new ItemStack(BlocksTC.metal, 1, 2)));
        ConfigResearch.recipes.put("MnemonicMatrix", ThaumcraftApi.addArcaneCraftingRecipe("THAUMATORIUM", new ItemStack(BlocksTC.brainBox), new AspectList().add(Aspect.FIRE, 50).add(Aspect.WATER, 50).add(Aspect.ORDER, 50), "IAI", "ABA", "IAI", Character.valueOf('B'), new ItemStack(ItemsTC.mind, 1, 0), Character.valueOf('A'), "gemAmber", Character.valueOf('I'), "ingotIron"));
        ConfigResearch.recipes.put("MindClockwork", ThaumcraftApi.addArcaneCraftingRecipe("MINDCLOCKWORK", new ItemStack(ItemsTC.mind, 1, 0), new AspectList().add(Aspect.FIRE, 10).add(Aspect.WATER, 10).add(Aspect.ORDER, 10), "PPP", "PGP", "BCB", Character.valueOf('G'), "gearBrass", Character.valueOf('B'), "plateBrass", Character.valueOf('P'), "paneGlass", Character.valueOf('C'), new ItemStack(Items.field_151132_bS)));
        ConfigResearch.recipes.put("AutomatedCrossbow", ThaumcraftApi.addArcaneCraftingRecipe("BASICTURRET", new ItemStack(ItemsTC.turretPlacer, 1, 0), new AspectList().add(Aspect.FIRE, 50).add(Aspect.AIR, 100).add(Aspect.ORDER, 50), "BGI", "WMW", "S S", Character.valueOf('G'), "gearBrass", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), "stickWood", Character.valueOf('M'), new ItemStack(ItemsTC.mind), Character.valueOf('B'), new ItemStack((Item)Items.field_151031_f), Character.valueOf('W'), new ItemStack(BlocksTC.plank)));
        ConfigResearch.recipes.put("AdvancedCrossbow", ThaumcraftApi.addArcaneCraftingRecipe("ADVANCEDTURRET", new ItemStack(ItemsTC.turretPlacer, 1, 3), new AspectList().add(Aspect.FIRE, 50).add(Aspect.AIR, 75).add(Aspect.ORDER, 125), "PMP", "PTP", "BGB", Character.valueOf('G'), "gearBrass", Character.valueOf('T'), new ItemStack(ItemsTC.turretPlacer, 1, 0), Character.valueOf('P'), "plateIron", Character.valueOf('B'), "plateBrass", Character.valueOf('M'), new ItemStack(ItemsTC.mind, 1, 1)));
        ConfigResearch.recipes.put("NodeStable", ThaumcraftApi.addArcaneCraftingRecipe("NODESTABLE", new ItemStack(BlocksTC.nodeStabilizer), new AspectList().add(Aspect.WATER, 25).add(Aspect.EARTH, 25).add(Aspect.ORDER, 50), " G ", "QPQ", "SNS", Character.valueOf('S'), new ItemStack(BlocksTC.stone, 1, 1), Character.valueOf('G'), new ItemStack(Items.field_151043_k), Character.valueOf('P'), new ItemStack((Block)Blocks.field_150331_J), Character.valueOf('Q'), new ItemStack(Blocks.field_150371_ca), Character.valueOf('N'), "nitor"));
        ConfigResearch.recipes.put("ArcanePatternCrafter", ThaumcraftApi.addArcaneCraftingRecipe("ARCANEPATTERNCRAFTER", new ItemStack(BlocksTC.patternCrafter), new AspectList().add(Aspect.ORDER, 100).add(Aspect.FIRE, 100).add(Aspect.ENTROPY, 100), " H ", "GCG", " W ", Character.valueOf('H'), new ItemStack((Block)Blocks.field_150438_bZ), Character.valueOf('W'), new ItemStack(BlocksTC.plank), Character.valueOf('G'), "gearBrass", Character.valueOf('C'), new ItemStack(Blocks.field_150462_ai)));
    }

    private static void initializeInfusionRecipes() {
        ConfigResearch.recipes.put("SealHarvest", ThaumcraftApi.addInfusionCraftingRecipe("SEALHARVEST", (Object)GolemHelper.getSealStack("Thaumcraft:harvest"), 0, new AspectList().add(Aspect.PLANT, 4).add(Aspect.SENSES, 4).add(Aspect.MAN, 4), (Object)new ItemStack(ItemsTC.seals), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151080_bb), new ItemStack(Items.field_151081_bc), new ItemStack(Items.field_151100_aR, 1, 3), new ItemStack(Items.field_151120_aE), new ItemStack((Block)Blocks.field_150434_aF)}));
        ConfigResearch.recipes.put("SealButcher", ThaumcraftApi.addInfusionCraftingRecipe("SEALBUTCHER", (Object)GolemHelper.getSealStack("Thaumcraft:butcher"), 0, new AspectList().add(Aspect.BEAST, 4).add(Aspect.SENSES, 4).add(Aspect.MAN, 4), (Object)GolemHelper.getSealStack("Thaumcraft:guard"), new Object[]{new ItemStack(Items.field_151116_aA), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), new ItemStack(Items.field_179555_bs), new ItemStack(Items.field_151147_al), new ItemStack(Items.field_179561_bm), new ItemStack(Items.field_151082_bd)}));
        ConfigResearch.recipes.put("SealBreak", ThaumcraftApi.addInfusionCraftingRecipe("SEALBREAK", (Object)GolemHelper.getSealStack("Thaumcraft:breaker"), 1, new AspectList().add(Aspect.TOOL, 4).add(Aspect.ENTROPY, 4).add(Aspect.MAN, 4), (Object)new ItemStack(ItemsTC.seals), new Object[]{new ItemStack(Items.field_151006_E), new ItemStack(Items.field_151005_D), new ItemStack(Items.field_151011_C)}));
        ConfigResearch.recipes.put("ClusterAir", ThaumcraftApi.addInfusionCraftingRecipe("CRYSTALFARMER", (Object)new ItemStack(BlocksTC.crystalAir), 0, new AspectList().add(Aspect.AIR, 8).add(Aspect.CRYSTAL, 8).add(Aspect.TRAP, 4), (Object)new ItemStack(ItemsTC.shard, 1, 0), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}));
        ConfigResearch.recipes.put("ClusterFire", ThaumcraftApi.addInfusionCraftingRecipe("CRYSTALFARMER", (Object)new ItemStack(BlocksTC.crystalFire), 0, new AspectList().add(Aspect.FIRE, 8).add(Aspect.CRYSTAL, 8).add(Aspect.TRAP, 4), (Object)new ItemStack(ItemsTC.shard, 1, 1), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}));
        ConfigResearch.recipes.put("ClusterWater", ThaumcraftApi.addInfusionCraftingRecipe("CRYSTALFARMER", (Object)new ItemStack(BlocksTC.crystalWater), 0, new AspectList().add(Aspect.WATER, 8).add(Aspect.CRYSTAL, 8).add(Aspect.TRAP, 4), (Object)new ItemStack(ItemsTC.shard, 1, 2), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}));
        ConfigResearch.recipes.put("ClusterEarth", ThaumcraftApi.addInfusionCraftingRecipe("CRYSTALFARMER", (Object)new ItemStack(BlocksTC.crystalEarth), 0, new AspectList().add(Aspect.EARTH, 8).add(Aspect.CRYSTAL, 8).add(Aspect.TRAP, 4), (Object)new ItemStack(ItemsTC.shard, 1, 3), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}));
        ConfigResearch.recipes.put("ClusterOrder", ThaumcraftApi.addInfusionCraftingRecipe("CRYSTALFARMER", (Object)new ItemStack(BlocksTC.crystalOrder), 0, new AspectList().add(Aspect.ORDER, 8).add(Aspect.CRYSTAL, 8).add(Aspect.TRAP, 4), (Object)new ItemStack(ItemsTC.shard, 1, 4), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}));
        ConfigResearch.recipes.put("ClusterEntropy", ThaumcraftApi.addInfusionCraftingRecipe("CRYSTALFARMER", (Object)new ItemStack(BlocksTC.crystalEntropy), 0, new AspectList().add(Aspect.ENTROPY, 8).add(Aspect.CRYSTAL, 8).add(Aspect.TRAP, 4), (Object)new ItemStack(ItemsTC.shard, 1, 5), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}));
        ConfigResearch.recipes.put("ClusterFlux", ThaumcraftApi.addInfusionCraftingRecipe("CRYSTALFARMER", (Object)new ItemStack(BlocksTC.crystalTaint), 4, new AspectList().add(Aspect.FLUX, 8).add(Aspect.CRYSTAL, 8).add(Aspect.TRAP, 4), (Object)new ItemStack(ItemsTC.shard, 1, 6), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}));
        ConfigResearch.recipes.put("TotemPull", ThaumcraftApi.addInfusionCraftingRecipe("AURAMANIP1", (Object)new ItemStack(BlocksTC.auraTotem, 1, 1), 5, new AspectList().add(Aspect.ENERGY, 25).add(Aspect.AURA, 25).add(Aspect.MOTION, 25).add(Aspect.DESIRE, 25), (Object)new ItemStack(BlocksTC.plank, 1, 1), new Object[]{new ItemStack(BlocksTC.plank, 1, 0), new ItemStack((Block)Blocks.field_150486_ae), "shardBalanced", new ItemStack(ItemsTC.salisMundus), "gemAmber", new ItemStack(Items.field_151146_bM), new ItemStack(ItemsTC.wispyEssence)}));
        ConfigResearch.recipes.put("TotemPush", ThaumcraftApi.addInfusionCraftingRecipe("AURAMANIP1", (Object)new ItemStack(BlocksTC.auraTotem, 1, 0), 5, new AspectList().add(Aspect.ENERGY, 25).add(Aspect.AURA, 25).add(Aspect.MOTION, 25).add(Aspect.AVERSION, 25), (Object)new ItemStack(BlocksTC.plank, 1, 1), new Object[]{new ItemStack(BlocksTC.plank, 1, 0), new ItemStack((Block)Blocks.field_150486_ae), "shardBalanced", new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.quicksilver), new ItemStack((Block)Blocks.field_150331_J), new ItemStack(ItemsTC.wispyEssence)}));
        ConfigResearch.recipes.put("WaterJug", ThaumcraftApi.addInfusionCraftingRecipe("WATERJUG", (Object)new ItemStack(BlocksTC.waterJug), 1, new AspectList().add(Aspect.WATER, 16).add(Aspect.CRAFT, 8).add(Aspect.EARTH, 8), (Object)new ItemStack(Blocks.field_150405_ch), new Object[]{new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151131_as), "shardWater", new ItemStack(ItemsTC.salisMundus)}));
        ConfigResearch.recipes.put("WandCapThaumium", ThaumcraftApi.addInfusionCraftingRecipe("CAP_thaumium", (Object)new ItemStack(ItemsTC.wandCaps, 1, 4), 5, new AspectList().add(Aspect.ENERGY, WandCap.caps.get("thaumium").getCraftCost() * 2).add(Aspect.AURA, WandCap.caps.get("thaumium").getCraftCost()), (Object)new ItemStack(ItemsTC.wandCaps, 1, 3), (Object[])new ItemStack[]{new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.salisMundus)}));
        ConfigResearch.recipes.put("WandCapVoid", ThaumcraftApi.addInfusionCraftingRecipe("CAP_void", (Object)new ItemStack(ItemsTC.wandCaps, 1, 6), 8, new AspectList().add(Aspect.ENERGY, WandCap.caps.get("void").getCraftCost() * 2).add(Aspect.VOID, WandCap.caps.get("void").getCraftCost() * 2).add(Aspect.ELDRITCH, WandCap.caps.get("void").getCraftCost() * 2).add(Aspect.AURA, WandCap.caps.get("void").getCraftCost() * 2), (Object)new ItemStack(ItemsTC.wandCaps, 1, 5), (Object[])new ItemStack[]{new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.salisMundus)}));
        ConfigResearch.recipes.put("WandRodObsidian", ThaumcraftApi.addInfusionCraftingRecipe("ROD_obsidian", (Object)new ItemStack(ItemsTC.wandRods, 1, 2), 3, new AspectList().add(Aspect.EARTH, WandRod.rods.get("obsidian").getCraftCost() * 2).add(Aspect.ENERGY, WandRod.rods.get("obsidian").getCraftCost()).add(Aspect.DARKNESS, WandRod.rods.get("obsidian").getCraftCost()), (Object)new ItemStack(Blocks.field_150343_Z), new Object[]{"shardBalanced", "shardEarth"}));
        ConfigResearch.recipes.put("WandRodIce", ThaumcraftApi.addInfusionCraftingRecipe("ROD_ice", (Object)new ItemStack(ItemsTC.wandRods, 1, 4), 3, new AspectList().add(Aspect.WATER, WandRod.rods.get("ice").getCraftCost() * 2).add(Aspect.ENERGY, WandRod.rods.get("ice").getCraftCost()).add(Aspect.COLD, WandRod.rods.get("ice").getCraftCost()), (Object)new ItemStack(Blocks.field_150432_aD), new Object[]{"shardBalanced", "shardWater"}));
        ConfigResearch.recipes.put("WandRodQuartz", ThaumcraftApi.addInfusionCraftingRecipe("ROD_quartz", (Object)new ItemStack(ItemsTC.wandRods, 1, 5), 3, new AspectList().add(Aspect.ORDER, WandRod.rods.get("quartz").getCraftCost() * 2).add(Aspect.ENERGY, WandRod.rods.get("quartz").getCraftCost()).add(Aspect.CRYSTAL, WandRod.rods.get("quartz").getCraftCost()), (Object)new ItemStack(Blocks.field_150371_ca), new Object[]{"shardBalanced", "shardOrder"}));
        ConfigResearch.recipes.put("WandRodReed", ThaumcraftApi.addInfusionCraftingRecipe("ROD_reed", (Object)new ItemStack(ItemsTC.wandRods, 1, 7), 3, new AspectList().add(Aspect.AIR, WandRod.rods.get("reed").getCraftCost() * 2).add(Aspect.ENERGY, WandRod.rods.get("reed").getCraftCost()).add(Aspect.MOTION, WandRod.rods.get("reed").getCraftCost()), (Object)new ItemStack(Items.field_151120_aE), new Object[]{"shardBalanced", "shardAir"}));
        ConfigResearch.recipes.put("WandRodBlaze", ThaumcraftApi.addInfusionCraftingRecipe("ROD_blaze", (Object)new ItemStack(ItemsTC.wandRods, 1, 3), 3, new AspectList().add(Aspect.FIRE, WandRod.rods.get("blaze").getCraftCost() * 2).add(Aspect.ENERGY, WandRod.rods.get("blaze").getCraftCost()).add(Aspect.BEAST, WandRod.rods.get("blaze").getCraftCost()), (Object)new ItemStack(Items.field_151072_bj), new Object[]{"shardBalanced", "shardFire"}));
        ConfigResearch.recipes.put("WandRodBone", ThaumcraftApi.addInfusionCraftingRecipe("ROD_bone", (Object)new ItemStack(ItemsTC.wandRods, 1, 6), 3, new AspectList().add(Aspect.ENTROPY, WandRod.rods.get("bone").getCraftCost() * 2).add(Aspect.ENERGY, WandRod.rods.get("bone").getCraftCost()).add(Aspect.UNDEAD, WandRod.rods.get("bone").getCraftCost()), (Object)new ItemStack(Items.field_151103_aS), new Object[]{"shardBalanced", "shardEntropy"}));
        ConfigResearch.recipes.put("WandRodSilverwood", ThaumcraftApi.addInfusionCraftingRecipe("ROD_silverwood", (Object)new ItemStack(ItemsTC.wandRods, 1, 1), 5, new AspectList().add(Aspect.AIR, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.FIRE, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.WATER, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.EARTH, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.ORDER, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.ENTROPY, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.ENERGY, WandRod.rods.get("silverwood").getCraftCost()), (Object)new ItemStack(BlocksTC.log, 1, 3), new Object[]{"shardBalanced", "shardAir", "shardFire", "shardWater", "shardEarth", "shardOrder", "shardEntropy"}));
        ConfigResearch.recipes.put("WandRodPrimalStaff", ThaumcraftApi.addInfusionCraftingRecipe("ROD_primal_staff", (Object)new ItemStack(ItemsTC.wandRods, 1, 16), 8, new AspectList().add(Aspect.AIR, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.FIRE, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.WATER, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.EARTH, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.ORDER, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.ENTROPY, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.ENERGY, WandRod.rods.get("primal_staff").getCraftCost() * 2), (Object)new ItemStack(ItemsTC.wandRods, 1, 1), new Object[]{new ItemStack(ItemsTC.primalCharm), new ItemStack(ItemsTC.wandRods, 1, 2), new ItemStack(ItemsTC.wandRods, 1, 3), new ItemStack(ItemsTC.wandRods, 1, 4), new ItemStack(ItemsTC.primalCharm), new ItemStack(ItemsTC.wandRods, 1, 5), new ItemStack(ItemsTC.wandRods, 1, 6), new ItemStack(ItemsTC.wandRods, 1, 7)}));
        ConfigResearch.recipes.put("FocusHellbat", ThaumcraftApi.addInfusionCraftingRecipe("FOCUSHELLBAT", (Object)new ItemStack(ItemsTC.focusHellbat), 3, new AspectList().add(Aspect.FIRE, 25).add(Aspect.AIR, 15).add(Aspect.BEAST, 15).add(Aspect.ENTROPY, 25), (Object)new ItemStack(Items.field_151064_bs), new Object[]{new ItemStack(Items.field_151128_bU), "shardFire", new ItemStack(Items.field_151128_bU), "shardAir", new ItemStack(Items.field_151128_bU), "shardEntropy"}));
        ConfigResearch.recipes.put("FocusPortableHole", ThaumcraftApi.addInfusionCraftingRecipe("FOCUSPORTABLEHOLE", (Object)new ItemStack(ItemsTC.focusHole), 3, new AspectList().add(Aspect.MOTION, 25).add(Aspect.ELDRITCH, 10).add(Aspect.EXCHANGE, 10).add(Aspect.ENTROPY, 25), (Object)new ItemStack(Items.field_151079_bi), new Object[]{new ItemStack(Items.field_151128_bU), "shardEarth", new ItemStack(Items.field_151128_bU), "shardAir", new ItemStack(Items.field_151128_bU), "shardEntropy"}));
        ConfigResearch.recipes.put("WandPed", ThaumcraftApi.addInfusionCraftingRecipe("WANDPED", (Object)new ItemStack(BlocksTC.rechargePedestal), 3, new AspectList().add(Aspect.AURA, 10).add(Aspect.ENERGY, 15).add(Aspect.EXCHANGE, 15), (Object)new ItemStack(BlocksTC.pedestal), (Object[])new ItemStack[]{new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151045_i), new ItemStack(ItemsTC.primalCharm), new ItemStack(Items.field_151045_i)}));
        ConfigResearch.recipes.put("JarBrain", ThaumcraftApi.addInfusionCraftingRecipe("JARBRAIN", (Object)new ItemStack(BlocksTC.jar, 1, 2), 4, new AspectList().add(Aspect.MIND, 10).add(Aspect.SENSES, 10).add(Aspect.UNDEAD, 20), (Object)new ItemStack(BlocksTC.jar, 1, 0), (Object[])new ItemStack[]{new ItemStack(ItemsTC.brain), new ItemStack(Items.field_151070_bp), new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151070_bp)}));
        ConfigResearch.recipes.put("HoverHarness", ThaumcraftApi.addInfusionCraftingRecipe("HOVERHARNESS", (Object)new ItemStack(ItemsTC.thaumostaticHarness), 6, new AspectList().add(Aspect.FLIGHT, 32).add(Aspect.ENERGY, 32).add(Aspect.MECHANISM, 32).add(Aspect.MOTION, 16), (Object)new ItemStack((Item)Items.field_151027_R), new Object[]{"shardAir", "shardAir", new ItemStack(BlocksTC.plank), new ItemStack(BlocksTC.plank), new ItemStack(ItemsTC.morphicResonator), "plateBrass", "plateBrass", "ingotIron", "ingotIron"}));
        ConfigResearch.recipes.put("HoverGirdle", ThaumcraftApi.addInfusionCraftingRecipe("HOVERGIRDLE", (Object)new ItemStack(ItemsTC.girdleHover), 8, new AspectList().add(Aspect.FLIGHT, 16).add(Aspect.ENERGY, 32).add(Aspect.AIR, 32).add(Aspect.MOTION, 16), (Object)new ItemStack(ItemsTC.baubles, 1, 2), new Object[]{"shardAir", new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151043_k), "shardEarth", new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151043_k)}));
        ConfigResearch.recipes.put("VisAmulet", ThaumcraftApi.addInfusionCraftingRecipe("VISAMULET", (Object)new ItemStack(ItemsTC.amuletVis, 1, 1), 6, new AspectList().add(Aspect.AURA, 24).add(Aspect.ENERGY, 64).add(Aspect.ENERGY, 64).add(Aspect.VOID, 24), (Object)new ItemStack(ItemsTC.baubles, 1, 0), new Object[]{new ItemStack(ItemsTC.primalCharm), new ItemStack(ItemsTC.shard, 1, 0), new ItemStack(ItemsTC.shard, 1, 1), new ItemStack(ItemsTC.primalCharm), new ItemStack(ItemsTC.shard, 1, 2), new ItemStack(ItemsTC.shard, 1, 3)}));
        ConfigResearch.recipes.put("RunicAmulet", ThaumcraftApi.addInfusionCraftingRecipe("RUNICARMOR", (Object)new ItemStack(ItemsTC.amuletRunic, 1, 0), 4, new AspectList().add(Aspect.PROTECT, 30).add(Aspect.ENERGY, 50), (Object)new ItemStack(ItemsTC.baubles, 1, 0), new Object[]{new ItemStack(ItemsTC.primalCharm), "gemAmber", new ItemStack(ItemsTC.fabric), "nitor", "nitor", new ItemStack(ItemsTC.scribingTools)}));
        ConfigResearch.recipes.put("RunicAmuletEmergency", ThaumcraftApi.addInfusionCraftingRecipe("RUNICSPECIAL", (Object)new ItemStack(ItemsTC.amuletRunic, 1, 1), 7, new AspectList().add(Aspect.PROTECT, 30).add(Aspect.EARTH, 50).add(Aspect.VOID, 32), (Object)new ItemStack(ItemsTC.amuletRunic, 1, 0), new Object[]{"shardBalanced", "shardEarth", "shardEarth", new ItemStack((Item)Items.field_151068_bn, 1, 8233), "shardEarth", "shardEarth"}));
        ConfigResearch.recipes.put("RunicRing", ThaumcraftApi.addInfusionCraftingRecipe("RUNICARMOR", (Object)new ItemStack(ItemsTC.ringRunic, 1, 1), 3, new AspectList().add(Aspect.PROTECT, 25).add(Aspect.ENERGY, 45), (Object)new ItemStack(ItemsTC.baubles, 1, 1), new Object[]{new ItemStack(ItemsTC.primalCharm), "gemAmber", new ItemStack(ItemsTC.fabric), "nitor", new ItemStack(ItemsTC.scribingTools)}));
        ConfigResearch.recipes.put("RunicRingCharged", ThaumcraftApi.addInfusionCraftingRecipe("RUNICSPECIAL", (Object)new ItemStack(ItemsTC.ringRunic, 1, 2), 6, new AspectList().add(Aspect.PROTECT, 25).add(Aspect.ENERGY, 64), (Object)new ItemStack(ItemsTC.ringRunic, 1, 1), new Object[]{"shardBalanced", "shardFire", "shardFire", new ItemStack((Item)Items.field_151068_bn, 1, 8226), "shardFire", "shardFire"}));
        ConfigResearch.recipes.put("RunicRingHealing", ThaumcraftApi.addInfusionCraftingRecipe("RUNICSPECIAL", (Object)new ItemStack(ItemsTC.ringRunic, 1, 3), 6, new AspectList().add(Aspect.PROTECT, 25).add(Aspect.WATER, 32).add(Aspect.LIFE, 32), (Object)new ItemStack(ItemsTC.ringRunic, 1, 1), new Object[]{"shardBalanced", "shardWater", "shardWater", new ItemStack((Item)Items.field_151068_bn, 1, 8257), "shardWater", "shardWater"}));
        ConfigResearch.recipes.put("RunicGirdle", ThaumcraftApi.addInfusionCraftingRecipe("RUNICARMOR", (Object)new ItemStack(ItemsTC.girdleRunic, 1, 0), 4, new AspectList().add(Aspect.PROTECT, 40).add(Aspect.ENERGY, 64), (Object)new ItemStack(ItemsTC.baubles, 1, 2), new Object[]{new ItemStack(ItemsTC.primalCharm), "gemAmber", new ItemStack(ItemsTC.fabric), "nitor", "nitor", "nitor", new ItemStack(ItemsTC.scribingTools)}));
        ConfigResearch.recipes.put("RunicGirdleKinetic", ThaumcraftApi.addInfusionCraftingRecipe("RUNICSPECIAL", (Object)new ItemStack(ItemsTC.girdleRunic, 1, 1), 7, new AspectList().add(Aspect.PROTECT, 40).add(Aspect.AIR, 64), (Object)new ItemStack(ItemsTC.girdleRunic, 1, 0), new Object[]{"shardBalanced", "shardAir", "shardAir", new ItemStack((Item)Items.field_151068_bn, 1, 16428), "shardAir", "shardAir"}));
        ConfigResearch.recipes.put("RunicGirdleKinetic_2", ThaumcraftApi.addInfusionCraftingRecipe("RUNICSPECIAL", (Object)new ItemStack(ItemsTC.girdleRunic, 1, 1), 7, new AspectList().add(Aspect.PROTECT, 40).add(Aspect.AIR, 64), (Object)new ItemStack(ItemsTC.girdleRunic, 1, 0), new Object[]{"shardBalanced", "shardAir", "shardAir", new ItemStack((Item)Items.field_151068_bn, 1, 24620), "shardAir", "shardAir"}));
        InfusionRunicAugmentRecipe ra = new InfusionRunicAugmentRecipe();
        ThaumcraftApi.getCraftingRecipes().add(ra);
        if (Config.allowMirrors) {
            ConfigResearch.recipes.put("Mirror", ThaumcraftApi.addInfusionCraftingRecipe("MIRROR", (Object)new ItemStack(BlocksTC.mirror), 1, new AspectList().add(Aspect.MOTION, 8).add(Aspect.DARKNESS, 8).add(Aspect.EXCHANGE, 8), (Object)new ItemStack(ItemsTC.mirroredGlass), new Object[]{new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151079_bi)}));
            ConfigResearch.recipes.put("MirrorHand", ThaumcraftApi.addInfusionCraftingRecipe("MIRRORHAND", (Object)new ItemStack(ItemsTC.handMirror), 5, new AspectList().add(Aspect.TOOL, 16).add(Aspect.MOTION, 16), (Object)new ItemStack(BlocksTC.mirror), (Object[])new ItemStack[]{new ItemStack(Items.field_151055_y), new ItemStack(Items.field_151111_aL), new ItemStack((Item)Items.field_151148_bJ)}));
            ConfigResearch.recipes.put("MirrorEssentia", ThaumcraftApi.addInfusionCraftingRecipe("MIRRORESSENTIA", (Object)new ItemStack(BlocksTC.mirrorEssentia), 2, new AspectList().add(Aspect.MOTION, 8).add(Aspect.WATER, 8).add(Aspect.EXCHANGE, 8), (Object)new ItemStack(ItemsTC.mirroredGlass), new Object[]{"ingotIron", "ingotIron", "ingotIron", new ItemStack(Items.field_151079_bi)}));
        }
        ItemStack isEA = new ItemStack(ItemsTC.elementalAxe);
        EnumInfusionEnchantment.addInfusionEnchantment(isEA, EnumInfusionEnchantment.COLLECTOR, 1);
        EnumInfusionEnchantment.addInfusionEnchantment(isEA, EnumInfusionEnchantment.BURROWING, 1);
        ConfigResearch.recipes.put("ElementalAxe", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALTOOLS", (Object)isEA, 1, new AspectList().add(Aspect.WATER, 16).add(Aspect.PLANT, 8), (Object)new ItemStack(ItemsTC.thaumiumAxe), new Object[]{"shardWater", "shardWater", new ItemStack(Items.field_151045_i), new ItemStack(BlocksTC.plank)}));
        ItemStack isEP = new ItemStack(ItemsTC.elementalPick);
        EnumInfusionEnchantment.addInfusionEnchantment(isEP, EnumInfusionEnchantment.REFINING, 1);
        EnumInfusionEnchantment.addInfusionEnchantment(isEP, EnumInfusionEnchantment.SOUNDING, 2);
        ConfigResearch.recipes.put("ElementalPick", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALTOOLS", (Object)isEP, 1, new AspectList().add(Aspect.FIRE, 8).add(Aspect.METAL, 8).add(Aspect.SENSES, 8), (Object)new ItemStack(ItemsTC.thaumiumPick), new Object[]{"shardFire", "shardFire", new ItemStack(Items.field_151045_i), new ItemStack(BlocksTC.plank)}));
        ItemStack isESW = new ItemStack(ItemsTC.elementalSword);
        EnumInfusionEnchantment.addInfusionEnchantment(isESW, EnumInfusionEnchantment.ARCING, 2);
        ConfigResearch.recipes.put("ElementalSword", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALTOOLS", (Object)isESW, 1, new AspectList().add(Aspect.AIR, 8).add(Aspect.MOTION, 8).add(Aspect.AVERSION, 8), (Object)new ItemStack(ItemsTC.thaumiumSword), new Object[]{"shardAir", "shardAir", new ItemStack(Items.field_151045_i), new ItemStack(BlocksTC.plank)}));
        ItemStack isES = new ItemStack(ItemsTC.elementalShovel);
        EnumInfusionEnchantment.addInfusionEnchantment(isES, EnumInfusionEnchantment.DESTRUCTIVE, 1);
        ConfigResearch.recipes.put("ElementalShovel", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALTOOLS", (Object)isES, 1, new AspectList().add(Aspect.EARTH, 16).add(Aspect.CRAFT, 8), (Object)new ItemStack(ItemsTC.thaumiumShovel), new Object[]{"shardEarth", "shardEarth", new ItemStack(Items.field_151045_i), new ItemStack(BlocksTC.plank)}));
        ConfigResearch.recipes.put("ElementalHoe", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALTOOLS", (Object)new ItemStack(ItemsTC.elementalHoe), 1, new AspectList().add(Aspect.ORDER, 8).add(Aspect.PLANT, 8).add(Aspect.ENTROPY, 8), (Object)new ItemStack(ItemsTC.thaumiumHoe), new Object[]{"shardOrder", "shardEntropy", new ItemStack(Items.field_151045_i), new ItemStack(BlocksTC.plank)}));
        InfusionEnchantmentRecipe IEBURROWING = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.BURROWING, new AspectList().add(Aspect.SENSES, 24).add(Aspect.EARTH, 32), new Object[]{new ItemStack(ItemsTC.knowledgeFragment), new ItemStack((Item)Items.field_151134_bR), new ItemStack(Items.field_179556_br)});
        ThaumcraftApi.getCraftingRecipes().add(IEBURROWING);
        ConfigResearch.recipes.put("IEBURROWING", IEBURROWING);
        InfusionEnchantmentRecipe IECOLLECTOR = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.COLLECTOR, new AspectList().add(Aspect.DESIRE, 16).add(Aspect.WATER, 24), new Object[]{new ItemStack(ItemsTC.knowledgeFragment), new ItemStack((Item)Items.field_151134_bR), new ItemStack(Items.field_151058_ca)});
        ThaumcraftApi.getCraftingRecipes().add(IECOLLECTOR);
        ConfigResearch.recipes.put("IECOLLECTOR", IECOLLECTOR);
        InfusionEnchantmentRecipe IEDESTRUCTIVE = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.DESTRUCTIVE, new AspectList().add(Aspect.AVERSION, 48).add(Aspect.ENTROPY, 64), new Object[]{new ItemStack(ItemsTC.knowledgeFragment), new ItemStack((Item)Items.field_151134_bR), new ItemStack(Blocks.field_150335_W)});
        ThaumcraftApi.getCraftingRecipes().add(IEDESTRUCTIVE);
        ConfigResearch.recipes.put("IEDESTRUCTIVE", IEDESTRUCTIVE);
        InfusionEnchantmentRecipe IEREFINING = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.REFINING, new AspectList().add(Aspect.ORDER, 16).add(Aspect.EXCHANGE, 12), new Object[]{new ItemStack(ItemsTC.knowledgeFragment), new ItemStack((Item)Items.field_151134_bR), new ItemStack(ItemsTC.salisMundus)});
        ThaumcraftApi.getCraftingRecipes().add(IEREFINING);
        ConfigResearch.recipes.put("IEREFINING", IEREFINING);
        InfusionEnchantmentRecipe IESOUNDING = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.SOUNDING, new AspectList().add(Aspect.SENSES, 8).add(Aspect.FIRE, 12), new Object[]{new ItemStack(ItemsTC.knowledgeFragment), new ItemStack((Item)Items.field_151134_bR), new ItemStack((Item)Items.field_151148_bJ)});
        ThaumcraftApi.getCraftingRecipes().add(IESOUNDING);
        ConfigResearch.recipes.put("IESOUNDING", IESOUNDING);
        InfusionEnchantmentRecipe IEARCING = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.ARCING, new AspectList().add(Aspect.ENERGY, 8).add(Aspect.AIR, 12), new Object[]{new ItemStack(ItemsTC.knowledgeFragment), new ItemStack((Item)Items.field_151134_bR), new ItemStack(Blocks.field_150451_bX)});
        ThaumcraftApi.getCraftingRecipes().add(IEARCING);
        ConfigResearch.recipes.put("IEARCING", IEARCING);
        InfusionEnchantmentRecipe IEESSENCE = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.ESSENCE, new AspectList().add(Aspect.BEAST, 8).add(Aspect.FLUX, 12), new Object[]{new ItemStack(ItemsTC.knowledgeFragment), new ItemStack((Item)Items.field_151134_bR), new ItemStack(ItemsTC.crystalEssence)});
        ThaumcraftApi.getCraftingRecipes().add(IEESSENCE);
        ConfigResearch.recipes.put("IEESSENCE", IEESSENCE);
        ConfigResearch.recipes.put("BootsTraveller", ThaumcraftApi.addInfusionCraftingRecipe("BOOTSTRAVELLER", (Object)new ItemStack(ItemsTC.travellerBoots), 1, new AspectList().add(Aspect.FLIGHT, 25).add(Aspect.MOTION, 25), (Object)new ItemStack((Item)Items.field_151021_T), new Object[]{"shardAir", "shardAir", new ItemStack(ItemsTC.fabric), new ItemStack(ItemsTC.fabric), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE)}));
        ConfigResearch.recipes.put("MindBiothaumic", ThaumcraftApi.addInfusionCraftingRecipe("MINDBIOTHAUMIC", (Object)new ItemStack(ItemsTC.mind, 1, 1), 4, new AspectList().add(Aspect.MIND, 16).add(Aspect.MECHANISM, 16), (Object)new ItemStack(ItemsTC.mind, 1, 0), new Object[]{new ItemStack(ItemsTC.brain), new ItemStack(Items.field_151113_aN)}));
        ConfigResearch.recipes.put("ArcaneBore", ThaumcraftApi.addInfusionCraftingRecipe("ARCANEBORE", (Object)new ItemStack(BlocksTC.arcaneBore), 4, new AspectList().add(Aspect.ENERGY, 16).add(Aspect.EARTH, 32).add(Aspect.MECHANISM, 32).add(Aspect.VOID, 16).add(Aspect.MOTION, 16), (Object)new ItemStack(ItemsTC.mind), new Object[]{new ItemStack(BlocksTC.plank), new ItemStack(BlocksTC.plank), "gearBrass", "plateBrass", new ItemStack(Items.field_151046_w), new ItemStack(Items.field_151047_v), "shardAir", "shardEarth"}));
        ConfigResearch.recipes.put("AutoCaster", ThaumcraftApi.addInfusionCraftingRecipe("FOCUSTURRET", (Object)new ItemStack(ItemsTC.turretPlacer, 1, 1), 5, new AspectList().add(Aspect.AURA, 16).add(Aspect.MECHANISM, 32).add(Aspect.MIND, 16).add(Aspect.SENSES, 16).add(Aspect.AVERSION, 16), (Object)new ItemStack(ItemsTC.mind, 1, 1), new Object[]{"shardBalanced", new ItemStack(ItemsTC.morphicResonator), new ItemStack(BlocksTC.plank), "gearBrass", basicWand, "plateBrass", new ItemStack(BlocksTC.plank)}));
        ConfigResearch.recipes.put("NodeMagnet", ThaumcraftApi.addInfusionCraftingRecipe("NODEMAGNET", (Object)new ItemStack(ItemsTC.turretPlacer, 1, 2), 4, new AspectList().add(Aspect.MECHANISM, 16).add(Aspect.MOTION, 32).add(Aspect.AURA, 64), (Object)new ItemStack(ItemsTC.morphicResonator), new Object[]{"gearBrass", "plateBrass", "blockIron", new ItemStack(ItemsTC.mind, 1, 1), new ItemStack(BlocksTC.plank), new ItemStack(BlocksTC.crystalAir), new ItemStack(BlocksTC.crystalFire), new ItemStack(BlocksTC.crystalWater), new ItemStack(BlocksTC.crystalEarth), new ItemStack(BlocksTC.crystalOrder), new ItemStack(BlocksTC.crystalEntropy)}));
        ConfigResearch.recipes.put("LampGrowth", ThaumcraftApi.addInfusionCraftingRecipe("LAMPGROWTH", (Object)new ItemStack(BlocksTC.lampGrowth), 4, new AspectList().add(Aspect.PLANT, 16).add(Aspect.LIGHT, 8).add(Aspect.LIFE, 8).add(Aspect.TOOL, 8), (Object)new ItemStack(BlocksTC.lampArcane), new Object[]{new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151100_aR, 1, 15), "shardEarth", new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151100_aR, 1, 15), "shardEarth"}));
        ConfigResearch.recipes.put("LampFertility", ThaumcraftApi.addInfusionCraftingRecipe("LAMPFERTILITY", (Object)new ItemStack(BlocksTC.lampFertility), 4, new AspectList().add(Aspect.BEAST, 16).add(Aspect.LIGHT, 8).add(Aspect.LIFE, 8).add(Aspect.DESIRE, 8), (Object)new ItemStack(BlocksTC.lampArcane), new Object[]{new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151015_O), "shardFire", new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151172_bF), "shardFire"}));
        ConfigResearch.recipes.put("ThaumiumFortressHelm", ThaumcraftApi.addInfusionCraftingRecipe("ARMORFORTRESS", (Object)new ItemStack(ItemsTC.fortressHelm), 3, new AspectList().add(Aspect.METAL, 24).add(Aspect.PROTECT, 16).add(Aspect.ENERGY, 16), (Object)new ItemStack(ItemsTC.thaumiumHelm), new Object[]{"plateThaumium", "plateThaumium", new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151166_bC)}));
        ConfigResearch.recipes.put("ThaumiumFortressChest", ThaumcraftApi.addInfusionCraftingRecipe("ARMORFORTRESS", (Object)new ItemStack(ItemsTC.fortressChest), 3, new AspectList().add(Aspect.METAL, 24).add(Aspect.PROTECT, 24).add(Aspect.ENERGY, 16), (Object)new ItemStack(ItemsTC.thaumiumChest), new Object[]{"plateThaumium", "plateThaumium", "plateThaumium", "plateThaumium", new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151116_aA)}));
        ConfigResearch.recipes.put("ThaumiumFortressLegs", ThaumcraftApi.addInfusionCraftingRecipe("ARMORFORTRESS", (Object)new ItemStack(ItemsTC.fortressLegs), 3, new AspectList().add(Aspect.METAL, 24).add(Aspect.PROTECT, 20).add(Aspect.ENERGY, 16), (Object)new ItemStack(ItemsTC.thaumiumLegs), new Object[]{"plateThaumium", "plateThaumium", "plateThaumium", new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151116_aA)}));
        ConfigResearch.recipes.put("VoidRobeHelm", ThaumcraftApi.addInfusionCraftingRecipe("ARMORVOIDFORTRESS", (Object)new ItemStack(ItemsTC.voidRobeHelm), 6, new AspectList().add(Aspect.METAL, 16).add(Aspect.SENSES, 16).add(Aspect.PROTECT, 16).add(Aspect.ENERGY, 16).add(Aspect.ELDRITCH, 16).add(Aspect.VOID, 16), (Object)new ItemStack(ItemsTC.voidHelm), new Object[]{new ItemStack(ItemsTC.goggles), new ItemStack(ItemsTC.fabric), new ItemStack(ItemsTC.fabric), new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.fabric), new ItemStack(ItemsTC.fabric)}));
        ConfigResearch.recipes.put("VoidRobeChest", ThaumcraftApi.addInfusionCraftingRecipe("ARMORVOIDFORTRESS", (Object)new ItemStack(ItemsTC.voidRobeChest), 6, new AspectList().add(Aspect.METAL, 24).add(Aspect.PROTECT, 24).add(Aspect.ENERGY, 16).add(Aspect.ELDRITCH, 16).add(Aspect.VOID, 24), (Object)new ItemStack(ItemsTC.voidChest), new Object[]{new ItemStack(ItemsTC.clothChest), "plateVoid", "plateVoid", new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.fabric), new ItemStack(Items.field_151116_aA)}));
        ConfigResearch.recipes.put("VoidRobeLegs", ThaumcraftApi.addInfusionCraftingRecipe("ARMORVOIDFORTRESS", (Object)new ItemStack(ItemsTC.voidRobeLegs), 6, new AspectList().add(Aspect.METAL, 20).add(Aspect.PROTECT, 20).add(Aspect.ENERGY, 16).add(Aspect.ELDRITCH, 16).add(Aspect.VOID, 20), (Object)new ItemStack(ItemsTC.voidLegs), new Object[]{new ItemStack(ItemsTC.clothLegs), "plateVoid", "plateVoid", new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.fabric), new ItemStack(Items.field_151116_aA)}));
        ConfigResearch.recipes.put("HelmGoggles", ThaumcraftApi.addInfusionCraftingRecipe("HELMGOGGLES", (Object)new Object[]{"goggles", new NBTTagByte(1)}, 5, new AspectList().add(Aspect.SENSES, 32).add(Aspect.AURA, 16).add(Aspect.PROTECT, 16), (Object)new ItemStack(ItemsTC.fortressHelm, 1, Short.MAX_VALUE), new Object[]{new ItemStack(Items.field_151123_aH), new ItemStack(ItemsTC.goggles, 1, Short.MAX_VALUE)}));
        ConfigResearch.recipes.put("MaskGrinningDevil", ThaumcraftApi.addInfusionCraftingRecipe("MASKGRINNINGDEVIL", (Object)new Object[]{"mask", new NBTTagInt(0)}, 8, new AspectList().add(Aspect.MIND, 64).add(Aspect.LIFE, 64).add(Aspect.PROTECT, 16), (Object)new ItemStack(ItemsTC.fortressHelm, 1, Short.MAX_VALUE), new Object[]{new ItemStack(Items.field_151100_aR, 1, 0), "ingotIron", new ItemStack(Items.field_151116_aA), new ItemStack(BlocksTC.shimmerleaf), new ItemStack(ItemsTC.brain), "ingotIron"}));
        ConfigResearch.recipes.put("MaskAngryGhost", ThaumcraftApi.addInfusionCraftingRecipe("MASKANGRYGHOST", (Object)new Object[]{"mask", new NBTTagInt(1)}, 8, new AspectList().add(Aspect.ENTROPY, 64).add(Aspect.DEATH, 64).add(Aspect.PROTECT, 16), (Object)new ItemStack(ItemsTC.fortressHelm, 1, Short.MAX_VALUE), new Object[]{new ItemStack(Items.field_151100_aR, 1, 15), "ingotIron", new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151170_bI), new ItemStack(Items.field_151144_bL, 1, 1), "ingotIron"}));
        ConfigResearch.recipes.put("MaskSippingFiend", ThaumcraftApi.addInfusionCraftingRecipe("MASKSIPPINGFIEND", (Object)new Object[]{"mask", new NBTTagInt(2)}, 8, new AspectList().add(Aspect.UNDEAD, 64).add(Aspect.LIFE, 64).add(Aspect.PROTECT, 16), (Object)new ItemStack(ItemsTC.fortressHelm, 1, Short.MAX_VALUE), new Object[]{new ItemStack(Items.field_151100_aR, 1, 1), "ingotIron", new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151073_bk), new ItemStack(Items.field_151117_aB), "ingotIron"}));
        ConfigResearch.recipes.put("SanityCheck", ThaumcraftApi.addInfusionCraftingRecipe("SANITYCHECK", (Object)new ItemStack(ItemsTC.sanityChecker), 4, new AspectList().add(Aspect.MIND, 24).add(Aspect.SENSES, 24).add(Aspect.ELDRITCH, 8), (Object)new ItemStack(ItemsTC.thaumometer, 1, Short.MAX_VALUE), (Object[])new ItemStack[]{new ItemStack(ItemsTC.mirroredGlass), new ItemStack(ItemsTC.brain), new ItemStack(ItemsTC.morphicResonator)}));
        ConfigResearch.recipes.put("SinStone", ThaumcraftApi.addInfusionCraftingRecipe("SINSTONE", (Object)new ItemStack(ItemsTC.sinisterStone), 5, new AspectList().add(Aspect.SENSES, 8).add(Aspect.DARKNESS, 8).add(Aspect.ELDRITCH, 8).add(Aspect.AURA, 8), (Object)new ItemStack(Items.field_151145_ak), new Object[]{"nitor", "shardOrder", new ItemStack(ItemsTC.knowledgeFragment), "shardEntropy"}));
        ItemStack isPC = new ItemStack(ItemsTC.primalCrusher);
        EnumInfusionEnchantment.addInfusionEnchantment(isPC, EnumInfusionEnchantment.DESTRUCTIVE, 1);
        EnumInfusionEnchantment.addInfusionEnchantment(isPC, EnumInfusionEnchantment.REFINING, 1);
        ConfigResearch.recipes.put("PrimalCrusher", ThaumcraftApi.addInfusionCraftingRecipe("PRIMALCRUSHER", (Object)isPC, 6, new AspectList().add(Aspect.EARTH, 24).add(Aspect.TOOL, 24).add(Aspect.ENTROPY, 16).add(Aspect.VOID, 16).add(Aspect.AVERSION, 16).add(Aspect.ELDRITCH, 16).add(Aspect.DESIRE, 16), (Object)new ItemStack(ItemsTC.primordialPearl), (Object[])new ItemStack[]{new ItemStack(ItemsTC.primalCharm), new ItemStack(ItemsTC.voidPick, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.voidShovel, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.primalCharm), new ItemStack(ItemsTC.elementalPick, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.elementalShovel, 1, Short.MAX_VALUE)}));
        ConfigResearch.recipes.put("EldritchEye", ThaumcraftApi.addInfusionCraftingRecipe("OCULUS", (Object)new ItemStack(ItemsTC.eldritchEye), 5, new AspectList().add(Aspect.ELDRITCH, 64).add(Aspect.VOID, 16).add(Aspect.DARKNESS, 16).add(Aspect.MOTION, 16), (Object)new ItemStack(Items.field_151061_bv), (Object[])new ItemStack[]{new ItemStack(ItemsTC.voidSeed), new ItemStack(Items.field_151043_k)}));
        ConfigResearch.recipes.put("VerdantHeart", ThaumcraftApi.addInfusionCraftingRecipe("VERDANTHEART", (Object)new ItemStack(ItemsTC.ringVerdant), 5, new AspectList().add(Aspect.LIFE, 48).add(Aspect.ORDER, 24).add(Aspect.PLANT, 48), (Object)new ItemStack(ItemsTC.baubles, 1, 10), new Object[]{new ItemStack(ItemsTC.primordialPearl), Utils.makeShard(Aspect.LIFE), new ItemStack(Items.field_151117_aB), Utils.makeShard(Aspect.PLANT)}));
        ConfigResearch.recipes.put("VerdantHeartLife", ThaumcraftApi.addInfusionCraftingRecipe("VERDANTHEARTLIFE", (Object)new Object[]{"type", new NBTTagByte(1)}, 5, new AspectList().add(Aspect.LIFE, 64).add(Aspect.MAN, 64), (Object)new ItemStack(ItemsTC.ringVerdant, 1, Short.MAX_VALUE), new Object[]{new ItemStack(Items.field_151153_ao), Utils.makeShard(Aspect.LIFE), new ItemStack((Item)Items.field_151068_bn, 1, 8193), Utils.makeShard(Aspect.MAN)}));
        ConfigResearch.recipes.put("VerdantHeartSustain", ThaumcraftApi.addInfusionCraftingRecipe("VERDANTHEARTLIFE", (Object)new Object[]{"type", new NBTTagByte(2)}, 5, new AspectList().add(Aspect.DESIRE, 64).add(Aspect.AIR, 64), (Object)new ItemStack(ItemsTC.ringVerdant, 1, Short.MAX_VALUE), new Object[]{new ItemStack(ItemsTC.tripleMeatTreat), Utils.makeShard(Aspect.DESIRE), new ItemStack((Item)Items.field_151068_bn, 1, 8237), Utils.makeShard(Aspect.AIR)}));
    }

    private static void initializeNormalRecipes() {
        GameRegistry.addRecipe((IRecipe)new RecipesRobeArmorDyes());
        GameRegistry.addRecipe((IRecipe)new RecipesVoidRobeArmorDyes());
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 0), new Object[]{"#", Character.valueOf('#'), Items.field_151042_j});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 6), new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 0)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 7), new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 1)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 8), new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 2)});
        ConfigRecipes.oreDictRecipe(new ItemStack(Items.field_151042_j), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetIron"});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.ingots, 1, 0), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetThaumium"});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.ingots, 1, 1), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetVoid"});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.ingots, 1, 2), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetBrass"});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.quicksilver), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetQuicksilver"});
        ConfigRecipes.oreDictRecipe(new ItemStack(Items.field_151043_k), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.coin)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 5), new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.quicksilver)});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.metal, 1, 0), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 0)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.ingots, 9, 0), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.metal, 1, 0)});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.metal, 1, 1), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 1)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.ingots, 9, 1), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.metal, 1, 1)});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.metal, 1, 4), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 2)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.ingots, 9, 2), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.metal, 1, 4)});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.fleshBlock), new Object[]{"###", "###", "###", Character.valueOf('#'), Items.field_151078_bh});
        ConfigRecipes.oreDictRecipe(new ItemStack(Items.field_151078_bh, 9, 0), new Object[]{"#", Character.valueOf('#'), BlocksTC.fleshBlock});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.translucent, 1, 0), new Object[]{"###", "###", "###", Character.valueOf('#'), "gemAmber"});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.translucent, 4, 1), new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(BlocksTC.translucent, 1, 0)});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.translucent, 4, 0), new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(BlocksTC.translucent, 1, 1)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.amber, 9, 0), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.translucent, 1, 0)});
        ConfigResearch.recipes.put("BrassPlate", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.plate, 3, 0), new Object[]{"BBB", Character.valueOf('B'), "ingotBrass"}));
        ConfigResearch.recipes.put("BrassGear", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.gear, 1, 0), new Object[]{"BBB", "BIB", "BBB", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "nuggetBrass"}));
        ConfigResearch.recipes.put("IronPlate", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.plate, 3, 1), new Object[]{"BBB", Character.valueOf('B'), "ingotIron"}));
        ConfigResearch.recipes.put("ThaumiumPlate", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.plate, 3, 2), new Object[]{"BBB", Character.valueOf('B'), "ingotThaumium"}));
        ConfigResearch.recipes.put("ThaumiumGear", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.gear, 1, 1), new Object[]{"BBB", "BIB", "BBB", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "nuggetThaumium"}));
        ConfigResearch.recipes.put("VoidPlate", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.plate, 3, 3), new Object[]{"BBB", Character.valueOf('B'), "ingotVoid"}));
        ConfigResearch.recipes.put("VoidGear", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.gear, 1, 2), new Object[]{"BBB", "BIB", "BBB", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "nuggetVoid"}));
        ConfigResearch.recipes.put("MundaneAmulet", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.baubles, 1, 0), new Object[]{" S ", "S S", " I ", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('I'), "ingotBrass"}));
        ConfigResearch.recipes.put("MundaneRing", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.baubles, 1, 1), new Object[]{"NNN", "N N", "NNN", Character.valueOf('N'), "nuggetBrass"}));
        ConfigResearch.recipes.put("MundaneBelt", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.baubles, 1, 2), new Object[]{" L ", "L L", " I ", Character.valueOf('L'), new ItemStack(Items.field_151116_aA), Character.valueOf('I'), "ingotBrass"}));
        ConfigResearch.recipes.put("FancyAmulet", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.baubles, 1, 9), new Object[]{" S ", "SGS", " I ", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('G'), new ItemStack(Items.field_151045_i), Character.valueOf('I'), "ingotGold"}));
        ConfigResearch.recipes.put("FancyRing", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.baubles, 1, 10), new Object[]{"NGN", "N N", "NNN", Character.valueOf('G'), new ItemStack(Items.field_151045_i), Character.valueOf('N'), "nuggetGold"}));
        ConfigResearch.recipes.put("FancyBelt", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.baubles, 1, 11), new Object[]{" L ", "LGL", " I ", Character.valueOf('L'), new ItemStack(Items.field_151116_aA), Character.valueOf('G'), new ItemStack(Items.field_151045_i), Character.valueOf('I'), "ingotGold"}));
        CraftingManager.func_77594_a().func_180302_a((IRecipe)new RecipeTripleMeatTreat());
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.quicksilver), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.shimmerleaf)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(Items.field_151065_br), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.cinderpearl)});
        ConfigResearch.recipes.put("JarLabel", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ItemsTC.label, 4, 0), new Object[]{"dyeBlack", "slimeball", Items.field_151121_aF, Items.field_151121_aF, Items.field_151121_aF, Items.field_151121_aF}));
        int count = 0;
        for (Aspect aspect : Aspect.aspects.values()) {
            ItemStack essence = new ItemStack(ItemsTC.phial, 1, 1);
            ((IEssentiaContainerItem)essence.func_77973_b()).setAspects(essence, new AspectList().add(aspect, 8));
            ItemStack output = new ItemStack(ItemsTC.label, 1, 1);
            ((IEssentiaContainerItem)output.func_77973_b()).setAspects(output, new AspectList().add(aspect, 1));
            ConfigResearch.recipes.put("JarLabel" + count, ConfigRecipes.shapelessNBTOreRecipe(output, new Object[]{new ItemStack(ItemsTC.label), essence}));
            ++count;
        }
        ConfigResearch.recipes.put("JarLabelNull", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ItemsTC.label), new Object[]{new ItemStack(ItemsTC.label, 1, 1)}));
        ConfigResearch.recipes.put("WandBasic", ConfigRecipes.oreDictRecipe(basicWand, new Object[]{"  I", " S ", "I  ", Character.valueOf('I'), new ItemStack(ItemsTC.wandCaps, 1, 0), Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("WandCapIron", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.wandCaps, 1, 0), new Object[]{"NNN", "N N", Character.valueOf('N'), "nuggetIron"}));
        ConfigResearch.recipes.put("PlankGreatwood", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.plank, 4, 0), (Object[])new Object[]{"W", Character.valueOf('W'), new ItemStack(BlocksTC.log, 1, 0)}));
        ConfigResearch.recipes.put("PlankSilverwood", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.plank, 4, 1), (Object[])new Object[]{"W", Character.valueOf('W'), new ItemStack(BlocksTC.log, 1, 3)}));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stairsGreatwood, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.plank, 1, 0)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stairsSilverwood, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.plank, 1, 1)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stairsArcane, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stone, 1, 0)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stairsArcaneBrick, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stone, 1, 1)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stairsAncient, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stone, 1, 2)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabWood, 6, 0), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.plank, 1, 0)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabWood, 6, 1), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.plank, 1, 1)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabStone, 6, 0), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stone, 1, 0)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabStone, 6, 1), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stone, 1, 1)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabStone, 6, 2), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stone, 1, 2)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabStone, 6, 3), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stone, 1, 4)});
        ConfigResearch.recipes.put("Phial", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.phial, 8, 0), new Object[]{" C ", "G G", " G ", Character.valueOf('G'), "blockGlass", Character.valueOf('C'), Items.field_151119_aD}));
        ConfigResearch.recipes.put("TableWood", ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.tableWood), new Object[]{"SSS", "W W", Character.valueOf('S'), "slabWood", Character.valueOf('W'), "plankWood"}));
        ConfigResearch.recipes.put("TableStone", ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.tableStone), new Object[]{"SSS", "W W", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U), Character.valueOf('W'), "stone"}));
        ConfigResearch.recipes.put("Scribe1", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ItemsTC.scribingTools), new Object[]{new ItemStack(ItemsTC.phial, 1, 0), Items.field_151008_G, "dyeBlack"}));
        ConfigResearch.recipes.put("Scribe2", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ItemsTC.scribingTools), new Object[]{Items.field_151069_bo, Items.field_151008_G, "dyeBlack"}));
        ConfigResearch.recipes.put("Scribe3", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ItemsTC.scribingTools), new Object[]{new ItemStack(ItemsTC.scribingTools, 1, Short.MAX_VALUE), "dyeBlack"}));
        ConfigResearch.recipes.put("Thaumometer", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumometer), new Object[]{" 1 ", "IGI", " 1 ", Character.valueOf('I'), Items.field_151043_k, Character.valueOf('G'), new ItemStack(Blocks.field_150359_w), Character.valueOf('1'), new ItemStack(ItemsTC.shard, 1, Short.MAX_VALUE)}));
        ConfigResearch.recipes.put("ThaumiumHelm", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumHelm, 1), new Object[]{"III", "I I", Character.valueOf('I'), "ingotThaumium"}));
        ConfigResearch.recipes.put("ThaumiumChest", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumChest, 1), new Object[]{"I I", "III", "III", Character.valueOf('I'), "ingotThaumium"}));
        ConfigResearch.recipes.put("ThaumiumLegs", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumLegs, 1), new Object[]{"III", "I I", "I I", Character.valueOf('I'), "ingotThaumium"}));
        ConfigResearch.recipes.put("ThaumiumBoots", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumBoots, 1), new Object[]{"I I", "I I", Character.valueOf('I'), "ingotThaumium"}));
        ConfigResearch.recipes.put("ThaumiumShovel", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumShovel, 1), new Object[]{"I", "S", "S", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("ThaumiumPick", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumPick, 1), new Object[]{"III", " S ", " S ", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("ThaumiumAxe", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumAxe, 1), new Object[]{"II", "SI", "S ", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("ThaumiumHoe", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumHoe, 1), new Object[]{"II", "S ", "S ", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("ThaumiumSword", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumSword, 1), new Object[]{"I", "I", "S", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("VoidHelm", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidHelm, 1), new Object[]{"III", "I I", Character.valueOf('I'), "ingotVoid"}));
        ConfigResearch.recipes.put("VoidChest", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidChest, 1), new Object[]{"I I", "III", "III", Character.valueOf('I'), "ingotVoid"}));
        ConfigResearch.recipes.put("VoidLegs", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidLegs, 1), new Object[]{"III", "I I", "I I", Character.valueOf('I'), "ingotVoid"}));
        ConfigResearch.recipes.put("VoidBoots", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidBoots, 1), new Object[]{"I I", "I I", Character.valueOf('I'), "ingotVoid"}));
        ConfigResearch.recipes.put("VoidShovel", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidShovel, 1), new Object[]{"I", "S", "S", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("VoidPick", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidPick, 1), new Object[]{"III", " S ", " S ", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("VoidAxe", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidAxe, 1), new Object[]{"II", "SI", "S ", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("VoidHoe", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidHoe, 1), new Object[]{"II", "S ", "S ", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("VoidSword", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidSword, 1), new Object[]{"I", "I", "S", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("TallowCandle", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.candle, 3, 0), (Object[])new Object[]{" S ", " T ", " T ", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('T'), new ItemStack(ItemsTC.tallow)}));
        for (int a = 1; a < 16; ++a) {
            ConfigRecipes.shapelessOreDictRecipe(new ItemStack(BlocksTC.candle, 1, a), new Object[]{ConfigAspects.dyes[15 - a], new ItemStack(BlocksTC.candle, 1, 0)});
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BlocksTC.candle, 1, 0), (Object[])new Object[]{new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack(BlocksTC.candle, 1, Short.MAX_VALUE)});
        ConfigResearch.recipes.put("BrassBrace", ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.jarBrace, 2), new Object[]{"NSN", "S S", "NSN", Character.valueOf('N'), "nuggetBrass", Character.valueOf('S'), "stickWood"}));
    }

    private static void initializeSmelting() {
        GameRegistry.addSmelting((Block)BlocksTC.oreCinnabar, (ItemStack)new ItemStack(ItemsTC.quicksilver), (float)1.0f);
        GameRegistry.addSmelting((Block)BlocksTC.oreAmber, (ItemStack)new ItemStack(ItemsTC.amber), (float)1.0f);
        GameRegistry.addSmelting((Block)BlocksTC.log, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.5f);
        GameRegistry.addSmelting((Item)ItemsTC.coin, (ItemStack)new ItemStack(Items.field_151074_bl), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTC.clusters, 1, 0), (ItemStack)new ItemStack(Items.field_151042_j, 2, 0), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTC.clusters, 1, 1), (ItemStack)new ItemStack(Items.field_151043_k, 2, 0), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTC.clusters, 1, 6), (ItemStack)new ItemStack(ItemsTC.quicksilver, 2, 0), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTC.shard, 1, 7), (ItemStack)new ItemStack(ItemsTC.salisMundus), (float)1.0f);
        ThaumcraftApi.addSmeltingBonus("oreGold", new ItemStack(Items.field_151074_bl, 0, 0));
        ThaumcraftApi.addSmeltingBonus("oreIron", new ItemStack(ItemsTC.nuggets, 0, 0));
        ThaumcraftApi.addSmeltingBonus("oreCinnabar", new ItemStack(ItemsTC.nuggets, 0, 5));
        ThaumcraftApi.addSmeltingBonus("oreCopper", new ItemStack(ItemsTC.nuggets, 0, 1));
        ThaumcraftApi.addSmeltingBonus("oreTin", new ItemStack(ItemsTC.nuggets, 0, 2));
        ThaumcraftApi.addSmeltingBonus("oreSilver", new ItemStack(ItemsTC.nuggets, 0, 3));
        ThaumcraftApi.addSmeltingBonus("oreLead", new ItemStack(ItemsTC.nuggets, 0, 4));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 0), new ItemStack(ItemsTC.nuggets, 0, 0));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 1), new ItemStack(Items.field_151074_bl, 0, 0));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 6), new ItemStack(ItemsTC.nuggets, 0, 5));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 2), new ItemStack(ItemsTC.nuggets, 0, 1));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 3), new ItemStack(ItemsTC.nuggets, 0, 2));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 4), new ItemStack(ItemsTC.nuggets, 0, 3));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 5), new ItemStack(ItemsTC.nuggets, 0, 4));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_151082_bd), new ItemStack(ItemsTC.chunks, 0, 0));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_151076_bf), new ItemStack(ItemsTC.chunks, 0, 1));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_151147_al), new ItemStack(ItemsTC.chunks, 0, 2));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.chunks, 0, 3));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_179558_bo), new ItemStack(ItemsTC.chunks, 0, 4));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_179561_bm), new ItemStack(ItemsTC.chunks, 0, 5));
    }

    static IRecipe oreDictRecipe(ItemStack res, Object[] params) {
        ShapedOreRecipe rec = new ShapedOreRecipe(res, params);
        CraftingManager.func_77594_a().func_77592_b().add(rec);
        return rec;
    }

    static IRecipe shapelessOreDictRecipe(ItemStack res, Object[] params) {
        ShapelessOreRecipe rec = new ShapelessOreRecipe(res, params);
        CraftingManager.func_77594_a().func_77592_b().add(rec);
        return rec;
    }

    static IRecipe shapelessNBTOreRecipe(ItemStack res, Object[] params) {
        ShapelessNBTOreRecipe rec = new ShapelessNBTOreRecipe(res, params);
        CraftingManager.func_77594_a().func_77592_b().add(rec);
        return rec;
    }
}

