/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.world.taint;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTC;
import thaumcraft.common.blocks.IBlockFacing;
import thaumcraft.common.blocks.world.taint.BlockTaintFibre;
import thaumcraft.common.blocks.world.taint.BlockTaintLog;
import thaumcraft.common.blocks.world.taint.ITaintBlock;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.monster.tainted.EntityTaintCrawler;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.lib.utils.Utils;

public class BlockTaintFeature
extends BlockTC
implements ITaintBlock {
    public BlockTaintFeature() {
        super(ThaumcraftMaterials.MATERIAL_TAINT);
        this.func_149711_c(0.1f);
        this.func_149715_a(0.625f);
        IBlockState bs = this.field_176227_L.func_177621_b();
        bs.func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)EnumFacing.UP);
        this.func_180632_j(bs);
        this.func_149675_a(true);
        this.func_149647_a(Thaumcraft.tabTC);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            if (worldIn.field_73012_v.nextFloat() < 0.333f) {
                EntityTaintCrawler e = new EntityTaintCrawler(worldIn);
                e.func_70012_b((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, worldIn.field_73012_v.nextInt(360), 0.0f);
                worldIn.func_72838_d((Entity)e);
            } else {
                AuraHelper.pollute(worldIn, pos, 1, true);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public void die(World world, BlockPos pos, IBlockState blockState) {
        world.func_175656_a(pos, BlocksTC.taintDust.func_176223_P().func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(2))));
        Utils.resetBiomeAt(world, pos, world.field_73012_v.nextInt(25) == 0);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K) {
            if (AuraHelper.getAura(world, pos, Aspect.FLUX) < Config.AURABASE / 25 && random.nextInt(10) == 0) {
                this.die(world, pos, state);
                return;
            }
            if (AuraHelper.getAura(world, pos, Aspect.FLUX) <= Config.AURABASE / 5 && random.nextInt(200) == 0) {
                AuraHelper.pollute(world, pos, 1, true);
                return;
            }
            BlockTaintFibre.spreadFibres(world, pos);
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == BlocksTC.taintLog && world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)BlockTaintLog.AXIS) == EnumFacing.Axis.Y && world.field_73012_v.nextInt(100) == 0) {
                if (world.field_73012_v.nextFloat() < Config.taintSpreadRate * 5.0f) {
                    AuraHelper.drainAura(world, pos, Aspect.FLUX, 1);
                }
                world.func_175656_a(pos, BlocksTC.taintBlock.func_176203_a(2));
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemsTC.tainted;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public int func_176207_c(IBlockAccess worldIn, BlockPos pos) {
        return 200;
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (!worldIn.field_72995_K && !worldIn.func_180495_p(pos.func_177972_a(BlockStateUtils.getFacing(state).func_176734_d())).func_177230_c().func_176212_b((IBlockAccess)worldIn, pos.func_177972_a(BlockStateUtils.getFacing(state).func_176734_d()), BlockStateUtils.getFacing(state))) {
            BlockTaintFeature.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ItemsTC.tainted));
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState bs = this.func_176223_P();
        bs = bs.func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)facing);
        return bs;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState bs = this.func_176223_P();
        bs = bs.func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)BlockStateUtils.getFacing(meta));
        return bs;
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((EnumFacing)state.func_177229_b((IProperty)IBlockFacing.FACING)).func_176745_a();
        return i;
    }

    protected BlockState func_180661_e() {
        ArrayList<PropertyDirection> ip = new ArrayList<PropertyDirection>();
        ip.add(IBlockFacing.FACING);
        return new BlockState((Block)this, ip.toArray(new IProperty[ip.size()]));
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = BlockStateUtils.getFacing(this.func_176201_c(worldIn.func_180495_p(pos)));
        switch (facing.ordinal()) {
            case 0: {
                this.func_149676_a(0.125f, 0.625f, 0.125f, 0.875f, 1.0f, 0.875f);
                break;
            }
            case 1: {
                this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 0.375f, 0.875f);
                break;
            }
            case 2: {
                this.func_149676_a(0.125f, 0.125f, 0.625f, 0.875f, 0.875f, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(0.125f, 0.125f, 0.0f, 0.875f, 0.875f, 0.375f);
                break;
            }
            case 4: {
                this.func_149676_a(0.625f, 0.125f, 0.125f, 1.0f, 0.875f, 0.875f);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, 0.125f, 0.125f, 0.375f, 0.875f, 0.875f);
            }
        }
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
    }
}

