/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.world.ore;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchHelper;
import thaumcraft.api.wands.IWandable;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.resources.ItemShard;
import thaumcraft.common.lib.CustomSoundType;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.utils.BlockUtils;

public class BlockCrystal
extends Block
implements IWandable {
    public static final PropertyInteger SIZE = PropertyInteger.func_177719_a((String)"size", (int)0, (int)3);
    public static final PropertyInteger GENERATION = PropertyInteger.func_177719_a((String)"gen", (int)1, (int)4);
    public static final IUnlistedProperty<Boolean> NORTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"north"));
    public static final IUnlistedProperty<Boolean> EAST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"east"));
    public static final IUnlistedProperty<Boolean> SOUTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"south"));
    public static final IUnlistedProperty<Boolean> WEST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"west"));
    public static final IUnlistedProperty<Boolean> UP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"up"));
    public static final IUnlistedProperty<Boolean> DOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"down"));
    public static final IUnlistedProperty<Integer> SEED = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"seed", (int)0, (int)7));
    protected Aspect aspect;

    public BlockCrystal(Aspect aspect) {
        super(Material.field_151592_s);
        this.aspect = aspect;
        this.func_149711_c(0.25f);
        this.func_149672_a(new CustomSoundType("crystal", 1.0f, 1.0f));
        this.func_149675_a(true);
        this.func_149647_a(Thaumcraft.tabTC);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)GENERATION, (Comparable)Integer.valueOf(1)));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150899_d((int)0);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int md = ItemShard.ShardType.getMetaByAspect(this.aspect);
        int count = this.getGrowth(state) + 1;
        for (int i = 0; i < count; ++i) {
            ret.add(new ItemStack(ItemsTC.shard, 1, md));
        }
        return ret;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && rand.nextInt(3 + this.getGeneration(state)) == 0) {
            int growth = this.getGrowth(state);
            int generation = this.getGeneration(state);
            if ((float)AuraHandler.getAuraCurrent(worldIn, pos, this.aspect) < (float)AuraHandler.getAuraBase(worldIn, pos) / 8.0f) {
                if (growth > 0) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(growth - 1)));
                    AuraHandler.addRechargeTicket(worldIn, pos, this.aspect, Config.AURABASE / 9);
                } else if (BlockUtils.isBlockTouching((IBlockAccess)worldIn, pos, this)) {
                    worldIn.func_175698_g(pos);
                    AuraHandler.addRechargeTicket(worldIn, pos, this.aspect, Config.AURABASE / 9);
                    AuraHandler.addRechargeTicket(worldIn, pos, Aspect.FLUX, 1);
                }
            } else if (AuraHandler.getAuraCurrent(worldIn, pos, this.aspect) >= AuraHandler.getAuraBase(worldIn, pos) + Config.AURABASE / 16) {
                BlockPos p2;
                if (growth < 3 && (long)growth < (long)(5 - generation) + pos.func_177986_g() % 3L) {
                    if (AuraHandler.drainAura(worldIn, pos, this.aspect, Config.AURABASE / 8)) {
                        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(growth + 1)));
                    }
                } else if (generation < 4 && (p2 = BlockCrystal.spreadCrystal(worldIn, pos)) != null && AuraHandler.drainAura(worldIn, pos, this.aspect, Config.AURABASE / 8)) {
                    if (rand.nextInt(8) == 0) {
                        --generation;
                    }
                    worldIn.func_175656_a(p2, this.func_176223_P().func_177226_a((IProperty)GENERATION, (Comparable)Integer.valueOf(generation + 1)));
                }
            } else if (this.aspect != Aspect.FLUX && AuraHandler.getAuraCurrent(worldIn, pos, Aspect.FLUX) > AuraHandler.getAuraCurrent(worldIn, pos, this.aspect) && AuraHandler.getAuraCurrent(worldIn, pos, Aspect.FLUX) > AuraHandler.getAuraBase(worldIn, pos) / 2 && AuraHandler.drainAura(worldIn, pos, Aspect.FLUX, growth + 1)) {
                worldIn.func_175656_a(pos, BlocksTC.crystalTaint.func_176203_a(this.func_176201_c(state)));
            }
        }
    }

    public static BlockPos spreadCrystal(World world, BlockPos pos) {
        int zz;
        int yy;
        int xx = pos.func_177958_n() + world.field_73012_v.nextInt(3) - 1;
        BlockPos t = new BlockPos(xx, yy = pos.func_177956_o() + world.field_73012_v.nextInt(3) - 1, zz = pos.func_177952_p() + world.field_73012_v.nextInt(3) - 1);
        if (t.equals((Object)pos)) {
            return null;
        }
        IBlockState bs = world.func_180495_p(t);
        Material bm = bs.func_177230_c().func_149688_o();
        if (!bm.func_76224_d() && (world.func_175623_d(t) || bs.func_177230_c().func_176200_f(world, t)) && world.field_73012_v.nextInt(16) == 0 && BlockUtils.isBlockTouching((IBlockAccess)world, t, Material.field_151576_e, true)) {
            return t;
        }
        return null;
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (!BlockUtils.isBlockTouching((IBlockAccess)worldIn, pos, Material.field_151576_e, true)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        super.func_176204_a(worldIn, pos, state, neighborBlock);
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing o) {
        return false;
    }

    private boolean drawAt(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        Block b = worldIn.func_180495_p(pos).func_177230_c();
        return b.func_149688_o() == Material.field_151576_e && b.isSideSolid(worldIn, pos, side.func_176734_d());
    }

    public void func_180654_a(IBlockAccess iblockaccess, BlockPos pos) {
        IBlockState state = this.getExtendedState(iblockaccess.func_180495_p(pos), iblockaccess, pos);
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState es = (IExtendedBlockState)state;
            int c = 0;
            if (((Boolean)es.getValue(UP)).booleanValue()) {
                ++c;
            }
            if (((Boolean)es.getValue(DOWN)).booleanValue()) {
                ++c;
            }
            if (((Boolean)es.getValue(EAST)).booleanValue()) {
                ++c;
            }
            if (((Boolean)es.getValue(WEST)).booleanValue()) {
                ++c;
            }
            if (((Boolean)es.getValue(SOUTH)).booleanValue()) {
                ++c;
            }
            if (((Boolean)es.getValue(NORTH)).booleanValue()) {
                ++c;
            }
            if (c > 1) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else {
                if (((Boolean)es.getValue(UP)).booleanValue()) {
                    this.func_149676_a(0.125f, 0.5f, 0.125f, 0.875f, 1.0f, 0.875f);
                }
                if (((Boolean)es.getValue(DOWN)).booleanValue()) {
                    this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 0.5f, 0.875f);
                }
                if (((Boolean)es.getValue(EAST)).booleanValue()) {
                    this.func_149676_a(0.5f, 0.125f, 0.125f, 1.0f, 0.875f, 0.875f);
                }
                if (((Boolean)es.getValue(WEST)).booleanValue()) {
                    this.func_149676_a(0.0f, 0.125f, 0.125f, 0.5f, 0.875f, 0.875f);
                }
                if (((Boolean)es.getValue(SOUTH)).booleanValue()) {
                    this.func_149676_a(0.125f, 0.125f, 0.5f, 0.875f, 0.875f, 1.0f);
                }
                if (((Boolean)es.getValue(NORTH)).booleanValue()) {
                    this.func_149676_a(0.125f, 0.125f, 0.0f, 0.875f, 0.875f, 0.5f);
                }
            }
        }
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        IBlockState st = world.func_180495_p(pos);
        return 2 + (st.func_177230_c().func_176201_c(st) & 3) * 3;
    }

    public int func_176207_c(IBlockAccess worldIn, BlockPos pos) {
        IBlockState bs = worldIn.func_180495_p(pos);
        int i = worldIn.func_175626_b(pos, bs.func_177230_c().getLightValue(worldIn, pos));
        int j = 180;
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
    }

    public int func_180644_h(IBlockState state) {
        return this.aspect.getColor();
    }

    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        return this.aspect.getColor();
    }

    protected BlockState func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{SIZE, GENERATION};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{UP, DOWN, NORTH, EAST, WEST, SOUTH, SEED};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState retval = (IExtendedBlockState)state;
            return retval.withProperty(UP, (Object)this.drawAt(world, pos.func_177984_a(), EnumFacing.UP)).withProperty(DOWN, (Object)this.drawAt(world, pos.func_177977_b(), EnumFacing.DOWN)).withProperty(NORTH, (Object)this.drawAt(world, pos.func_177978_c(), EnumFacing.NORTH)).withProperty(EAST, (Object)this.drawAt(world, pos.func_177974_f(), EnumFacing.EAST)).withProperty(SOUTH, (Object)this.drawAt(world, pos.func_177968_d(), EnumFacing.SOUTH)).withProperty(WEST, (Object)this.drawAt(world, pos.func_177976_e(), EnumFacing.WEST)).withProperty(SEED, (Object)Math.abs(pos.hashCode() % 8));
        }
        return state;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(meta & 3)).func_177226_a((IProperty)GENERATION, (Comparable)Integer.valueOf(1 + (meta >> 2)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((Integer)state.func_177229_b((IProperty)SIZE)).intValue();
        return i |= (Integer)state.func_177229_b((IProperty)GENERATION) - 1 << 2;
    }

    public int getGrowth(IBlockState state) {
        return this.func_176201_c(state) & 3;
    }

    public int getGeneration(IBlockState state) {
        return 1 + (this.func_176201_c(state) >> 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        list.add(new ItemStack(itemIn, 1, 0));
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return BlockUtils.isBlockTouching((IBlockAccess)worldIn, pos, Material.field_151576_e, true) && super.func_176196_c(worldIn, pos);
    }

    @Override
    public boolean onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, BlockPos pos, EnumFacing side) {
        if (!world.field_72995_K && ResearchHelper.isResearchComplete(player.func_70005_c_(), "CRYSTALFARMER")) {
            IBlockState state = world.func_180495_p(pos);
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            int growth = this.getGrowth(state);
            if (growth > 0) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(growth - 1)));
            } else {
                world.func_175698_g(pos);
            }
            int md = ItemShard.ShardType.getMetaByAspect(this.aspect);
            player.func_146097_a(new ItemStack(ItemsTC.shard, 1, md), false, true);
            return true;
        }
        return false;
    }

    @Override
    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    @Override
    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }
}

