/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.basic;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.internal.WeightedRandomLoot;
import thaumcraft.api.items.ItemGenericEssentiaContainer;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTC;
import thaumcraft.common.config.Config;

public class BlockStoneTC
extends BlockTC {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", StoneType.class);
    private static int cc = 0;
    static Random r = new Random(System.currentTimeMillis());
    static ArrayList<WeightedRandomLoot> pdrops = null;

    public BlockStoneTC() {
        super(Material.field_151576_e);
        this.func_149647_a(Thaumcraft.tabTC);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)StoneType.ARCANE)));
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149769_e);
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return meta < StoneType.values().length ? this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)StoneType.values()[meta])) : this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
        return meta;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public IProperty[] getProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public String getStateName(IBlockState state, boolean fullName) {
        StoneType type = (StoneType)((Object)state.func_177229_b((IProperty)VARIANT));
        return type.func_176610_l() + (fullName ? "_stone" : "");
    }

    public boolean canCreatureSpawn(IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return super.canCreatureSpawn(world, pos, type);
        }
        return (StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.ANCIENT_ROCK || (StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.ANCIENT_DOORWAY || (StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.GLYPHED || (StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.BEDROCK || (StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.ANCIENT_TILE ? false : super.canCreatureSpawn(world, pos, type);
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return super.getLightValue(world, pos);
        }
        return (StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.CRUST_GLOW ? 9 : super.getLightValue(world, pos);
    }

    public float func_176195_g(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return super.func_176195_g(worldIn, pos);
        }
        return (StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.ANCIENT_ROCK ? 6.0f : ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.CRUST ? 1.0f : ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.POROUS ? 0.5f : ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.CRUST_GLOW ? 1.0f : ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.ELDRITCH ? 15.0f : ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.ANCIENT_DOORWAY ? -1.0f : ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.BEDROCK ? -1.0f : super.func_176195_g(worldIn, pos)))))));
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return super.getExplosionResistance(world, pos, exploder, explosion);
        }
        return (StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.ANCIENT_ROCK ? 20.0f : ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.CRUST ? 5.0f : ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.POROUS ? 5.0f : ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.CRUST_GLOW ? 5.0f : ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.ELDRITCH ? 1000.0f : super.getExplosionResistance(world, pos, exploder, explosion)))));
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (state.func_177230_c() == this && (StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.BEDROCK && this.isBlockExposed(worldIn, pos) && cc++ < 10) {
            worldIn.func_180501_a(pos, BlocksTC.vacuum.func_176223_P(), 2);
            worldIn.func_175684_a(pos, BlocksTC.vacuum, 1);
        }
        cc = 0;
    }

    private boolean isBlockExposed(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.values()) {
            if (!world.func_175623_d(pos.func_177972_a(face))) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177230_c() == this && (StoneType)((Object)state.func_177229_b((IProperty)VARIANT)) == StoneType.POROUS) {
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            int rr = r.nextInt(15) + fortune;
            if (rr > 13) {
                if (pdrops == null || pdrops.size() <= 0) {
                    this.createDrops();
                }
                ItemStack s = ((WeightedRandomLoot)WeightedRandom.func_76271_a((Random)BlockStoneTC.r, BlockStoneTC.pdrops)).item.func_77946_l();
                ret.add(s);
            } else {
                ret.add(new ItemStack(Blocks.field_150347_e));
            }
            return ret;
        }
        return super.getDrops(world, pos, state, fortune);
    }

    private void createDrops() {
        pdrops = new ArrayList();
        for (Aspect aspect : Aspect.getCompoundAspects()) {
            ItemStack is = new ItemStack(ItemsTC.crystalEssence);
            ((ItemGenericEssentiaContainer)ItemsTC.crystalEssence).setAspects(is, new AspectList().add(aspect, 1));
            pdrops.add(new WeightedRandomLoot(is, 1));
        }
        pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.shard, 1, 0), 20));
        pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.shard, 1, 1), 20));
        pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.shard, 1, 2), 20));
        pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.shard, 1, 3), 20));
        pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.shard, 1, 4), 20));
        pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.shard, 1, 5), 20));
        pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.shard, 1, 6), 100));
        pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.shard, 1, 7), 5));
        pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.amber), 20));
        pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.clusters, 1, 0), 20));
        pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.clusters, 1, 1), 10));
        pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.clusters, 1, 6), 10));
        if (Config.foundCopperIngot) {
            pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.clusters, 1, 2), 10));
        }
        if (Config.foundTinIngot) {
            pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.clusters, 1, 3), 10));
        }
        if (Config.foundSilverIngot) {
            pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.clusters, 1, 4), 8));
        }
        if (Config.foundLeadIngot) {
            pdrops.add(new WeightedRandomLoot(new ItemStack(ItemsTC.clusters, 1, 5), 10));
        }
        pdrops.add(new WeightedRandomLoot(new ItemStack(Items.field_151045_i), 6));
        pdrops.add(new WeightedRandomLoot(new ItemStack(Items.field_151166_bC), 10));
        pdrops.add(new WeightedRandomLoot(new ItemStack(Items.field_151137_ax), 15));
        pdrops.add(new WeightedRandomLoot(new ItemStack(Items.field_179563_cD), 3));
        pdrops.add(new WeightedRandomLoot(new ItemStack(Items.field_179562_cC), 3));
        pdrops.add(new WeightedRandomLoot(new ItemStack(Items.field_151119_aD), 30));
        pdrops.add(new WeightedRandomLoot(new ItemStack(Items.field_151128_bU), 15));
    }

    public static enum StoneType implements IStringSerializable
    {
        ARCANE,
        ARCANE_BRICK,
        ANCIENT,
        ANCIENT_ROCK,
        ELDRITCH,
        ANCIENT_TILE,
        CRUST,
        CRUST_GLOW,
        MATRIX_SPEED,
        MATRIX_COST,
        ANCIENT_DOORWAY,
        GLYPHED,
        BEDROCK,
        POROUS;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

