/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.client.lib.RenderBlocks;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.renderers.models.block.ModelBrain;
import thaumcraft.client.renderers.models.block.ModelJar;
import thaumcraft.common.config.Config;
import thaumcraft.common.tiles.devices.TileJarBrain;
import thaumcraft.common.tiles.essentia.TileJar;
import thaumcraft.common.tiles.essentia.TileJarFillable;

@SideOnly(value=Side.CLIENT)
public class TileJarRenderer
extends TileEntitySpecialRenderer {
    private ModelJar model = new ModelJar();
    private ModelBrain brain = new ModelBrain();
    private static final ResourceLocation TEX_LABEL = new ResourceLocation("thaumcraft", "textures/models/label.png");
    private static final ResourceLocation TEX_BRAIN = new ResourceLocation("thaumcraft", "textures/models/brain2.png");
    private static final ResourceLocation TEX_BRINE = new ResourceLocation("thaumcraft", "textures/models/jarbrine.png");

    public void renderTileEntityAt(TileJar tile, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.01f), (float)((float)z + 0.5f));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (tile instanceof TileJarBrain) {
            this.renderBrain((TileJarBrain)tile, x, y, z, f);
        } else if (tile instanceof TileJarFillable) {
            GL11.glDisable((int)2896);
            if (((TileJarFillable)tile).blocked) {
                GL11.glPushMatrix();
                this.func_147499_a(TEX_BRINE);
                GL11.glScaled((double)1.001, (double)1.001, (double)1.001);
                this.model.renderLidBrace();
                GL11.glPopMatrix();
            }
            if (ThaumcraftApiHelper.getConnectableTile(tile.func_145831_w(), tile.func_174877_v(), EnumFacing.UP) != null) {
                GL11.glPushMatrix();
                this.func_147499_a(TEX_BRINE);
                GL11.glScaled((double)0.9, (double)1.0, (double)0.9);
                this.model.renderLidExtension();
                GL11.glPopMatrix();
            }
            if (((TileJarFillable)tile).aspectFilter != null) {
                GL11.glPushMatrix();
                GL11.glBlendFunc((int)770, (int)771);
                switch (((TileJarFillable)tile).facing) {
                    case 3: {
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 5: {
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 4: {
                        GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                }
                float rot = (((TileJarFillable)tile).aspectFilter.getTag().hashCode() + tile.func_174877_v().func_177958_n() + ((TileJarFillable)tile).facing) % 4 - 2;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.315f);
                if (Config.crooked) {
                    GL11.glRotatef((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                UtilsFX.renderQuadCentered(TEX_LABEL, 0.5f, 1.0f, 1.0f, 1.0f, -99, 771, 1.0f);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.316f);
                if (Config.crooked) {
                    GL11.glRotatef((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                GL11.glScaled((double)0.021, (double)0.021, (double)0.021);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                UtilsFX.drawTag(-8, -8, ((TileJarFillable)tile).aspectFilter);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            }
            if (((TileJarFillable)tile).amount > 0) {
                this.renderLiquid((TileJarFillable)tile, x, y, z, f);
            }
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    public void renderLiquid(TileJarFillable te, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        World world = te.func_145831_w();
        RenderBlocks renderBlocks = new RenderBlocks();
        GL11.glDisable((int)2896);
        float level = (float)te.amount / (float)te.maxAmount * 0.625f;
        Tessellator t = Tessellator.func_178181_a();
        renderBlocks.setRenderBounds(0.25, 0.0625, 0.25, 0.75, 0.0625 + (double)level, 0.75);
        t.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181711_k);
        Color co = new Color(0);
        if (te.aspect != null) {
            co = new Color(te.aspect.getColor());
        }
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_110572_b("thaumcraft:blocks/animatedglow");
        this.func_147499_a(TextureMap.field_110575_b);
        renderBlocks.renderFaceYNeg(BlocksTC.jar, -0.5, 0.0, -0.5, icon, (float)co.getRed() / 255.0f, (float)co.getGreen() / 255.0f, (float)co.getBlue() / 255.0f, 200);
        renderBlocks.renderFaceYPos(BlocksTC.jar, -0.5, 0.0, -0.5, icon, (float)co.getRed() / 255.0f, (float)co.getGreen() / 255.0f, (float)co.getBlue() / 255.0f, 200);
        renderBlocks.renderFaceZNeg(BlocksTC.jar, -0.5, 0.0, -0.5, icon, (float)co.getRed() / 255.0f, (float)co.getGreen() / 255.0f, (float)co.getBlue() / 255.0f, 200);
        renderBlocks.renderFaceZPos(BlocksTC.jar, -0.5, 0.0, -0.5, icon, (float)co.getRed() / 255.0f, (float)co.getGreen() / 255.0f, (float)co.getBlue() / 255.0f, 200);
        renderBlocks.renderFaceXNeg(BlocksTC.jar, -0.5, 0.0, -0.5, icon, (float)co.getRed() / 255.0f, (float)co.getGreen() / 255.0f, (float)co.getBlue() / 255.0f, 200);
        renderBlocks.renderFaceXPos(BlocksTC.jar, -0.5, 0.0, -0.5, icon, (float)co.getRed() / 255.0f, (float)co.getGreen() / 255.0f, (float)co.getBlue() / 255.0f, 200);
        t.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderBrain(TileJarBrain te, double x, double y, double z, float f) {
        float f2;
        float bob = MathHelper.func_76126_a((float)((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa / 14.0f)) * 0.03f + 0.03f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-0.8f + bob), (float)0.0f);
        for (f2 = te.rota - te.rotb; f2 >= 3.141593f; f2 -= 6.283185f) {
        }
        while (f2 < -3.141593f) {
            f2 += 6.283185f;
        }
        float f3 = te.rotb + f2 * f;
        GL11.glRotatef((float)(f3 * 180.0f / 3.141593f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(TEX_BRAIN);
        GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
        this.brain.render();
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.func_147499_a(TEX_BRINE);
        this.model.renderBrine();
        GL11.glPopMatrix();
    }

    public void func_180535_a(TileEntity par1TileEntity, double par2, double par4, double par6, float par8, int q) {
        this.renderTileEntityAt((TileJar)par1TileEntity, par2, par4, par6, par8);
    }
}

