/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import java.awt.Color;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.TexturedQuadTC;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.lib.models.AdvancedModelLoader;
import thaumcraft.client.lib.models.IModelCustom;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.tiles.devices.TileDioptra;

public class TileDioptraRenderer
extends TileEntitySpecialRenderer {
    private IModelCustom model = AdvancedModelLoader.loadModel(crystal);
    private static final ResourceLocation crystal = new ResourceLocation("thaumcraft", "models/obj/vis_relay.obj");
    private static final ResourceLocation crystalTexture = new ResourceLocation("thaumcraft", "textures/models/vis_relay.png");
    private static final ResourceLocation gridTexture = new ResourceLocation("thaumcraft", "textures/misc/gridblock.png");
    private static final ResourceLocation sideTexture = new ResourceLocation("thaumcraft", "textures/models/dioptra_side.png");

    public void func_180535_a(TileEntity te, double x, double y, double z, float pt, int p_180535_9_) {
        TileDioptra tco = (TileDioptra)te;
        if (tco.type < 0) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.func_147499_a(crystalTexture);
        float t = this.field_147501_a.field_147551_g != null ? (float)this.field_147501_a.field_147551_g.field_70173_aa + pt : 0.0f;
        float rc = 1.0f;
        float gc = 1.0f;
        float bc = 1.0f;
        Aspect as = tco.getAspect(tco.type);
        if (as != null) {
            Color c = new Color(as.getColor());
            rc = (float)c.getRed() / 255.0f;
            gc = (float)c.getGreen() / 255.0f;
            bc = (float)c.getBlue() / 255.0f;
        } else {
            rc = MathHelper.func_76126_a((float)(t / 12.0f)) * 0.3f + 0.7f;
            gc = MathHelper.func_76126_a((float)(t / 11.0f)) * 0.3f + 0.7f;
            bc = MathHelper.func_76126_a((float)(t / 10.0f)) * 0.3f + 0.7f;
        }
        GL11.glColor3f((float)rc, (float)gc, (float)bc);
        GL11.glScaled((double)1.3, (double)1.3, (double)1.2);
        this.model.renderPart("Crystal");
        GL11.glPopMatrix();
        if (BlockStateUtils.isEnabled(tco.func_145832_p())) {
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glPushMatrix();
            GL11.glTranslated((double)-0.495, (double)0.501, (double)-0.495);
            this.func_147499_a(gridTexture);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScaled((double)0.99, (double)1.0, (double)0.99);
            for (int a = 0; a < 12; ++a) {
                for (int b = 0; b < 12; ++b) {
                    byte t1 = tco.grid_type[a + b * 13];
                    if (t1 > 10) {
                        t1 = (byte)(t1 - 10);
                    }
                    if (tco.getAspect(t1) == null) continue;
                    Color c1 = new Color(tco.getAspect(t1).getColor());
                    byte t2 = tco.grid_type[a + 1 + b * 13];
                    if (t2 > 10) {
                        t2 = (byte)(t2 - 10);
                    }
                    if (tco.getAspect(t2) == null) continue;
                    Color c2 = new Color(tco.getAspect(t2).getColor());
                    byte t3 = tco.grid_type[a + 1 + (b + 1) * 13];
                    if (t3 > 10) {
                        t3 = (byte)(t3 - 10);
                    }
                    if (tco.getAspect(t3) == null) continue;
                    Color c3 = new Color(tco.getAspect(t3).getColor());
                    byte t4 = tco.grid_type[a + (b + 1) * 13];
                    if (t4 > 10) {
                        t4 = (byte)(t4 - 10);
                    }
                    if (tco.getAspect(t4) == null) continue;
                    Color c4 = new Color(tco.getAspect(t4).getColor());
                    double d3 = a - 6;
                    double d5 = b - 6;
                    double dis = Math.sqrt(d3 * d3 + d5 * d5);
                    float s = MathHelper.func_76126_a((float)((float)(((double)tco.counter - dis * 10.0) / 8.0)));
                    float rr = c1.getRed() + c2.getRed() + c3.getRed() + c4.getRed();
                    float gg = c1.getGreen() + c2.getGreen() + c3.getGreen() + c4.getGreen();
                    float bb = c1.getBlue() + c2.getBlue() + c3.getBlue() + c4.getBlue();
                    Color co = new Color(rr / 1020.0f, gg / 1020.0f, bb / 1020.0f);
                    TexturedQuadTC quad = new TexturedQuadTC(new PositionTextureVertex[]{new PositionTextureVertex((float)a / 12.0f, (float)tco.grid_amt[a + b * 13] / ((float)Config.AURABASE * 1.5f), (float)b / 12.0f, 0.0f, 1.0f), new PositionTextureVertex((float)(a + 1) / 12.0f, (float)tco.grid_amt[a + 1 + b * 13] / ((float)Config.AURABASE * 1.5f), (float)b / 12.0f, 1.0f, 1.0f), new PositionTextureVertex((float)(a + 1) / 12.0f, (float)tco.grid_amt[a + 1 + (b + 1) * 13] / ((float)Config.AURABASE * 1.5f), (float)(b + 1) / 12.0f, 1.0f, 0.0f), new PositionTextureVertex((float)a / 12.0f, (float)tco.grid_amt[a + (b + 1) * 13] / ((float)Config.AURABASE * 1.5f), (float)(b + 1) / 12.0f, 0.0f, 0.0f)});
                    quad.flipFace();
                    quad.draw(tessellator.func_178180_c(), 1.0f, (int)(200.0f + s * 15.0f), co.getRGB(), 0.9f);
                    if (a == 0) {
                        quad = new TexturedQuadTC(new PositionTextureVertex[]{new PositionTextureVertex(0.0f, 0.0f, (float)b / 12.0f, 0.0f, 1.0f), new PositionTextureVertex(0.0f, (float)tco.grid_amt[b * 13] / ((float)Config.AURABASE * 1.5f), (float)b / 12.0f, 1.0f, 1.0f), new PositionTextureVertex(0.0f, (float)tco.grid_amt[(b + 1) * 13] / ((float)Config.AURABASE * 1.5f), (float)(b + 1) / 12.0f, 1.0f, 0.0f), new PositionTextureVertex(0.0f, 0.0f, (float)(b + 1) / 12.0f, 0.0f, 0.0f)});
                        quad.flipFace();
                        quad.draw(tessellator.func_178180_c(), 1.0f, (int)(200.0f + s * 15.0f), co.getRGB(), 0.9f);
                    }
                    if (a == 11) {
                        quad = new TexturedQuadTC(new PositionTextureVertex[]{new PositionTextureVertex(1.0f, 0.0f, (float)b / 12.0f, 0.0f, 1.0f), new PositionTextureVertex(1.0f, (float)tco.grid_amt[a + 1 + b * 13] / ((float)Config.AURABASE * 1.5f), (float)b / 12.0f, 1.0f, 1.0f), new PositionTextureVertex(1.0f, (float)tco.grid_amt[a + 1 + (b + 1) * 13] / ((float)Config.AURABASE * 1.5f), (float)(b + 1) / 12.0f, 1.0f, 0.0f), new PositionTextureVertex(1.0f, 0.0f, (float)(b + 1) / 12.0f, 0.0f, 0.0f)});
                        quad.draw(tessellator.func_178180_c(), 1.0f, (int)(200.0f + s * 15.0f), co.getRGB(), 0.9f);
                    }
                    if (b == 0) {
                        quad = new TexturedQuadTC(new PositionTextureVertex[]{new PositionTextureVertex((float)a / 12.0f, 0.0f, 0.0f, 0.0f, 1.0f), new PositionTextureVertex((float)(a + 1) / 12.0f, 0.0f, 0.0f, 1.0f, 1.0f), new PositionTextureVertex((float)(a + 1) / 12.0f, (float)tco.grid_amt[a + 1] / ((float)Config.AURABASE * 1.5f), 0.0f, 1.0f, 0.0f), new PositionTextureVertex((float)a / 12.0f, (float)tco.grid_amt[a] / ((float)Config.AURABASE * 1.5f), 0.0f, 0.0f, 0.0f)});
                        quad.flipFace();
                        quad.draw(tessellator.func_178180_c(), 1.0f, (int)(200.0f + s * 15.0f), co.getRGB(), 0.9f);
                    }
                    if (b != 11) continue;
                    quad = new TexturedQuadTC(new PositionTextureVertex[]{new PositionTextureVertex((float)a / 12.0f, 0.0f, 1.0f, 0.0f, 1.0f), new PositionTextureVertex((float)(a + 1) / 12.0f, 0.0f, 1.0f, 1.0f, 1.0f), new PositionTextureVertex((float)(a + 1) / 12.0f, (float)tco.grid_amt[a + 1 + (b + 1) * 13] / ((float)Config.AURABASE * 1.5f), 1.0f, 1.0f, 0.0f), new PositionTextureVertex((float)a / 12.0f, (float)tco.grid_amt[a + (b + 1) * 13] / ((float)Config.AURABASE * 1.5f), 1.0f, 0.0f, 0.0f)});
                    quad.draw(tessellator.func_178180_c(), 1.0f, (int)(200.0f + s * 15.0f), co.getRGB(), 0.9f);
                }
            }
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GlStateManager.func_179129_p();
            GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (int q = 0; q < 4; ++q) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)(90.0f * (float)q), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslated((double)0.0, (double)0.0, (double)-0.5);
                UtilsFX.renderQuadCentered(sideTexture, 1.0f, rc, gc, bc, 220, 1, 0.8f);
                GL11.glPopMatrix();
            }
            GlStateManager.func_179089_o();
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

