/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.models.block;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import thaumcraft.client.lib.models.IInitializeBakedModel;
import thaumcraft.common.blocks.BlockTC;
import thaumcraft.common.blocks.devices.BlockJarItem;

public class CustomJarInventoryModel
implements ISmartItemModel,
IInitializeBakedModel {
    ItemCameraTransforms transforms;
    List<BakedQuad> faceQuads;
    List<BakedQuad> generalQuads;
    TextureAtlasSprite iconSprite;
    public ResourceLocation MA;
    Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        }
    };
    static HashMap<String, IBakedModel> cache = new HashMap();

    public CustomJarInventoryModel(String variant) {
        this.MA = new ResourceLocation("thaumcraft:block/" + variant);
    }

    @Override
    public void initialize(ItemCameraTransforms cameraTransforms, ResourceLocation icon, ModelManager modelManager) {
        this.transforms = cameraTransforms;
        this.iconSprite = modelManager.func_174952_b().func_110572_b(icon.toString());
        this.faceQuads = new ArrayList<BakedQuad>();
        this.generalQuads = new ArrayList<BakedQuad>();
    }

    public IBakedModel handleItemState(ItemStack stack) {
        IBakedModel m = null;
        BlockJarItem item = (BlockJarItem)stack.func_77973_b();
        String key = stack.func_77960_j() + "";
        if (item.getAspects(stack) != null) {
            key = key + ":" + item.getAspects(stack).getAspects()[0].getName();
            if (item.getAspects(stack).visSize() > 0) {
                key = key + ":" + item.getAspects(stack).visSize();
            }
        }
        if (cache.containsKey(key)) {
            return cache.get(key);
        }
        SimpleBakedModel.Builder b = new SimpleBakedModel.Builder((IBakedModel)this, null);
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)this.getModel(stack));
            IFlexibleBakedModel bm = model.bake(model.getDefaultState(), Attributes.DEFAULT_BAKED_FORMAT, this.textureGetter);
            List list = bm.func_177550_a();
            for (BakedQuad bq : list) {
                b.func_177648_a(bq);
            }
            m = b.func_177645_b();
            cache.put(key, m);
        }
        catch (IOException e) {
            // empty catch block
        }
        return m;
    }

    public ResourceLocation getModel(ItemStack stack) {
        BlockJarItem item = (BlockJarItem)stack.func_77973_b();
        BlockTC block = (BlockTC)item.field_150939_a;
        ResourceLocation modelresourcelocation = new ResourceLocation("Thaumcraft:block/" + block.getStateName(block.func_176203_a(stack.func_77960_j()), false));
        if (item.getAspects(stack) != null && item.getAspects(stack).visSize() > 0) {
            modelresourcelocation = item.getAspects(stack).visSize() < 16 ? new ResourceLocation("Thaumcraft:block/" + block.getStateName(block.func_176203_a(stack.func_77960_j()), false) + "_0") : (item.getAspects(stack).visSize() < 32 ? new ResourceLocation("Thaumcraft:block/" + block.getStateName(block.func_176203_a(stack.func_77960_j()), false) + "_1") : (item.getAspects(stack).visSize() < 48 ? new ResourceLocation("Thaumcraft:block/" + block.getStateName(block.func_176203_a(stack.func_77960_j()), false) + "_2") : new ResourceLocation("Thaumcraft:block/" + block.getStateName(block.func_176203_a(stack.func_77960_j()), false) + "_3")));
        }
        return modelresourcelocation;
    }

    public List func_177551_a(EnumFacing face) {
        return this.faceQuads;
    }

    public List func_177550_a() {
        return this.generalQuads;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.iconSprite;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.transforms;
    }
}

