/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.math;

import thaumcraft.client.lib.math.Vec4;

public class Matrix {
    public static final Matrix IDENTITY = new Matrix(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, true);
    public final double m11;
    public final double m12;
    public final double m13;
    public final double m14;
    public final double m21;
    public final double m22;
    public final double m23;
    public final double m24;
    public final double m31;
    public final double m32;
    public final double m33;
    public final double m34;
    public final double m41;
    public final double m42;
    public final double m43;
    public final double m44;
    protected static final double EPSILON = 1.0E-6;
    protected static final double NEAR_ZERO_THRESHOLD = 1.0E-8;
    private static final int NUM_ELEMENTS = 16;
    private final boolean isOrthonormalTransform;
    private int hashCode;
    private static final Double POSITIVE_ZERO = 0.0;
    private static final Double NEGATIVE_ZERO = -0.0;

    public Matrix(double value) {
        this(value, 0.0, 0.0, 0.0, 0.0, value, 0.0, 0.0, 0.0, 0.0, value, 0.0, 0.0, 0.0, 0.0, value);
    }

    public Matrix(double m11, double m12, double m13, double m14, double m21, double m22, double m23, double m24, double m31, double m32, double m33, double m34, double m41, double m42, double m43, double m44) {
        this(m11, m12, m13, m14, m21, m22, m23, m24, m31, m32, m33, m34, m41, m42, m43, m44, false);
    }

    Matrix(double m11, double m12, double m13, double m14, double m21, double m22, double m23, double m24, double m31, double m32, double m33, double m34, double m41, double m42, double m43, double m44, boolean isOrthonormalTransform) {
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m14 = m14;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m24 = m24;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
        this.m34 = m34;
        this.m41 = m41;
        this.m42 = m42;
        this.m43 = m43;
        this.m44 = m44;
        this.isOrthonormalTransform = isOrthonormalTransform;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Matrix that = (Matrix)obj;
        return this.m11 == that.m11 && this.m12 == that.m12 && this.m13 == that.m13 && this.m14 == that.m14 && this.m21 == that.m21 && this.m22 == that.m22 && this.m23 == that.m23 && this.m24 == that.m24 && this.m31 == that.m31 && this.m32 == that.m32 && this.m33 == that.m33 && this.m34 == that.m34 && this.m41 == that.m41 && this.m42 == that.m42 && this.m43 == that.m43 && this.m44 == that.m44;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            long tmp = Double.doubleToLongBits(this.m11);
            int result = (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m12);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m13);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m14);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m21);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m22);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m23);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m24);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m31);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m32);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m33);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m34);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m41);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m42);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m43);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.m44);
            this.hashCode = result = 29 * result + (int)(tmp ^ tmp >>> 32);
        }
        return this.hashCode;
    }

    public static Matrix fromArray(double[] compArray, int offset, boolean rowMajor) {
        if (compArray == null) {
            throw new IllegalArgumentException();
        }
        if (compArray.length - offset < 16) {
            throw new IllegalArgumentException();
        }
        if (rowMajor) {
            return new Matrix(compArray[0 + offset], compArray[1 + offset], compArray[2 + offset], compArray[3 + offset], compArray[4 + offset], compArray[5 + offset], compArray[6 + offset], compArray[7 + offset], compArray[8 + offset], compArray[9 + offset], compArray[10 + offset], compArray[11 + offset], compArray[12 + offset], compArray[13 + offset], compArray[14 + offset], compArray[15 + offset]);
        }
        return new Matrix(compArray[0 + offset], compArray[4 + offset], compArray[8 + offset], compArray[12 + offset], compArray[1 + offset], compArray[5 + offset], compArray[9 + offset], compArray[13 + offset], compArray[2 + offset], compArray[6 + offset], compArray[10 + offset], compArray[14 + offset], compArray[3 + offset], compArray[7 + offset], compArray[11 + offset], compArray[15 + offset]);
    }

    public final double[] toArray(double[] compArray, int offset, boolean rowMajor) {
        if (compArray == null) {
            throw new IllegalArgumentException();
        }
        if (compArray.length - offset < 16) {
            throw new IllegalArgumentException();
        }
        if (rowMajor) {
            compArray[0 + offset] = this.m11;
            compArray[1 + offset] = this.m12;
            compArray[2 + offset] = this.m13;
            compArray[3 + offset] = this.m14;
            compArray[4 + offset] = this.m21;
            compArray[5 + offset] = this.m22;
            compArray[6 + offset] = this.m23;
            compArray[7 + offset] = this.m24;
            compArray[8 + offset] = this.m31;
            compArray[9 + offset] = this.m32;
            compArray[10 + offset] = this.m33;
            compArray[11 + offset] = this.m34;
            compArray[12 + offset] = this.m41;
            compArray[13 + offset] = this.m42;
            compArray[14 + offset] = this.m43;
            compArray[15 + offset] = this.m44;
        } else {
            compArray[0 + offset] = this.m11;
            compArray[4 + offset] = this.m12;
            compArray[8 + offset] = this.m13;
            compArray[12 + offset] = this.m14;
            compArray[1 + offset] = this.m21;
            compArray[5 + offset] = this.m22;
            compArray[9 + offset] = this.m23;
            compArray[13 + offset] = this.m24;
            compArray[2 + offset] = this.m31;
            compArray[6 + offset] = this.m32;
            compArray[10 + offset] = this.m33;
            compArray[14 + offset] = this.m34;
            compArray[3 + offset] = this.m41;
            compArray[7 + offset] = this.m42;
            compArray[11 + offset] = this.m43;
            compArray[15 + offset] = this.m44;
        }
        return compArray;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.m11).append(", ").append(this.m12).append(", ").append(this.m13).append(", ").append(this.m14);
        sb.append(", \r\n");
        sb.append(this.m21).append(", ").append(this.m22).append(", ").append(this.m23).append(", ").append(this.m24);
        sb.append(", \r\n");
        sb.append(this.m31).append(", ").append(this.m32).append(", ").append(this.m33).append(", ").append(this.m34);
        sb.append(", \r\n");
        sb.append(this.m41).append(", ").append(this.m42).append(", ").append(this.m43).append(", ").append(this.m44);
        sb.append(")");
        return sb.toString();
    }

    public final double getM11() {
        return this.m11;
    }

    public final double getM12() {
        return this.m12;
    }

    public final double getM13() {
        return this.m13;
    }

    public final double getM14() {
        return this.m14;
    }

    public final double getM21() {
        return this.m21;
    }

    public final double getM22() {
        return this.m22;
    }

    public final double getM23() {
        return this.m23;
    }

    public final double getM24() {
        return this.m24;
    }

    public final double getM31() {
        return this.m31;
    }

    public final double getM32() {
        return this.m32;
    }

    public final double getM33() {
        return this.m33;
    }

    public final double getM34() {
        return this.m34;
    }

    public final double getM41() {
        return this.m41;
    }

    public final double getM42() {
        return this.m42;
    }

    public final double getM43() {
        return this.m43;
    }

    public final double getM44() {
        return this.m44;
    }

    public final double m11() {
        return this.m11;
    }

    public final double m12() {
        return this.m12;
    }

    public final double m13() {
        return this.m13;
    }

    public final double m14() {
        return this.m14;
    }

    public final double m21() {
        return this.m21;
    }

    public final double m22() {
        return this.m22;
    }

    public final double m23() {
        return this.m23;
    }

    public final double m24() {
        return this.m24;
    }

    public final double m31() {
        return this.m31;
    }

    public final double m32() {
        return this.m32;
    }

    public final double m33() {
        return this.m33;
    }

    public final double m34() {
        return this.m34;
    }

    public final double m41() {
        return this.m41;
    }

    public final double m42() {
        return this.m42;
    }

    public final double m43() {
        return this.m43;
    }

    public final double m44() {
        return this.m44;
    }

    public static Matrix fromAxes(Vec4[] axes) {
        if (axes == null) {
            throw new IllegalArgumentException();
        }
        if (axes.length < 3) {
            throw new IllegalArgumentException();
        }
        if (axes[0] == null || axes[1] == null || axes[2] == null) {
            throw new IllegalArgumentException();
        }
        Vec4 s = axes[0].normalize3();
        Vec4 f = s.cross3(axes[1]).normalize3();
        Vec4 u = f.cross3(s).normalize3();
        return new Matrix(s.x, u.x, f.x, 0.0, s.y, u.y, f.y, 0.0, s.z, u.z, f.z, 0.0, 0.0, 0.0, 0.0, 1.0, true);
    }

    private static Matrix fromQuaternion(double x, double y, double z, double w, boolean normalize) {
        double length;
        if (normalize && !Matrix.isZero(length = Math.sqrt(x * x + y * y + z * z + w * w)) && length != 1.0) {
            x /= length;
            y /= length;
            z /= length;
            w /= length;
        }
        return new Matrix(1.0 - 2.0 * y * y - 2.0 * z * z, 2.0 * x * y - 2.0 * z * w, 2.0 * x * z + 2.0 * y * w, 0.0, 2.0 * x * y + 2.0 * z * w, 1.0 - 2.0 * x * x - 2.0 * z * z, 2.0 * y * z - 2.0 * x * w, 0.0, 2.0 * x * z - 2.0 * y * w, 2.0 * y * z + 2.0 * x * w, 1.0 - 2.0 * x * x - 2.0 * y * y, 0.0, 0.0, 0.0, 0.0, 1.0, true);
    }

    public static Matrix fromScale(double scale) {
        return Matrix.fromScale(scale, scale, scale);
    }

    public static Matrix fromScale(Vec4 scale) {
        if (scale == null) {
            throw new IllegalArgumentException();
        }
        return Matrix.fromScale(scale.x, scale.y, scale.z);
    }

    public static Matrix fromScale(double scaleX, double scaleY, double scaleZ) {
        return new Matrix(scaleX, 0.0, 0.0, 0.0, 0.0, scaleY, 0.0, 0.0, 0.0, 0.0, scaleZ, 0.0, 0.0, 0.0, 0.0, 1.0, false);
    }

    public static Matrix fromTranslation(Vec4 translation) {
        if (translation == null) {
            throw new IllegalArgumentException();
        }
        return Matrix.fromTranslation(translation.x, translation.y, translation.z);
    }

    public static Matrix fromTranslation(double x, double y, double z) {
        return new Matrix(1.0, 0.0, 0.0, x, 0.0, 1.0, 0.0, y, 0.0, 0.0, 1.0, z, 0.0, 0.0, 0.0, 1.0, true);
    }

    public static Matrix fromLocalOrientation(Vec4 origin, Vec4[] axes) {
        if (origin == null) {
            throw new IllegalArgumentException();
        }
        if (axes == null) {
            throw new IllegalArgumentException();
        }
        if (axes.length < 3) {
            throw new IllegalArgumentException();
        }
        if (axes[0] == null || axes[1] == null || axes[2] == null) {
            throw new IllegalArgumentException();
        }
        return Matrix.fromTranslation(origin).multiply(Matrix.fromAxes(axes));
    }

    public static Matrix fromViewLookAt(Vec4 eye, Vec4 center, Vec4 up) {
        if (eye == null || center == null || up == null) {
            throw new IllegalArgumentException();
        }
        if (eye.distanceTo3(center) <= 1.0E-6) {
            throw new IllegalArgumentException();
        }
        Vec4 forward = center.subtract3(eye);
        Vec4 f = forward.normalize3();
        Vec4 s = f.cross3(up);
        if ((s = s.normalize3()).getLength3() <= 1.0E-6) {
            throw new IllegalArgumentException();
        }
        Vec4 u = s.cross3(f);
        u = u.normalize3();
        Matrix mAxes = new Matrix(s.x, s.y, s.z, 0.0, u.x, u.y, u.z, 0.0, -f.x, -f.y, -f.z, 0.0, 0.0, 0.0, 0.0, 1.0, true);
        Matrix mEye = Matrix.fromTranslation(-eye.x, -eye.y, -eye.z);
        return mAxes.multiply(mEye);
    }

    public static Matrix fromModelLookAt(Vec4 eye, Vec4 center, Vec4 up) {
        if (eye == null || center == null || up == null) {
            throw new IllegalArgumentException();
        }
        if (eye.distanceTo3(center) <= 1.0E-6) {
            throw new IllegalArgumentException();
        }
        Vec4 forward = center.subtract3(eye);
        Vec4 f = forward.normalize3();
        Vec4 s = up.cross3(f);
        if ((s = s.normalize3()).getLength3() <= 1.0E-6) {
            throw new IllegalArgumentException();
        }
        Vec4 u = f.cross3(s);
        u = u.normalize3();
        Matrix mAxes = new Matrix(s.x, u.x, f.x, 0.0, s.y, u.y, f.y, 0.0, s.z, u.z, f.z, 0.0, 0.0, 0.0, 0.0, 1.0, true);
        Matrix mEye = Matrix.fromTranslation(eye.x, eye.y, eye.z);
        return mEye.multiply(mAxes);
    }

    public static Matrix fromPerspective(double width, double height, double near, double far) {
        if (width <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (near <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (far <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (far <= near) {
            throw new IllegalArgumentException();
        }
        return new Matrix(2.0 / width, 0.0, 0.0, 0.0, 0.0, 2.0 * near / height, 0.0, 0.0, 0.0, 0.0, -(far + near) / (far - near), -(2.0 * far * near) / (far - near), 0.0, 0.0, -1.0, 0.0);
    }

    public static Matrix fromOrthographic(double width, double height, double near, double far) {
        if (width <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (near <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (far <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (far <= near) {
            throw new IllegalArgumentException();
        }
        return new Matrix(2.0 / width, 0.0, 0.0, 0.0, 0.0, 2.0 / height, 0.0, 0.0, 0.0, 0.0, -2.0 / (far - near), -(far + near) / (far - near), 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix fromOrthographic2D(double width, double height) {
        if (width <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException();
        }
        return new Matrix(2.0 / width, 0.0, 0.0, 0.0, 0.0, 2.0 / height, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix fromCovarianceOfVertices(Iterable<? extends Vec4> points) {
        if (points == null) {
            throw new IllegalArgumentException();
        }
        Vec4 mean = Vec4.computeAveragePoint(points);
        if (mean == null) {
            return null;
        }
        int count = 0;
        double c11 = 0.0;
        double c22 = 0.0;
        double c33 = 0.0;
        double c12 = 0.0;
        double c13 = 0.0;
        double c23 = 0.0;
        for (Vec4 vec4 : points) {
            if (vec4 == null) continue;
            ++count;
            c11 += (vec4.x - mean.x) * (vec4.x - mean.x);
            c22 += (vec4.y - mean.y) * (vec4.y - mean.y);
            c33 += (vec4.z - mean.z) * (vec4.z - mean.z);
            c12 += (vec4.x - mean.x) * (vec4.y - mean.y);
            c13 += (vec4.x - mean.x) * (vec4.z - mean.z);
            c23 += (vec4.y - mean.y) * (vec4.z - mean.z);
        }
        if (count == 0) {
            return null;
        }
        return new Matrix(c11 / (double)count, c12 / (double)count, c13 / (double)count, 0.0, c12 / (double)count, c22 / (double)count, c23 / (double)count, 0.0, c13 / (double)count, c23 / (double)count, c33 / (double)count, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static void computeEigensystemFromSymmetricMatrix3(Matrix matrix2, double[] outEigenvalues, Vec4[] outEigenvectors) {
        if (matrix2 == null) {
            throw new IllegalArgumentException();
        }
        if (matrix2.m12 != matrix2.m21 || matrix2.m13 != matrix2.m31 || matrix2.m23 != matrix2.m32) {
            throw new IllegalArgumentException();
        }
        double EPSILON = 1.0E-10;
        int MAX_SWEEPS = 32;
        double m11 = matrix2.m11;
        double m12 = matrix2.m12;
        double m13 = matrix2.m13;
        double m22 = matrix2.m22;
        double m23 = matrix2.m23;
        double m33 = matrix2.m33;
        double[][] r = new double[3][3];
        r[2][2] = 1.0;
        r[1][1] = 1.0;
        r[0][0] = 1.0;
        for (int a = 0; !(a >= 32 || Math.abs(m12) < 1.0E-10 && Math.abs(m13) < 1.0E-10 && Math.abs(m23) < 1.0E-10); ++a) {
            int i;
            double temp;
            double s;
            double c;
            double t;
            double u2p1;
            double u2;
            double u;
            if (m12 != 0.0) {
                u = (m22 - m11) * 0.5 / m12;
                u2 = u * u;
                u2p1 = u2 + 1.0;
                t = u2p1 != u2 ? (u < 0.0 ? -1.0 : 1.0) * (Math.sqrt(u2p1) - Math.abs(u)) : 0.5 / u;
                c = 1.0 / Math.sqrt(t * t + 1.0);
                s = c * t;
                m11 -= t * m12;
                m22 += t * m12;
                m12 = 0.0;
                temp = c * m13 - s * m23;
                m23 = s * m13 + c * m23;
                m13 = temp;
                for (i = 0; i < 3; ++i) {
                    temp = c * r[i][0] - s * r[i][1];
                    r[i][1] = s * r[i][0] + c * r[i][1];
                    r[i][0] = temp;
                }
            }
            if (m13 != 0.0) {
                u = (m33 - m11) * 0.5 / m13;
                u2 = u * u;
                u2p1 = u2 + 1.0;
                t = u2p1 != u2 ? (u < 0.0 ? -1.0 : 1.0) * (Math.sqrt(u2p1) - Math.abs(u)) : 0.5 / u;
                c = 1.0 / Math.sqrt(t * t + 1.0);
                s = c * t;
                m11 -= t * m13;
                m33 += t * m13;
                m13 = 0.0;
                temp = c * m12 - s * m23;
                m23 = s * m12 + c * m23;
                m12 = temp;
                for (i = 0; i < 3; ++i) {
                    temp = c * r[i][0] - s * r[i][2];
                    r[i][2] = s * r[i][0] + c * r[i][2];
                    r[i][0] = temp;
                }
            }
            if (m23 == 0.0) continue;
            u = (m33 - m22) * 0.5 / m23;
            u2 = u * u;
            u2p1 = u2 + 1.0;
            t = u2p1 != u2 ? (u < 0.0 ? -1.0 : 1.0) * (Math.sqrt(u2p1) - Math.abs(u)) : 0.5 / u;
            c = 1.0 / Math.sqrt(t * t + 1.0);
            s = c * t;
            m22 -= t * m23;
            m33 += t * m23;
            m23 = 0.0;
            temp = c * m12 - s * m13;
            m13 = s * m12 + c * m13;
            m12 = temp;
            for (i = 0; i < 3; ++i) {
                temp = c * r[i][1] - s * r[i][2];
                r[i][2] = s * r[i][1] + c * r[i][2];
                r[i][1] = temp;
            }
        }
        outEigenvalues[0] = m11;
        outEigenvalues[1] = m22;
        outEigenvalues[2] = m33;
        outEigenvectors[0] = new Vec4(r[0][0], r[1][0], r[2][0]);
        outEigenvectors[1] = new Vec4(r[0][1], r[1][1], r[2][1]);
        outEigenvectors[2] = new Vec4(r[0][2], r[1][2], r[2][2]);
    }

    public final Matrix add(Matrix matrix2) {
        if (matrix2 == null) {
            throw new IllegalArgumentException();
        }
        return new Matrix(this.m11 + matrix2.m11, this.m12 + matrix2.m12, this.m13 + matrix2.m13, this.m14 + matrix2.m14, this.m21 + matrix2.m21, this.m22 + matrix2.m22, this.m23 + matrix2.m23, this.m24 + matrix2.m24, this.m31 + matrix2.m31, this.m32 + matrix2.m32, this.m33 + matrix2.m33, this.m34 + matrix2.m34, this.m41 + matrix2.m41, this.m42 + matrix2.m42, this.m43 + matrix2.m43, this.m44 + matrix2.m44);
    }

    public final Matrix subtract(Matrix matrix2) {
        if (matrix2 == null) {
            throw new IllegalArgumentException();
        }
        return new Matrix(this.m11 - matrix2.m11, this.m12 - matrix2.m12, this.m13 - matrix2.m13, this.m14 - matrix2.m14, this.m21 - matrix2.m21, this.m22 - matrix2.m22, this.m23 - matrix2.m23, this.m24 - matrix2.m24, this.m31 - matrix2.m31, this.m32 - matrix2.m32, this.m33 - matrix2.m33, this.m34 - matrix2.m34, this.m41 - matrix2.m41, this.m42 - matrix2.m42, this.m43 - matrix2.m43, this.m44 - matrix2.m44);
    }

    public final Matrix multiplyComponents(double value) {
        return new Matrix(this.m11 * value, this.m12 * value, this.m13 * value, this.m14 * value, this.m21 * value, this.m22 * value, this.m23 * value, this.m24 * value, this.m31 * value, this.m32 * value, this.m33 * value, this.m34 * value, this.m41 * value, this.m42 * value, this.m43 * value, this.m44 * value);
    }

    public final Matrix multiply(Matrix matrix2) {
        if (matrix2 == null) {
            throw new IllegalArgumentException();
        }
        return new Matrix(this.m11 * matrix2.m11 + this.m12 * matrix2.m21 + this.m13 * matrix2.m31 + this.m14 * matrix2.m41, this.m11 * matrix2.m12 + this.m12 * matrix2.m22 + this.m13 * matrix2.m32 + this.m14 * matrix2.m42, this.m11 * matrix2.m13 + this.m12 * matrix2.m23 + this.m13 * matrix2.m33 + this.m14 * matrix2.m43, this.m11 * matrix2.m14 + this.m12 * matrix2.m24 + this.m13 * matrix2.m34 + this.m14 * matrix2.m44, this.m21 * matrix2.m11 + this.m22 * matrix2.m21 + this.m23 * matrix2.m31 + this.m24 * matrix2.m41, this.m21 * matrix2.m12 + this.m22 * matrix2.m22 + this.m23 * matrix2.m32 + this.m24 * matrix2.m42, this.m21 * matrix2.m13 + this.m22 * matrix2.m23 + this.m23 * matrix2.m33 + this.m24 * matrix2.m43, this.m21 * matrix2.m14 + this.m22 * matrix2.m24 + this.m23 * matrix2.m34 + this.m24 * matrix2.m44, this.m31 * matrix2.m11 + this.m32 * matrix2.m21 + this.m33 * matrix2.m31 + this.m34 * matrix2.m41, this.m31 * matrix2.m12 + this.m32 * matrix2.m22 + this.m33 * matrix2.m32 + this.m34 * matrix2.m42, this.m31 * matrix2.m13 + this.m32 * matrix2.m23 + this.m33 * matrix2.m33 + this.m34 * matrix2.m43, this.m31 * matrix2.m14 + this.m32 * matrix2.m24 + this.m33 * matrix2.m34 + this.m34 * matrix2.m44, this.m41 * matrix2.m11 + this.m42 * matrix2.m21 + this.m43 * matrix2.m31 + this.m44 * matrix2.m41, this.m41 * matrix2.m12 + this.m42 * matrix2.m22 + this.m43 * matrix2.m32 + this.m44 * matrix2.m42, this.m41 * matrix2.m13 + this.m42 * matrix2.m23 + this.m43 * matrix2.m33 + this.m44 * matrix2.m43, this.m41 * matrix2.m14 + this.m42 * matrix2.m24 + this.m43 * matrix2.m34 + this.m44 * matrix2.m44, this.isOrthonormalTransform && matrix2.isOrthonormalTransform);
    }

    public final Matrix divideComponents(double value) {
        if (Matrix.isZero(value)) {
            throw new IllegalArgumentException();
        }
        return new Matrix(this.m11 / value, this.m12 / value, this.m13 / value, this.m14 / value, this.m21 / value, this.m22 / value, this.m23 / value, this.m24 / value, this.m31 / value, this.m32 / value, this.m33 / value, this.m34 / value, this.m41 / value, this.m42 / value, this.m43 / value, this.m44 / value);
    }

    public final Matrix divideComponents(Matrix matrix2) {
        if (matrix2 == null) {
            throw new IllegalArgumentException();
        }
        return new Matrix(this.m11 / matrix2.m11, this.m12 / matrix2.m12, this.m13 / matrix2.m13, this.m14 / matrix2.m14, this.m21 / matrix2.m21, this.m22 / matrix2.m22, this.m23 / matrix2.m23, this.m24 / matrix2.m24, this.m31 / matrix2.m31, this.m32 / matrix2.m32, this.m33 / matrix2.m33, this.m34 / matrix2.m34, this.m41 / matrix2.m41, this.m42 / matrix2.m42, this.m43 / matrix2.m43, this.m44 / matrix2.m44);
    }

    public final Matrix negate() {
        return new Matrix(0.0 - this.m11, 0.0 - this.m12, 0.0 - this.m13, 0.0 - this.m14, 0.0 - this.m21, 0.0 - this.m22, 0.0 - this.m23, 0.0 - this.m24, 0.0 - this.m31, 0.0 - this.m32, 0.0 - this.m33, 0.0 - this.m34, 0.0 - this.m41, 0.0 - this.m42, 0.0 - this.m43, 0.0 - this.m44, this.isOrthonormalTransform);
    }

    public final Vec4 transformBy3(Matrix matrix2, double x, double y, double z) {
        if (matrix2 == null) {
            throw new IllegalArgumentException();
        }
        return new Vec4(matrix2.m11 * x + matrix2.m12 * y + matrix2.m13 * z, matrix2.m21 * x + matrix2.m22 * y + matrix2.m23 * z, matrix2.m31 * x + matrix2.m32 * y + matrix2.m33 * z);
    }

    public final double getDeterminant() {
        double result = 0.0;
        result += this.m11 * (this.m22 * (this.m33 * this.m44 - this.m43 * this.m34) - this.m23 * (this.m32 * this.m44 - this.m42 * this.m34) + this.m24 * (this.m32 * this.m43 - this.m42 * this.m33));
        result -= this.m12 * (this.m21 * (this.m33 * this.m44 - this.m43 * this.m34) - this.m23 * (this.m31 * this.m44 - this.m41 * this.m34) + this.m24 * (this.m31 * this.m43 - this.m41 * this.m33));
        result += this.m13 * (this.m21 * (this.m32 * this.m44 - this.m42 * this.m34) - this.m22 * (this.m31 * this.m44 - this.m41 * this.m34) + this.m24 * (this.m31 * this.m42 - this.m41 * this.m32));
        return result -= this.m14 * (this.m21 * (this.m32 * this.m43 - this.m42 - this.m33) - this.m22 * (this.m31 * this.m43 - this.m41 * this.m33) + this.m23 * (this.m31 * this.m42 - this.m41 * this.m32));
    }

    public final Matrix getTranspose() {
        return new Matrix(this.m11, this.m21, this.m31, this.m41, this.m12, this.m22, this.m32, this.m42, this.m13, this.m23, this.m33, this.m43, this.m14, this.m24, this.m34, this.m44, false);
    }

    public final double getTrace() {
        return this.m11 + this.m22 + this.m33 + this.m44;
    }

    public final Matrix getInverse() {
        if (this.isOrthonormalTransform) {
            return Matrix.computeTransformInverse(this);
        }
        return Matrix.computeGeneralInverse(this);
    }

    private static Matrix computeTransformInverse(Matrix a) {
        return new Matrix(a.m11, a.m21, a.m31, 0.0 - a.m11 * a.m14 - a.m21 * a.m24 - a.m31 * a.m34, a.m12, a.m22, a.m32, 0.0 - a.m12 * a.m14 - a.m22 * a.m24 - a.m32 * a.m34, a.m13, a.m23, a.m33, 0.0 - a.m13 * a.m14 - a.m23 * a.m24 - a.m33 * a.m34, 0.0, 0.0, 0.0, 1.0, false);
    }

    private static Matrix computeGeneralInverse(Matrix a) {
        double[][] A = new double[4][4];
        A[0][0] = a.m11;
        A[0][1] = a.m12;
        A[0][2] = a.m13;
        A[0][3] = a.m14;
        A[1][0] = a.m21;
        A[1][1] = a.m22;
        A[1][2] = a.m23;
        A[1][3] = a.m24;
        A[2][0] = a.m31;
        A[2][1] = a.m32;
        A[2][2] = a.m33;
        A[2][3] = a.m34;
        A[3][0] = a.m41;
        A[3][1] = a.m42;
        A[3][2] = a.m43;
        A[3][3] = a.m44;
        int[] indx = new int[4];
        double d = Matrix.ludcmp(A, indx);
        for (int i = 0; i < 4; ++i) {
            d *= A[i][i];
        }
        if (Math.abs(d) < 1.0E-8) {
            return null;
        }
        double[][] Y = new double[4][4];
        double[] col = new double[4];
        for (int j = 0; j < 4; ++j) {
            int i;
            for (i = 0; i < 4; ++i) {
                col[i] = 0.0;
            }
            col[j] = 1.0;
            Matrix.lubksb(A, indx, col);
            for (i = 0; i < 4; ++i) {
                Y[i][j] = col[i];
            }
        }
        return new Matrix(Y[0][0], Y[0][1], Y[0][2], Y[0][3], Y[1][0], Y[1][1], Y[1][2], Y[1][3], Y[2][0], Y[2][1], Y[2][2], Y[2][3], Y[3][0], Y[3][1], Y[3][2], Y[3][3]);
    }

    private static void lubksb(double[][] A, int[] indx, double[] b) {
        int i;
        int ii = -1;
        for (i = 0; i < 4; ++i) {
            int ip = indx[i];
            double sum = b[ip];
            b[ip] = b[i];
            if (ii != -1) {
                for (int j = ii; j <= i - 1; ++j) {
                    sum -= A[i][j] * b[j];
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            b[i] = sum;
        }
        for (i = 3; i >= 0; --i) {
            double sum = b[i];
            for (int j = i + 1; j < 4; ++j) {
                sum -= A[i][j] * b[j];
            }
            b[i] = sum / A[i][i];
        }
    }

    private static double ludcmp(double[][] A, int[] indx) {
        double TINY = 1.0E-20;
        double[] vv = new double[4];
        double d = 1.0;
        for (int i = 0; i < 4; ++i) {
            double big = 0.0;
            for (int j = 0; j < 4; ++j) {
                double d2;
                double temp = Math.abs(A[i][j]);
                if (!(d2 > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                return 0.0;
            }
            vv[i] = 1.0 / big;
        }
        for (int j = 0; j < 4; ++j) {
            double dum;
            int i;
            for (int i2 = 0; i2 < j; ++i2) {
                double sum = A[i2][j];
                for (int k = 0; k < i2; ++k) {
                    sum -= A[i2][k] * A[k][j];
                }
                A[i2][j] = sum;
            }
            double big = 0.0;
            int imax = -1;
            for (i = j; i < 4; ++i) {
                double d3;
                double sum = A[i][j];
                for (int k = 0; k < j; ++k) {
                    sum -= A[i][k] * A[k][j];
                }
                A[i][j] = sum;
                dum = vv[i] * Math.abs(sum);
                if (!(d3 >= big)) continue;
                big = dum;
                imax = i;
            }
            if (j != imax) {
                for (int k = 0; k < 4; ++k) {
                    dum = A[imax][k];
                    A[imax][k] = A[j][k];
                    A[j][k] = dum;
                }
                d = -d;
                vv[imax] = vv[j];
            }
            indx[j] = imax;
            if (A[j][j] == 0.0) {
                A[j][j] = 1.0E-20;
            }
            if (j == 3) continue;
            dum = 1.0 / A[j][j];
            for (i = j + 1; i < 4; ++i) {
                double[] dArray = A[i];
                int n = j;
                dArray[n] = dArray[n] * dum;
            }
        }
        return d;
    }

    public final Vec4 getTranslation() {
        return new Vec4(this.m14, this.m24, this.m34);
    }

    public Vec4 extractEyePoint() {
        double x = -(this.m11 * this.m14) - this.m21 * this.m24 - this.m31 * this.m34;
        double y = -(this.m12 * this.m14) - this.m22 * this.m24 - this.m32 * this.m34;
        double z = -(this.m13 * this.m14) - this.m23 * this.m24 - this.m33 * this.m34;
        return new Vec4(x, y, z);
    }

    public Vec4 extractForwardVector() {
        return new Vec4(-this.m31, -this.m32, -this.m33);
    }

    private static boolean isZero(double value) {
        return POSITIVE_ZERO.compareTo(value) == 0 || NEGATIVE_ZERO.compareTo(value) == 0;
    }
}

