/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.math;

import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import thaumcraft.client.lib.math.Intersection;
import thaumcraft.client.lib.math.Line;
import thaumcraft.client.lib.math.Matrix;
import thaumcraft.client.lib.math.Plane;
import thaumcraft.client.lib.math.Vec4;

public class Math3d {
    public static final double SECOND_TO_MILLIS = 1000.0;
    public static final double MINUTE_TO_MILLIS = 60000.0;
    public static final double HOUR_TO_MILLIS = 3600000.0;
    public static final double DAY_TO_MILLIS = 8.64E7;
    public static final double METERS_TO_KILOMETERS = 0.001;
    public static final double METERS_TO_MILES = 6.21371192E-4;
    public static final double METERS_TO_NAUTICAL_MILES = 5.39956803E-4;
    public static final double METERS_TO_YARDS = 1.0936133;
    public static final double METERS_TO_FEET = 3.280839895;
    public static final double SQUARE_METERS_TO_SQUARE_KILOMETERS = 1.0E-6;
    public static final double SQUARE_METERS_TO_SQUARE_MILES = 3.86102159E-7;
    public static final double SQUARE_METERS_TO_SQUARE_YARDS = 1.19599005;
    public static final double SQUARE_METERS_TO_SQUARE_FEET = 10.7639104;
    public static final double SQUARE_METERS_TO_HECTARES = 1.0E-4;
    public static final double SQUARE_METERS_TO_ACRES = 2.47105381E-4;

    public static double logBase2(double value) {
        return Math.log(value) / Math.log(2.0);
    }

    public static boolean isPowerOfTwo(int value) {
        return value == Math3d.powerOfTwoCeiling(value);
    }

    public static int powerOfTwoCeiling(int reference) {
        int power = (int)Math.ceil(Math.log(reference) / Math.log(2.0));
        return (int)Math.pow(2.0, power);
    }

    public static int powerOfTwoFloor(int reference) {
        int power = (int)Math.floor(Math.log(reference) / Math.log(2.0));
        return (int)Math.pow(2.0, power);
    }

    protected static int[] computePowers(int base, int numPowers) {
        int[] powers = new int[numPowers];
        powers[0] = 1;
        for (int i = 1; i < numPowers; ++i) {
            int n = i;
            powers[n] = powers[n] + base * powers[i - 1];
        }
        return powers;
    }

    public static double clamp(double v, double min, double max) {
        return v < min ? min : (v > max ? max : v);
    }

    public static int clamp(int v, int min, int max) {
        return v < min ? min : (v > max ? max : v);
    }

    public static double stepValue(double value, double min, double max) {
        if (value <= min) {
            return 0.0;
        }
        if (value >= max) {
            return 1.0;
        }
        return (value - min) / (max - min);
    }

    public static double smoothStepValue(double value, double min, double max) {
        if (value <= min) {
            return 0.0;
        }
        if (value >= max) {
            return 1.0;
        }
        double step = (value - min) / (max - min);
        return step * step * (3.0 - 2.0 * step);
    }

    public static double computeInterpolationFactor(double v, double x, double y) {
        return Math3d.clamp((v - x) / (y - x), 0.0, 1.0);
    }

    public static double mix(double a, double x, double y) {
        double t = Math3d.clamp(a, 0.0, 1.0);
        return x + t * (y - x);
    }

    public static double mixSmooth(double a, double x, double y) {
        double t = Math3d.clamp(a, 0.0, 1.0);
        t = t * t * (3.0 - 2.0 * t);
        return x + t * (y - x);
    }

    public static double convertMetersToFeet(double meters) {
        return meters * 3.280839895;
    }

    public static double convertMetersToMiles(double meters) {
        return meters * 6.21371192E-4;
    }

    public static double convertFeetToMeters(double feet) {
        return feet / 3.280839895;
    }

    public static double convertSecondsToMillis(double seconds) {
        return seconds * 1000.0;
    }

    public static double convertMillisToSeconds(double millis) {
        return millis / 1000.0;
    }

    public static double convertMinutesToMillis(double minutes) {
        return minutes * 60000.0;
    }

    public static double convertMillisToMinutes(double millis) {
        return millis / 60000.0;
    }

    public static double convertHoursToMillis(double hours) {
        return hours * 3600000.0;
    }

    public static double convertMillisToHours(double mills) {
        return mills / 3600000.0;
    }

    public static double convertDaysToMillis(double millis) {
        return millis * 8.64E7;
    }

    public static double convertMillisToDays(double millis) {
        return millis / 8.64E7;
    }

    public static Vec4 computeArrayNormal(Vec4[] coords) {
        Vec4[] verts = Math3d.findThreeIndependentVertices(coords);
        return verts != null ? Math3d.computeTriangleNormal(verts[0], verts[1], verts[2]) : null;
    }

    public static Vec4[] findThreeIndependentVertices(FloatBuffer coords, int stride) {
        Vec4[] vec4Array;
        int k;
        int xstride;
        int n = xstride = stride > 0 ? stride : 3;
        if (coords == null || coords.limit() < 3 * xstride) {
            return null;
        }
        Vec4 a = new Vec4(coords.get(0), coords.get(1), coords.get(2));
        Vec4 b = null;
        Vec4 c = null;
        for (k = xstride; k < coords.limit(); k += xstride) {
            b = new Vec4(coords.get(k), coords.get(k + 1), coords.get(k + 2));
            if (b.x != a.x || b.y != a.y || b.z != a.z) break;
            b = null;
        }
        if (b == null) {
            return null;
        }
        k += xstride;
        while (k < coords.limit()) {
            c = new Vec4(coords.get(k), coords.get(k + 1), coords.get(k + 2));
            if (!(c.x == a.x && c.y == a.y && c.z == a.z || c.x == b.x && c.y == b.y && c.z == b.z || Vec4.areColinear(a, b, c))) break;
            c = null;
            k += xstride;
        }
        if (c != null) {
            Vec4[] vec4Array2 = new Vec4[3];
            vec4Array2[0] = a;
            vec4Array2[1] = b;
            vec4Array = vec4Array2;
            vec4Array2[2] = c;
        } else {
            vec4Array = null;
        }
        return vec4Array;
    }

    public static Vec4[] findThreeIndependentVertices(Vec4[] coords) {
        Vec4[] vec4Array;
        int k;
        if (coords == null || coords.length < 3) {
            return null;
        }
        Vec4 a = coords[0];
        Vec4 b = null;
        Vec4 c = null;
        for (k = 1; k < coords.length; ++k) {
            b = coords[k];
            if (b.x != a.x || b.y != a.y || b.z != a.z) break;
            b = null;
        }
        if (b == null) {
            return null;
        }
        while (k < coords.length) {
            c = coords[k];
            if (!(c.x == a.x && c.y == a.y && c.z == a.z || c.x == b.x && c.y == b.y && c.z == b.z || Vec4.areColinear(a, b, c))) break;
            c = null;
            ++k;
        }
        if (c != null) {
            Vec4[] vec4Array2 = new Vec4[3];
            vec4Array2[0] = a;
            vec4Array2[1] = b;
            vec4Array = vec4Array2;
            vec4Array2[2] = c;
        } else {
            vec4Array = null;
        }
        return vec4Array;
    }

    public static Vec4 computeTriangleNormal(Vec4 a, Vec4 b, Vec4 c) {
        if (a == null || b == null || c == null) {
            throw new IllegalArgumentException();
        }
        double x = (b.y - a.y) * (c.z - a.z) - (b.z - a.z) * (c.y - a.y);
        double y = (b.z - a.z) * (c.x - a.x) - (b.x - a.x) * (c.z - a.z);
        double z = (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
        double length = x * x + y * y + z * z;
        if (length == 0.0) {
            return new Vec4(x, y, z);
        }
        length = Math.sqrt(length);
        return new Vec4(x / length, y / length, z / length);
    }

    public static double computePolygonAreaFromVertices(Iterable<? extends Vec4> points) {
        Vec4 firstPoint;
        if (points == null) {
            throw new IllegalArgumentException();
        }
        Iterator<? extends Vec4> iter = points.iterator();
        if (!iter.hasNext()) {
            return 0.0;
        }
        double area = 0.0;
        Vec4 point = firstPoint = iter.next();
        while (iter.hasNext()) {
            Vec4 nextLocation = iter.next();
            area += point.x * nextLocation.y;
            area -= nextLocation.x * point.y;
            point = nextLocation;
        }
        if (!point.equals(firstPoint)) {
            area += point.x * firstPoint.y;
            area -= firstPoint.x * point.y;
        }
        return area /= 2.0;
    }

    public static Vec4[] computePrincipalAxes(Iterable<? extends Vec4> points) {
        if (points == null) {
            throw new IllegalArgumentException();
        }
        Matrix covariance = Matrix.fromCovarianceOfVertices(points);
        if (covariance == null) {
            return null;
        }
        final double[] eigenValues = new double[3];
        Vec4[] eigenVectors = new Vec4[3];
        Matrix.computeEigensystemFromSymmetricMatrix3(covariance, eigenValues, eigenVectors);
        Integer[] indexArray = new Integer[]{0, 1, 2};
        Arrays.sort(indexArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return Double.compare(eigenValues[a], eigenValues[b]);
            }
        });
        return new Vec4[]{eigenVectors[indexArray[2]].normalize3(), eigenVectors[indexArray[1]].normalize3(), eigenVectors[indexArray[0]].normalize3()};
    }

    public static boolean isPolygonClosed2(Iterable<? extends Vec4> points) {
        if (points == null) {
            throw new IllegalArgumentException();
        }
        Iterator<? extends Vec4> iter = points.iterator();
        if (!iter.hasNext()) {
            return false;
        }
        Vec4 firstPoint = iter.next();
        Vec4 lastPoint = null;
        while (iter.hasNext()) {
            lastPoint = iter.next();
        }
        return lastPoint != null && lastPoint.x == firstPoint.x && lastPoint.y == firstPoint.y;
    }

    public static boolean computeCircleThroughPoints(Vec4 p0, Vec4 p1, Vec4 p2, Vec4[] centerOut, Vec4[] axisOut, double[] radiusOut) {
        if (p0 == null || p1 == null || p2 == null) {
            throw new IllegalArgumentException();
        }
        Vec4 v0 = p1.subtract3(p0);
        Vec4 v1 = p2.subtract3(p1);
        Vec4 v2 = p2.subtract3(p0);
        double d0 = v0.dot3(v2);
        double d1 = -v0.dot3(v1);
        double d2 = v1.dot3(v2);
        double t0 = d1 + d2;
        double t1 = d0 + d2;
        double t2 = d0 + d1;
        double e0 = d0 * t0;
        double e1 = d1 * t1;
        double e2 = d2 * t2;
        double max_e = Math.max(Math.max(e0, e1), e2);
        double min_e = Math.min(Math.min(e0, e1), e2);
        double E = e0 + e1 + e2;
        double tolerance = 1.0E-6;
        if (Math.abs(E) <= tolerance * (max_e - min_e)) {
            return false;
        }
        double radiusSquared = 0.5 * t0 * t1 * t2 / E;
        if (radiusSquared < 0.0) {
            return false;
        }
        double radius = Math.sqrt(radiusSquared);
        Vec4 center = p0.multiply3(e0 / E);
        center = center.add3(p1.multiply3(e1 / E));
        center = center.add3(p2.multiply3(e2 / E));
        Vec4 axis = v2.cross3(v0);
        axis = axis.normalize3();
        if (centerOut != null) {
            centerOut[0] = center;
        }
        if (axisOut != null) {
            axisOut[0] = axis;
        }
        if (radiusOut != null) {
            radiusOut[0] = radius;
        }
        return true;
    }

    public static Intersection[] polytopeIntersect(Line line, Plane[] planes) {
        if (line == null) {
            throw new IllegalArgumentException();
        }
        double fMax = -1.7976931348623157E308;
        double bMin = Double.MAX_VALUE;
        boolean isTangent = false;
        Vec4 u = line.getDirection();
        Vec4 p = line.getOrigin();
        for (Plane plane : planes) {
            Vec4 n = plane.getNormal();
            double d = -plane.getDistance();
            double s = u.dot3(n);
            if (s == 0.0) {
                double pdn = p.dot3(n);
                if (pdn > d) {
                    return null;
                }
                if (pdn != d) continue;
                isTangent = true;
                continue;
            }
            double a = (d - p.dot3(n)) / s;
            if (u.dot3(n) < 0.0) {
                if (!(a > fMax)) continue;
                if (a > bMin) {
                    return null;
                }
                fMax = a;
                continue;
            }
            if (!(a < bMin)) continue;
            if (a < 0.0 || a < fMax) {
                return null;
            }
            bMin = a;
        }
        if (fMax >= 0.0) {
            return new Intersection[]{new Intersection(p.add3(u.multiply3(fMax)), isTangent), new Intersection(p.add3(u.multiply3(bMin)), isTangent)};
        }
        return new Intersection[]{new Intersection(p.add3(u.multiply3(bMin)), isTangent)};
    }
}

