/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.math;

import thaumcraft.client.lib.math.Intersection;
import thaumcraft.client.lib.math.Vec4;

public final class Line {
    private final Vec4 origin;
    private final Vec4 direction;

    public static Line fromSegment(Vec4 pa, Vec4 pb) {
        return new Line(pa, new Vec4(pb.x - pa.x, pb.y - pa.y, pb.z - pa.z, 0.0));
    }

    public Line(Vec4 origin, Vec4 direction) {
        String message = null;
        if (origin == null) {
            message = "nullValue.OriginIsNull";
        } else if (direction == null) {
            message = "nullValue.DirectionIsNull";
        } else if (direction.getLength3() <= 0.0) {
            message = "Geom.Line.DirectionIsZeroVector";
        }
        if (message != null) {
            throw new IllegalArgumentException();
        }
        this.origin = origin;
        this.direction = direction;
    }

    public final Vec4 getDirection() {
        return this.direction;
    }

    public final Vec4 getOrigin() {
        return this.origin;
    }

    public final Vec4 getPointAt(double t) {
        return Vec4.fromLine3(this.origin, t, this.direction);
    }

    public final double selfDot() {
        return this.origin.dot3(this.direction);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Line line = (Line)o;
        if (!this.direction.equals(line.direction)) {
            return false;
        }
        return line.origin.equals(this.origin);
    }

    public final int hashCode() {
        int result = this.origin.hashCode();
        result = 29 * result + this.direction.hashCode();
        return result;
    }

    public String toString() {
        return "Origin: " + this.origin + ", Direction: " + this.direction;
    }

    public final Vec4 nearestPointTo(Vec4 p) {
        Vec4 w = p.subtract3(this.origin);
        double c1 = w.dot3(this.direction);
        double c2 = this.direction.dot3(this.direction);
        return this.origin.add3(this.direction.multiply3(c1 / c2));
    }

    public final double distanceTo(Vec4 p) {
        return p.distanceTo3(this.nearestPointTo(p));
    }

    public static Vec4 nearestPointOnSegment(Vec4 p0, Vec4 p1, Vec4 p) {
        Vec4 v = p1.subtract3(p0);
        Vec4 w = p.subtract3(p0);
        double c1 = w.dot3(v);
        double c2 = v.dot3(v);
        if (c1 <= 0.0) {
            return p0;
        }
        if (c2 <= c1) {
            return p1;
        }
        return p0.add3(v.multiply3(c1 / c2));
    }

    public static double distanceToSegment(Vec4 p0, Vec4 p1, Vec4 p) {
        Vec4 pb = Line.nearestPointOnSegment(p0, p1, p);
        return p.distanceTo3(pb);
    }

    public boolean isPointBehindLineOrigin(Vec4 point) {
        double dot = point.subtract3(this.getOrigin()).dot3(this.getDirection());
        return dot < 0.0;
    }

    public Vec4 nearestIntersectionPoint(Intersection[] intersections) {
        Vec4 intersectionPoint = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Intersection intersection : intersections) {
            double d;
            if (this.isPointBehindLineOrigin(intersection.getIntersectionPoint()) || !((d = intersection.getIntersectionPoint().distanceTo3(this.getOrigin())) < nearestDistance)) continue;
            intersectionPoint = intersection.getIntersectionPoint();
            nearestDistance = d;
        }
        return intersectionPoint;
    }
}

