/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.math;

import thaumcraft.client.lib.math.Vec4;

public final class Intersection {
    protected Vec4 intersectionPoint;
    protected Double intersectionLength;
    protected boolean isTangent;
    protected Object object;

    public Intersection(Vec4 intersectionPoint, boolean isTangent) {
        if (intersectionPoint == null) {
            throw new IllegalArgumentException();
        }
        this.intersectionPoint = intersectionPoint;
        this.isTangent = isTangent;
    }

    public Intersection(Vec4 intersectionPoint, double intersectionLength, boolean isTangent) {
        this(intersectionPoint, isTangent);
        this.intersectionLength = intersectionLength;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Vec4 getIntersectionPoint() {
        return this.intersectionPoint;
    }

    public void setIntersectionPoint(Vec4 intersectionPoint) {
        this.intersectionPoint = intersectionPoint;
    }

    public boolean isTangent() {
        return this.isTangent;
    }

    public void setTangent(boolean tangent) {
        this.isTangent = tangent;
    }

    public Double getIntersectionLength() {
        return this.intersectionLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Intersection that = (Intersection)o;
        if (this.isTangent != that.isTangent) {
            return false;
        }
        return this.intersectionPoint.equals(that.intersectionPoint);
    }

    public int hashCode() {
        int result = this.intersectionPoint.hashCode();
        result = 29 * result + (this.isTangent ? 1 : 0);
        return result;
    }

    public String toString() {
        String pt = "Intersection Point: " + this.intersectionPoint;
        String tang = this.isTangent ? " is a tangent." : " not a tangent";
        return pt + tang;
    }
}

