/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.math;

import thaumcraft.client.lib.math.Intersection;
import thaumcraft.client.lib.math.Line;
import thaumcraft.client.lib.math.Plane;
import thaumcraft.client.lib.math.Vec4;

public class Cylinder {
    protected final Vec4 bottomCenter;
    protected final Vec4 topCenter;
    protected final Vec4 axisUnitDirection;
    protected final double cylinderRadius;
    protected final double cylinderHeight;

    public Cylinder(Vec4 bottomCenter, Vec4 topCenter, double cylinderRadius) {
        if (bottomCenter == null || topCenter == null || bottomCenter.equals(topCenter)) {
            throw new IllegalArgumentException();
        }
        if (cylinderRadius <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.bottomCenter = bottomCenter.toHomogeneousPoint3();
        this.topCenter = topCenter.toHomogeneousPoint3();
        this.cylinderHeight = this.bottomCenter.distanceTo3(this.topCenter);
        this.cylinderRadius = cylinderRadius;
        this.axisUnitDirection = this.topCenter.subtract3(this.bottomCenter).normalize3();
    }

    public Cylinder(Vec4 bottomCenter, Vec4 topCenter, double cylinderRadius, Vec4 unitDirection) {
        if (bottomCenter == null || topCenter == null || bottomCenter.equals(topCenter)) {
            throw new IllegalArgumentException();
        }
        if (cylinderRadius <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.bottomCenter = bottomCenter.toHomogeneousPoint3();
        this.topCenter = topCenter.toHomogeneousPoint3();
        this.cylinderHeight = this.bottomCenter.distanceTo3(this.topCenter);
        this.cylinderRadius = cylinderRadius;
        this.axisUnitDirection = unitDirection;
    }

    public Vec4 getAxisUnitDirection() {
        return this.axisUnitDirection;
    }

    public Vec4 getBottomCenter() {
        return this.bottomCenter;
    }

    public Vec4 getTopCenter() {
        return this.topCenter;
    }

    public double getCylinderRadius() {
        return this.cylinderRadius;
    }

    public double getCylinderHeight() {
        return this.cylinderHeight;
    }

    public Vec4 getCenter() {
        Vec4 b = this.bottomCenter;
        Vec4 t = this.topCenter;
        return new Vec4((b.x + t.x) / 2.0, (b.y + t.y) / 2.0, (b.z + t.z) / 2.0);
    }

    public double getDiameter() {
        return 2.0 * this.getRadius();
    }

    public double getRadius() {
        double halfHeight = this.bottomCenter.distanceTo3(this.topCenter) / 2.0;
        return Math.sqrt(halfHeight * halfHeight + this.cylinderRadius * this.cylinderRadius);
    }

    public double getVolume() {
        return Math.PI * this.cylinderRadius * this.cylinderRadius * this.cylinderHeight;
    }

    public Intersection[] intersect(Line line) {
        if (line == null) {
            throw new IllegalArgumentException();
        }
        double[] tVals = new double[2];
        if (!this.intcyl(line.getOrigin(), line.getDirection(), this.bottomCenter, this.axisUnitDirection, this.cylinderRadius, tVals)) {
            return null;
        }
        if (!this.clipcyl(line.getOrigin(), line.getDirection(), this.bottomCenter, this.topCenter, this.axisUnitDirection, tVals)) {
            return null;
        }
        if (!Double.isInfinite(tVals[0]) && !Double.isInfinite(tVals[1]) && tVals[0] >= 0.0 && tVals[1] >= 0.0) {
            return new Intersection[]{new Intersection(line.getPointAt(tVals[0]), false), new Intersection(line.getPointAt(tVals[1]), false)};
        }
        if (!Double.isInfinite(tVals[0]) && tVals[0] >= 0.0) {
            return new Intersection[]{new Intersection(line.getPointAt(tVals[0]), false)};
        }
        if (!Double.isInfinite(tVals[1]) && tVals[1] >= 0.0) {
            return new Intersection[]{new Intersection(line.getPointAt(tVals[1]), false)};
        }
        return null;
    }

    public boolean intersects(Line line) {
        if (line == null) {
            throw new IllegalArgumentException();
        }
        return this.intersect(line) != null;
    }

    protected boolean intcyl(Vec4 raybase, Vec4 raycos, Vec4 base, Vec4 axis, double radius, double[] tVals) {
        boolean hit;
        Vec4 RC = raybase.subtract3(base);
        Vec4 n = raycos.cross3(axis);
        double ln = n.getLength3();
        if (ln == 0.0) {
            double d = RC.dot3(axis);
            Vec4 D = RC.subtract3(axis.multiply3(d));
            d = D.getLength3();
            tVals[0] = Double.NEGATIVE_INFINITY;
            tVals[1] = Double.POSITIVE_INFINITY;
            return d <= radius;
        }
        double d = Math.abs(RC.dot3(n = n.normalize3()));
        boolean bl = hit = d <= radius;
        if (hit) {
            Vec4 O = RC.cross3(axis);
            double t = -O.dot3(n) / ln;
            O = n.cross3(axis);
            O = O.normalize3();
            double s = Math.abs(Math.sqrt(radius * radius - d * d) / raycos.dot3(O));
            tVals[0] = t - s;
            tVals[1] = t + s;
        }
        return hit;
    }

    protected boolean clipcyl(Vec4 raybase, Vec4 raycos, Vec4 bot, Vec4 top, Vec4 axis, double[] tVals) {
        double in = tVals[0];
        double out = tVals[1];
        double dc = axis.dot3(raycos);
        double dwb = axis.dot3(raybase) - axis.dot3(bot);
        double dwt = axis.dot3(raybase) - axis.dot3(top);
        if (dc == 0.0) {
            if (dwb <= 0.0) {
                return false;
            }
            if (dwt >= 0.0) {
                return false;
            }
        } else {
            double tb = -dwb / dc;
            double tt = -dwt / dc;
            if (dc >= 0.0) {
                if (tb > out) {
                    return false;
                }
                if (tt < in) {
                    return false;
                }
                if (tb > in && tb < out) {
                    in = tb;
                }
                if (tt > in && tt < out) {
                    out = tt;
                }
            } else {
                if (tb < in) {
                    return false;
                }
                if (tt > out) {
                    return false;
                }
                if (tb > in && tb < out) {
                    out = tb;
                }
                if (tt > in && tt < out) {
                    in = tt;
                }
            }
        }
        tVals[0] = in;
        tVals[1] = out;
        return in < out;
    }

    protected double intersects(Plane plane, double effectiveRadius) {
        boolean bq2;
        double dq1 = plane.dot(this.bottomCenter);
        boolean bq1 = dq1 <= -effectiveRadius;
        double dq2 = plane.dot(this.topCenter);
        boolean bl = bq2 = dq2 <= -effectiveRadius;
        if (bq1 && bq2) {
            return -1.0;
        }
        if (bq1 == bq2) {
            return 0.0;
        }
        return 1.0;
    }

    protected double intersectsAt(Plane plane, double effectiveRadius, Vec4[] endpoints) {
        boolean bq2;
        double dq1 = plane.dot(endpoints[0]);
        boolean bq1 = dq1 <= -effectiveRadius;
        double dq2 = plane.dot(endpoints[1]);
        boolean bl = bq2 = dq2 <= -effectiveRadius;
        if (bq1 && bq2) {
            return -1.0;
        }
        if (bq1 == bq2) {
            return 0.0;
        }
        double t = (effectiveRadius + dq1) / plane.getNormal().dot3(endpoints[0].subtract3(endpoints[1]));
        Vec4 newEndPoint = endpoints[0].add3(endpoints[1].subtract3(endpoints[0]).multiply3(t));
        if (bq1) {
            endpoints[0] = newEndPoint;
        } else {
            endpoints[1] = newEndPoint;
        }
        return t;
    }

    public double getEffectiveRadius(Plane plane) {
        if (plane == null) {
            return 0.0;
        }
        double dot = plane.getNormal().dot3(this.axisUnitDirection);
        double scale = 1.0 - dot * dot;
        if (scale <= 0.0) {
            return 0.0;
        }
        return this.cylinderRadius * Math.sqrt(scale);
    }

    public boolean intersects(Plane plane) {
        if (plane == null) {
            throw new IllegalArgumentException();
        }
        double effectiveRadius = this.getEffectiveRadius(plane);
        return this.intersects(plane, effectiveRadius) >= 0.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cylinder)) {
            return false;
        }
        Cylinder cylinder = (Cylinder)o;
        if (Double.compare(cylinder.cylinderHeight, this.cylinderHeight) != 0) {
            return false;
        }
        if (Double.compare(cylinder.cylinderRadius, this.cylinderRadius) != 0) {
            return false;
        }
        if (this.axisUnitDirection != null ? !this.axisUnitDirection.equals(cylinder.axisUnitDirection) : cylinder.axisUnitDirection != null) {
            return false;
        }
        if (this.bottomCenter != null ? !this.bottomCenter.equals(cylinder.bottomCenter) : cylinder.bottomCenter != null) {
            return false;
        }
        return !(this.topCenter != null ? !this.topCenter.equals(cylinder.topCenter) : cylinder.topCenter != null);
    }

    public int hashCode() {
        int result = this.bottomCenter != null ? this.bottomCenter.hashCode() : 0;
        result = 31 * result + (this.topCenter != null ? this.topCenter.hashCode() : 0);
        result = 31 * result + (this.axisUnitDirection != null ? this.axisUnitDirection.hashCode() : 0);
        long temp = this.cylinderRadius != 0.0 ? Double.doubleToLongBits(this.cylinderRadius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.cylinderHeight != 0.0 ? Double.doubleToLongBits(this.cylinderHeight) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return this.cylinderRadius + ", " + this.bottomCenter.toString() + ", " + this.topCenter.toString() + ", " + this.axisUnitDirection.toString();
    }
}

