/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.math;

import java.util.ArrayList;
import java.util.Arrays;
import thaumcraft.client.lib.math.Intersection;
import thaumcraft.client.lib.math.Line;
import thaumcraft.client.lib.math.Math3d;
import thaumcraft.client.lib.math.Plane;
import thaumcraft.client.lib.math.Vec4;

public class Box {
    protected static final int[][] ProjectionHullTable = new int[][]{null, {7, 6, 5, 4}, {0, 1, 2, 3}, null, {3, 2, 6, 7}, {3, 2, 6, 5, 4, 7}, {0, 1, 2, 6, 7, 3}, null, {1, 0, 4, 5}, {1, 0, 4, 7, 6, 5}, {2, 3, 0, 4, 5, 1}, null, null, null, null, null, {2, 1, 5, 6}, {2, 1, 5, 4, 7, 6}, {3, 0, 1, 5, 6, 2}, null, {3, 2, 1, 5, 6, 7}, {3, 2, 1, 5, 4, 7}, {3, 0, 1, 5, 6, 7}, null, {2, 1, 0, 4, 5, 6}, {2, 1, 0, 4, 7, 6}, {2, 3, 0, 4, 5, 6}, null, null, null, null, null, {0, 3, 7, 4}, {0, 3, 7, 6, 5, 4}, {1, 2, 3, 7, 4, 0}, null, {0, 3, 2, 6, 7, 4}, {0, 3, 2, 6, 5, 4}, {0, 1, 2, 6, 7, 4}, null, {1, 0, 3, 7, 4, 5}, {1, 0, 3, 7, 6, 5}, {1, 2, 3, 7, 4, 5}};
    public Vec4 bottomCenter;
    public Vec4 topCenter;
    protected final Vec4 center;
    protected final Vec4 r;
    protected final Vec4 s;
    protected final Vec4 t;
    protected final Vec4 ru;
    protected final Vec4 su;
    protected final Vec4 tu;
    protected final double rLength;
    protected final double sLength;
    protected final double tLength;
    protected final Plane[] planes;

    protected Box(Vec4 bottomCenter, Vec4 topCenter, Vec4 center, Vec4 r, Vec4 s, Vec4 t, Vec4 ru, Vec4 su, Vec4 tu, double rlength, double sLength, double tLength, Plane[] planes) {
        this.bottomCenter = bottomCenter;
        this.topCenter = topCenter;
        this.center = center;
        this.r = r;
        this.s = s;
        this.t = t;
        this.ru = ru;
        this.su = su;
        this.tu = tu;
        this.rLength = rlength;
        this.sLength = sLength;
        this.tLength = tLength;
        this.planes = planes;
    }

    public Box(Vec4[] axes, double rMin, double rMax, double sMin, double sMax, double tMin, double tMax) {
        if (axes == null || axes[0] == null || axes[1] == null || axes[2] == null) {
            throw new IllegalArgumentException();
        }
        this.ru = axes[0];
        this.su = axes[1];
        this.tu = axes[2];
        this.r = this.ru.multiply3(rMax - rMin);
        this.s = this.su.multiply3(sMax - sMin);
        this.t = this.tu.multiply3(tMax - tMin);
        this.rLength = this.r.getLength3();
        this.sLength = this.s.getLength3();
        this.tLength = this.t.getLength3();
        this.planes = new Plane[6];
        this.planes[0] = new Plane(-this.ru.x, -this.ru.y, -this.ru.z, rMin);
        this.planes[1] = new Plane(this.ru.x, this.ru.y, this.ru.z, -rMax);
        this.planes[2] = new Plane(-this.su.x, -this.su.y, -this.su.z, sMin);
        this.planes[3] = new Plane(this.su.x, this.su.y, this.su.z, -sMax);
        this.planes[4] = new Plane(-this.tu.x, -this.tu.y, -this.tu.z, tMin);
        this.planes[5] = new Plane(this.tu.x, this.tu.y, this.tu.z, -tMax);
        double a = 0.5 * (rMin + rMax);
        double b = 0.5 * (sMin + sMax);
        double c = 0.5 * (tMin + tMax);
        this.center = this.ru.multiply3(a).add3(this.su.multiply3(b)).add3(this.tu.multiply3(c));
        Vec4 rHalf = this.r.multiply3(0.5);
        this.topCenter = this.center.add3(rHalf);
        this.bottomCenter = this.center.subtract3(rHalf);
    }

    public Box(Vec4 point) {
        if (point == null) {
            throw new IllegalArgumentException();
        }
        this.ru = new Vec4(1.0, 0.0, 0.0, 1.0);
        this.su = new Vec4(0.0, 1.0, 0.0, 1.0);
        this.tu = new Vec4(0.0, 0.0, 1.0, 1.0);
        this.r = this.ru;
        this.s = this.su;
        this.t = this.tu;
        this.rLength = 1.0;
        this.sLength = 1.0;
        this.tLength = 1.0;
        this.planes = new Plane[6];
        double d = 0.5 * point.getLength3();
        this.planes[0] = new Plane(-this.ru.x, -this.ru.y, -this.ru.z, -(d + 0.5));
        this.planes[1] = new Plane(this.ru.x, this.ru.y, this.ru.z, -(d + 0.5));
        this.planes[2] = new Plane(-this.su.x, -this.su.y, -this.su.z, -(d + 0.5));
        this.planes[3] = new Plane(this.su.x, this.su.y, this.su.z, -(d + 0.5));
        this.planes[4] = new Plane(-this.tu.x, -this.tu.y, -this.tu.z, -(d + 0.5));
        this.planes[5] = new Plane(this.tu.x, this.tu.y, this.tu.z, -(d + 0.5));
        this.center = this.ru.add3(this.su).add3(this.tu).multiply3(0.5);
        Vec4 rHalf = this.r.multiply3(0.5);
        this.topCenter = this.center.add3(rHalf);
        this.bottomCenter = this.center.subtract3(rHalf);
    }

    public Vec4 getCenter() {
        return this.center;
    }

    public Vec4 getBottomCenter() {
        return this.bottomCenter;
    }

    public Vec4 getTopCenter() {
        return this.topCenter;
    }

    public Vec4 getRAxis() {
        return this.r;
    }

    public Vec4 getSAxis() {
        return this.s;
    }

    public Vec4 getTAxis() {
        return this.t;
    }

    public Vec4 getUnitRAxis() {
        return this.ru;
    }

    public Vec4 getUnitSAxis() {
        return this.su;
    }

    public Vec4 getUnitTAxis() {
        return this.tu;
    }

    public Vec4[] getCorners() {
        Vec4 ll = this.s.add3(this.t).multiply3(-0.5);
        Vec4 lr = this.t.subtract3(this.s).multiply3(0.5);
        Vec4 ur = this.s.add3(this.t).multiply3(0.5);
        Vec4 ul = this.s.subtract3(this.t).multiply3(0.5);
        Vec4[] corners = new Vec4[]{this.bottomCenter.add3(ll), this.bottomCenter.add3(lr), this.bottomCenter.add3(ur), this.bottomCenter.add3(ul), this.topCenter.add3(ll), this.topCenter.add3(lr), this.topCenter.add3(ur), this.topCenter.add3(ul)};
        return corners;
    }

    public Plane[] getPlanes() {
        return this.planes;
    }

    public double getRLength() {
        return this.rLength;
    }

    public double getSLength() {
        return this.sLength;
    }

    public double getTLength() {
        return this.tLength;
    }

    public double getDiameter() {
        return Math.sqrt(this.rLength * this.rLength + this.sLength * this.sLength + this.tLength * this.tLength);
    }

    public double getRadius() {
        return 0.5 * this.getDiameter();
    }

    public Box translate(Vec4 point) {
        Vec4 bc = this.bottomCenter.add3(point);
        Vec4 tc = this.topCenter.add3(point);
        Vec4 c = this.center.add3(point);
        Plane[] newPlanes = new Plane[this.planes.length];
        for (int i = 0; i < this.planes.length; ++i) {
            Plane pl = this.planes[i];
            Vec4 n = pl.getNormal();
            newPlanes[i] = new Plane(n.x, n.y, n.z, pl.getDistance() - n.dot3(point));
        }
        return new Box(bc, tc, c, this.r, this.s, this.t, this.ru, this.su, this.tu, this.rLength, this.sLength, this.tLength, newPlanes);
    }

    public static Box computeBoundingBox(Iterable<? extends Vec4> points) {
        if (points == null) {
            throw new IllegalArgumentException();
        }
        Vec4[] axes = Math3d.computePrincipalAxes(points);
        if (axes == null) {
            throw new IllegalArgumentException();
        }
        Vec4 r = axes[0];
        Vec4 s = axes[1];
        Vec4 t = axes[2];
        double minDotR = Double.MAX_VALUE;
        double maxDotR = -minDotR;
        double minDotS = Double.MAX_VALUE;
        double maxDotS = -minDotS;
        double minDotT = Double.MAX_VALUE;
        double maxDotT = -minDotT;
        for (Vec4 vec4 : points) {
            double pdt;
            double pds;
            if (vec4 == null) continue;
            double pdr = vec4.dot3(r);
            if (pdr < minDotR) {
                minDotR = pdr;
            }
            if (pdr > maxDotR) {
                maxDotR = pdr;
            }
            if ((pds = vec4.dot3(s)) < minDotS) {
                minDotS = pds;
            }
            if (pds > maxDotS) {
                maxDotS = pds;
            }
            if ((pdt = vec4.dot3(t)) < minDotT) {
                minDotT = pdt;
            }
            if (!(pdt > maxDotT)) continue;
            maxDotT = pdt;
        }
        if (maxDotR == minDotR) {
            maxDotR = minDotR + 1.0;
        }
        if (maxDotS == minDotS) {
            maxDotS = minDotS + 1.0;
        }
        if (maxDotT == minDotT) {
            maxDotT = minDotT + 1.0;
        }
        return new Box(axes, minDotR, maxDotR, minDotS, maxDotS, minDotT, maxDotT);
    }

    public static Box union(Iterable<? extends Box> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Box> boxes = new ArrayList<Box>();
        for (Box box : iterable) {
            if (box == null) continue;
            boxes.add(box);
        }
        if (boxes.size() == 0) {
            return null;
        }
        if (boxes.size() == 1) {
            return (Box)boxes.get(0);
        }
        ArrayList<Vec4> corners = new ArrayList<Vec4>(8 * boxes.size());
        for (Box box : boxes) {
            corners.addAll(Arrays.asList(box.getCorners()));
        }
        return Box.computeBoundingBox(corners);
    }

    protected double getEffectiveRadius2(Plane plane) {
        if (plane == null) {
            return 0.0;
        }
        Vec4 n = plane.getNormal();
        return 0.5 * (Math.abs(this.s.dot3(n)) + Math.abs(this.t.dot3(n)));
    }

    public double getEffectiveRadius(Plane plane) {
        if (plane == null) {
            return 0.0;
        }
        Vec4 n = plane.getNormal();
        return 0.5 * (Math.abs(this.s.dot3(n)) + Math.abs(this.t.dot3(n)) + Math.abs(this.r.dot3(n)));
    }

    protected double intersectsAt(Plane plane, double effectiveRadius, Vec4[] endpoints) {
        boolean bq2;
        double dq1 = plane.dot(endpoints[0]);
        boolean bq1 = dq1 <= -effectiveRadius;
        double dq2 = plane.dot(endpoints[1]);
        boolean bl = bq2 = dq2 <= -effectiveRadius;
        if (bq1 && bq2) {
            return -1.0;
        }
        if (bq1 == bq2) {
            return 0.0;
        }
        double t = (effectiveRadius + dq1) / plane.getNormal().dot3(endpoints[0].subtract3(endpoints[1]));
        Vec4 newEndPoint = endpoints[0].add3(endpoints[1].subtract3(endpoints[0]).multiply3(t));
        if (bq1) {
            endpoints[0] = newEndPoint;
        } else {
            endpoints[1] = newEndPoint;
        }
        return t;
    }

    public boolean intersects(Plane plane) {
        if (plane == null) {
            throw new IllegalArgumentException();
        }
        double effectiveRadius = this.getEffectiveRadius(plane);
        return this.intersects(plane, effectiveRadius) >= 0.0;
    }

    protected double intersects(Plane plane, double effectiveRadius) {
        boolean bq2;
        double dq1 = plane.dot(this.bottomCenter);
        boolean bq1 = dq1 <= -effectiveRadius;
        double dq2 = plane.dot(this.topCenter);
        boolean bl = bq2 = dq2 <= -effectiveRadius;
        if (bq1 && bq2) {
            return -1.0;
        }
        if (bq1 == bq2) {
            return 0.0;
        }
        return 1.0;
    }

    public Intersection[] intersect(Line line) {
        return Math3d.polytopeIntersect(line, this.planes);
    }

    public boolean intersects(Line line) {
        if (line == null) {
            throw new IllegalArgumentException();
        }
        return Math3d.polytopeIntersect(line, this.planes) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Box)) {
            return false;
        }
        Box box = (Box)o;
        if (this.center != null ? !this.center.equals(box.center) : box.center != null) {
            return false;
        }
        if (this.r != null ? !this.r.equals(box.r) : box.r != null) {
            return false;
        }
        if (this.s != null ? !this.s.equals(box.s) : box.s != null) {
            return false;
        }
        return !(this.t != null ? !this.t.equals(box.t) : box.t != null);
    }

    public int hashCode() {
        int result = this.center != null ? this.center.hashCode() : 0;
        result = 31 * result + (this.r != null ? this.r.hashCode() : 0);
        result = 31 * result + (this.s != null ? this.s.hashCode() : 0);
        result = 31 * result + (this.t != null ? this.t.hashCode() : 0);
        return result;
    }
}

