/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib;

import baubles.api.BaublesApi;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.golems.ISealDisplayer;
import thaumcraft.api.golems.seals.ISealConfigArea;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.seals.SealPos;
import thaumcraft.api.items.IArchitect;
import thaumcraft.api.items.IArchitectExtended;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXSpark;
import thaumcraft.client.gui.GuiResearchPopup;
import thaumcraft.client.lib.HudHandler;
import thaumcraft.client.lib.ShaderHandler;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.lib.WandRenderingHandler;
import thaumcraft.codechicken.lib.raytracer.RayTracer;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.EntityTaintSource;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.monster.mods.ChampionModifier;
import thaumcraft.common.items.armor.ItemFortressArmor;
import thaumcraft.common.items.armor.ItemVoidRobeArmor;
import thaumcraft.common.items.tools.ItemSanityChecker;
import thaumcraft.common.items.tools.ItemThaumometer;
import thaumcraft.common.lib.events.EssentiaHandler;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketNote;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.tiles.crafting.TileInfusionMatrix;
import thaumcraft.common.tiles.devices.TileArcaneEar;
import thaumcraft.common.tiles.devices.TileRechargePedestal;
import thaumcraft.common.tiles.devices.TileRedstoneRelay;

public class RenderEventHandler {
    @SideOnly(value=Side.CLIENT)
    HudHandler hudHandler = new HudHandler();
    @SideOnly(value=Side.CLIENT)
    WandRenderingHandler wandHandler = new WandRenderingHandler();
    @SideOnly(value=Side.CLIENT)
    ShaderHandler shaderhandler = new ShaderHandler();
    public static List blockTags = new ArrayList();
    public static float tagscale = 0.0f;
    public static GuiResearchPopup researchPopup = null;
    public int tickCount = 0;
    int prevWorld;
    boolean checkedDate = false;
    private Random random = new Random();
    public static TreeMap<Integer, ChargeEntry> chargedItems = new TreeMap();
    public static boolean resetShaders = false;
    private static int oldDisplayWidth = 0;
    private static int oldDisplayHeight = 0;
    final ResourceLocation CFRAME = new ResourceLocation("thaumcraft", "textures/misc/frame_corner.png");
    final ResourceLocation MIDDLE = new ResourceLocation("thaumcraft", "textures/misc/seal_area.png");
    EnumFacing[][] rotfaces = new EnumFacing[][]{{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.NORTH, EnumFacing.WEST}, {EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST}, {EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.EAST}, {EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.WEST}};
    int[][] rotmat = new int[][]{{0, 270, 0}, {270, 180, 270}, {90, 0, 90}, {180, 90, 180}, {180, 180, 0}, {90, 270, 270}, {270, 90, 90}, {0, 0, 180}};
    public static final ResourceLocation rainTexture = new ResourceLocation("textures/environment/rain.png");
    private float[] rainXCoords = null;
    private float[] rainYCoords = null;
    public static ConcurrentHashMap<Integer, EntityTaintSource> clouds = new ConcurrentHashMap();
    public static HashMap<Integer, ShaderGroup> shaderGroups = new HashMap();
    public static boolean fogFiddled = false;
    public static float fogTarget = 0.0f;
    public static int fogDuration = 0;
    public static float prevVignetteBrightness = 0.0f;
    public static float targetBrightness = 1.0f;
    protected static final ResourceLocation vignetteTexPath = new ResourceLocation("thaumcraft", "textures/misc/vignette.png");

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            if (event.player.field_70173_aa % 20 == 0) {
                this.checkChargedItems(event.player);
            }
            if (event.player.func_71011_bu() != null && event.player.func_71011_bu().func_77973_b() instanceof IWand) {
                event.player.func_71008_a(event.player.func_70694_bm(), event.player.func_71052_bv());
            }
            try {
                if (event.player.func_145782_y() == mc.field_71439_g.func_145782_y()) {
                    this.shaderhandler.checkShaders(event, mc);
                    if (ShaderHandler.warpVignette > 0) {
                        --ShaderHandler.warpVignette;
                        targetBrightness = 0.0f;
                    } else {
                        targetBrightness = 1.0f;
                    }
                    if (fogFiddled) {
                        if (fogDuration < 100) {
                            fogTarget = 0.1f * ((float)fogDuration / 100.0f);
                        } else if (fogTarget < 0.1f) {
                            fogTarget += 0.001f;
                        }
                        if (--fogDuration < 0) {
                            fogFiddled = false;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void checkChargedItems(EntityPlayer player) {
        int a;
        long time = System.currentTimeMillis();
        int count = 0;
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        int a2 = 0;
        while (true) {
            EntityPlayer entityPlayer = player;
            if (a2 >= entityPlayer.field_71071_by.func_70451_h()) break;
            if (inv[a2] != null && inv[a2].func_77973_b() instanceof IRechargable) {
                this.addItemToChargedList(inv[a2], count, time);
            } else {
                chargedItems.remove(count);
            }
            ++count;
            ++a2;
        }
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (a = 0; a < 4; ++a) {
            if (baubles.func_70301_a(a) != null && baubles.func_70301_a(a).func_77973_b() instanceof IRechargable) {
                this.addItemToChargedList(baubles.func_70301_a(a), count, time);
            } else {
                chargedItems.remove(count);
            }
            ++count;
        }
        inv = player.field_71071_by.field_70460_b;
        for (a = 0; a < inv.length; ++a) {
            if (inv[a] != null && inv[a].func_77973_b() instanceof IRechargable) {
                this.addItemToChargedList(inv[a], count, time);
            } else {
                chargedItems.remove(count);
            }
            ++count;
        }
    }

    private void addItemToChargedList(ItemStack item, int count, long time) {
        float nc = ((IRechargable)item.func_77973_b()).getChargeLevel(item);
        if (nc < 0.0f) {
            chargedItems.remove(count);
            return;
        }
        ChargeEntry ce = chargedItems.get(count);
        if (ce != null && ce.item.func_77973_b() == item.func_77973_b() && ce.charge != nc) {
            ce.diff = nc > ce.charge ? (byte)1 : (byte)-1;
            ce.tickTime = time;
            ce.charge = nc;
            ce.time = ce.time < time - 9500L ? time : time - 500L;
        } else if (ce == null) {
            chargedItems.put(count, new ChargeEntry(time, item, nc));
        } else {
            ce.diff = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientWorldTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.SERVER) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldClient world = mc.field_71441_e;
        if (event.phase == TickEvent.Phase.START) {
            ItemStack itr;
            if (mc.field_71439_g != null && mc.field_71439_g.func_70694_bm() != null && mc.field_71439_g.func_70694_bm().func_77973_b() instanceof IWand && (itr = this.getItemToRender(mc.func_175597_ag())) != null && itr.func_77973_b() instanceof IWand) {
                this.setItemToRender(mc.func_175597_ag(), mc.field_71439_g.func_70694_bm());
            }
            ++this.tickCount;
            for (String fxk : EssentiaHandler.sourceFX.keySet().toArray(new String[0])) {
                EssentiaHandler.EssentiaSourceFX fx = EssentiaHandler.sourceFX.get(fxk);
                if (world == null) continue;
                int mod = 0;
                TileEntity tile = world.func_175625_s(fx.start);
                if (tile != null && tile instanceof TileInfusionMatrix) {
                    mod = -1;
                }
                Thaumcraft.proxy.getFX().essentiaTrailFx(fx.end, fx.start.func_177981_b(mod), this.tickCount, fx.color, 0.1f, fx.ext);
                EssentiaHandler.sourceFX.remove(fxk);
            }
        } else if (mc.field_71441_e != null && !this.checkedDate) {
            this.checkedDate = true;
            Calendar calendar = mc.field_71441_e.func_83015_S();
            if (calendar.get(2) + 1 == 10 && calendar.get(5) == 31) {
                Thaumcraft.isHalloween = true;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        block15: {
            long time;
            EntityPlayer player;
            Minecraft mc;
            block16: {
                GuiScreen gui;
                block18: {
                    block17: {
                        block14: {
                            if (event.phase != TickEvent.Phase.START) break block14;
                            UtilsFX.sysPartialTicks = event.renderTickTime;
                            break block15;
                        }
                        mc = FMLClientHandler.instance().getClient();
                        WorldClient world = mc.field_71441_e;
                        if (!(Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer)) break block15;
                        player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
                        time = System.currentTimeMillis();
                        if (researchPopup == null) {
                            researchPopup = new GuiResearchPopup(mc);
                        }
                        researchPopup.updateResearchWindow();
                        gui = mc.field_71462_r;
                        if (!(gui instanceof GuiContainer)) break block16;
                        if (!gui.func_146272_n()) break block17;
                        if (!Config.showTags) break block18;
                    }
                    if (gui.func_146272_n() || !Config.showTags) break block16;
                }
                if (!Mouse.isGrabbed()) {
                    this.hudHandler.renderAspectsInGui((GuiContainer)gui, player);
                }
            }
            if (player != null && mc.field_71415_G) {
                if (mc.func_71382_s()) {
                    if (chargedItems.size() > 0) {
                        this.hudHandler.renderChargeMeters(mc, event.renderTickTime, player, time);
                    }
                    if (player.func_70694_bm() != null) {
                        if (player.func_70694_bm().func_77973_b() instanceof ItemThaumometer) {
                            this.hudHandler.renderThaumometerHud(mc, Float.valueOf(event.renderTickTime), player, time);
                        } else if (player.func_70694_bm().func_77973_b() instanceof IWand) {
                            this.hudHandler.renderCastingWandHud(mc, event.renderTickTime, player, time, player.func_70694_bm());
                        } else if (player.func_70694_bm().func_77973_b() instanceof ItemSanityChecker) {
                            this.hudHandler.renderSanityHud(mc, Float.valueOf(event.renderTickTime), player, time);
                        }
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        long time = System.nanoTime() / 1000000L;
        if (event.type == RenderGameOverlayEvent.ElementType.TEXT) {
            this.wandHandler.handleFociRadial(mc, time, event);
        }
        if (event.type == RenderGameOverlayEvent.ElementType.PORTAL) {
            this.renderVignette(targetBrightness, event.resolution.func_78327_c(), event.resolution.func_78324_d());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderShaders(RenderGameOverlayEvent.Pre event) {
        if (Config.shaders && event.type == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft mc = Minecraft.func_71410_x();
            if (OpenGlHelper.field_148824_g) {
                if (shaderGroups.size() > 0) {
                    this.updateShaderFrameBuffers(mc);
                    GL11.glMatrixMode((int)5890);
                    GL11.glLoadIdentity();
                    for (ShaderGroup sg : shaderGroups.values()) {
                        GL11.glPushMatrix();
                        try {
                            sg.func_148018_a(event.partialTicks);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        GL11.glPopMatrix();
                    }
                    mc.func_147110_a().func_147610_a(true);
                }
            }
        }
    }

    private void updateShaderFrameBuffers(Minecraft mc) {
        if (resetShaders || mc.field_71443_c != oldDisplayWidth || oldDisplayHeight != mc.field_71440_d) {
            for (ShaderGroup sg : shaderGroups.values()) {
                sg.func_148026_a(mc.field_71443_c, mc.field_71440_d);
            }
            oldDisplayWidth = mc.field_71443_c;
            oldDisplayHeight = mc.field_71440_d;
            resetShaders = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void blockHighlight(DrawBlockHighlightEvent event) {
        int ticks = event.player.field_70173_aa;
        MovingObjectPosition target = event.target;
        if (blockTags.size() > 0) {
            int x = (Integer)blockTags.get(0);
            int y = (Integer)blockTags.get(1);
            int z = (Integer)blockTags.get(2);
            AspectList ot = (AspectList)blockTags.get(3);
            EnumFacing dir = EnumFacing.field_82609_l[(Integer)blockTags.get(4)];
            if (x == target.func_178782_a().func_177958_n() && y == target.func_178782_a().func_177956_o() && z == target.func_178782_a().func_177952_p()) {
                if (tagscale < 0.5f) {
                    tagscale += 0.031f - tagscale / 10.0f;
                }
                RenderEventHandler.drawTagsOnContainer((float)target.func_178782_a().func_177958_n() + (float)dir.func_82601_c() / 2.0f, (float)target.func_178782_a().func_177956_o() + (float)dir.func_96559_d() / 2.0f, (float)target.func_178782_a().func_177952_p() + (float)dir.func_82599_e() / 2.0f, ot, 220, dir, event.partialTicks);
            }
        }
        if (target != null && target.func_178782_a() != null) {
            MovingObjectPosition hit;
            TileEntity te = event.player.field_70170_p.func_175625_s(target.func_178782_a());
            if (te != null && te instanceof TileRedstoneRelay && (hit = RayTracer.retraceBlock(event.player.field_70170_p, event.player, target.func_178782_a())) != null) {
                if (hit.subHit == 0) {
                    this.drawTextInAir(target.func_178782_a().func_177958_n(), (double)target.func_178782_a().func_177956_o() + 0.3, target.func_178782_a().func_177952_p(), event.partialTicks, "Out: " + ((TileRedstoneRelay)te).getOut());
                } else if (hit.subHit == 1) {
                    this.drawTextInAir(target.func_178782_a().func_177958_n(), (double)target.func_178782_a().func_177956_o() + 0.3, target.func_178782_a().func_177952_p(), event.partialTicks, "In: " + ((TileRedstoneRelay)te).getIn());
                }
            }
            if (EntityUtils.hasGoggles((Entity)event.player)) {
                boolean spaceAbove = event.player.field_70170_p.func_175623_d(target.func_178782_a().func_177984_a());
                if (te != null) {
                    int note = -1;
                    if (te instanceof TileEntityNote) {
                        note = ((TileEntityNote)te).field_145879_a;
                    } else if (te instanceof TileArcaneEar) {
                        note = ((TileArcaneEar)te).note;
                    } else if (te instanceof IAspectContainer && ((IAspectContainer)te).getAspects() != null && ((IAspectContainer)te).getAspects().size() > 0) {
                        float shift = 0.0f;
                        if (te instanceof TileRechargePedestal) {
                            shift = 0.6f;
                        }
                        if (tagscale < 0.3f) {
                            tagscale += 0.031f - tagscale / 10.0f;
                        }
                        RenderEventHandler.drawTagsOnContainer(target.func_178782_a().func_177958_n(), (float)target.func_178782_a().func_177956_o() + (spaceAbove ? 0.4f : 0.0f) + shift, target.func_178782_a().func_177952_p(), ((IAspectContainer)te).getAspects(), 220, spaceAbove ? EnumFacing.UP : event.target.field_178784_b, event.partialTicks);
                    }
                    if (note >= 0) {
                        if (ticks % 5 == 0) {
                            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNote(target.func_178782_a().func_177958_n(), target.func_178782_a().func_177956_o(), target.func_178782_a().func_177952_p(), event.player.field_70170_p.field_73011_w.func_177502_q()));
                        }
                        this.drawTextInAir(target.func_178782_a().func_177958_n(), target.func_178782_a().func_177956_o() + 1, target.func_178782_a().func_177952_p(), event.partialTicks, "Note: " + note);
                    }
                }
            }
        }
        if (target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && event.player.func_70694_bm() != null && event.player.func_70694_bm().func_77973_b() instanceof IArchitect && !(event.player.func_70694_bm().func_77973_b() instanceof ItemFocusBasic)) {
            boolean proceed = true;
            MovingObjectPosition target2 = null;
            if (event.player.func_70694_bm().func_77973_b() instanceof IArchitectExtended) {
                proceed = ((IArchitectExtended)event.player.func_70694_bm().func_77973_b()).useBlockHighlight(event.player.func_70694_bm());
                target2 = ((IArchitectExtended)event.player.func_70694_bm().func_77973_b()).getArchitectMOP(event.player.func_70694_bm(), event.player.field_70170_p, (EntityLivingBase)event.player);
            }
            if (proceed && this.wandHandler.handleArchitectOverlay(event.player.func_70694_bm(), event.player, event.partialTicks, ticks, target2 == null ? target : target2)) {
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        if (tagscale > 0.0f) {
            tagscale -= 0.005f;
        }
        float partialTicks = event.partialTicks;
        Minecraft mc = Minecraft.func_71410_x();
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)mc.func_175606_aa();
            long time = System.currentTimeMillis();
            if (player.func_70694_bm() != null) {
                if (player.func_70694_bm().func_77973_b() instanceof ISealDisplayer) {
                    this.drawSeals(event, partialTicks, player, time);
                }
                if (player.func_70694_bm().func_77973_b() instanceof IArchitectExtended && !(player.func_70694_bm().func_77973_b() instanceof ItemFocusBasic)) {
                    MovingObjectPosition target = ((IArchitectExtended)player.func_70694_bm().func_77973_b()).getArchitectMOP(player.func_70694_bm(), player.field_70170_p, (EntityLivingBase)player);
                    this.wandHandler.handleArchitectOverlay(player.func_70694_bm(), player, partialTicks, player.field_70173_aa, target);
                }
            }
            if (!clouds.isEmpty()) {
                int key;
                ArrayList<Integer> rl = new ArrayList<Integer>();
                Iterator i$ = clouds.keySet().iterator();
                while (i$.hasNext()) {
                    key = (Integer)i$.next();
                    EntityTaintSource cloud = clouds.get(key);
                    if (cloud.field_70128_L) {
                        rl.add(key);
                        continue;
                    }
                    this.renderFluxRain(mc, cloud, partialTicks);
                }
                i$ = rl.iterator();
                while (i$.hasNext()) {
                    key = (Integer)i$.next();
                    clouds.remove(key);
                }
            }
        }
    }

    private void drawSeals(RenderWorldLastEvent event, float partialTicks, EntityPlayer player, long time) {
        ConcurrentHashMap<SealPos, SealEntity> seals = SealHandler.sealEntities.get(player.field_70170_p.field_73011_w.func_177502_q());
        if (seals != null && seals.size() > 0) {
            GL11.glPushMatrix();
            if (player.func_70093_af()) {
                GL11.glDisable((int)2929);
            }
            BlockPos pos = player.func_180425_c();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2884);
            double iPX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double iPY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
            double iPZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            GL11.glTranslated((double)(-iPX), (double)(-iPY), (double)(-iPZ));
            for (ISealEntity iSealEntity : seals.values()) {
                double dis = player.func_174831_c(iSealEntity.getSealPos().pos);
                if (!(dis <= 256.0)) continue;
                float alpha = 1.0f - (float)(dis / 256.0);
                boolean ia = false;
                if (iSealEntity.isStoppedByRedstone(player.field_70170_p)) {
                    ia = true;
                    if (player.field_70170_p.field_73012_v.nextFloat() < partialTicks / 12.0f) {
                        FXSpark ef = new FXSpark(player.field_70170_p, (float)iSealEntity.getSealPos().pos.func_177958_n() + 0.5f + (float)iSealEntity.getSealPos().face.func_82601_c() * 0.66f, (float)iSealEntity.getSealPos().pos.func_177956_o() + 0.5f + (float)iSealEntity.getSealPos().face.func_96559_d() * 0.66f, (float)iSealEntity.getSealPos().pos.func_177952_p() + 0.5f + (float)iSealEntity.getSealPos().face.func_82599_e() * 0.66f, 0.3f);
                        ef.layer = 3;
                        ef.func_70538_b(0.75f - player.field_70170_p.field_73012_v.nextFloat() * 0.2f, 0.0f, 0.0f);
                        ParticleEngine.instance.addEffect(player.field_70170_p, ef);
                        ia = false;
                    }
                }
                this.renderSeal(iSealEntity.getSealPos().pos.func_177958_n(), iSealEntity.getSealPos().pos.func_177956_o(), iSealEntity.getSealPos().pos.func_177952_p(), partialTicks, alpha, iSealEntity.getSealPos().face, iSealEntity.getSeal().getSealIcon(), player.func_70093_af(), ia);
                this.drawSealArea(player, iSealEntity, alpha, partialTicks);
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2884);
            if (player.func_70093_af()) {
                GL11.glEnable((int)2929);
            }
            GL11.glPopMatrix();
        }
    }

    private void drawSealArea(EntityPlayer player, ISealEntity seal, float alpha, float partialTicks) {
        GL11.glPushMatrix();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (seal.getColor() > 0) {
            Color c = new Color(EnumDyeColor.func_176764_b((int)(seal.getColor() - 1)).func_176768_e().field_76291_p);
            r = (float)c.getRed() / 255.0f;
            g = (float)c.getGreen() / 255.0f;
            b = (float)c.getBlue() / 255.0f;
        } else {
            r = 0.7f + MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks + (float)seal.getSealPos().pos.func_177958_n()) / 4.0f)) * 0.1f;
            g = 0.7f + MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks + (float)seal.getSealPos().pos.func_177956_o()) / 5.0f)) * 0.1f;
            b = 0.7f + MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks + (float)seal.getSealPos().pos.func_177952_p()) / 6.0f)) * 0.1f;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)seal.getSealPos().pos.func_177958_n() + 0.5), (double)((double)seal.getSealPos().pos.func_177956_o() + 0.5), (double)((double)seal.getSealPos().pos.func_177952_p() + 0.5));
        GL11.glRotatef((float)90.0f, (float)(-seal.getSealPos().face.func_96559_d()), (float)seal.getSealPos().face.func_82601_c(), (float)(-seal.getSealPos().face.func_82599_e()));
        if (seal.getSealPos().face.func_82599_e() < 0) {
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.51f);
        } else {
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.51f);
        }
        GL11.glRotatef((float)((float)(player.field_70173_aa % 360) + partialTicks), (float)0.0f, (float)0.0f, (float)1.0f);
        UtilsFX.renderQuadCentered(this.MIDDLE, 0.9f, r, g, b, 200, 771, alpha * 0.8f);
        GL11.glPopMatrix();
        if (seal.getSeal() instanceof ISealConfigArea) {
            GL11.glDepthMask((boolean)false);
            AxisAlignedBB area = AxisAlignedBB.func_178781_a((double)seal.getSealPos().pos.func_177958_n(), (double)seal.getSealPos().pos.func_177956_o(), (double)seal.getSealPos().pos.func_177952_p(), (double)(seal.getSealPos().pos.func_177958_n() + 1), (double)(seal.getSealPos().pos.func_177956_o() + 1), (double)(seal.getSealPos().pos.func_177952_p() + 1)).func_72317_d((double)seal.getSealPos().face.func_82601_c(), (double)seal.getSealPos().face.func_96559_d(), (double)seal.getSealPos().face.func_82599_e()).func_72321_a(seal.getSealPos().face.func_82601_c() != 0 ? (double)((seal.getArea().func_177958_n() - 1) * seal.getSealPos().face.func_82601_c()) : 0.0, seal.getSealPos().face.func_96559_d() != 0 ? (double)((seal.getArea().func_177956_o() - 1) * seal.getSealPos().face.func_96559_d()) : 0.0, seal.getSealPos().face.func_82599_e() != 0 ? (double)((seal.getArea().func_177952_p() - 1) * seal.getSealPos().face.func_82599_e()) : 0.0).func_72314_b(seal.getSealPos().face.func_82601_c() == 0 ? (double)(seal.getArea().func_177958_n() - 1) : 0.0, seal.getSealPos().face.func_96559_d() == 0 ? (double)(seal.getArea().func_177956_o() - 1) : 0.0, seal.getSealPos().face.func_82599_e() == 0 ? (double)(seal.getArea().func_177952_p() - 1) : 0.0);
            double[][] locs = new double[][]{{area.field_72340_a, area.field_72338_b, area.field_72339_c}, {area.field_72340_a, area.field_72337_e - 1.0, area.field_72339_c}, {area.field_72336_d - 1.0, area.field_72338_b, area.field_72339_c}, {area.field_72336_d - 1.0, area.field_72337_e - 1.0, area.field_72339_c}, {area.field_72336_d - 1.0, area.field_72338_b, area.field_72334_f - 1.0}, {area.field_72336_d - 1.0, area.field_72337_e - 1.0, area.field_72334_f - 1.0}, {area.field_72340_a, area.field_72338_b, area.field_72334_f - 1.0}, {area.field_72340_a, area.field_72337_e - 1.0, area.field_72334_f - 1.0}};
            int q = 0;
            for (double[] loc : locs) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(loc[0] + 0.5), (double)(loc[1] + 0.5), (double)(loc[2] + 0.5));
                int w = 0;
                for (EnumFacing face : this.rotfaces[q]) {
                    GL11.glPushMatrix();
                    GL11.glRotatef((float)90.0f, (float)(-face.func_96559_d()), (float)face.func_82601_c(), (float)(-face.func_82599_e()));
                    if (face.func_82599_e() < 0) {
                        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.49f);
                    } else {
                        GL11.glTranslated((double)0.0, (double)0.0, (double)0.49f);
                    }
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glRotatef((float)this.rotmat[q][w], (float)0.0f, (float)0.0f, (float)1.0f);
                    UtilsFX.renderQuadCentered(this.CFRAME, 1.0f, r, g, b, 200, 771, alpha * 0.7f);
                    GL11.glPopMatrix();
                    ++w;
                }
                GL11.glPopMatrix();
                ++q;
            }
            GL11.glDepthMask((boolean)true);
        }
        GL11.glPopMatrix();
    }

    void renderSeal(int x, int y, int z, float partialTicks, float alpha, EnumFacing face, ResourceLocation resourceLocation, boolean b, boolean ia) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)(ia ? 0.5f : 1.0f), (float)(ia ? 0.5f : 1.0f), (float)(ia ? 0.5f : 1.0f), (float)alpha);
        this.translateSeal(x, y, z, face.ordinal(), -0.05f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        UtilsFX.renderItemIn2D(resourceLocation.toString(), 0.1f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void translateSeal(float x, float y, float z, int orientation, float off) {
        if (orientation == 1) {
            GL11.glTranslatef((float)(x + 0.25f), (float)(y + 1.0f), (float)(z + 0.75f));
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == 0) {
            GL11.glTranslatef((float)(x + 0.25f), (float)y, (float)(z + 0.25f));
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == 3) {
            GL11.glTranslatef((float)(x + 0.25f), (float)(y + 0.25f), (float)(z + 1.0f));
        } else if (orientation == 2) {
            GL11.glTranslatef((float)(x + 0.75f), (float)(y + 0.25f), (float)z);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (orientation == 5) {
            GL11.glTranslatef((float)(x + 1.0f), (float)(y + 0.25f), (float)(z + 0.75f));
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (orientation == 4) {
            GL11.glTranslatef((float)x, (float)(y + 0.25f), (float)(z + 0.25f));
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-off));
    }

    private void renderFluxRain(Minecraft mc, EntityTaintSource cloud, float partialTicks) {
        if (this.rainXCoords == null) {
            this.rainXCoords = new float[1024];
            this.rainYCoords = new float[1024];
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    float f = j - 16;
                    float f1 = i - 16;
                    float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                    this.rainXCoords[i << 5 | j] = -f1 / f2;
                    this.rainYCoords[i << 5 | j] = f / f2;
                }
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179089_o();
        mc.field_71460_t.func_180436_i();
        Entity entity = mc.func_175606_aa();
        this.random.setSeed((long)entity.field_70173_aa * 312987231L);
        WorldClient worldclient = mc.field_71441_e;
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.field_70163_u);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179129_p();
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        int l = MathHelper.func_76128_c((double)d1);
        int b0 = 10;
        if (mc.field_71474_y.field_74347_j) {
            b0 = 15;
        }
        int b1 = -1;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i1 = k - b0; i1 <= k + b0; ++i1) {
            for (int j1 = i - b0; j1 <= i + b0; ++j1) {
                int k1 = (i1 - k + 16) * 32 + j1 - i + 16;
                float f3 = this.rainXCoords[k1] * 0.5f;
                float f4 = this.rainYCoords[k1] * 0.5f;
                BlockPos blockpos = new BlockPos(j1, MathHelper.func_76128_c((double)cloud.field_70163_u), i1);
                if (cloud.func_174831_c(blockpos) > 256.0) continue;
                int l1 = worldclient.func_175725_q(blockpos).func_177956_o();
                int i2 = j - b0;
                int j2 = j + b0;
                if (i2 < l1) {
                    i2 = l1;
                }
                if (j2 < l1) {
                    j2 = l1;
                }
                float f5 = 1.0f;
                int k2 = l1;
                if (l1 < l) {
                    k2 = l;
                }
                if (j2 > MathHelper.func_76128_c((double)cloud.field_70163_u)) {
                    j2 = MathHelper.func_76128_c((double)cloud.field_70163_u);
                }
                if (i2 == j2) continue;
                if (b1 != 0) {
                    if (b1 >= 0) {
                        tessellator.func_78381_a();
                    }
                    b1 = 0;
                    mc.func_110434_K().func_110577_a(rainTexture);
                    worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
                }
                float f7 = ((float)(entity.field_70173_aa + j1 * j1 * 3121 + j1 * 45238971 + i1 * i1 * 418711 + i1 * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + this.random.nextFloat());
                double d3 = (double)((float)j1 + 0.5f) - entity.field_70165_t;
                double d4 = (double)((float)i1 + 0.5f) - entity.field_70161_v;
                float f9 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4)) / (float)b0;
                int ii = worldclient.func_175626_b(new BlockPos(j1, k2, i1), 0);
                int jj = ii >> 16 & 0xFFFF;
                int kk = ii & 0xFFFF;
                worldrenderer.func_178969_c(-d0 * 1.0, -d1 * 1.0, -d2 * 1.0);
                worldrenderer.func_181662_b((double)((float)j1 - f3) + 0.5, (double)i2, (double)((float)i1 - f4) + 0.5).func_181673_a((double)(0.0f * f5), (double)((float)i2 * f5 / 4.0f + f7 * f5)).func_181671_a(jj, kk).func_181666_a(1.0f, 0.2f, 0.8f, ((1.0f - f9 * f9) * 0.5f + 0.5f) * 0.5f).func_181675_d();
                worldrenderer.func_181662_b((double)((float)j1 + f3) + 0.5, (double)i2, (double)((float)i1 + f4) + 0.5).func_181673_a((double)(1.0f * f5), (double)((float)i2 * f5 / 4.0f + f7 * f5)).func_181671_a(jj, kk).func_181666_a(1.0f, 0.2f, 0.8f, ((1.0f - f9 * f9) * 0.5f + 0.5f) * 0.5f).func_181675_d();
                worldrenderer.func_181662_b((double)((float)j1 + f3) + 0.5, (double)j2, (double)((float)i1 + f4) + 0.5).func_181673_a((double)(1.0f * f5), (double)((float)j2 * f5 / 4.0f + f7 * f5)).func_181671_a(jj, kk).func_181666_a(1.0f, 0.2f, 0.8f, ((1.0f - f9 * f9) * 0.5f + 0.5f) * 0.5f).func_181675_d();
                worldrenderer.func_181662_b((double)((float)j1 - f3) + 0.5, (double)j2, (double)((float)i1 - f4) + 0.5).func_181673_a((double)(0.0f * f5), (double)((float)j2 * f5 / 4.0f + f7 * f5)).func_181671_a(jj, kk).func_181666_a(1.0f, 0.2f, 0.8f, ((1.0f - f9 * f9) * 0.5f + 0.5f) * 0.5f).func_181675_d();
                worldrenderer.func_178969_c(0.0, 0.0, 0.0);
            }
        }
        if (b1 >= 0) {
            tessellator.func_78381_a();
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        mc.field_71460_t.func_175072_h();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void fogDensityEvent(EntityViewRenderEvent.RenderFogEvent event) {
        if (fogFiddled && fogTarget > 0.0f) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)fogTarget);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderPlayerSpecialsEvent(RenderPlayerEvent.Specials.Pre event) {
        if (event.entityPlayer != null && event.entityPlayer.field_71071_by.field_70460_b[2] != null && (event.entityPlayer.field_71071_by.field_70460_b[2].func_77973_b() instanceof ItemFortressArmor || event.entityPlayer.field_71071_by.field_70460_b[2].func_77973_b() instanceof ItemVoidRobeArmor)) {
            event.renderCape = false;
        }
    }

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingUpdateEvent event) {
        Integer t;
        EntityMob mob;
        if (event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityMob && !event.entity.field_70128_L && (mob = (EntityMob)event.entity).func_110148_a(EntityUtils.CHAMPION_MOD) != null && (t = Integer.valueOf((int)mob.func_110148_a(EntityUtils.CHAMPION_MOD).func_111126_e())) != null && t >= 0 && t < ChampionModifier.mods.length) {
            ChampionModifier.mods[t.intValue()].effect.showFX((EntityLivingBase)mob);
        }
    }

    public static void drawTagsOnContainer(double x, double y, double z, AspectList tags, int bright, EnumFacing dir, float partialTicks) {
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer && tags != null && tags.size() > 0 && dir != null) {
            EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
            double iPX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double iPY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
            double iPZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            boolean e = false;
            int rowsize = 5;
            int current = 0;
            float shifty = 0.0f;
            int left = tags.size();
            for (Aspect tag : tags.getAspects()) {
                int div = Math.min(left, rowsize);
                if (current >= rowsize) {
                    current = 0;
                    shifty -= tagscale * 1.05f;
                    if ((left -= rowsize) < rowsize) {
                        div = left % rowsize;
                    }
                }
                float shift = ((float)current - (float)div / 2.0f + 0.5f) * tagscale * 4.0f;
                shift *= tagscale;
                Color color = new Color(tag.getColor());
                GL11.glPushMatrix();
                GL11.glDisable((int)2929);
                GL11.glTranslated((double)(-iPX + x + 0.5 + (double)(tagscale * 2.0f * (float)dir.func_82601_c())), (double)(-iPY + y - (double)shifty + 0.5 + (double)(tagscale * 2.0f * (float)dir.func_96559_d())), (double)(-iPZ + z + 0.5 + (double)(tagscale * 2.0f * (float)dir.func_82599_e())));
                float xd = (float)(iPX - (x + 0.5));
                float zd = (float)(iPZ - (z + 0.5));
                float rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
                GL11.glRotatef((float)(rotYaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)shift, (double)0.0, (double)0.0);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)tagscale, (float)tagscale, (float)tagscale);
                UtilsFX.renderQuadCentered(tag.getImage(), 1.0f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, bright, 771, 0.75f);
                if (tags.getAmount(tag) >= 0) {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    String am = "" + tags.getAmount(tag);
                    GL11.glScalef((float)0.04f, (float)0.04f, (float)0.04f);
                    GL11.glTranslated((double)0.0, (double)6.0, (double)-0.1);
                    int sw = Minecraft.func_71410_x().field_71466_p.func_78256_a(am);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(am, 14 - sw, 1, 0x111111);
                    GL11.glTranslated((double)0.0, (double)0.0, (double)-0.1);
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(am, 13 - sw, 0, 0xFFFFFF);
                }
                GL11.glEnable((int)2929);
                GL11.glPopMatrix();
                ++current;
            }
        }
    }

    public void drawTextInAir(double x, double y, double z, float partialTicks, String text) {
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
            double iPX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double iPY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
            double iPZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-iPX + x + 0.5), (double)(-iPY + y + 0.5), (double)(-iPZ + z + 0.5));
            float xd = (float)(iPX - (x + 0.5));
            float zd = (float)(iPZ - (z + 0.5));
            float rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
            GL11.glRotatef((float)(rotYaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)0.02f, (float)0.02f, (float)0.02f);
            int sw = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, 1 - sw / 2, 1, 0x111111);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.1);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, -sw / 2, 0, 0xFFFFFF);
            GL11.glPopMatrix();
        }
    }

    protected void renderVignette(float brightness, double sw, double sh) {
        int k = (int)sw;
        int l = (int)sh;
        brightness = 1.0f - brightness;
        if ((prevVignetteBrightness = (float)((double)prevVignetteBrightness + (double)(brightness - prevVignetteBrightness) * 0.01)) > 0.0f) {
            float b = prevVignetteBrightness * (1.0f + MathHelper.func_76126_a((float)((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa / 2.0f)) * 0.1f);
            GL11.glPushMatrix();
            GL11.glClear((int)256);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)sw, (double)sh, (double)0.0, (double)1000.0, (double)3000.0);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(vignetteTexPath);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            OpenGlHelper.func_148821_a((int)0, (int)769, (int)1, (int)0);
            GL11.glColor4f((float)b, (float)b, (float)b, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
            tessellator.func_178180_c().func_181662_b(0.0, (double)l, -90.0).func_181673_a(0.0, 1.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)k, (double)l, -90.0).func_181673_a(1.0, 1.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)k, 0.0, -90.0).func_181673_a(1.0, 0.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b(0.0, 0.0, -90.0).func_181673_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glPopMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void textureStitchEventPre(TextureStitchEvent.Pre event) {
        for (WandRod rod : WandRod.rods.values()) {
            event.map.func_174942_a(rod.getTexture());
        }
        for (WandCap cap : WandCap.caps.values()) {
            event.map.func_174942_a(cap.getTexture());
        }
        event.map.func_174942_a(new ResourceLocation("thaumcraft", "blocks/tablequill"));
    }

    public void setItemToRender(ItemRenderer ir, ItemStack stack) {
        try {
            ObfuscationReflectionHelper.setPrivateValue(ItemRenderer.class, (Object)ir, (Object)stack, (String[])new String[]{"itemToRender", "field_78453_b"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ItemStack getItemToRender(ItemRenderer ir) {
        try {
            return (ItemStack)ReflectionHelper.getPrivateValue(ItemRenderer.class, (Object)ir, (String[])new String[]{"itemToRender", "field_78453_b"});
        }
        catch (Exception e) {
            return null;
        }
    }

    public class ChargeEntry {
        public long time;
        public long tickTime;
        public ItemStack item;
        float charge = 0.0f;
        byte diff = 0;

        public ChargeEntry(long time, ItemStack item, float charge) {
            this.time = time;
            this.item = item;
            this.charge = charge;
        }
    }
}

