/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchHelper;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.client.gui.GuiResearchBrowser;
import thaumcraft.client.lib.TCFontRenderer;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.lib.crafting.InfusionEnchantmentRecipe;
import thaumcraft.common.lib.crafting.InfusionRunicAugmentRecipe;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.utils.InventoryUtils;

@SideOnly(value=Side.CLIENT)
public class GuiResearchRecipe
extends GuiScreen {
    public static LinkedList<Object[]> history = new LinkedList();
    protected int paneWidth = 256;
    protected int paneHeight = 181;
    protected double guiMapX;
    protected double guiMapY;
    protected int mouseX = 0;
    protected int mouseY = 0;
    private GuiButton button;
    private ResearchItem research;
    private ResearchPage[] pages = null;
    private int page = 0;
    private int maxPages = 0;
    TCFontRenderer fr = null;
    HashMap<Aspect, ArrayList<ItemStack>> aspectItems = new HashMap();
    float pt;
    ResourceLocation tex1 = new ResourceLocation("thaumcraft", "textures/gui/gui_researchbook.png");
    ResourceLocation tex2 = new ResourceLocation("thaumcraft", "textures/gui/gui_researchbook_overlay.png");
    ResourceLocation tex3 = new ResourceLocation("thaumcraft", "textures/aspects/_back.png");
    private long lastCycle = 0L;
    ArrayList<List> reference = new ArrayList();
    private int cycle = -1;
    List tipText = null;

    public GuiResearchRecipe(ResearchItem research, int page, double x, double y) {
        this.research = research;
        this.guiMapX = x;
        this.guiMapY = y;
        this.field_146297_k = Minecraft.func_71410_x();
        this.pages = research.getPages();
        List<ResearchPage> p1 = Arrays.asList(this.pages);
        ArrayList<ResearchPage> p2 = new ArrayList<ResearchPage>();
        for (ResearchPage pp : p1) {
            if (pp != null && pp.research != null && !ResearchHelper.isResearchComplete(this.field_146297_k.field_71439_g.func_70005_c_(), pp.research)) continue;
            p2.add(pp);
        }
        this.pages = p2.toArray(new ResearchPage[0]);
        if (research.key.equals("ASPECTS")) {
            ArrayList itemList = Lists.newArrayList();
            for (Item item : Item.field_150901_e) {
                if (item == null || item.func_77640_w() == null) continue;
                for (CreativeTabs creativeTabs : item.getCreativeTabs()) {
                    item.func_150895_a(item, creativeTabs, (List)itemList);
                }
            }
            for (Object e : itemList) {
                try {
                    ItemStack is = (ItemStack)e;
                    AspectList tags = ThaumcraftCraftingManager.getObjectTags(is);
                    if (tags == null || tags.size() <= 0) continue;
                    for (Aspect a : tags.getAspects()) {
                        ArrayList<Object> items = this.aspectItems.get(a);
                        if (items == null) {
                            items = new ArrayList();
                        }
                        ItemStack is2 = is.func_77946_l();
                        is2.field_77994_a = tags.getAmount(a);
                        items.add(is2);
                        this.aspectItems.put(a, items);
                    }
                }
                catch (Exception e2) {
                }
            }
            ArrayList<ResearchPage> tpl = new ArrayList<ResearchPage>();
            for (ResearchPage researchPage : research.getPages()) {
                tpl.add(researchPage);
            }
            AspectList aspectList = new AspectList();
            for (Aspect aspect : Aspect.aspects.values()) {
                aspectList.add(aspect, 1);
            }
            AspectList tal = new AspectList();
            int count = 0;
            for (Aspect aspect : aspectList.getAspectsSortedByName()) {
                if (count <= 4) {
                    ++count;
                    tal.add(aspect, 0);
                }
                if (count != 4) continue;
                count = 0;
                tpl.add(new ResearchPage(tal.copy()));
                tal = new AspectList();
            }
            if (count > 0) {
                tpl.add(new ResearchPage(tal));
            }
            this.pages = tpl.toArray(this.pages);
        }
        this.maxPages = this.pages.length;
        if (page < 0) {
            page = 0;
        }
        this.fr = new TCFontRenderer(this.field_146297_k.field_71474_y, TCFontRenderer.FONT_NORMAL, this.field_146297_k.field_71446_o, true);
        if (page % 2 == 1) {
            --page;
        }
        this.page = page;
    }

    public void func_73866_w_() {
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.pt = par3;
        this.func_146276_q_();
        this.genResearchBackground(par1, par2, par3);
        int sw = (this.field_146294_l - this.paneWidth) / 2;
        int sh = (this.field_146295_m - this.paneHeight) / 2;
        if (!history.isEmpty()) {
            int mx = par1 - (sw + 118);
            int my = par2 - (sh + 189);
            if (mx >= 0 && my >= 0 && mx < 20 && my < 12) {
                this.field_146289_q.func_175063_a(StatCollector.func_74838_a((String)"recipe.return"), (float)par1, (float)par2, 0xFFFFFF);
            }
        }
    }

    protected void genResearchBackground(int par1, int par2, float par3) {
        int sw = (this.field_146294_l - this.paneWidth) / 2;
        int sh = (this.field_146295_m - this.paneHeight) / 2;
        float var10 = ((float)this.field_146294_l - (float)this.paneWidth * 1.3f) / 2.0f;
        float var11 = ((float)this.field_146295_m - (float)this.paneHeight * 1.3f) / 2.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)var10, (float)var11, (float)0.0f);
        GL11.glScalef((float)1.3f, (float)1.3f, (float)1.0f);
        this.func_73729_b(0, 0, 0, 0, this.paneWidth, this.paneHeight);
        GL11.glPopMatrix();
        this.reference.clear();
        int current = 0;
        for (int a = 0; a < this.pages.length; ++a) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if ((current == this.page || current == this.page + 1) && current < this.maxPages) {
                this.drawPage(this.pages[a], current % 2, sw, sh, par1, par2);
            }
            ++current;
            this.field_73735_i = 0.0f;
            this.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179145_e();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
            if (current > this.page + 1) break;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
        int mx1 = par1 - (sw + 261);
        int my1 = par2 - (sh + 189);
        int mx2 = par1 - (sw - 17);
        int my2 = par2 - (sh + 189);
        float bob = MathHelper.func_76126_a((float)((float)this.field_146297_k.field_71439_g.field_70173_aa / 3.0f)) * 0.2f + 0.1f;
        if (!history.isEmpty()) {
            this.drawTexturedModalRectScaled(sw + 118, sh + 189, 38, 202, 20, 12, bob);
        }
        if (this.page > 0) {
            this.drawTexturedModalRectScaled(sw - 16, sh + 190, 0, 184, 12, 8, bob);
        }
        if (this.page < this.maxPages - 2) {
            this.drawTexturedModalRectScaled(sw + 262, sh + 190, 12, 184, 12, 8, bob);
        }
        if (this.tipText != null) {
            UtilsFX.drawCustomTooltip(this, this.field_146289_q, this.tipText, par1, par2, 11);
            this.tipText = null;
        }
    }

    private void drawPage(ResearchPage pageParm, int side, int x, int y, int mx, int my) {
        if (this.lastCycle < System.currentTimeMillis()) {
            ++this.cycle;
            this.lastCycle = System.currentTimeMillis() + 1000L;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (this.page == 0 && side == 0) {
            this.func_73729_b(x + 4, y - 13, 24, 184, 96, 4);
            this.func_73729_b(x + 4, y + 4, 24, 184, 96, 4);
            int offset = this.field_146289_q.func_78256_a(this.research.getName());
            if (offset <= 130) {
                this.field_146289_q.func_78276_b(this.research.getName(), x + 52 - offset / 2, y - 6, 0x303030);
            } else {
                float vv = 130.0f / (float)offset;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)(x + 52) - (float)(offset / 2) * vv), (float)((float)y - 6.0f * vv), (float)0.0f);
                GL11.glScalef((float)vv, (float)vv, (float)vv);
                this.field_146289_q.func_78276_b(this.research.getName(), 0, 0, 0x303030);
                GL11.glPopMatrix();
            }
            y += 25;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (pageParm.type == ResearchPage.PageType.TEXT) {
            this.drawTextPage(side, x, y - 10, pageParm.getTranslatedText());
        } else if (pageParm.type == ResearchPage.PageType.ASPECTS) {
            this.drawAspectPage(side, x - 8, y - 8, mx, my, pageParm.aspects);
        } else if (pageParm.type == ResearchPage.PageType.CRUCIBLE_CRAFTING) {
            this.drawCruciblePage(side, x - 4, y - 8, mx, my, pageParm);
        } else if (pageParm.type == ResearchPage.PageType.NORMAL_CRAFTING) {
            this.drawCraftingPage(side, x - 4, y - 8, mx, my, pageParm);
        } else if (pageParm.type == ResearchPage.PageType.ARCANE_CRAFTING) {
            this.drawArcaneCraftingPage(side, x - 4, y - 8, mx, my, pageParm);
        } else if (pageParm.type == ResearchPage.PageType.COMPOUND_CRAFTING) {
            this.drawCompoundCraftingPage(side, x - 4, y - 8, mx, my, pageParm);
        } else if (pageParm.type == ResearchPage.PageType.INFUSION_CRAFTING) {
            this.drawInfusionPage(side, x - 4, y - 8, mx, my, pageParm);
        } else if (pageParm.type == ResearchPage.PageType.SMELTING) {
            this.drawSmeltingPage(side, x - 4, y - 8, mx, my, pageParm);
        }
    }

    private void drawTextPage(int side, int x, int y, String text) {
        this.fr.drawSplitString(text, x - 15 + side * 152, y, 139, 0, (Gui)this);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    private void drawCompoundCraftingPage(int side, int x, int y, int mx, int my, ResearchPage page) {
        List r = (List)page.recipe;
        if (r != null) {
            int count;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            AspectList aspects = (AspectList)r.get(0);
            int dx = (Integer)r.get(1);
            int dy = (Integer)r.get(2);
            int dz = (Integer)r.get(3);
            int xoff = 64 - (dx * 16 + dz * 16) / 2;
            int yoff = -dy * 25;
            List items = (List)r.get(4);
            GL11.glPushMatrix();
            int start = side * 152;
            String text = StatCollector.func_74838_a((String)"recipe.type.construct");
            int offset = this.field_146289_q.func_78256_a(text);
            this.field_146289_q.func_78276_b(text, x + start + 56 - offset / 2, y, 0x505050);
            int mposx = mx;
            int mposy = my;
            if (aspects != null && aspects.size() > 0) {
                count = 0;
                for (Aspect tag : aspects.getAspectsSortedByAmount()) {
                    UtilsFX.drawTag(x + start + 14 + 18 * count + (5 - aspects.size()) * 8, y + 182, tag, (float)aspects.getAmount(tag), 0, 0.0, 771, 1.0f, false);
                    ++count;
                }
                count = 0;
                for (Aspect tag : aspects.getAspectsSortedByAmount()) {
                    int tx = x + start + 14 + 18 * count + (5 - aspects.size()) * 8;
                    int ty = y + 182;
                    if (mposx >= tx && mposy >= ty && mposx < tx + 16 && mposy < ty + 16) {
                        this.tipText = Arrays.asList(tag.getName(), tag.getLocalizedDescription());
                    }
                    ++count;
                }
            }
            this.field_146297_k.field_71446_o.func_110577_a(this.tex2);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (aspects != null && aspects.size() > 0) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GL11.glTranslatef((float)(x + start), (float)(y + 174), (float)0.0f);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
                this.func_73729_b(0, 0, 68, 76, 12, 12);
                GL11.glPopMatrix();
            }
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GL11.glTranslatef((float)(x + start + xoff), (float)(y + 100 + yoff), (float)0.0f);
            GL11.glTranslatef((float)(-8 - xoff), (float)(-119 + Math.max(3 - dx, 3 - dz) * 8 + dx * 4 + dz * 4 + dy * 50), (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            this.func_73729_b(0, 0, 0, 72, 64, 44);
            GL11.glPopMatrix();
            count = 0;
            for (int j = 0; j < dy; ++j) {
                for (int k = dz - 1; k >= 0; --k) {
                    for (int i = dx - 1; i >= 0; --i) {
                        int px = x + start + xoff + i * 16 + k * 16;
                        int py = y + 100 + yoff - i * 8 + k * 8 + j * 50;
                        if (items.get(count) != null && InventoryUtils.cycleItemStack(items.get(count), count) != null) {
                            this.drawStackAt(InventoryUtils.cycleItemStack(items.get(count), count), px, py, mx, my, true);
                        }
                        ++count;
                    }
                }
            }
            GL11.glPopMatrix();
        }
    }

    private void drawAspectPage(int side, int x, int y, int mx, int my, AspectList aspects) {
        if (aspects != null && aspects.size() > 0) {
            int ty;
            int tx;
            GL11.glPushMatrix();
            int start = side * 152;
            int mposx = mx;
            int mposy = my;
            int count = 0;
            for (Aspect aspect : aspects.getAspectsSortedByName()) {
                if (aspect.getImage() != null) {
                    GL11.glPushMatrix();
                    tx = x + start;
                    ty = y + count * 50;
                    if (mposx >= tx && mposy >= ty && mposx < tx + 40 && mposy < ty + 40) {
                        this.field_146297_k.field_71446_o.func_110577_a(this.tex3);
                        GL11.glPushMatrix();
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179112_b((int)770, (int)771);
                        GL11.glTranslated((double)(x + start - 5), (double)(y + count * 50 - 5), (double)0.0);
                        GL11.glScaled((double)2.5, (double)2.5, (double)0.0);
                        UtilsFX.drawTexturedQuadFull(0, 0, this.field_73735_i);
                        GL11.glPopMatrix();
                    }
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                    UtilsFX.drawTag((x + start) / 2, (y + count * 50) / 2, aspect, aspects.getAmount(aspect), 0, this.field_73735_i);
                    GL11.glPopMatrix();
                    String text = aspect.getName();
                    int offset = this.fr.getStringWidth(text) / 2;
                    this.fr.drawString(text, x + start + 16 - offset, y + 33 + count * 50, 0x505050);
                    if (aspect.getComponents() != null) {
                        GL11.glPushMatrix();
                        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
                        UtilsFX.drawTag((int)((float)(x + start + 54) / 1.5f), (int)((float)(y + 4 + count * 50) / 1.5f), aspect.getComponents()[0], 0.0f, 0, this.field_73735_i);
                        UtilsFX.drawTag((int)((float)(x + start + 96) / 1.5f), (int)((float)(y + 4 + count * 50) / 1.5f), aspect.getComponents()[1], 0.0f, 0, this.field_73735_i);
                        GL11.glPopMatrix();
                        text = aspect.getComponents()[0].getName();
                        offset = this.fr.getStringWidth(text) / 2;
                        this.fr.drawString("\u00a7o" + text, x + start + 16 - offset + 50, y + 30 + count * 50, 0x505050);
                        text = aspect.getComponents()[1].getName();
                        offset = this.fr.getStringWidth(text) / 2;
                        this.fr.drawString("\u00a7o" + text, x + start + 16 - offset + 92, y + 30 + count * 50, 0x505050);
                        this.field_146289_q.func_78276_b("=", x + start + 7 + 32, y + 12 + count * 50, 0x999999);
                        this.field_146289_q.func_78276_b("+", x + start + 4 + 79, y + 12 + count * 50, 0x999999);
                    } else {
                        this.fr.drawString(StatCollector.func_74838_a((String)"tc.aspect.primal"), x + start + 48, y + 12 + count * 50, 0x444444);
                    }
                }
                ++count;
            }
            count = 0;
            for (Aspect aspect : aspects.getAspectsSortedByName()) {
                ArrayList<ItemStack> items;
                tx = x + start;
                ty = y + count * 50;
                if (mposx >= tx && mposy >= ty && mposx < tx + 40 && mposy < ty + 40 && (items = this.aspectItems.get(aspect)) != null && items.size() > 0) {
                    int xcount = 0;
                    int ycount = 0;
                    int cc = 0;
                    int sp = 0;
                    if (items.size() > 16) {
                        sp = this.field_146297_k.field_71439_g.field_70173_aa / 5 % items.size();
                    }
                    int max = Math.min(16, items.size());
                    while (cc < max && ycount < 2) {
                        ItemStack item = items.get(sp);
                        GL11.glPushMatrix();
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderHelper.func_74520_c();
                        GL11.glEnable((int)2884);
                        this.field_146296_j.func_180450_b(InventoryUtils.cycleItemStack(item), mposx + 8 + xcount * 17, 17 * ycount + (mposy - (4 + max / 8 * 8)));
                        this.field_146296_j.func_180453_a(this.field_146297_k.field_71466_p, InventoryUtils.cycleItemStack(item), mposx + 8 + xcount * 17, 17 * ycount + (mposy - (4 + max / 8 * 8)), null);
                        RenderHelper.func_74518_a();
                        GL11.glPopMatrix();
                        if (++xcount >= 8) {
                            xcount = 0;
                            ++ycount;
                        }
                        if (++sp >= items.size()) {
                            sp = 0;
                        }
                        ++cc;
                    }
                    GL11.glEnable((int)2896);
                }
                ++count;
            }
            GL11.glPopMatrix();
        }
    }

    private void drawArcaneCraftingPage(int side, int x, int y, int mx, int my, ResearchPage pageParm) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        IArcaneRecipe recipe = null;
        Object tr = null;
        if (pageParm.recipe instanceof Object[]) {
            try {
                tr = ((Object[])pageParm.recipe)[this.cycle];
            }
            catch (Exception e) {
                this.cycle = 0;
                tr = ((Object[])pageParm.recipe)[this.cycle];
            }
        } else {
            tr = pageParm.recipe;
        }
        if (tr instanceof ShapedArcaneRecipe) {
            recipe = (ShapedArcaneRecipe)tr;
        } else if (tr instanceof ShapelessArcaneRecipe) {
            recipe = (ShapelessArcaneRecipe)tr;
        }
        if (recipe == null) {
            return;
        }
        GL11.glPushMatrix();
        int start = side * 152;
        this.field_146297_k.field_71446_o.func_110577_a(this.tex2);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glTranslatef((float)(x + start), (float)y, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        this.func_73729_b(2, 27, 112, 15, 52, 52);
        this.func_73729_b(20, 7, 20, 3, 16, 16);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glTranslatef((float)(x + start), (float)(y + 164), (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        this.func_73729_b(0, 0, 68, 76, 12, 12);
        GL11.glPopMatrix();
        int mposx = mx;
        int mposy = my;
        AspectList tags = recipe.getAspects();
        if (tags != null && tags.size() > 0) {
            int count = 0;
            for (Aspect tag : tags.getAspectsSortedByAmount()) {
                UtilsFX.drawTag(x + start + 14 + 18 * count + (5 - tags.size()) * 8, y + 172, tag, tags.getAmount(tag), 0, 0.0, 771, 1.0f);
                ++count;
            }
        }
        String text = StatCollector.func_74838_a((String)"recipe.type.arcane");
        int offset = this.field_146289_q.func_78256_a(text);
        this.field_146289_q.func_78276_b(text, x + start + 56 - offset / 2, y, 0x505050);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)100.0);
        this.drawStackAt(InventoryUtils.cycleItemStack(recipe.func_77571_b(), 0), x + 48 + start, y + 22, mx, my, false);
        if (recipe != null && recipe instanceof ShapedArcaneRecipe) {
            int rw = ((ShapedArcaneRecipe)recipe).width;
            int rh = ((ShapedArcaneRecipe)recipe).height;
            Object[] items = ((ShapedArcaneRecipe)recipe).getInput();
            for (int i = 0; i < rw && i < 3; ++i) {
                for (int j = 0; j < rh && j < 3; ++j) {
                    if (items[i + j * rw] == null) continue;
                    this.drawStackAt(InventoryUtils.cycleItemStack(items[i + j * rw], i + j * rw), x + start + 16 + i * 32, y + 66 + j * 32, mx, my, true);
                }
            }
        }
        if (recipe != null && recipe instanceof ShapelessArcaneRecipe) {
            ArrayList items = ((ShapelessArcaneRecipe)recipe).getInput();
            for (int i = 0; i < items.size() && i < 9; ++i) {
                if (items.get(i) == null) continue;
                this.drawStackAt(InventoryUtils.cycleItemStack(items.get(i), i), x + start + 16 + i % 3 * 32, y + 66 + i / 3 * 32, mx, my, true);
            }
        }
        if (tags != null && tags.size() > 0) {
            int count = 0;
            for (Aspect tag : tags.getAspectsSortedByAmount()) {
                int tx = x + start + 14 + 18 * count + (5 - tags.size()) * 8;
                int ty = y + 172;
                if (mposx >= tx && mposy >= ty && mposx < tx + 16 && mposy < ty + 16) {
                    this.tipText = Arrays.asList(tag.getName(), tag.getLocalizedDescription());
                }
                ++count;
            }
        }
        GL11.glPopMatrix();
    }

    private void drawCraftingPage(int side, int x, int y, int mx, int my, ResearchPage pageParm) {
        int offset;
        String text;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        ShapedRecipes recipe = null;
        Object tr = null;
        if (pageParm.recipe instanceof Object[]) {
            try {
                tr = ((Object[])pageParm.recipe)[this.cycle];
            }
            catch (Exception e) {
                this.cycle = 0;
                tr = ((Object[])pageParm.recipe)[this.cycle];
            }
        } else {
            tr = pageParm.recipe;
        }
        if (tr instanceof ShapedRecipes) {
            recipe = (ShapedRecipes)tr;
        } else if (tr instanceof ShapelessRecipes) {
            recipe = (ShapelessRecipes)tr;
        } else if (tr instanceof ShapedOreRecipe) {
            recipe = (ShapedOreRecipe)tr;
        } else if (tr instanceof ShapelessOreRecipe) {
            recipe = (ShapelessOreRecipe)tr;
        }
        if (recipe == null) {
            return;
        }
        GL11.glPushMatrix();
        int start = side * 152;
        this.field_146297_k.field_71446_o.func_110577_a(this.tex2);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glTranslatef((float)(x + start), (float)y, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        this.func_73729_b(2, 32, 60, 15, 52, 52);
        this.func_73729_b(20, 12, 20, 3, 16, 16);
        GL11.glPopMatrix();
        int mposx = mx;
        int mposy = my;
        this.drawStackAt(InventoryUtils.cycleItemStack(recipe.func_77571_b(), 0), x + 48 + start, y + 32, mx, my, false);
        if (recipe != null && (recipe instanceof ShapedRecipes || recipe instanceof ShapedOreRecipe)) {
            text = StatCollector.func_74838_a((String)"recipe.type.workbench");
            offset = this.field_146289_q.func_78256_a(text);
            this.field_146289_q.func_78276_b(text, x + start + 56 - offset / 2, y, 0x505050);
            int rw = 0;
            int rh = 0;
            Object[] items = null;
            if (recipe instanceof ShapedRecipes) {
                rw = recipe.field_77576_b;
                rh = recipe.field_77577_c;
                items = recipe.field_77574_d;
            } else {
                rw = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"width"});
                rh = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"height"});
                items = ((ShapedOreRecipe)recipe).getInput();
            }
            for (int i = 0; i < rw && i < 3; ++i) {
                for (int j = 0; j < rh && j < 3; ++j) {
                    if (items[i + j * rw] == null) continue;
                    this.drawStackAt(InventoryUtils.cycleItemStack(items[i + j * rw], i + j * rw), x + start + 16 + i * 32, y + 76 + j * 32, mx, my, true);
                }
            }
        }
        if (recipe != null && (recipe instanceof ShapelessRecipes || recipe instanceof ShapelessOreRecipe)) {
            text = StatCollector.func_74838_a((String)"recipe.type.workbenchshapeless");
            offset = this.field_146289_q.func_78256_a(text);
            this.field_146289_q.func_78276_b(text, x + start + 56 - offset / 2, y, 0x505050);
            ArrayList items = null;
            if (recipe instanceof ShapelessRecipes) {
                items = new ArrayList();
                items.addAll(((ShapelessRecipes)recipe).field_77579_b);
            } else {
                items = ((ShapelessOreRecipe)recipe).getInput();
            }
            for (int i = 0; i < items.size() && i < 9; ++i) {
                if (items.get(i) == null) continue;
                this.drawStackAt(InventoryUtils.cycleItemStack(items.get(i), i), x + start + 16 + i % 3 * 32, y + 76 + i / 3 * 32, mx, my, true);
            }
        }
        GL11.glPopMatrix();
    }

    private void drawCruciblePage(int side, int x, int y, int mx, int my, ResearchPage pageParm) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        CrucibleRecipe rc = null;
        Object tr = null;
        if (pageParm.recipe instanceof Object[]) {
            try {
                tr = ((Object[])pageParm.recipe)[this.cycle];
            }
            catch (Exception e) {
                this.cycle = 0;
                tr = ((Object[])pageParm.recipe)[this.cycle];
            }
        } else {
            tr = pageParm.recipe;
        }
        if (tr instanceof CrucibleRecipe) {
            rc = (CrucibleRecipe)tr;
        }
        if (rc != null) {
            int vy;
            int vx;
            int m;
            GL11.glPushMatrix();
            int start = side * 152;
            String text = StatCollector.func_74838_a((String)"recipe.type.crucible");
            int offset = this.field_146289_q.func_78256_a(text);
            this.field_146289_q.func_78276_b(text, x + start + 56 - offset / 2, y, 0x505050);
            this.field_146297_k.field_71446_o.func_110577_a(this.tex2);
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GL11.glTranslatef((float)(x + start), (float)(y + 28), (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            this.func_73729_b(0, 0, 0, 3, 56, 17);
            GL11.glTranslatef((float)0.0f, (float)32.0f, (float)0.0f);
            this.func_73729_b(0, 0, 0, 20, 56, 48);
            GL11.glTranslatef((float)21.0f, (float)-8.0f, (float)0.0f);
            this.func_73729_b(0, 0, 100, 84, 11, 13);
            GL11.glPopMatrix();
            int mposx = mx;
            int mposy = my;
            int total = 0;
            int rows = (rc.aspects.size() - 1) / 3;
            int shift = (3 - rc.aspects.size() % 3) * 10;
            int sx = x + start + 28;
            int sy = y + 96 + 32 - 10 * rows;
            for (Aspect tag : rc.aspects.getAspectsSortedByName()) {
                m = 0;
                if (total / 3 >= rows && (rows > 1 || rc.aspects.size() < 3)) {
                    m = 1;
                }
                vx = sx + total % 3 * 20 + shift * m;
                vy = sy + total / 3 * 20;
                UtilsFX.drawTag(vx, vy, tag, rc.aspects.getAmount(tag), 0, this.field_73735_i);
                ++total;
            }
            this.drawStackAt(rc.getRecipeOutput(), x + 48 + start, y + 36, mx, my, false);
            this.drawStackAt(InventoryUtils.cycleItemStack(rc.catalyst, 0), x + 26 + start, y + 72, mx, my, true);
            total = 0;
            for (Aspect tag : rc.aspects.getAspectsSortedByName()) {
                m = 0;
                if (total / 3 >= rows && (rows > 1 || rc.aspects.size() < 3)) {
                    m = 1;
                }
                vx = sx + total % 3 * 20 + shift * m;
                vy = sy + total / 3 * 20;
                if (mposx >= vx && mposy >= vy && mposx < vx + 16 && mposy < vy + 16) {
                    this.tipText = Arrays.asList(tag.getName(), tag.getLocalizedDescription());
                }
                ++total;
            }
            GL11.glPopMatrix();
        }
    }

    private void drawSmeltingPage(int side, int x, int y, int mx, int my, ResearchPage pageParm) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        ItemStack in = (ItemStack)pageParm.recipe;
        ItemStack out = null;
        if (in != null) {
            out = FurnaceRecipes.func_77602_a().func_151395_a(in);
        }
        if (in != null && out != null) {
            GL11.glPushMatrix();
            int start = side * 152;
            String text = StatCollector.func_74838_a((String)"recipe.type.smelting");
            int offset = this.field_146289_q.func_78256_a(text);
            this.field_146289_q.func_78276_b(text, x + start + 56 - offset / 2, y, 0x505050);
            this.field_146297_k.field_71446_o.func_110577_a(this.tex2);
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GL11.glTranslatef((float)(x + start), (float)(y + 28), (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            this.func_73729_b(0, 0, 0, 192, 56, 64);
            GL11.glPopMatrix();
            int mposx = mx;
            int mposy = my;
            this.drawStackAt(in, x + 48 + start, y + 64, mx, my, true);
            this.drawStackAt(out, x + 48 + start, y + 144, mx, my, false);
            GL11.glPopMatrix();
        }
    }

    private void drawInfusionPage(int side, int x, int y, int mx, int my, ResearchPage pageParm) {
        Object tr = null;
        if (pageParm.recipe instanceof Object[]) {
            try {
                tr = ((Object[])pageParm.recipe)[this.cycle];
            }
            catch (Exception e) {
                this.cycle = 0;
                tr = ((Object[])pageParm.recipe)[this.cycle];
            }
        } else {
            tr = pageParm.recipe;
        }
        InfusionRecipe ri = (InfusionRecipe)tr;
        Object[] components = ri.getComponents();
        if (ri != null) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GL11.glPushMatrix();
            int start = side * 152;
            AspectList aspects = ri.getAspects();
            Object output = ri.getRecipeOutput();
            if (ri instanceof InfusionRunicAugmentRecipe) {
                ItemStack[] c = ((InfusionRunicAugmentRecipe)ri).getComponents((ItemStack)ri.getRecipeInput());
                components = c;
                ArrayList<ItemStack> com = new ArrayList<ItemStack>();
                for (ItemStack s : c) {
                    com.add(s);
                }
                aspects = ri.getAspects((EntityPlayer)this.field_146297_k.field_71439_g, (ItemStack)ri.getRecipeInput(), com);
                output = ((InfusionRunicAugmentRecipe)ri).getRecipeOutput((EntityPlayer)this.field_146297_k.field_71439_g, (ItemStack)ri.getRecipeInput(), com);
            }
            if (ri instanceof InfusionEnchantmentRecipe) {
                ArrayList<ItemStack> com = new ArrayList<ItemStack>();
                for (Object s : components) {
                    if (!(s instanceof ItemStack)) continue;
                    com.add((ItemStack)s);
                }
                aspects = ri.getAspects((EntityPlayer)this.field_146297_k.field_71439_g, (ItemStack)ri.getRecipeInput(), com);
                output = ((InfusionEnchantmentRecipe)ri).getRecipeOutput(null, (ItemStack)ri.getRecipeInput(), com);
            }
            String text = StatCollector.func_74838_a((String)"recipe.type.infusion");
            int offset = this.field_146289_q.func_78256_a(text);
            this.field_146289_q.func_78276_b(text, x + start + 56 - offset / 2, y, 0x505050);
            this.field_146297_k.field_71446_o.func_110577_a(this.tex2);
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GL11.glTranslatef((float)(x + start), (float)(y + 20), (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            this.func_73729_b(0, 0, 0, 3, 56, 17);
            GL11.glTranslatef((float)0.0f, (float)19.0f, (float)0.0f);
            this.func_73729_b(0, 0, 200, 77, 60, 44);
            GL11.glPopMatrix();
            int mposx = mx;
            int mposy = my;
            int total = 0;
            int rows = (aspects.size() - 1) / 5;
            int shift = (5 - aspects.size() % 5) * 10;
            int sx = x + start + 8;
            int sy = y + 164 - 10 * rows;
            for (Aspect tag : aspects.getAspectsSortedByName()) {
                int m = 0;
                if (total / 5 >= rows && (rows > 1 || aspects.size() < 5)) {
                    m = 1;
                }
                int vx = sx + total % 5 * 20 + shift * m;
                int vy = sy + total / 5 * 20;
                UtilsFX.drawTag(vx, vy, tag, aspects.getAmount(tag), 0, this.field_73735_i);
                ++total;
            }
            ItemStack idisp = null;
            if (output instanceof ItemStack) {
                idisp = InventoryUtils.cycleItemStack((ItemStack)output);
            } else {
                idisp = InventoryUtils.cycleItemStack(ri.getRecipeInput()).func_77946_l();
                try {
                    Object[] obj = (Object[])output;
                    NBTBase tag = (NBTBase)obj[1];
                    idisp.func_77983_a((String)obj[0], tag);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.drawStackAt(idisp, x + 48 + start, y + 28, mx, my, false);
            ItemStack rinp = InventoryUtils.cycleItemStack(ri.getRecipeInput()).func_77946_l();
            this.drawStackAt(rinp, x + 48 + start, y + 94, mx, my, true);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.0, (double)100.0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int le = components.length;
            ArrayList<Coord2D> coords = new ArrayList<Coord2D>();
            float pieSlice = 360 / le;
            float currentRot = -90.0f;
            for (int a = 0; a < le; ++a) {
                int xx = (int)(MathHelper.func_76134_b((float)(currentRot / 180.0f * (float)Math.PI)) * 40.0f) - 8;
                int yy = (int)(MathHelper.func_76126_a((float)(currentRot / 180.0f * (float)Math.PI)) * 40.0f) - 8;
                currentRot += pieSlice;
                coords.add(new Coord2D(xx, yy));
            }
            ArrayList<ItemStack> cmps = new ArrayList<ItemStack>();
            total = 0;
            sx = x + 56 + start;
            sy = y + 102;
            for (Object ingredient : components) {
                int vx = sx + ((Coord2D)coords.get((int)total)).x;
                int vy = sy + ((Coord2D)coords.get((int)total)).y;
                ItemStack is = InventoryUtils.cycleItemStack(ingredient);
                this.drawStackAt(is.func_77946_l().func_77979_a(1), vx, vy, mx, my, true);
                ++total;
                cmps.add(is.func_77946_l());
            }
            GL11.glPopMatrix();
            int inst = Math.min(5, ri.getInstability((EntityPlayer)this.field_146297_k.field_71439_g, rinp, cmps) / 2);
            text = StatCollector.func_74838_a((String)"tc.inst") + " " + StatCollector.func_74838_a((String)("tc.inst." + inst));
            offset = this.field_146289_q.func_78256_a(text);
            this.field_146289_q.func_78276_b(text, x + start + 56 - offset / 2, y + 194, 0x505050);
            total = 0;
            rows = (aspects.size() - 1) / 5;
            shift = (5 - aspects.size() % 5) * 10;
            sx = x + start + 8;
            sy = y + 164 - 10 * rows;
            for (Aspect tag : aspects.getAspectsSortedByName()) {
                int m = 0;
                if (total / 5 >= rows && (rows > 1 || aspects.size() < 5)) {
                    m = 1;
                }
                int vx = sx + total % 5 * 20 + shift * m;
                int vy = sy + total / 5 * 20;
                if (mposx >= vx && mposy >= vy && mposx < vx + 16 && mposy < vy + 16) {
                    this.tipText = Arrays.asList(tag.getName(), tag.getLocalizedDescription());
                }
                ++total;
            }
            GL11.glPopMatrix();
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (par2 == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() || par2 == 1) {
            history.clear();
            this.field_146297_k.func_147108_a((GuiScreen)new GuiResearchBrowser(this.guiMapX, this.guiMapY));
        } else if (par2 == 203 || par2 == 200 || par2 == 201) {
            this.prevPage();
        } else if (par2 == 205 || par2 == 208 || par2 == 209) {
            this.nextPage();
        }
        if (par2 == 14) {
            this.goBack();
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    private void nextPage() {
        if (this.page < this.maxPages - 2) {
            this.page += 2;
            this.lastCycle = 0L;
            this.cycle = -1;
            Minecraft.func_71410_x().field_71441_e.func_72980_b(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v, "thaumcraft:page", 0.66f, 1.0f, false);
        }
    }

    private void prevPage() {
        if (this.page >= 2) {
            this.page -= 2;
            this.lastCycle = 0L;
            this.cycle = -1;
            Minecraft.func_71410_x().field_71441_e.func_72980_b(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v, "thaumcraft:page", 0.66f, 1.0f, false);
        }
    }

    private void goBack() {
        if (!history.isEmpty()) {
            Minecraft.func_71410_x().field_71441_e.func_72980_b(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v, "thaumcraft:page", 0.66f, 1.0f, false);
            Object[] o = history.pop();
            this.field_146297_k.func_147108_a((GuiScreen)new GuiResearchRecipe(ResearchCategories.getResearch((String)o[0]), (Integer)o[1], this.guiMapX, this.guiMapY));
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        int var4 = (this.field_146294_l - this.paneWidth) / 2;
        int var5 = (this.field_146295_m - this.paneHeight) / 2;
        int mx = par1 - (var4 + 261);
        int my = par2 - (var5 + 189);
        if (mx >= 0 && my >= 0 && mx < 14 && my < 10) {
            this.nextPage();
        }
        mx = par1 - (var4 - 17);
        my = par2 - (var5 + 189);
        if (mx >= 0 && my >= 0 && mx < 14 && my < 10) {
            this.prevPage();
        }
        mx = par1 - (var4 + 118);
        my = par2 - (var5 + 189);
        if (mx >= 0 && my >= 0 && mx < 20 && my < 12) {
            this.goBack();
        }
        if (this.reference.size() > 0) {
            for (List coords : this.reference) {
                if (par1 < (Integer)coords.get(0) || par2 < (Integer)coords.get(1) || par1 >= (Integer)coords.get(0) + 16 || par2 >= (Integer)coords.get(1) + 16) continue;
                Minecraft.func_71410_x().field_71441_e.func_72980_b(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v, "thaumcraft:page", 0.66f, 1.0f, false);
                history.push(new Object[]{this.research.key, this.page});
                this.field_146297_k.func_147108_a((GuiScreen)new GuiResearchRecipe(ResearchCategories.getResearch((String)coords.get(2)), (Integer)coords.get(3), this.guiMapX, this.guiMapY));
            }
        }
        try {
            super.func_73864_a(par1, par2, par3);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public Object[] findRecipeReference(ItemStack item) {
        return ThaumcraftApi.getCraftingRecipeKey((EntityPlayer)this.field_146297_k.field_71439_g, item);
    }

    void drawStackAt(ItemStack itemstack, int x, int y, int mx, int my, boolean clickthrough) {
        UtilsFX.renderItemStack(this.field_146297_k, itemstack, x, y, null);
        if (mx >= x && my >= y && mx < x + 16 && my < y + 16 && itemstack != null && itemstack.func_77973_b() != null) {
            if (clickthrough) {
                List addtext = itemstack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
                Object[] ref = this.findRecipeReference(itemstack);
                if (ref != null && !((String)ref[0]).equals(this.research.key)) {
                    addtext.add("\u00a78\u00a7o" + StatCollector.func_74838_a((String)"recipe.clickthrough"));
                    this.reference.add(Arrays.asList(mx, my, (String)ref[0], (Integer)ref[1]));
                }
                this.tipText = addtext;
            } else {
                this.tipText = itemstack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
            }
        }
    }

    public void drawTexturedModalRectScaled(int par1, int par2, int par3, int par4, int par5, int par6, float scale) {
        GL11.glPushMatrix();
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.func_178181_a();
        GL11.glTranslatef((float)((float)par1 + (float)par5 / 2.0f), (float)((float)par2 + (float)par6 / 2.0f), (float)0.0f);
        GL11.glScalef((float)(1.0f + scale), (float)(1.0f + scale), (float)1.0f);
        var9.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        var9.func_178180_c().func_181662_b((double)((float)(-par5) / 2.0f), (double)((float)par6 / 2.0f), (double)this.field_73735_i).func_181673_a((double)((float)(par3 + 0) * var7), (double)((float)(par4 + par6) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)((float)par5 / 2.0f), (double)((float)par6 / 2.0f), (double)this.field_73735_i).func_181673_a((double)((float)(par3 + par5) * var7), (double)((float)(par4 + par6) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)((float)par5 / 2.0f), (double)((float)(-par6) / 2.0f), (double)this.field_73735_i).func_181673_a((double)((float)(par3 + par5) * var7), (double)((float)(par4 + 0) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)((float)(-par5) / 2.0f), (double)((float)(-par6) / 2.0f), (double)this.field_73735_i).func_181673_a((double)((float)(par3 + 0) * var7), (double)((float)(par4 + 0) * var8)).func_181675_d();
        var9.func_78381_a();
        GL11.glPopMatrix();
    }

    class Coord2D {
        int x;
        int y;

        Coord2D(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

