/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.client.gui.GuiResearchRecipe;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.renderers.entity.RenderAuraNode;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigResearch;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketPlayerCompleteToServer;
import thaumcraft.common.lib.network.playerdata.PacketSyncResearchFlags;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.utils.InventoryUtils;

@SideOnly(value=Side.CLIENT)
public class GuiResearchBrowser
extends GuiScreen {
    private static int guiBoundsLeft;
    private static int guiBoundsTop;
    private static int guiBoundsRight;
    private static int guiBoundsBottom;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected float screenZoom = 1.0f;
    protected double curMouseX;
    protected double curMouseY;
    protected double guiMapX;
    protected double guiMapY;
    protected double tempMapX;
    protected double tempMapY;
    private int isMouseButtonDown = 0;
    public static double lastX;
    public static double lastY;
    GuiResearchBrowser instance = null;
    private int screenX;
    private int screenY;
    private int startX = 16;
    private int startY = 16;
    long t = 0L;
    private LinkedList<ResearchItem> research = new LinkedList();
    public static HashMap<String, ArrayList<String>> completedResearch;
    static String selectedCategory;
    private ResearchItem currentHighlight = null;
    private String player = "";
    long popuptime = 0L;
    String popupmessage = "";
    private GuiTextField searchField;
    private static boolean searching;
    private ArrayList<String> categoriesTC = new ArrayList();
    private ArrayList<String> categoriesOther = new ArrayList();
    static int catScrollPos;
    static int catScrollMax;
    public boolean hasScribestuff = false;
    public int addonShift = 0;
    private ArrayList<String> invisible = new ArrayList();
    ArrayList<Pair<String, SearchResult>> searchResults = new ArrayList();
    ResourceLocation tx1 = new ResourceLocation("thaumcraft", "textures/gui/gui_research_browser.png");

    public GuiResearchBrowser() {
        this.guiMapX = this.tempMapX = lastX;
        this.curMouseX = this.tempMapX;
        this.guiMapY = this.tempMapY = lastY;
        this.curMouseY = this.tempMapY;
        this.player = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        this.instance = this;
    }

    public GuiResearchBrowser(double x, double y) {
        this.guiMapX = this.tempMapX = x;
        this.curMouseX = this.tempMapX;
        this.guiMapY = this.tempMapY = y;
        this.curMouseY = this.tempMapY;
        this.player = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        this.instance = this;
    }

    public void func_73866_w_() {
        this.updateResearch();
    }

    public void updateResearch() {
        if (this.field_146297_k == null) {
            this.field_146297_k = Minecraft.func_71410_x();
        }
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiSearchButton(2, 1, this.field_146295_m - 17, 16, 16, I18n.func_135052_a((String)"tc.search", (Object[])new Object[0])));
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchField = new GuiTextField(0, this.field_146289_q, 20, 20, 89, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(15);
        this.searchField.func_146185_a(true);
        this.searchField.func_146189_e(false);
        this.searchField.func_146193_g(0xFFFFFF);
        if (searching) {
            this.searchField.func_146189_e(true);
            this.searchField.func_146205_d(false);
            this.searchField.func_146195_b(true);
            this.searchField.func_146180_a("");
            this.updateSearch();
        }
        this.screenX = this.field_146294_l - 32;
        this.screenY = this.field_146295_m - 32;
        this.research.clear();
        this.hasScribestuff = false;
        if (selectedCategory == null) {
            Set<String> cats = ResearchCategories.researchCategories.keySet();
            selectedCategory = (String)cats.iterator().next();
        }
        int limit = (int)Math.floor((float)(this.screenY - 28) / 24.0f);
        this.addonShift = 0;
        int count = 0;
        this.categoriesTC.clear();
        this.categoriesOther.clear();
        block0: for (String rcl : ResearchCategories.researchCategories.keySet()) {
            int rt = 0;
            int rco = 0;
            Collection<ResearchItem> col = ResearchCategories.getResearchList((String)rcl).research.values();
            for (ResearchItem res : col) {
                if (res.isAutoUnlock()) continue;
                ++rt;
                if (!ResearchManager.isResearchComplete(this.player, res.key)) continue;
                ++rco;
            }
            int v = (int)((float)rco / (float)rt * 100.0f);
            ResearchCategoryList rc = ResearchCategories.getResearchList(rcl);
            if (rc.researchKey != null && !ResearchManager.isResearchComplete(this.player, rc.researchKey)) continue;
            for (String tcc : ConfigResearch.TCCategories) {
                if (!tcc.equals(rcl)) continue;
                this.categoriesTC.add(rcl);
                this.field_146292_n.add(new GuiCategoryButton(rc, rcl, false, 20 + this.categoriesTC.size(), 1, 10 + this.categoriesTC.size() * 24, 16, 16, I18n.func_135052_a((String)("tc.research_category." + rcl), (Object[])new Object[0]), v));
                continue block0;
            }
            if (++count > limit + catScrollPos || count - 1 < catScrollPos) continue;
            this.categoriesOther.add(rcl);
            this.field_146292_n.add(new GuiCategoryButton(rc, rcl, true, 50 + this.categoriesOther.size(), this.field_146294_l - 17, 10 + this.categoriesOther.size() * 24, 16, 16, I18n.func_135052_a((String)("tc.research_category." + rcl), (Object[])new Object[0]), v));
        }
        if (count > limit || count < catScrollPos) {
            this.addonShift = (this.screenY - 28) % 24 / 2;
            this.field_146292_n.add(new GuiScrollButton(false, 3, this.field_146294_l - 14, 20, 10, 11, ""));
            this.field_146292_n.add(new GuiScrollButton(true, 4, this.field_146294_l - 14, this.screenY + 1, 10, 11, ""));
        }
        catScrollMax = count - limit;
        if (ResearchManager.consumeInkFromPlayer((EntityPlayer)this.field_146297_k.field_71439_g, false) && InventoryUtils.isPlayerCarrying((EntityPlayer)this.field_146297_k.field_71439_g, new ItemStack(Items.field_151121_aF)) >= 0) {
            this.hasScribestuff = true;
        }
        if (completedResearch.get(this.player) == null) {
            completedResearch.put(this.player, new ArrayList());
        }
        if (selectedCategory == null || selectedCategory.equals("")) {
            return;
        }
        Collection<ResearchItem> col = ResearchCategories.getResearchList((String)GuiResearchBrowser.selectedCategory).research.values();
        for (ResearchItem res : col) {
            this.research.add(res);
        }
        guiBoundsLeft = 99999;
        guiBoundsTop = 99999;
        guiBoundsRight = -99999;
        guiBoundsBottom = -99999;
        for (ResearchItem res : this.research) {
            if (res == null || res.isVirtual() || !this.isVisible(res)) continue;
            if (res.displayColumn * 24 - this.screenX + 48 < guiBoundsLeft) {
                guiBoundsLeft = res.displayColumn * 24 - this.screenX + 48;
            }
            if (res.displayColumn * 24 - 24 > guiBoundsRight) {
                guiBoundsRight = res.displayColumn * 24 - 24;
            }
            if (res.displayRow * 24 - this.screenY + 48 < guiBoundsTop) {
                guiBoundsTop = res.displayRow * 24 - this.screenY + 48;
            }
            if (res.displayRow * 24 - 24 <= guiBoundsBottom) continue;
            guiBoundsBottom = res.displayRow * 24 - 24;
        }
    }

    private boolean isVisible(ResearchItem res) {
        ResearchItem ri;
        if (completedResearch.get(this.player).contains(res.key)) {
            return true;
        }
        if (this.invisible.contains(res.key) || res.isHidden() && !this.canUnlockResearch(res)) {
            return false;
        }
        if (res.parents == null && res.parentsHidden == null && res.isHidden()) {
            return false;
        }
        if (res.parents != null) {
            for (String r : res.parents) {
                ri = ResearchCategories.getResearch(r);
                if (ri == null || this.isVisible(ri)) continue;
                this.invisible.add(r);
                return false;
            }
        }
        if (res.parentsHidden != null) {
            for (String r : res.parentsHidden) {
                ri = ResearchCategories.getResearch(r);
                if (ri == null || this.isVisible(ri)) continue;
                this.invisible.add(r);
                return false;
            }
        }
        return true;
    }

    private boolean canUnlockResearch(ResearchItem res) {
        if (res.parents != null && res.parents.length > 0) {
            for (String pt : res.parents) {
                if (pt == null || completedResearch.get(this.player).contains(pt)) continue;
                return false;
            }
        }
        if (res.parentsHidden != null && res.parentsHidden.length > 0) {
            for (String pt : res.parentsHidden) {
                if (pt == null || completedResearch.get(this.player).contains(pt)) continue;
                return false;
            }
        }
        return true;
    }

    public void func_146281_b() {
        lastX = this.guiMapX;
        lastY = this.guiMapY;
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.updateResearch();
        if (lastX == -9999.0 || this.guiMapX > (double)guiBoundsRight || this.guiMapX < (double)guiBoundsLeft) {
            this.guiMapX = this.tempMapX = (double)((guiBoundsLeft + guiBoundsRight) / 2);
        }
        if (lastY == -9999.0 || this.guiMapY > (double)guiBoundsBottom || this.guiMapY < (double)guiBoundsTop) {
            this.guiMapY = this.tempMapY = (double)((guiBoundsBottom + guiBoundsTop) / 2);
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (searching && this.searchField.func_146201_a(par1, par2)) {
            this.updateSearch();
        } else if (par2 == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            this.field_146297_k.func_71381_h();
        }
        super.func_73869_a(par1, par2);
    }

    private void updateSearch() {
        this.searchResults.clear();
        this.invisible.clear();
        String s1 = this.searchField.func_146179_b().toLowerCase();
        for (String cat : this.categoriesTC) {
            if (!cat.toLowerCase().contains(s1)) continue;
            this.searchResults.add((Pair<String, SearchResult>)Pair.of((Object)I18n.func_135052_a((String)("tc.research_category." + cat), (Object[])new Object[0]), (Object)new SearchResult(cat, -2)));
        }
        for (String cat : this.categoriesOther) {
            if (!cat.toLowerCase().contains(s1)) continue;
            this.searchResults.add((Pair<String, SearchResult>)Pair.of((Object)I18n.func_135052_a((String)("tc.research_category." + cat), (Object[])new Object[0]), (Object)new SearchResult(cat, -2)));
        }
        for (String pre : completedResearch.get(this.player)) {
            ResearchItem ri = ResearchCategories.getResearch(pre);
            if (ri == null || ri.getName() == null) continue;
            if (ri.getName().toLowerCase().contains(s1)) {
                this.searchResults.add((Pair<String, SearchResult>)Pair.of((Object)ri.getName(), (Object)new SearchResult(pre, -1)));
            }
            int a = 0;
            if (ri.getPages() == null) continue;
            for (ResearchPage page : ri.getPages()) {
                if (page.recipeOutput != null && page.recipeOutput instanceof ItemStack && ((ItemStack)page.recipeOutput).func_82833_r().toLowerCase().contains(s1)) {
                    this.searchResults.add((Pair<String, SearchResult>)Pair.of((Object)((ItemStack)page.recipeOutput).func_82833_r(), (Object)new SearchResult(pre, a)));
                }
                ++a;
            }
        }
        Collections.sort(this.searchResults);
    }

    public void func_73863_a(int mx, int my, float par3) {
        if (!searching) {
            if (Mouse.isButtonDown((int)0)) {
                if ((this.isMouseButtonDown == 0 || this.isMouseButtonDown == 1) && mx >= this.startX && mx < this.startX + this.screenX && my >= this.startY && my < this.startY + this.screenY) {
                    if (this.isMouseButtonDown == 0) {
                        this.isMouseButtonDown = 1;
                    } else {
                        this.guiMapX -= (double)(mx - this.mouseX) * (double)this.screenZoom;
                        this.guiMapY -= (double)(my - this.mouseY) * (double)this.screenZoom;
                        this.tempMapX = this.curMouseX = this.guiMapX;
                        this.tempMapY = this.curMouseY = this.guiMapY;
                    }
                    this.mouseX = mx;
                    this.mouseY = my;
                }
                if (this.tempMapX < (double)guiBoundsLeft * (double)this.screenZoom) {
                    this.tempMapX = (double)guiBoundsLeft * (double)this.screenZoom;
                }
                if (this.tempMapY < (double)guiBoundsTop * (double)this.screenZoom) {
                    this.tempMapY = (double)guiBoundsTop * (double)this.screenZoom;
                }
                if (this.tempMapX >= (double)guiBoundsRight * (double)this.screenZoom) {
                    this.tempMapX = (float)guiBoundsRight * this.screenZoom - 1.0f;
                }
                if (this.tempMapY >= (double)guiBoundsBottom * (double)this.screenZoom) {
                    this.tempMapY = (float)guiBoundsBottom * this.screenZoom - 1.0f;
                }
            } else {
                this.isMouseButtonDown = 0;
            }
            int k = Mouse.getDWheel();
            float f4 = this.screenZoom;
            if (k < 0) {
                this.screenZoom += 0.25f;
            } else if (k > 0) {
                this.screenZoom -= 0.25f;
            }
            this.screenZoom = MathHelper.func_76131_a((float)this.screenZoom, (float)1.0f, (float)2.0f);
        }
        this.func_146276_q_();
        this.t = System.nanoTime() / 50000000L;
        int locX = MathHelper.func_76128_c((double)(this.curMouseX + (this.guiMapX - this.curMouseX) * (double)par3));
        int locY = MathHelper.func_76128_c((double)(this.curMouseY + (this.guiMapY - this.curMouseY) * (double)par3));
        if ((float)locX < (float)guiBoundsLeft * this.screenZoom) {
            locX = (int)((float)guiBoundsLeft * this.screenZoom);
        }
        if ((float)locY < (float)guiBoundsTop * this.screenZoom) {
            locY = (int)((float)guiBoundsTop * this.screenZoom);
        }
        if ((float)locX >= (float)guiBoundsRight * this.screenZoom) {
            locX = (int)((float)guiBoundsRight * this.screenZoom - 1.0f);
        }
        if ((float)locY >= (float)guiBoundsBottom * this.screenZoom) {
            locY = (int)((float)guiBoundsBottom * this.screenZoom - 1.0f);
        }
        this.genResearchBackgroundFixedPre(mx, my, par3, locX, locY);
        if (!searching) {
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.0f / this.screenZoom), (float)(1.0f / this.screenZoom), (float)1.0f);
            this.genResearchBackgroundZoomable(mx, my, par3, locX, locY);
            GL11.glPopMatrix();
        } else {
            this.searchField.func_146194_f();
            int q = 0;
            for (Pair<String, SearchResult> p : this.searchResults) {
                int color;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                SearchResult sr = (SearchResult)p.getRight();
                int n = sr.page == -1 ? 0xDDDDDD : (color = sr.page == -2 ? 0xDDAAAA : 0xAAAADD);
                if (sr.page != -1 && sr.page != -2) {
                    this.field_146297_k.field_71446_o.func_110577_a(this.tx1);
                    GL11.glPushMatrix();
                    GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                    this.func_73729_b(44, (32 + q * 10) * 2, 224, 48, 16, 16);
                    GL11.glPopMatrix();
                }
                if (mx > 22 && mx < 18 + this.screenX && my >= 32 + q * 10 && my < 40 + q * 10) {
                    color = sr.page == -1 ? 0xFFFFFF : (sr.page == -2 ? 0xFFCCCC : 0xCCCCFF);
                }
                this.field_146289_q.func_78276_b((String)p.getLeft(), 32, 32 + q * 10, color);
                if (32 + (++q + 1) * 10 <= this.screenY) continue;
                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tc.search.more", (Object[])new Object[0]), 22, 34 + q * 10, 0xAAAAAA);
                break;
            }
        }
        this.genResearchBackgroundFixedPost(mx, my, par3, locX, locY);
        if (this.popuptime > System.currentTimeMillis()) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(this.popupmessage);
            UtilsFX.drawCustomTooltip(this, this.field_146289_q, text, 10, 34, -99);
        }
    }

    public void func_73876_c() {
        this.curMouseX = this.guiMapX;
        this.curMouseY = this.guiMapY;
        double var1 = this.tempMapX - this.guiMapX;
        double var3 = this.tempMapY - this.guiMapY;
        if (var1 * var1 + var3 * var3 < 4.0) {
            this.guiMapX += var1;
            this.guiMapY += var3;
        } else {
            this.guiMapX += var1 * 0.85;
            this.guiMapY += var3 * 0.85;
        }
    }

    private void genResearchBackgroundFixedPre(int par1, int par2, float par3, int locX, int locY) {
        this.field_73735_i = 0.0f;
        GL11.glDepthFunc((int)518);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
    }

    protected void genResearchBackgroundZoomable(int mx, int my, float par3, int locX, int locY) {
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GL11.glEnable((int)3042);
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResearchCategories.getResearchList((String)GuiResearchBrowser.selectedCategory).background);
        this.drawTexturedModalRectWithDoubles((float)(this.startX - 2) * this.screenZoom, (float)(this.startY - 2) * this.screenZoom, (double)locX / 2.0, (double)locY / 2.0, (float)(this.screenX + 4) * this.screenZoom, (float)(this.screenY + 4) * this.screenZoom);
        if (ResearchCategories.getResearchList((String)GuiResearchBrowser.selectedCategory).background2 != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResearchCategories.getResearchList((String)GuiResearchBrowser.selectedCategory).background2);
            this.drawTexturedModalRectWithDoubles((float)(this.startX - 2) * this.screenZoom, (float)(this.startY - 2) * this.screenZoom, (double)locX / 1.5, (double)locY / 1.5, (float)(this.screenX + 4) * this.screenZoom, (float)(this.screenY + 4) * this.screenZoom);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        this.field_146297_k.field_71446_o.func_110577_a(this.tx1);
        if (completedResearch.get(this.player) != null) {
            for (int var22 = 0; var22 < this.research.size(); ++var22) {
                boolean var29;
                boolean var28;
                int a;
                ResearchItem var33 = this.research.get(var22);
                if (var33.parents != null && var33.parents.length > 0) {
                    for (a = 0; a < var33.parents.length; ++a) {
                        ResearchItem parent;
                        if (var33.parents[a] == null || ResearchCategories.getResearch(var33.parents[a]) == null || !ResearchCategories.getResearch((String)var33.parents[a]).category.equals(selectedCategory) || (parent = ResearchCategories.getResearch(var33.parents[a])).isVirtual() || parent.siblings != null && Arrays.asList(parent.siblings).contains(var33.key)) continue;
                        var28 = completedResearch.get(this.player).contains(var33.key);
                        var29 = completedResearch.get(this.player).contains(parent.key);
                        boolean b = this.isVisible(var33);
                        if (var28) {
                            this.drawLine(var33.displayColumn, var33.displayRow, parent.displayColumn, parent.displayRow, 0.6f, 0.6f, 0.7f, locX, locY, 5.0f, true, var33.isFlipped());
                            continue;
                        }
                        if (!b) continue;
                        if (var29) {
                            this.drawLine(var33.displayColumn, var33.displayRow, parent.displayColumn, parent.displayRow, 0.25f, 0.25f, 0.3f, locX, locY, 3.0f, true, var33.isFlipped());
                            continue;
                        }
                        if (!this.isVisible(parent)) continue;
                        this.drawLine(var33.displayColumn, var33.displayRow, parent.displayColumn, parent.displayRow, 0.1f, 0.1f, 0.15f, locX, locY, 2.0f, true, var33.isFlipped());
                    }
                }
                if (var33.siblings == null || var33.siblings.length <= 0) continue;
                for (a = 0; a < var33.siblings.length; ++a) {
                    ResearchItem sibling;
                    if (var33.siblings[a] == null || ResearchCategories.getResearch(var33.siblings[a]) == null || !ResearchCategories.getResearch((String)var33.siblings[a]).category.equals(selectedCategory) || (sibling = ResearchCategories.getResearch(var33.siblings[a])).isVirtual()) continue;
                    var28 = completedResearch.get(this.player).contains(var33.key);
                    var29 = completedResearch.get(this.player).contains(sibling.key);
                    if (var28) {
                        this.drawLine(sibling.displayColumn, sibling.displayRow, var33.displayColumn, var33.displayRow, 0.33f, 0.33f, 0.33f, locX, locY, 4.0f, false, var33.isFlipped());
                        continue;
                    }
                    if (!this.isVisible(var33)) continue;
                    if (var29) {
                        this.drawLine(sibling.displayColumn, sibling.displayRow, var33.displayColumn, var33.displayRow, 0.2f, 0.2f, 0.2f, locX, locY, 1.0f, false, var33.isFlipped());
                        continue;
                    }
                    if (!this.isVisible(sibling)) continue;
                    this.drawLine(sibling.displayColumn, sibling.displayRow, var33.displayColumn, var33.displayRow, 0.1f, 0.1f, 0.1f, locX, locY, 0.0f, false, var33.isFlipped());
                }
            }
        }
        this.currentHighlight = null;
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        if (completedResearch.get(this.player) != null) {
            for (int var24 = 0; var24 < this.research.size(); ++var24) {
                float var38;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                ResearchItem iconResearch = this.research.get(var24);
                int var26 = iconResearch.displayColumn * 24 - locX;
                int var27 = iconResearch.displayRow * 24 - locY;
                if (iconResearch.isVirtual() || var26 < -24 || var27 < -24 || !((float)var26 <= (float)this.screenX * this.screenZoom) || !((float)var27 <= (float)this.screenY * this.screenZoom)) continue;
                int iconX = this.startX + var26;
                int iconY = this.startY + var27;
                if (completedResearch.get(this.player).contains(iconResearch.key)) {
                    if (ThaumcraftApi.getWarp(iconResearch.key) > 0) {
                        this.drawForbidden(iconX + 8, iconY + 8);
                    }
                    var38 = 1.0f;
                    GL11.glColor4f((float)var38, (float)var38, (float)var38, (float)1.0f);
                } else {
                    if (!this.isVisible(iconResearch)) continue;
                    if (ThaumcraftApi.getWarp(iconResearch.key) > 0) {
                        this.drawForbidden(iconX + 8, iconY + 8);
                    }
                    if (this.canUnlockResearch(iconResearch)) {
                        var38 = (float)Math.sin((double)(Minecraft.func_71386_F() % 600L) / 600.0 * Math.PI * 2.0) * 0.25f + 0.75f;
                        GL11.glColor4f((float)var38, (float)var38, (float)var38, (float)1.0f);
                    } else {
                        var38 = 0.3f;
                        GL11.glColor4f((float)var38, (float)var38, (float)var38, (float)1.0f);
                    }
                }
                this.field_146297_k.field_71446_o.func_110577_a(this.tx1);
                GL11.glEnable((int)2884);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                if (iconResearch.isRound()) {
                    this.func_73729_b(iconX - 8, iconY - 8, 144, 48 + (iconResearch.isHidden() ? 32 : 0), 32, 32);
                } else {
                    int ix = 80;
                    int iy = 48;
                    if (iconResearch.isHidden()) {
                        iy += 32;
                    }
                    if (Config.researchDifficulty == -1 || Config.researchDifficulty == 0 && iconResearch.isSecondary()) {
                        ix += 32;
                    }
                    this.func_73729_b(iconX - 8, iconY - 8, ix, iy, 32, 32);
                }
                if (iconResearch.isSpecial()) {
                    this.func_73729_b(iconX - 8, iconY - 8, 176, 48 + (iconResearch.isHidden() ? 32 : 0), 32, 32);
                }
                boolean bw = false;
                if (!this.canUnlockResearch(iconResearch)) {
                    float var40 = 0.1f;
                    GL11.glColor4f((float)var40, (float)var40, (float)var40, (float)1.0f);
                    this.field_146296_j.func_175039_a(false);
                    bw = true;
                }
                if (ResearchManager.hasNewResearchFlag(this.player, iconResearch.key)) {
                    GL11.glPushMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glTranslatef((float)(iconX - 9), (float)(iconY - 9), (float)0.0f);
                    GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
                    this.func_73729_b(0, 0, 176, 16, 32, 32);
                    GL11.glPopMatrix();
                }
                if (ResearchManager.hasNewPageFlag(this.player, iconResearch.key)) {
                    GL11.glPushMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glTranslatef((float)(iconX - 9), (float)(iconY + 9), (float)0.0f);
                    GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
                    this.func_73729_b(0, 0, 208, 16, 32, 32);
                    GL11.glPopMatrix();
                }
                if (iconResearch.icon_item != null) {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    RenderHelper.func_74520_c();
                    GL11.glDisable((int)2896);
                    GL11.glEnable((int)32826);
                    GL11.glEnable((int)2903);
                    GL11.glEnable((int)2896);
                    this.field_146296_j.func_180450_b(InventoryUtils.cycleItemStack(iconResearch.icon_item), iconX, iconY);
                    GL11.glDisable((int)2896);
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                } else if (iconResearch.icon_resource != null && iconResearch.icon_resource.length > 0) {
                    int idx = (int)(System.currentTimeMillis() / 1000L % (long)iconResearch.icon_resource.length);
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    this.field_146297_k.field_71446_o.func_110577_a(iconResearch.icon_resource[idx]);
                    if (bw) {
                        GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
                    }
                    UtilsFX.drawTexturedQuadFull(iconX, iconY, this.field_73735_i);
                    GL11.glPopMatrix();
                }
                if (!this.canUnlockResearch(iconResearch)) {
                    this.field_146296_j.func_175039_a(true);
                    bw = false;
                }
                if (mx >= this.startX && my >= this.startY && mx < this.startX + this.screenX && my < this.startY + this.screenY && (float)mx >= (float)(iconX - 2) / this.screenZoom && (float)mx <= (float)(iconX + 18) / this.screenZoom && (float)my >= (float)(iconY - 2) / this.screenZoom && (float)my <= (float)(iconY + 18) / this.screenZoom) {
                    this.currentHighlight = iconResearch;
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GL11.glDisable((int)2929);
    }

    private void genResearchBackgroundFixedPost(int mx, int my, float par3, int locX, int locY) {
        int p;
        int c;
        this.field_146297_k.field_71446_o.func_110577_a(this.tx1);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (c = 16; c < this.field_146294_l - 16; c += 64) {
            p = 64;
            if (c + p > this.field_146294_l - 16) {
                p = this.field_146294_l - 16 - c;
            }
            if (p <= 0) continue;
            this.func_73729_b(c, -2, 48, 13, p, 22);
            this.func_73729_b(c, this.field_146295_m - 20, 48, 13, p, 22);
        }
        for (c = 16; c < this.field_146295_m - 16; c += 64) {
            p = 64;
            if (c + p > this.field_146295_m - 16) {
                p = this.field_146295_m - 16 - c;
            }
            if (p <= 0) continue;
            this.func_73729_b(-2, c, 13, 48, 22, p);
            this.func_73729_b(this.field_146294_l - 20, c, 13, 48, 22, p);
        }
        this.func_73729_b(-2, -2, 13, 13, 22, 22);
        this.func_73729_b(-2, this.field_146295_m - 20, 13, 13, 22, 22);
        this.func_73729_b(this.field_146294_l - 20, -2, 13, 13, 22, 22);
        this.func_73729_b(this.field_146294_l - 20, this.field_146295_m - 20, 13, 13, 22, 22);
        GL11.glPopMatrix();
        this.field_73735_i = 0.0f;
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        super.func_73863_a(mx, my, par3);
        if (completedResearch.get(this.player) != null && this.currentHighlight != null) {
            ArrayList<String> text = new ArrayList<String>();
            text.add("\u00a76" + this.currentHighlight.getName());
            text.add(this.currentHighlight.getText());
            int warp = ThaumcraftApi.getWarp(this.currentHighlight.key);
            if (warp > 0) {
                if (warp > 5) {
                    warp = 5;
                }
                String ws = StatCollector.func_74838_a((String)"tc.forbidden");
                String wr = StatCollector.func_74838_a((String)("tc.forbidden.level." + warp));
                String wte = "@@" + ws.replaceAll("%n", wr);
                text.add(wte);
            }
            if (this.canUnlockResearch(this.currentHighlight)) {
                boolean primary;
                boolean secondary = !completedResearch.get(this.player).contains(this.currentHighlight.key) && (Config.researchDifficulty == -1 || Config.researchDifficulty == 0 && this.currentHighlight.isSecondary());
                boolean bl = primary = !secondary && !completedResearch.get(this.player).contains(this.currentHighlight.key);
                if (!this.currentHighlight.isStub()) {
                    if (primary) {
                        if (ResearchManager.getResearchSlot((EntityPlayer)this.field_146297_k.field_71439_g, this.currentHighlight.key) >= 0) {
                            text.add("@@\u00a7o\u00a79" + StatCollector.func_74838_a((String)"tc.research.hasnote"));
                        } else if (this.hasScribestuff) {
                            text.add("@@\u00a7o\u00a72" + StatCollector.func_74838_a((String)"tc.research.getprim"));
                        } else {
                            text.add("@@\u00a7o\u00a7c" + StatCollector.func_74838_a((String)"tc.research.shortprim"));
                        }
                    } else if (secondary) {
                        boolean enough = this.field_146297_k.field_71439_g.field_71068_ca >= this.currentHighlight.getExperience() || this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d;
                        String t = null;
                        t = enough ? "@@\u00a7o\u00a72" + StatCollector.func_74838_a((String)"tc.research.purchase") : "@@\u00a7o\u00a7c" + StatCollector.func_74838_a((String)"tc.research.short");
                        text.add(new ChatComponentTranslation(t, new Object[]{"" + this.currentHighlight.getExperience()}).func_150260_c());
                    }
                }
            } else {
                text.add("@@\u00a7c" + StatCollector.func_74838_a((String)"tc.researchmissing"));
            }
            if (ResearchManager.hasNewResearchFlag(this.player, this.currentHighlight.key)) {
                text.add("@@" + StatCollector.func_74838_a((String)"tc.research.newresearch"));
            }
            if (ResearchManager.hasNewPageFlag(this.player, this.currentHighlight.key)) {
                text.add("@@" + StatCollector.func_74838_a((String)"tc.research.newpage"));
            }
            UtilsFX.drawCustomTooltip(this, this.field_146289_q, text, mx + 3, my - 3, -99);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        RenderHelper.func_74518_a();
    }

    protected void func_73864_a(int mx, int my, int par3) {
        block11: {
            block9: {
                block10: {
                    boolean secondary;
                    this.popuptime = System.currentTimeMillis() - 1L;
                    if (searching || this.currentHighlight == null || this.currentHighlight.isStub() || completedResearch.get(this.player).contains(this.currentHighlight.key) || !this.canUnlockResearch(this.currentHighlight)) break block9;
                    this.updateResearch();
                    boolean bl = secondary = Config.researchDifficulty == -1 || Config.researchDifficulty == 0 && this.currentHighlight.isSecondary();
                    if (!secondary) break block10;
                    if (!this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d && this.field_146297_k.field_71439_g.field_71068_ca < this.currentHighlight.getExperience()) break block11;
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketPlayerCompleteToServer(this.currentHighlight.key, this.field_146297_k.field_71439_g.func_70005_c_(), this.field_146297_k.field_71439_g.field_70170_p.field_73011_w.func_177502_q(), 0));
                    break block11;
                }
                if (!this.hasScribestuff || ResearchManager.getResearchSlot((EntityPlayer)this.field_146297_k.field_71439_g, this.currentHighlight.key) != -1) break block11;
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketPlayerCompleteToServer(this.currentHighlight.key, this.field_146297_k.field_71439_g.func_70005_c_(), this.field_146297_k.field_71439_g.field_70170_p.field_73011_w.func_177502_q(), 1));
                this.popuptime = System.currentTimeMillis() + 3000L;
                this.popupmessage = new ChatComponentTranslation(StatCollector.func_74838_a((String)"tc.research.popup"), new Object[]{"" + this.currentHighlight.getName()}).func_150260_c();
                break block11;
            }
            if (this.currentHighlight != null && completedResearch.get(this.player).contains(this.currentHighlight.key)) {
                ResearchManager.clearNewPageFlag(this.player, this.currentHighlight.key);
                ResearchManager.clearNewResearchFlag(this.player, this.currentHighlight.key);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncResearchFlags((EntityPlayer)this.field_146297_k.field_71439_g, this.currentHighlight.key));
                this.field_146297_k.func_147108_a((GuiScreen)new GuiResearchRecipe(this.currentHighlight, 0, this.guiMapX, this.guiMapY));
            } else if (searching) {
                int q = 0;
                for (Pair<String, SearchResult> p : this.searchResults) {
                    SearchResult sr = (SearchResult)p.getRight();
                    if (mx > 22 && mx < 18 + this.screenX && my >= 32 + q * 10 && my < 40 + q * 10) {
                        if (completedResearch.get(this.player).contains(sr.key) && sr.page > -2) {
                            this.field_146297_k.func_147108_a((GuiScreen)new GuiResearchRecipe(ResearchCategories.getResearch(sr.key), sr.page, this.guiMapX, this.guiMapY));
                            break;
                        }
                        if (this.categoriesTC.contains(sr.key) || this.categoriesOther.contains(sr.key)) {
                            searching = false;
                            this.searchField.func_146189_e(false);
                            this.searchField.func_146205_d(true);
                            this.searchField.func_146195_b(false);
                            selectedCategory = sr.key;
                            this.updateResearch();
                            this.guiMapX = this.tempMapX = (double)((guiBoundsLeft + guiBoundsRight) / 2);
                            this.guiMapY = this.tempMapY = (double)((guiBoundsBottom + guiBoundsTop) / 2);
                            break;
                        }
                    }
                    if (32 + (++q + 1) * 10 <= this.screenY) continue;
                    break;
                }
            }
        }
        try {
            super.func_73864_a(mx, my, par3);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 2) {
            selectedCategory = "";
            searching = true;
            this.searchField.func_146189_e(true);
            this.searchField.func_146205_d(false);
            this.searchField.func_146195_b(true);
            this.searchField.func_146180_a("");
            this.updateSearch();
        }
        if (button.field_146127_k == 3) {
            if (catScrollPos > 0) {
                --catScrollPos;
                this.updateResearch();
            }
        }
        if (button.field_146127_k == 4) {
            if (catScrollPos < catScrollMax) {
                ++catScrollPos;
                this.updateResearch();
            }
        }
        if (button.field_146127_k >= 20 && button instanceof GuiCategoryButton) {
            if (((GuiCategoryButton)button).key != selectedCategory) {
                searching = false;
                this.searchField.func_146189_e(false);
                this.searchField.func_146205_d(true);
                this.searchField.func_146195_b(false);
                selectedCategory = ((GuiCategoryButton)button).key;
                this.updateResearch();
                this.guiMapX = this.tempMapX = (double)((guiBoundsLeft + guiBoundsRight) / 2);
                this.guiMapY = this.tempMapY = (double)((guiBoundsBottom + guiBoundsTop) / 2);
            }
        }
    }

    private void playButtonClick() {
        this.field_146297_k.func_175606_aa().field_70170_p.func_72980_b(this.field_146297_k.func_175606_aa().field_70165_t, this.field_146297_k.func_175606_aa().field_70163_u, this.field_146297_k.func_175606_aa().field_70161_v, "thaumcraft:cameraclack", 0.4f, 1.0f, false);
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawLine(int x, int y, int x2, int y2, float r, float g, float b, int locX, int locY, float zMod, boolean arrow, boolean flipped) {
        int v;
        int yy;
        int xx;
        int ym;
        int xm;
        int yd;
        int xd;
        float zt = this.field_73735_i;
        this.field_73735_i += zMod;
        boolean bigCorner = false;
        if (flipped) {
            xd = Math.abs(x2 - x);
            yd = Math.abs(y2 - y);
            int n = xd == 0 ? 0 : (xm = x2 - x > 0 ? -1 : 1);
            int n2 = yd == 0 ? 0 : (ym = y2 - y > 0 ? -1 : 1);
            if (xd > 1 && yd > 1) {
                bigCorner = true;
            }
            xx = x2 * 24 - 4 - locX + this.startX;
            yy = y2 * 24 - 4 - locY + this.startY;
        } else {
            xd = Math.abs(x - x2);
            yd = Math.abs(y - y2);
            int n = xd == 0 ? 0 : (xm = x - x2 > 0 ? -1 : 1);
            int n3 = yd == 0 ? 0 : (ym = y - y2 > 0 ? -1 : 1);
            if (xd > 1 && yd > 1) {
                bigCorner = true;
            }
            xx = x * 24 - 4 - locX + this.startX;
            yy = y * 24 - 4 - locY + this.startY;
        }
        GL11.glPushMatrix();
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        if (arrow) {
            if (flipped) {
                int xx3 = x * 24 - 8 - locX + this.startX;
                int yy3 = y * 24 - 8 - locY + this.startY;
                if (xm < 0) {
                    this.func_73729_b(xx3, yy3, 160, 112, 32, 32);
                } else if (xm > 0) {
                    this.func_73729_b(xx3, yy3, 128, 112, 32, 32);
                } else if (ym > 0) {
                    this.func_73729_b(xx3, yy3, 64, 112, 32, 32);
                } else if (ym < 0) {
                    this.func_73729_b(xx3, yy3, 96, 112, 32, 32);
                }
            } else if (ym < 0) {
                this.func_73729_b(xx - 4, yy - 4, 64, 112, 32, 32);
            } else if (ym > 0) {
                this.func_73729_b(xx - 4, yy - 4, 96, 112, 32, 32);
            } else if (xm > 0) {
                this.func_73729_b(xx - 4, yy - 4, 160, 112, 32, 32);
            } else if (xm < 0) {
                this.func_73729_b(xx - 4, yy - 4, 128, 112, 32, 32);
            }
        }
        int h = 0;
        for (v = 1; v < yd - (bigCorner ? 1 : 0); ++v) {
            this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 0, 228, 24, 24);
        }
        if (bigCorner) {
            if (xm < 0 && ym > 0) {
                this.func_73729_b(xx + xm * 24 * h - 24, yy + ym * 24 * v, 0, 180, 48, 48);
            }
            if (xm > 0 && ym > 0) {
                this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 48, 180, 48, 48);
            }
            if (xm < 0 && ym < 0) {
                this.func_73729_b(xx + xm * 24 * h - 24, yy + ym * 24 * v - 24, 96, 180, 48, 48);
            }
            if (xm > 0 && ym < 0) {
                this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v - 24, 144, 180, 48, 48);
            }
        } else {
            if (xm < 0 && ym > 0) {
                this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 48, 228, 24, 24);
            }
            if (xm > 0 && ym > 0) {
                this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 72, 228, 24, 24);
            }
            if (xm < 0 && ym < 0) {
                this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 96, 228, 24, 24);
            }
            if (xm > 0 && ym < 0) {
                this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 120, 228, 24, 24);
            }
        }
        v += bigCorner ? 1 : 0;
        h += bigCorner ? 2 : 1;
        while (h < xd) {
            this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 24, 228, 24, 24);
            ++h;
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glPopMatrix();
        this.field_73735_i = zt;
    }

    private void drawForbidden(double x, double y) {
        int count = FMLClientHandler.instance().getClient().field_71439_g.field_70173_aa;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        UtilsFX.renderQuadCentered(RenderAuraNode.texture, 32, 32, 160 + count % 32, 80.0f, 0.33f, 0.0f, 0.44f, 220, 771, 0.9f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void drawTexturedModalRectWithDoubles(float xCoord, float yCoord, double minU, double minV, double maxU, double maxV) {
        float f2 = 0.00390625f;
        float f3 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(xCoord + 0.0f), (double)yCoord + maxV, (double)this.field_73735_i).func_181673_a((minU + 0.0) * (double)f2, (minV + maxV) * (double)f3).func_181675_d();
        worldrenderer.func_181662_b((double)xCoord + maxU, (double)yCoord + maxV, (double)this.field_73735_i).func_181673_a((minU + maxU) * (double)f2, (minV + maxV) * (double)f3).func_181675_d();
        worldrenderer.func_181662_b((double)xCoord + maxU, (double)(yCoord + 0.0f), (double)this.field_73735_i).func_181673_a((minU + maxU) * (double)f2, (minV + 0.0) * (double)f3).func_181675_d();
        worldrenderer.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), (double)this.field_73735_i).func_181673_a((minU + 0.0) * (double)f2, (minV + 0.0) * (double)f3).func_181675_d();
        tessellator.func_78381_a();
    }

    static {
        lastX = -9999.0;
        lastY = -9999.0;
        completedResearch = new HashMap();
        selectedCategory = null;
        searching = false;
        catScrollPos = 0;
        catScrollMax = 0;
    }

    private class GuiSearchButton
    extends GuiButton {
        public GuiSearchButton(int p_i1021_1_, int p_i1021_2_, int p_i1021_3_, int p_i1021_4_, int p_i1021_5_, String p_i1021_6_) {
            super(p_i1021_1_, p_i1021_2_, p_i1021_3_, p_i1021_4_, p_i1021_5_, p_i1021_6_);
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179112_b((int)770, (int)771);
                mc.field_71446_o.func_110577_a(GuiResearchBrowser.this.tx1);
                GL11.glPushMatrix();
                if (this.field_146123_n) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 160, 16, 16, 16);
                GL11.glPopMatrix();
                if (this.field_146123_n) {
                    this.func_73731_b(mc.field_71466_p, this.field_146126_j, this.field_146128_h + 19, this.field_146129_i + 4, 0xFFFFFF);
                }
                this.func_146119_b(mc, mouseX, mouseY);
            }
        }
    }

    private class GuiScrollButton
    extends GuiButton {
        boolean flip;

        public GuiScrollButton(boolean flip, int p_i1021_1_, int p_i1021_2_, int p_i1021_3_, int p_i1021_4_, int p_i1021_5_, String p_i1021_6_) {
            super(p_i1021_1_, p_i1021_2_, p_i1021_3_, p_i1021_4_, p_i1021_5_, p_i1021_6_);
            this.flip = flip;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179112_b((int)770, (int)771);
                mc.field_71446_o.func_110577_a(GuiResearchBrowser.this.tx1);
                GL11.glPushMatrix();
                if (this.field_146123_n) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 51, this.flip ? 71 : 55, 10, 11);
                GL11.glPopMatrix();
                this.func_146119_b(mc, mouseX, mouseY);
            }
        }
    }

    private class GuiCategoryButton
    extends GuiButton {
        ResearchCategoryList rc;
        String key;
        boolean flip;
        int completion;

        public GuiCategoryButton(ResearchCategoryList rc, String key, boolean flip, int p_i1021_1_, int p_i1021_2_, int p_i1021_3_, int p_i1021_4_, int p_i1021_5_, String p_i1021_6_, int completion) {
            super(p_i1021_1_, p_i1021_2_, p_i1021_3_, p_i1021_4_, p_i1021_5_, p_i1021_6_);
            this.rc = rc;
            this.key = key;
            this.flip = flip;
            this.completion = completion;
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            return this.field_146124_l && this.field_146125_m && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i + GuiResearchBrowser.this.addonShift && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g + GuiResearchBrowser.this.addonShift;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i + GuiResearchBrowser.this.addonShift && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g + GuiResearchBrowser.this.addonShift;
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179112_b((int)770, (int)771);
                mc.field_71446_o.func_110577_a(GuiResearchBrowser.this.tx1);
                GL11.glPushMatrix();
                if (!selectedCategory.equals(this.key)) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.6f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                this.func_73729_b(this.field_146128_h - 3, this.field_146129_i - 3 + GuiResearchBrowser.this.addonShift, 13, 13, 22, 22);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                mc.field_71446_o.func_110577_a(this.rc.icon);
                if (selectedCategory.equals(this.key) || this.field_146123_n) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.66f, (float)0.66f, (float)0.66f, (float)0.8f);
                }
                UtilsFX.drawTexturedQuadFull(this.field_146128_h, this.field_146129_i + GuiResearchBrowser.this.addonShift, -80.0);
                GL11.glPopMatrix();
                mc.field_71446_o.func_110577_a(GuiResearchBrowser.this.tx1);
                boolean nr = false;
                boolean np = false;
                for (String rk : this.rc.research.keySet()) {
                    if (!completedResearch.get(GuiResearchBrowser.this.player).contains(rk)) continue;
                    if (!nr && ResearchManager.hasNewResearchFlag(GuiResearchBrowser.this.player, rk)) {
                        nr = true;
                    }
                    if (!np && ResearchManager.hasNewPageFlag(GuiResearchBrowser.this.player, rk)) {
                        np = true;
                    }
                    if (!nr || !np) continue;
                    break;
                }
                if (nr) {
                    GL11.glPushMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                    GL11.glTranslated((double)(this.field_146128_h - 2), (double)(this.field_146129_i + GuiResearchBrowser.this.addonShift - 2), (double)0.0);
                    GL11.glScaled((double)0.25, (double)0.25, (double)1.0);
                    this.func_73729_b(0, 0, 176, 16, 32, 32);
                    GL11.glPopMatrix();
                }
                if (np) {
                    GL11.glPushMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                    GL11.glTranslated((double)(this.field_146128_h - 2), (double)(this.field_146129_i + GuiResearchBrowser.this.addonShift + 9), (double)0.0);
                    GL11.glScaled((double)0.25, (double)0.25, (double)1.0);
                    this.func_73729_b(0, 0, 208, 16, 32, 32);
                    GL11.glPopMatrix();
                }
                if (this.field_146123_n) {
                    String dp = this.field_146126_j + " (" + this.completion + "%)";
                    this.func_73731_b(mc.field_71466_p, dp, !this.flip ? this.field_146128_h + 22 : GuiResearchBrowser.this.screenX + 9 - mc.field_71466_p.func_78256_a(dp), this.field_146129_i + 4 + GuiResearchBrowser.this.addonShift, 0xFFFFFF);
                    int t = 9;
                    if (nr) {
                        this.func_73731_b(mc.field_71466_p, StatCollector.func_74838_a((String)"tc.research.newresearch"), !this.flip ? this.field_146128_h + 22 : GuiResearchBrowser.this.screenX + 9 - mc.field_71466_p.func_78256_a(StatCollector.func_74838_a((String)"tc.research.newresearch")), this.field_146129_i + 4 + t + GuiResearchBrowser.this.addonShift, 0xFFFFFF);
                        t += 9;
                    }
                    if (np) {
                        this.func_73731_b(mc.field_71466_p, StatCollector.func_74838_a((String)"tc.research.newpage"), !this.flip ? this.field_146128_h + 22 : GuiResearchBrowser.this.screenX + 9 - mc.field_71466_p.func_78256_a(StatCollector.func_74838_a((String)"tc.research.newpage")), this.field_146129_i + 4 + t + GuiResearchBrowser.this.addonShift, 0xFFFFFF);
                    }
                }
                this.func_146119_b(mc, mouseX, mouseY);
            }
        }
    }

    private class SearchResult
    implements Comparable {
        String key;
        int page;

        private SearchResult(String key, int page) {
            this.key = key;
            this.page = page;
        }

        public int compareTo(Object arg0) {
            SearchResult arg = (SearchResult)arg0;
            int k = this.key.compareTo(arg.key);
            return k == 0 ? (this.page == arg.page ? 0 : (this.page < arg.page ? -1 : 1)) : k;
        }
    }
}

