/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.golems.parts;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.parts.IGenericFunction;
import thaumcraft.api.golems.parts.PartModel;

public class GolemHead {
    protected static GolemHead[] heads = new GolemHead[1];
    public byte id;
    public String key;
    public String[] research;
    public ResourceLocation icon;
    public Object[] components;
    public EnumGolemTrait[] traits;
    public IHeadFunction function;
    public PartModel model;
    private static byte lastID = 0;

    public GolemHead(String key, String[] research, ResourceLocation icon, PartModel model, Object[] comp, EnumGolemTrait[] tags) {
        this.key = key;
        this.research = research;
        this.icon = icon;
        this.components = comp;
        this.traits = tags;
        this.model = model;
        this.function = null;
    }

    public GolemHead(String key, String[] research, ResourceLocation icon, PartModel model, Object[] comp, IHeadFunction function, EnumGolemTrait[] tags) {
        this(key, research, icon, model, comp, tags);
        this.function = function;
    }

    public static void register(GolemHead thing) {
        thing.id = lastID;
        lastID = (byte)(lastID + 1);
        if (thing.id >= heads.length) {
            GolemHead[] temp = new GolemHead[thing.id + 1];
            System.arraycopy(heads, 0, temp, 0, heads.length);
            heads = temp;
        }
        GolemHead.heads[thing.id] = thing;
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)("golem.head." + this.key.toLowerCase()));
    }

    public String getLocalizedDescription() {
        return StatCollector.func_74838_a((String)("golem.head.text." + this.key.toLowerCase()));
    }

    public static GolemHead[] getHeads() {
        return heads;
    }

    public static interface IHeadFunction
    extends IGenericFunction {
    }
}

