/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.golems.parts;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.parts.IGenericFunction;
import thaumcraft.api.golems.parts.PartModel;

public class GolemAddon {
    protected static GolemAddon[] addons = new GolemAddon[1];
    public byte id;
    public String key;
    public String[] research;
    public ResourceLocation icon;
    public Object[] components;
    public EnumGolemTrait[] traits;
    public IAddonFunction function;
    public PartModel model;
    private static byte lastID = 0;

    public GolemAddon(String key, String[] research, ResourceLocation icon, PartModel model, Object[] comp, EnumGolemTrait[] tags) {
        this.key = key;
        this.research = research;
        this.icon = icon;
        this.components = comp;
        this.traits = tags;
        this.model = model;
        this.function = null;
    }

    public GolemAddon(String key, String[] research, ResourceLocation icon, PartModel model, Object[] comp, IAddonFunction function, EnumGolemTrait[] tags) {
        this(key, research, icon, model, comp, tags);
        this.function = function;
    }

    public static void register(GolemAddon thing) {
        thing.id = lastID;
        lastID = (byte)(lastID + 1);
        if (thing.id >= addons.length) {
            GolemAddon[] temp = new GolemAddon[thing.id + 1];
            System.arraycopy(addons, 0, temp, 0, addons.length);
            addons = temp;
        }
        GolemAddon.addons[thing.id] = thing;
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)("golem.addon." + this.key.toLowerCase()));
    }

    public String getLocalizedDescription() {
        return StatCollector.func_74838_a((String)("golem.addon.text." + this.key.toLowerCase()));
    }

    public static GolemAddon[] getAddons() {
        return addons;
    }

    public static interface IAddonFunction
    extends IGenericFunction {
    }
}

