/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import slimeknights.mantle.util.SlimeknightException;

public abstract class BaseContainer<T extends TileEntity>
extends Container {
    protected double maxDist = 64.0;
    protected T tile;
    protected final Block originalBlock;
    protected final BlockPos pos;
    protected final World world;
    public List<Container> subContainers = Lists.newArrayList();
    protected int playerInventoryStart = -1;

    public BaseContainer(T tile) {
        this.tile = tile;
        this.world = tile.func_145831_w();
        this.pos = tile.func_174877_v();
        this.originalBlock = this.world.func_180495_p(this.pos).func_177230_c();
    }

    public void syncOnOpen(EntityPlayerMP playerOpened) {
        WorldServer server = playerOpened.func_71121_q();
        for (EntityPlayer player : server.field_73010_i) {
            if (player == playerOpened || !(player.field_71070_bA instanceof BaseContainer) || !this.sameGui((BaseContainer)player.field_71070_bA)) continue;
            this.syncWithOtherContainer((BaseContainer)player.field_71070_bA, playerOpened);
            return;
        }
        this.syncNewContainer(playerOpened);
    }

    public T getTile() {
        return this.tile;
    }

    protected void syncWithOtherContainer(BaseContainer<T> otherContainer, EntityPlayerMP player) {
    }

    protected void syncNewContainer(EntityPlayerMP player) {
    }

    public boolean sameGui(BaseContainer otherContainer) {
        return this.tile == otherContainer.tile;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        Block block = this.world.func_180495_p(this.pos).func_177230_c();
        if (block == Blocks.field_150350_a || block != this.originalBlock) {
            return false;
        }
        return playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= this.maxDist;
    }

    public List<ItemStack> func_75138_a() {
        return super.func_75138_a();
    }

    public IChatComponent getInventoryDisplayName() {
        if (this.tile instanceof IInventory) {
            return ((IInventory)this.tile).func_145748_c_();
        }
        return null;
    }

    protected void addPlayerInventory(InventoryPlayer playerInventory, int xCorner, int yCorner) {
        int index = 9;
        int start = this.field_75151_b.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, index, xCorner + col * 18, yCorner + row * 18));
                ++index;
            }
        }
        index = 0;
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInventory, index, xCorner + col * 18, yCorner + 58));
            ++index;
        }
        this.playerInventoryStart = start;
    }

    protected Slot func_75146_a(Slot slotIn) {
        if (this.playerInventoryStart >= 0) {
            throw new SlimeknightException("BaseContainer: Player inventory has to be last slots. Add all slots before adding the player inventory.");
        }
        return super.func_75146_a(slotIn);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        if (this.playerInventoryStart < 0) {
            return null;
        }
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int end = this.field_75151_b.size();
            if (index < this.playerInventoryStart ? !this.func_75135_a(itemstack1, this.playerInventoryStart, end, true) : !this.func_75135_a(itemstack1, 0, this.playerInventoryStart, false)) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean ret = this.mergeItemStackRefill(stack, startIndex, endIndex, useEndIndex);
        if (stack != null && stack.field_77994_a > 0) {
            ret |= this.mergeItemStackMove(stack, startIndex, endIndex, useEndIndex);
        }
        return ret;
    }

    protected boolean mergeItemStackRefill(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.field_77994_a <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = startIndex;
        if (useEndIndex) {
            k = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(k);
                ItemStack itemstack1 = slot.func_75211_c();
                if (itemstack1 != null && itemstack1.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack1)) {
                    int l = itemstack1.field_77994_a + stack.field_77994_a;
                    int limit = Math.min(stack.func_77976_d(), slot.func_178170_b(stack));
                    if (l <= limit) {
                        stack.field_77994_a = 0;
                        itemstack1.field_77994_a = l;
                        slot.func_75218_e();
                        flag1 = true;
                    } else if (itemstack1.field_77994_a < limit) {
                        stack.field_77994_a -= limit - itemstack1.field_77994_a;
                        itemstack1.field_77994_a = limit;
                        slot.func_75218_e();
                        flag1 = true;
                    }
                }
                if (useEndIndex) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    protected boolean mergeItemStackMove(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.field_77994_a <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = useEndIndex ? endIndex - 1 : startIndex;
        while (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex) {
            Slot slot = (Slot)this.field_75151_b.get(k);
            ItemStack itemstack1 = slot.func_75211_c();
            if (itemstack1 == null && slot.func_75214_a(stack)) {
                int limit = slot.func_178170_b(stack);
                ItemStack stack2 = stack.func_77946_l();
                if (stack2.field_77994_a > limit) {
                    stack2.field_77994_a = limit;
                    stack.field_77994_a -= limit;
                } else {
                    stack.field_77994_a = 0;
                }
                slot.func_75215_d(stack2);
                slot.func_75218_e();
                flag1 = true;
                if (stack.field_77994_a == 0) break;
            }
            if (useEndIndex) {
                --k;
                continue;
            }
            ++k;
        }
        return flag1;
    }
}

