/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Function;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.ZipperUtil;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.ObjectHolderRegistry;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.apache.logging.log4j.Level;

public class PersistentRegistryManager {
    public static final jy BLOCKS = new jy("minecraft:blocks");
    public static final jy ITEMS = new jy("minecraft:items");
    public static final jy POTIONS = new jy("minecraft:potions");

    public static <T> FMLControlledNamespacedRegistry<T> createRegistry(jy registryName, Class<T> registryType, jy optionalDefaultKey, int maxId, int minId, boolean hasDelegates, FMLControlledNamespacedRegistry.AddCallback<T> addCallback) {
        return PersistentRegistry.ACTIVE.createRegistry(registryName, registryType, optionalDefaultKey, minId, maxId, hasDelegates, addCallback);
    }

    public static <T> FMLControlledNamespacedRegistry<T> createRegistry(jy registryName, Class<T> registryType, jy optionalDefaultKey, int maxId, int minId, boolean hasDelegates) {
        return PersistentRegistry.ACTIVE.createRegistry(registryName, registryType, optionalDefaultKey, minId, maxId, hasDelegates);
    }

    public static List<String> injectSnapshot(GameDataSnapshot snapshot, boolean injectFrozenData, boolean isLocalWorld) {
        FMLLog.info("Injecting existing block and item data into this %s instance", FMLCommonHandler.instance().getEffectiveSide().isServer() ? "server" : "client");
        HashMap remaps = Maps.newHashMap();
        LinkedHashMap missing = Maps.newLinkedHashMap();
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, ValidateRegistryFunction.OPERATION);
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, DumpRegistryFunction.OPERATION);
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, ResetDelegatesFunction.OPERATION);
        GameData.getBlockStateIDMap().clear();
        Arrays.fill(pe.a, null);
        for (Map.Entry<jy, GameDataSnapshot.Entry> snapshotEntry : snapshot.entries.entrySet()) {
            PersistentRegistryManager.loadPersistentDataToStagingRegistry(injectFrozenData, remaps, missing, snapshotEntry, (Class)PersistentRegistry.ACTIVE.registrySuperTypes.inverse().get((Object)snapshotEntry.getKey()));
        }
        for (jy dummy : snapshot.entries.get((Object)PersistentRegistryManager.BLOCKS).dummied) {
            Integer id;
            if (((Map)missing.get(BLOCKS)).containsKey(dummy)) {
                id = (Integer)((Map)missing.get(BLOCKS)).remove(dummy);
                PersistentRegistry.STAGING.getRegistry(BLOCKS, afh.class).markDummy(dummy, id, (afh)new BlockDummyAir());
                continue;
            }
            if (isLocalWorld) {
                if (!FMLControlledNamespacedRegistry.DEBUG) continue;
                FMLLog.log(Level.DEBUG, "Registry: Resuscitating dummy block %s", dummy);
                continue;
            }
            id = PersistentRegistry.STAGING.getRegistry(BLOCKS, afh.class).getId(dummy);
            FMLLog.log(Level.WARN, "The ID %d is currently locally mapped - it will be replaced with air for this session", id);
            PersistentRegistry.STAGING.getRegistry(BLOCKS, afh.class).markDummy(dummy, id, (afh)new BlockDummyAir());
        }
        List<String> missedMappings = Loader.instance().fireMissingMappingEvent((Map)missing.get(BLOCKS), (Map)missing.get(ITEMS), isLocalWorld, (Map)remaps.get(BLOCKS), (Map)remaps.get(ITEMS));
        if (!missedMappings.isEmpty()) {
            return missedMappings;
        }
        if (injectFrozenData) {
            for (Map.Entry missingBlock : ((Map)missing.get(BLOCKS)).entrySet()) {
                jy rl = (jy)missingBlock.getKey();
                Integer id = (Integer)missingBlock.getValue();
                FMLLog.log(Level.DEBUG, "Replacing id %s named as %s with air block. If the mod becomes available again later, it can reload here", id, rl);
                PersistentRegistry.STAGING.getRegistry(BLOCKS, afh.class).markDummy(rl, id, (afh)new BlockDummyAir());
            }
        }
        if (injectFrozenData) {
            for (Map.Entry r : PersistentRegistry.ACTIVE.registries.entrySet()) {
                PersistentRegistryManager.loadFrozenDataToStagingRegistry(remaps, (jy)r.getKey(), (Class)PersistentRegistry.ACTIVE.registrySuperTypes.inverse().get(r.getKey()));
            }
        }
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.STAGING, ValidateRegistryFunction.OPERATION);
        for (Map.Entry r : PersistentRegistry.ACTIVE.registries.entrySet()) {
            PersistentRegistryManager.loadRegistry((jy)r.getKey(), PersistentRegistry.STAGING, PersistentRegistry.ACTIVE, (Class)PersistentRegistry.ACTIVE.registrySuperTypes.inverse().get(r.getKey()));
        }
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, DumpRegistryFunction.OPERATION);
        Loader.instance().fireRemapEvent((Map)remaps.get(BLOCKS), (Map)remaps.get(ITEMS), false);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        PersistentRegistry.STAGING.clean();
        return ImmutableList.of();
    }

    private static void forAllRegistries(PersistentRegistry registrySet, Function<Map.Entry<jy, FMLControlledNamespacedRegistry<?>>, Void> operation) {
        for (Map.Entry r : registrySet.registries.entrySet()) {
            operation.apply((Object)r);
        }
    }

    private static <T> void loadRegistry(final jy registryName, final PersistentRegistry from, final PersistentRegistry to, Class<T> regType) {
        FMLControlledNamespacedRegistry<T> fromRegistry = from.getRegistry(registryName, regType);
        if (fromRegistry == null) {
            FMLControlledNamespacedRegistry<T> toRegistry = to.getRegistry(registryName, regType);
            if (toRegistry == null) {
                throw new EnhancedRuntimeException("Could not find registry to load: " + registryName){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        stream.println("Looking For: " + registryName);
                        stream.println("Found From:");
                        for (jy name : from.registries.keySet()) {
                            stream.println("  " + name);
                        }
                        stream.println("Found To:");
                        for (jy name : to.registries.keySet()) {
                            stream.println("  " + name);
                        }
                    }
                };
            }
            toRegistry.notifyCallbacks();
        } else {
            FMLControlledNamespacedRegistry<T> toRegistry = to.getOrShallowCopyRegistry(registryName, regType, fromRegistry);
            toRegistry.set(fromRegistry);
        }
    }

    private static <T> void loadFrozenDataToStagingRegistry(Map<jy, Map<jy, Integer[]>> remaps, jy registryName, Class<T> regType) {
        FMLControlledNamespacedRegistry<T> frozenRegistry = PersistentRegistry.FROZEN.getRegistry(registryName, regType);
        FMLControlledNamespacedRegistry<T> newRegistry = PersistentRegistry.STAGING.getOrShallowCopyRegistry(registryName, regType, frozenRegistry);
        newRegistry.loadIds(frozenRegistry.getEntriesNotIn(newRegistry), Maps.newLinkedHashMap(), remaps.get(registryName), frozenRegistry, registryName);
    }

    private static <T> void loadPersistentDataToStagingRegistry(boolean injectFrozenData, Map<jy, Map<jy, Integer[]>> remaps, LinkedHashMap<jy, Map<jy, Integer>> missing, Map.Entry<jy, GameDataSnapshot.Entry> snapEntry, Class<T> regType) {
        jy registryName = snapEntry.getKey();
        if ("fml:blocks".equals(registryName.toString())) {
            registryName = BLOCKS;
        } else if ("fml:items".equals(registryName.toString())) {
            registryName = ITEMS;
        } else if ("fmlgr:villagerprofessions".equals(registryName.toString())) {
            registryName = VillagerRegistry.PROFESSIONS;
        }
        FMLControlledNamespacedRegistry<T> currentRegistry = PersistentRegistry.ACTIVE.getRegistry(registryName, regType);
        if (currentRegistry == null) {
            FMLLog.severe("An unknown persistent registry type \"%s\" has been encountered. This Forge instance cannot understand it.", registryName);
            StartupQuery.abort();
        }
        FMLControlledNamespacedRegistry<T> newRegistry = PersistentRegistry.STAGING.getOrShallowCopyRegistry(registryName, regType, currentRegistry);
        newRegistry.getPersistentSubstitutions().putAll(currentRegistry.getPersistentSubstitutions());
        GameDataSnapshot.Entry snapshotEntry = snapEntry.getValue();
        Sets.SetView substitutions = snapshotEntry.substitutions;
        if (injectFrozenData) {
            substitutions = Sets.union(snapshotEntry.substitutions, currentRegistry.getActiveSubstitutions());
        }
        newRegistry.loadAliases(snapshotEntry.aliases);
        newRegistry.loadBlocked(snapshotEntry.blocked);
        missing.put(registryName, Maps.newLinkedHashMap());
        remaps.put(registryName, Maps.newHashMap());
        newRegistry.loadDummied(snapshotEntry.dummied);
        newRegistry.loadIds(snapshotEntry.ids, missing.get(registryName), remaps.get(registryName), currentRegistry, registryName);
        newRegistry.loadSubstitutions((Set<jy>)substitutions);
    }

    public static boolean isFrozen(FMLControlledNamespacedRegistry<?> registry) {
        return PersistentRegistry.FROZEN.containsRegistry(registry);
    }

    public static void revertToFrozen() {
        if (!PersistentRegistry.FROZEN.isPopulated()) {
            FMLLog.warning("Can't revert to frozen GameData state without freezing first.", new Object[0]);
            return;
        }
        FMLLog.fine("Reverting to frozen data state.", new Object[0]);
        for (Map.Entry r : PersistentRegistry.ACTIVE.registries.entrySet()) {
            PersistentRegistryManager.loadRegistry((jy)r.getKey(), PersistentRegistry.FROZEN, PersistentRegistry.ACTIVE, (Class)PersistentRegistry.ACTIVE.registrySuperTypes.inverse().get(r.getKey()));
        }
        Loader.instance().fireRemapEvent((Map<jy, Integer[]>)ImmutableMap.of(), (Map<jy, Integer[]>)ImmutableMap.of(), true);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        FMLLog.fine("Frozen state restored.", new Object[0]);
    }

    public static void freezeData() {
        FMLLog.fine("Freezing block and item id maps", new Object[0]);
        for (Map.Entry r : PersistentRegistry.ACTIVE.registries.entrySet()) {
            PersistentRegistryManager.loadRegistry((jy)r.getKey(), PersistentRegistry.ACTIVE, PersistentRegistry.FROZEN, (Class)PersistentRegistry.ACTIVE.registrySuperTypes.inverse().get(r.getKey()));
        }
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.FROZEN, ValidateRegistryFunction.OPERATION);
    }

    public static List<String> processIdRematches(Iterable<FMLMissingMappingsEvent.MissingMapping> missedMappings, boolean isLocalWorld, Map<jy, Integer[]> remapBlocks, Map<jy, Integer[]> remapItems) {
        ArrayList failed = Lists.newArrayList();
        ArrayList ignored = Lists.newArrayList();
        ArrayList warned = Lists.newArrayList();
        ArrayList defaulted = Lists.newArrayList();
        PersistentRegistry staging = PersistentRegistry.STAGING;
        PersistentRegistry active = PersistentRegistry.ACTIVE;
        for (FMLMissingMappingsEvent.MissingMapping missingMapping : missedMappings) {
            FMLMissingMappingsEvent.Action action = missingMapping.getAction();
            if (action == FMLMissingMappingsEvent.Action.REMAP) {
                jy newName;
                int currId = -1;
                int newId = -1;
                if (missingMapping.type == GameRegistry.Type.BLOCK) {
                    currId = staging.getRegistry(BLOCKS, afh.class).getId((afh)missingMapping.getTarget());
                    newName = active.getRegistry(BLOCKS, afh.class).getNameForObject((afh)missingMapping.getTarget());
                    FMLLog.fine("The Block %s is being remapped to %s.", missingMapping.name, newName);
                    newId = staging.getRegistry(BLOCKS, afh.class).add(missingMapping.id, newName, (afh)missingMapping.getTarget());
                    staging.getRegistry(BLOCKS, afh.class).addAlias(missingMapping.resourceLocation, newName);
                } else {
                    if (missingMapping.type != GameRegistry.Type.ITEM) continue;
                    currId = staging.getRegistry(ITEMS, zw.class).getId((zw)missingMapping.getTarget());
                    newName = active.getRegistry(ITEMS, zw.class).getNameForObject((zw)missingMapping.getTarget());
                    FMLLog.fine("The Item %s is being remapped to %s.", missingMapping.name, newName);
                    newId = staging.getRegistry(ITEMS, zw.class).add(missingMapping.id, newName, (zw)missingMapping.getTarget());
                    staging.getRegistry(ITEMS, zw.class).addAlias(missingMapping.resourceLocation, newName);
                }
                if (newId != missingMapping.id) {
                    throw new IllegalStateException();
                }
                if (currId == newId) continue;
                FMLLog.info("Fixed %s id mismatch %s: %d (init) -> %d (map).", missingMapping.type == GameRegistry.Type.BLOCK ? "block" : "item", newName, currId, newId);
                (missingMapping.type == GameRegistry.Type.BLOCK ? remapBlocks : remapItems).put(newName, new Integer[]{currId, newId});
                continue;
            }
            if (action == FMLMissingMappingsEvent.Action.BLOCKONLY) {
                FMLLog.fine("The ItemBlock %s is no longer present in the game. The residual block will remain", missingMapping.name);
                continue;
            }
            if (action == FMLMissingMappingsEvent.Action.DEFAULT) {
                defaulted.add(missingMapping.name);
            } else if (action == FMLMissingMappingsEvent.Action.IGNORE) {
                ignored.add(missingMapping.name);
            } else if (action == FMLMissingMappingsEvent.Action.FAIL) {
                failed.add(missingMapping.name);
            } else if (action == FMLMissingMappingsEvent.Action.WARN) {
                warned.add(missingMapping.name);
            }
            if (missingMapping.type == GameRegistry.Type.BLOCK) {
                staging.getRegistry(BLOCKS, afh.class).blockId(missingMapping.id);
                continue;
            }
            if (missingMapping.type != GameRegistry.Type.ITEM) continue;
            staging.getRegistry(ITEMS, zw.class).blockId(missingMapping.id);
        }
        if (!defaulted.isEmpty()) {
            String text = "Forge Mod Loader detected missing blocks/items.\n\nThere are " + defaulted.size() + " missing blocks and items in this save.\n" + "If you continue the missing blocks/items will get removed.\n" + "A world backup will be automatically created in your saves directory.\n\n" + "Missing Blocks/Items:\n";
            for (String s : defaulted) {
                text = text + s + "\n";
            }
            boolean bl = StartupQuery.confirm(text);
            if (!bl) {
                StartupQuery.abort();
            }
            try {
                String skip = System.getProperty("fml.doNotBackup");
                if (skip == null || !"true".equals(skip)) {
                    ZipperUtil.backupWorld();
                } else {
                    for (int x = 0; x < 10; ++x) {
                        FMLLog.severe("!!!!!!!!!! UPDATING WORLD WITHOUT DOING BACKUP !!!!!!!!!!!!!!!!", new Object[0]);
                    }
                }
            }
            catch (IOException e2) {
                StartupQuery.notify("The world backup couldn't be created.\n\n" + e2);
                StartupQuery.abort();
            }
            warned.addAll(defaulted);
        }
        if (!failed.isEmpty()) {
            FMLLog.severe("This world contains blocks and items that refuse to be remapped. The world will not be loaded", new Object[0]);
            return failed;
        }
        if (!warned.isEmpty()) {
            FMLLog.warning("This world contains block and item mappings that may cause world breakage", new Object[0]);
            return failed;
        }
        if (!ignored.isEmpty()) {
            FMLLog.fine("There were %d missing mappings that have been ignored", ignored.size());
        }
        return failed;
    }

    public static GameDataSnapshot takeSnapshot() {
        final GameDataSnapshot snap = new GameDataSnapshot();
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, new Function<Map.Entry<jy, FMLControlledNamespacedRegistry<?>>, Void>(){

            public Void apply(Map.Entry<jy, FMLControlledNamespacedRegistry<?>> input) {
                snap.entries.put(input.getKey(), new GameDataSnapshot.Entry(input.getValue()));
                return null;
            }
        });
        return snap;
    }

    public static <T> RegistryDelegate<T> makeDelegate(T obj, Class<T> rootClass) {
        return PersistentRegistry.ACTIVE.getRegistry(rootClass).getDelegate(obj, rootClass);
    }

    private static class ResetDelegatesFunction
    implements Function<Map.Entry<jy, FMLControlledNamespacedRegistry<?>>, Void> {
        static final ResetDelegatesFunction OPERATION = new ResetDelegatesFunction();

        private ResetDelegatesFunction() {
        }

        public Void apply(Map.Entry<jy, FMLControlledNamespacedRegistry<?>> input) {
            input.getValue().resetSubstitutionDelegates();
            return null;
        }
    }

    private static class ValidateRegistryFunction
    implements Function<Map.Entry<jy, FMLControlledNamespacedRegistry<?>>, Void> {
        static final ValidateRegistryFunction OPERATION = new ValidateRegistryFunction();

        private ValidateRegistryFunction() {
        }

        public Void apply(Map.Entry<jy, FMLControlledNamespacedRegistry<?>> input) {
            input.getValue().validateContent(input.getKey());
            return null;
        }
    }

    private static class DumpRegistryFunction
    implements Function<Map.Entry<jy, FMLControlledNamespacedRegistry<?>>, Void> {
        static final DumpRegistryFunction OPERATION = new DumpRegistryFunction();

        private DumpRegistryFunction() {
        }

        public Void apply(Map.Entry<jy, FMLControlledNamespacedRegistry<?>> input) {
            input.getValue().dump(input.getKey());
            return null;
        }
    }

    public static class GameDataSnapshot {
        public final Map<jy, Entry> entries = Maps.newHashMap();

        public static class Entry {
            public final Map<jy, Integer> ids;
            public final Set<jy> substitutions;
            public final Map<jy, jy> aliases;
            public final Set<Integer> blocked;
            public final Set<jy> dummied;

            public Entry() {
                this(new HashMap<jy, Integer>(), new HashSet<jy>(), new HashMap<jy, jy>(), new HashSet<Integer>(), new HashSet<jy>());
            }

            public Entry(Map<jy, Integer> ids, Set<jy> substitutions, Map<jy, jy> aliases, Set<Integer> blocked, Set<jy> dummies) {
                this.ids = ids;
                this.substitutions = substitutions;
                this.aliases = aliases;
                this.blocked = blocked;
                this.dummied = dummies;
            }

            public Entry(FMLControlledNamespacedRegistry<?> registry) {
                this.ids = Maps.newHashMap();
                this.substitutions = Sets.newHashSet();
                this.aliases = Maps.newHashMap();
                this.blocked = Sets.newHashSet();
                this.dummied = Sets.newHashSet();
                registry.serializeIds(this.ids);
                registry.serializeSubstitutions(this.substitutions);
                registry.serializeAliases(this.aliases);
                registry.serializeBlockList(this.blocked);
                registry.serializeDummied(this.dummied);
            }
        }
    }

    private static class BlockDummyAir
    extends aey {
        private BlockDummyAir() {
            this.c("air");
        }
    }

    private static enum PersistentRegistry {
        ACTIVE,
        FROZEN,
        STAGING;

        private final BiMap<jy, FMLControlledNamespacedRegistry<?>> registries = HashBiMap.create();
        private final BiMap<Class<?>, jy> registrySuperTypes = HashBiMap.create();

        <T> FMLControlledNamespacedRegistry<T> getRegistry(jy key, Class<T> regType) {
            return (FMLControlledNamespacedRegistry)((Object)this.registries.get((Object)key));
        }

        <T> FMLControlledNamespacedRegistry<T> getOrShallowCopyRegistry(jy key, Class<T> regType, FMLControlledNamespacedRegistry<T> other) {
            if (!this.registries.containsKey((Object)key)) {
                this.registries.put((Object)key, other.makeShallowCopy());
                this.registrySuperTypes.put(regType, (Object)key);
            }
            return this.getRegistry(key, regType);
        }

        private <T> FMLControlledNamespacedRegistry<T> createRegistry(jy registryName, Class<T> registryType, jy optionalDefaultKey, int minId, int maxId, boolean hasDelegates) {
            return this.createRegistry(registryName, registryType, optionalDefaultKey, minId, maxId, hasDelegates, null);
        }

        private <T> FMLControlledNamespacedRegistry<T> createRegistry(jy registryName, Class<T> type, jy defaultObjectKey, int minId, int maxId, boolean isDelegated, FMLControlledNamespacedRegistry.AddCallback<T> addCallback) {
            HashSet parents = Sets.newHashSet();
            this.findSuperTypes(type, parents);
            Sets.SetView overlappedTypes = Sets.intersection((Set)parents, (Set)this.registrySuperTypes.keySet());
            if (!overlappedTypes.isEmpty()) {
                Class foundType = (Class)overlappedTypes.iterator().next();
                FMLLog.severe("Found existing registry of type %1s named %2s, you cannot create a new registry (%3s) with type %4s, as %4s has a parent of that type", foundType, this.registrySuperTypes.get((Object)foundType), registryName, type);
                throw new IllegalArgumentException("Duplicate registry parent type found - you can only have one registry for a particular super type");
            }
            FMLControlledNamespacedRegistry<T> fmlControlledNamespacedRegistry = new FMLControlledNamespacedRegistry<T>(defaultObjectKey, maxId, minId, type, isDelegated, addCallback);
            this.registries.put((Object)registryName, fmlControlledNamespacedRegistry);
            this.registrySuperTypes.put(type, (Object)registryName);
            return this.getRegistry(registryName, type);
        }

        private void findSuperTypes(Class<?> type, Set<Class<?>> types) {
            if (type == null || type == Object.class) {
                return;
            }
            types.add(type);
            for (Class<?> interfac : type.getInterfaces()) {
                this.findSuperTypes(interfac, types);
            }
            this.findSuperTypes(type.getSuperclass(), types);
        }

        void clean() {
            this.registries.clear();
            this.registrySuperTypes.clear();
        }

        boolean isPopulated() {
            return !this.registries.isEmpty();
        }

        boolean containsRegistry(FMLControlledNamespacedRegistry<?> registry) {
            return this.registries.containsValue(registry);
        }

        public <T> FMLControlledNamespacedRegistry<T> getRegistry(Class<T> rootClass) {
            jy rl = (jy)this.registrySuperTypes.get(rootClass);
            return this.getRegistry(rl, rootClass);
        }
    }
}

