/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.animation;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.animation.Clips;
import net.minecraftforge.client.model.animation.Event;
import net.minecraftforge.client.model.animation.IClip;
import net.minecraftforge.client.model.animation.ITimeValue;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

class AnimationStateMachine
implements IAnimationStateMachine {
    private final ImmutableMap<String, ITimeValue> parameters;
    private final ImmutableMap<String, IClip> clips;
    private final ImmutableList<String> states;
    private final ImmutableMap<String, String> transitions;
    @SerializedName(value="start_state")
    private final String startState;
    private transient boolean shouldHandleSpecialEvents;
    private transient String currentStateName;
    private transient IClip currentState;
    private transient float lastPollTime;
    private static final LoadingCache<Triple<? extends IClip, Float, Float>, Pair<IModelState, Iterable<Event>>> clipCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(100L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Triple<? extends IClip, Float, Float>, Pair<IModelState, Iterable<Event>>>(){

        public Pair<IModelState, Iterable<Event>> load(Triple<? extends IClip, Float, Float> key) throws Exception {
            return Clips.apply((IClip)key.getLeft(), ((Float)key.getMiddle()).floatValue(), ((Float)key.getRight()).floatValue());
        }
    });

    public AnimationStateMachine(ImmutableMap<String, ITimeValue> parameters, ImmutableMap<String, IClip> clips, ImmutableList<String> states, ImmutableMap<String, String> transitions, String startState) {
        this.parameters = parameters;
        this.clips = clips;
        this.states = states;
        this.transitions = transitions;
        this.startState = startState;
    }

    ImmutableMap<String, ITimeValue> getParameters() {
        return this.parameters;
    }

    ImmutableMap<String, IClip> getClips() {
        return this.clips;
    }

    void initialize() {
        if (this.parameters == null) {
            throw new JsonParseException("Animation State Machine should contain \"parameters\" key.");
        }
        if (this.clips == null) {
            throw new JsonParseException("Animation State Machine should contain \"clips\" key.");
        }
        if (this.states == null) {
            throw new JsonParseException("Animation State Machine should contain \"states\" key.");
        }
        if (this.transitions == null) {
            throw new JsonParseException("Animation State Machine should contain \"transitions\" key.");
        }
        this.shouldHandleSpecialEvents = true;
        this.lastPollTime = Float.NEGATIVE_INFINITY;
        IClip state = (IClip)this.clips.get((Object)this.startState);
        if (!this.clips.containsKey((Object)this.startState) || !this.states.contains((Object)this.startState)) {
            throw new IllegalStateException("unknown state: " + this.startState);
        }
        this.currentStateName = this.startState;
        this.currentState = state;
    }

    @Override
    public Pair<IModelState, Iterable<Event>> apply(float time) {
        if (this.lastPollTime == Float.NEGATIVE_INFINITY) {
            this.lastPollTime = time;
        }
        Pair pair = (Pair)clipCache.getUnchecked((Object)Triple.of((Object)this.currentState, (Object)Float.valueOf(this.lastPollTime), (Object)Float.valueOf(time)));
        this.lastPollTime = time;
        boolean shouldFilter = false;
        if (this.shouldHandleSpecialEvents) {
            for (Event event : ImmutableList.copyOf((Iterable)((Iterable)pair.getRight())).reverse()) {
                if (!event.event().startsWith("!")) continue;
                shouldFilter = true;
                if (event.event().startsWith("!transition:")) {
                    String newState = event.event().substring("!transition:".length());
                    this.transition(newState);
                    continue;
                }
                System.out.println("Unknown special event \"" + event.event() + "\", ignoring");
            }
        }
        if (!shouldFilter) {
            return pair;
        }
        return Pair.of((Object)pair.getLeft(), (Object)Iterables.filter((Iterable)((Iterable)pair.getRight()), (Predicate)new Predicate<Event>(){

            public boolean apply(Event event) {
                return !event.event().startsWith("!");
            }
        }));
    }

    @Override
    public void transition(String newState) {
        IClip nc = (IClip)this.clips.get((Object)newState);
        if (!this.clips.containsKey((Object)newState) || !this.states.contains((Object)newState)) {
            throw new IllegalStateException("unknown state: " + newState);
        }
        if (!((String)this.transitions.get((Object)this.currentStateName)).equals(newState)) {
            throw new IllegalArgumentException("no transition from current clip \"" + this.currentStateName + "\" to the clip \"" + newState + "\" found.");
        }
        this.currentStateName = newState;
        this.currentState = nc;
    }

    @Override
    public String currentState() {
        return this.currentStateName;
    }

    @Override
    public void shouldHandleSpecialEvents(boolean value) {
        this.shouldHandleSpecialEvents = true;
    }
}

